import { Component, OnInit, Input, Output, EventEmitter, ViewChild, ViewEncapsulation, NgZone } from '@angular/core';
import { ContentsSandbox } from '../shared/sandbox/content.sandbox';
//import { DashboardService } from '../components/dashboard/dashboard.service';
import { DashboardService } from '../../dashboard/dashboard.service';
import { Router } from '@angular/router'; //p a
// import { Subscription } from 'rxjs/Subscription';
import { Subscription } from 'rxjs';

@Component({
    selector: 'content-assoc-transactions',
    templateUrl: './content-assoc-transactions.component.html',
    styleUrls: ['./content-assoc-transactions.component.css'],
    //encapsulation: ViewEncapsulation.None //Commented by Sonam K [To avoid conflicts in CSS]
})
export class ContentAssocTransactionsComponent implements OnInit {

    @Input() content: any;
    @Input() assocObject: any;
    @Output() onAbort : EventEmitter<any> = new EventEmitter();
    @Output() onSelect: EventEmitter<any> = new EventEmitter<any>();


    status = "loading";
    transList: any[] = [];
    displayTemplate = "";
    profPath  = "/ibase/resource/images/users/";
    dataSource : any;
    filterValue : any;
    fileType: any;

    @ViewChild("elementRef") elementReference: any;
    divElement: HTMLDivElement | any;
    template:any ;
    hosturl: any ;
    storedTransKey : any; // Added by Pravin K on 17-APR-19 [to store transaction is session storage]
    //subscription: Subscription;

    constructor(public contentSandbox: ContentsSandbox, private router: Router, private dashboardService:DashboardService, public zone: NgZone ) { } //p c

    ngOnInit() {
        //console.log(" Route  ",this.router);
        this.content = this.contentSandbox.getSelectedContent();
        this.assocObject = this.contentSandbox.getSelectedAssocObject();
        this.hosturl= this.contentSandbox.getHostUrl();
        // Added by Pravin K on 17-APR-19 [to store transaction is session storage] START
        this.storedTransKey = this.assocObject.obj_name+"_"+this.content.docId+"_trans";
        // Added by Pravin K on 17-APR-19 [to store transaction is session storage] END

        ///FILETYPE
        this.fileType = this.content.fileType!.trim();
        console.log("In ContentAssocTransactionsComponent:: content transObj",this.content," AssociateObj : ",this.assocObject);

        var objName = this.assocObject.obj_name;
        if(objName)
        {
            objName = objName.toLowerCase()
            if(objName.indexOf("w_") == 0)
            {
                objName = objName.substring(2);
            }
        }

        // Changed by Pravin K on 23-NOV-18 [changed objName to objName:Refser and fieldName to tranIDCol ] START
        var objNameRefser =  "ASSOCIATE_TRANSACTION:"+this.assocObject.ref_ser
        var trand_id_col = this.assocObject.trand_id_col ;
        trand_id_col = trand_id_col.toUpperCase();
        this.dataSource =this.hosturl+"/ibase/rest/GetNewTransctionList/"+this.content.docId+"/"+this.content.docType+"/"+this.assocObject.ref_ser+"/"+objNameRefser+"/"+this.assocObject.table_name+"/"+trand_id_col;
        // Changed by Pravin K on 23-NOV-18 [changed objName to objName:Refser and fieldName to tranIDCol ] END

        console.log(" . selectedAllTranObjects ",this.contentSandbox.selectedTranObjects);

        if(this.contentSandbox.selectedTranObjects.length==0)
        {
            // Added by Pravin K on 17-APR-19 [to store transaction is session storage] START
            var storedTrans = this.contentSandbox.getSessionStorageItem( this.storedTransKey );
            console.log("storedTrans list ",storedTrans);
            if(storedTrans)
            {
                var resp = JSON.parse(storedTrans);
                console.log("Response in storedTrans resp ",typeof resp);
                if (  typeof resp === 'string' )
                {
                    resp = JSON.parse(resp);
                }
                console.log("Response in storedTrans resp : ",resp);
                this.transList = resp.assocTransList.data;
                this.template= resp.assocTransList.template;
                console.log("Response from transList :  ",this.transList);

                if(!this.transList || this.transList.length == 0){
                    console.log("Transaction  list is empty :  ");
                    this.status = "nodata";
                    return;
                }
                else
                {
                    this.status = "loaded";
                }
                // push all element to globle list farr.push.apply(farr,sarr);
                var selectedTranObjects = this.contentSandbox.selectedTranObjects
                selectedTranObjects.push.apply(selectedTranObjects , this.transList );

                //Commented by Sonam K on 30-JUL-19 [included in html template]
                /* this.divElement = this.elementReference.nativeElement;
                  this.divElement.innerHTML="";*/
                this.drawFeeds( this.transList );
            }
            else
            {

                this.contentSandbox.getAssocTranscList(this.content.docType, this.content.docId, this.assocObject.ref_ser , objNameRefser, this.assocObject.table_name , trand_id_col,
                        (resp: any) => {
                            console.log("Response in ContentAssocTransactionsComponent",resp);
                            if(resp.result == "success"){
                                //Added by Pravin K on 17-APR-19 [to store transaction is session storage] START
                                //  this.contentSandbox.setSessionStorageItem(this.storedTransKey,JSON.stringify(resp)); //Commented by Sonam K on 30-JUL-19
                                //Added by Pravin K on 17-APR-19 [to store transaction is session storage] END
                                this.transList = resp.assocTransList.data;
                                this.template= resp.assocTransList.template;
                                console.log("Response from transList :  ",this.transList);

                                if(!this.transList || this.transList.length == 0){
                                    console.log("Transaction  list is empty :  ");
                                    this.status = "nodata";
                                    return;
                                }
                                else
                                {
                                    this.status = "loaded";
                                }
                                // push all element to globle list farr.push.apply(farr,sarr);
                                var selectedTranObjects = this.contentSandbox.selectedTranObjects
                                selectedTranObjects.push.apply(selectedTranObjects , this.transList );

                                //Commented by Sonam K on 30-JUL-19 [included in html template]
                                /* this.divElement = this.elementReference.nativeElement;
                                this.divElement.innerHTML="";*/
                                this.drawFeeds( this.transList );
                            }
                            else if(resp.result == "failure"){
                                this.status = "failed";
                            }
                        }
                );
            }
            //Added by Pravin K on 17-APR-19 [to store transaction is session storage] END
        }
        else
        {
            this.transList = this.contentSandbox.selectedTranObjects;
            console.log("Stored transList : ",this.transList);
            if(this.transList.length == 0){
                this.status = "nodata";
            }
            else
            {
                this.status = "loaded";
            }
            //Commented by Sonam K on 30-JUL-19 [included in html template]
            /*this.divElement = this.elementReference.nativeElement;
            this.divElement.innerHTML="";*/
            this.drawFeeds( this.transList );
        }
    }

    private drawFeeds(data: any)
    {
        for (let object of data)
        {
            //Commented by Sonam K on 30-JUL-19
            // let feed: any = this.createFeed(object,false);
            //this.divElement.appendChild(feed);

            //Added by Sonam K on 30-JUL-19 [To include code in html]
            let feed: any = this.addNewFeed(object,false);

        }
    }

    feedDataList: any = []; //Added by Sonam K on 30-JUL-19
    feedObjectData: Object | any; //Added by Sonam K on 30-JUL-19

  //Added by Sonam K on 30-JUL-19 [To add new feed to the transaction and include code into html] START
    private addNewFeed(object: Object | any, isAdd:boolean) {
        var feedDataObject: any ={};
        this.feedObjectData = object;

        if(typeof object["@page_info"] == "string") {
            object["@page_info"] = JSON.parse( object["@page_info"] );
        }

        var feedRefId = object["@ref_id"];
        var selectedPagesCount =  this.getPageCountFromPageSequence(object["@page_info"]["selectedPages"]);

        this.selectedPagesCount= selectedPagesCount;
        this.isAdd= isAdd;

        let parsedHTML: string;
        if(this.template &&  ! object["selectedTemplate"]) {
            parsedHTML = this.createParsedHTML(object);
            object["selectedTemplate"] = parsedHTML;
        } else {
            parsedHTML =  object["selectedTemplate"];
        }

        var fldValue: string = parsedHTML.length > 10 ? parsedHTML.substring(0, 10) : parsedHTML;
        var errorSrc: string = this.hosturl + '/ibase/CustomMenuImageServlet?fldValue=' + fldValue + '&object=&objName=&ALT_FLD_VALUE=' + fldValue + '&isOval=true';
        var image = window.document.createElement('img');
        //image.classList.add('assocobj-icon');
        image.src = this.hosturl + '/ibase/resource/images/users/default.png';

        var imageSource = image.src;
        var selectedPagesCountHtml;
        var docPagesHtml;

        if( this.content.docPages > 0 && (this.fileType  === 'pdf' || this.fileType  === 'zip') ) {
            selectedPagesCountHtml = selectedPagesCount;
            docPagesHtml = this.content.docPages;
        } else if( this.fileType  === 'pdf' || this.fileType  === 'zip' ) {
            selectedPagesCountHtml = selectedPagesCount;
        }

        if( this.fileType  === 'pdf' || this.fileType  === 'zip' ) {
            console.log("this.fileType  === 'pdf' || this.fileType  === 'zip'");
        }

        feedDataObject['@ref_id']= feedRefId;
        feedDataObject['profileImg']= imageSource;
        feedDataObject['profileInfo']= parsedHTML;
        feedDataObject['selectedPagesCount'] = selectedPagesCountHtml;
        feedDataObject['docPagesHtml'] = docPagesHtml;

        if( object["action"]=="I" ) {
            feedDataObject['closeTransactionIcon']= true;
        } else {
            feedDataObject['closeTransactionIcon']= false;
        }

        this.feedDataList.push(feedDataObject);
        return this.feedDataList;
    }
    //Added by Sonam K on 30-JUL-19 [To add new feed to the transaction and include code into html] END

  //Commented by SOnam K on 30-JUL-19[To include code into hmtl]
  /*
  private createFeed(object: Object, isAdd:boolean) {
    //For Important
    if(typeof object["@page_info"] == "string")
    {
        object["@page_info"] = JSON.parse( object["@page_info"] );
    }

    var selectedPagesCount =  this.getPageCountFromPageSequence(object["@page_info"]["selectedPages"]);

    let container = window.document.createElement('div');//assoc-obj-feed
    let profile = window.document.createElement('div');//assocobj-icon-container
    let templateView = window.document.createElement('div');//assocobj-detail-container  -- .assocobj-detail-title
    let selectedPages = window.document.createElement('div');
    let pageInfo = window.document.createElement('div');//.assocobj-info-container

    container.classList.add("assoc-obj-feed");
    profile.classList.add("assocobj-icon-container");
    templateView.classList.add("assocobj-detail-container");
    pageInfo.classList.add("assocobj-info-container");
    selectedPages.classList.add("selectedPages");

    pageInfo.setAttribute("align", "right");

    let parsedHTML: string;
    if(this.template &&  ! object["selectedTemplate"])
    {
        parsedHTML = this.createParsedHTML(object);
        object["selectedTemplate"] = parsedHTML;
    }
    else
    {
        parsedHTML =  object["selectedTemplate"];
    }



    var fldValue: string = parsedHTML.length > 10 ? parsedHTML.substring(0, 10) : parsedHTML;
    var errorSrc: string = this.hosturl + '/ibase/CustomMenuImageServlet?fldValue=' + fldValue + '&object=&objName=&ALT_FLD_VALUE=' + fldValue + '&isOval=true';
    var image = window.document.createElement('img');
    image.classList.add('assocobj-icon');
    image.src = this.hosturl + '/ibase/resource/images/users/default.png';
    image.onerror = function() {
        image.src = errorSrc;
    };
    profile.appendChild(image);

    templateView.innerHTML = "<div style='display: inherit;'>"+parsedHTML+"</div>";

    if( this.content.docPages > 0 && (this.fileType  === 'pdf' || this.fileType  === 'zip') )
    {
        selectedPages.innerHTML ="Pages "+selectedPagesCount+"/"+ this.content.docPages;
    }
    else if( this.fileType  === 'pdf' || this.fileType  === 'zip' )
    {
        selectedPages.innerHTML ="Selected Pages "+selectedPagesCount;
    }
    templateView.appendChild(selectedPages);

    container.appendChild(profile);
    container.appendChild(templateView);
    //this.addClickEventHandler(container, object, selectedPagesCount);

    if( this.fileType  === 'pdf' || this.fileType  === 'zip' )
    {
		this.addClickEventHandler(container, object, selectedPagesCount, isAdd);
    }
    if(object["action"]=="I")
    {
        pageInfo.innerHTML = " <span class='assc-close-transaction visionicon' ></span>";
        this.addRemovePanelHandler(container, object,pageInfo);
        container.appendChild(pageInfo);
    }
    return container;
  }
 */
  //Commented by Sonam K on 30-JUL-19
 /*
  public addRemovePanelHandler(container :  any, object, removeBtn)
  {
        var self = this;
        removeBtn.addEventListener('click', function(event){
            event.stopPropagation();
            //remove from  selected array
            var tranObjects = self.contentSandbox.selectedTranObjects ;
            tranObjects.splice(tranObjects.indexOf(object),1);

            //remove feed from container
            container.parentNode.removeChild(container);
        });
  }
*/

//Added by Sonam K on 30-JUL-19 [To remove feed from panel]
    removePnlHandler(event: any, ref_id: any) {
        var self = this;
        event.stopPropagation();
        var tranObjects = self.contentSandbox.selectedTranObjects;
        tranObjects.splice(tranObjects.indexOf(this.feedObjectData),1);
        for(var i=0; i < this.feedDataList.length; i++) {
            var feedData = this.feedDataList[i];
            if(feedData['@ref_id'] === ref_id) {
                this.feedDataList.splice(i, 1);
                return;
            }
        }
    }

//Commented by Sonam K on 30-JUL-19
/*
public addClickEventHandler(container :  any, object, selectedPagesCount, isAdd)
  {
    var self = this;
    container.addEventListener('click', function(){
        var pageSelectionDetails = {
            "selectedPages" : +selectedPagesCount||0,
            "selectedPagesSeq" : object["@page_info"]["selectedPages"]||'',
            "importantPagesSeq" : object["@page_info"]["importantPages"]||'',
            "isAdd" :  isAdd
        };
        self.contentSandbox.pageSelectionDetails = pageSelectionDetails ;
        self.contentSandbox.selectedTemplate = object["selectedTemplate"];
        console.log("selectedPagesSeq : ",self.contentSandbox.pageSelectionDetails)
        console.log("selectedTemplate :", self.contentSandbox.selectedTemplate)

       //Process and set new page seq an no of pages
        self.router.navigateByUrl('ManagerComponent', { skipLocationChange: true });
      } );

  }*/

    selectedPagesCount: any;
    isAdd: any;

//  Added by Sonam K on 30-JUL-19
    onFeedClick(){
        var self =this;
        var pageSelectionDetails = {
                "selectedPages" : + this.selectedPagesCount||0,
                "selectedPagesSeq" :  this.feedObjectData["@page_info"]["selectedPages"]||'',
                "importantPagesSeq" :  this.feedObjectData["@page_info"]["importantPages"]||'',
                "isAdd" :  this.isAdd
        };
        self.contentSandbox.pageSelectionDetails = pageSelectionDetails ;
        self.contentSandbox.selectedTemplate =  this.feedObjectData["selectedTemplate"];

//      Process and set new page seq an no of pages
        self.router.navigateByUrl('ManagerComponent', { skipLocationChange: true });
    }

    private createParsedHTML(object: Object | any) {
        let template = this.template;

        for (let key in object)
        {
            var regExp = new RegExp('{{\\s*' + key + '\\s*}}', 'g');
            var value = object[key];
            template = template.replace(regExp, value);
        }
        return template;
    }

    getPageCountFromPageSequence  (pageSeq : string) : string
    {
        console.log("getPageCountFromPageSequence=>",pageSeq);
        if(!pageSeq || pageSeq.length==0 )
        {
            return "0";
        }
        /*
    var pageNumbers  = pageSeq.split(",");
    var pageCn = 0;
    for(var cn = 0; cn < pageNumbers.length ; cn++)
    {
        if(pageNumbers[cn].indexOf('-')>0)
        {
            var range = pageNumbers[cn].split("-");
            var start :number = +range[0];
            var end :number = +range[1];
            pageCn = pageCn + ( end-start ) + 1;
        }
        else
        {
         pageCn = pageCn +1;
        }
    }
         */
        if(this.fileType === 'pdf')
        {
            var pageNumbers  = pageSeq.split(",");
            var pageCn: any = 0;
            for(var cn = 0; cn < pageNumbers.length ; cn++)
            {
                if(pageNumbers[cn].indexOf('-')>0)
                {
                    var range = pageNumbers[cn].split("-");
                    var start :number = +range[0];
                    var end :number = +range[1];
                    pageCn = pageCn + ( end-start ) + 1;
                }
                else
                {
                    pageCn = pageCn +1;
                }
            }
        }
        else if(this.fileType === 'zip')
        {
            /*   if(!pageSeq || pageSeq.length==0 )
        {
            return "0";
        }*/
            var arr = pageSeq.split(',');
            console.log("arr ===>",arr);
            pageCn  = arr.length;

        }
        console.log("pageCn return ===>",pageCn);
        return pageCn+"";
    }

    abort()
    {
      //Added by Sonam K on 06-Sept-19 [To resolve back button issue of assoc object] START
        if(this.contentSandbox.assocObjList.length == 1) {
            console.log('called close from abort');
            this.close();
            return;
        }
      //Added by Sonam K on 06-Sept-19 [To resolve back button issue of assoc object] END
        this.contentSandbox.cleareSelectedTranObjects();
        this.template='';
        this.router.navigateByUrl('assocObjects', { skipLocationChange: true });//P A
        this.ramoveIbaseAng();
    }

   //  Added by Sonam K on 30-JUL-19
    close(){
        this.contentSandbox.onAssocOption.emit(false);
    }

    onDone() {
        var tranObjects = this.contentSandbox.selectedTranObjects ;
        var doc_id = this.content.docId;//doc001
        var ref_sr =this.assocObject.ref_ser; //s-order
        var tranUpateArr: any = []; // to store page info and ref_id
        var tranInsertArr: any = []; // to store page info and ref_id
        var trand_id_col: string =  this.assocObject.trand_id_col;

        for( var tranObj of tranObjects)
        {
            var  tempTranObj:any = {};
        // to porcess only objects having 'action'=(U/I)
        if(!tranObj["action"]) {
            continue;
        }
        tempTranObj["ref_id"] = tranObj["@ref_id"];
        tempTranObj["@page_info"] = tranObj["@page_info"];

        if(tranObj["action"]=="U") {
            tranUpateArr.push( tempTranObj );
        }
        else if(tranObj["action"]=="I") {
            tranInsertArr.push( tempTranObj );
        }
        }

        if(tranUpateArr.length == 0 && tranInsertArr.length == 0) {
            console.log(" Nothing to Update or save");
            this.abort();
            return;
        }

        var transactionObject :object | any = {};
        transactionObject["doc_id"] = doc_id;
        transactionObject["ref_ser"] = ref_sr;
        transactionObject["doc_type_attach"] = this.content.docType;
        transactionObject["update_data_arr"] = tranUpateArr;
        transactionObject["insert_data_arr"] = tranInsertArr;

        this.contentSandbox.updateDocTransPageInfo(transactionObject ,
                (resp: any) => {
                    if(resp.status == "success") {
                        this.assocObject.ref_ser_count = tranObjects.length;
                        this.abort();
                    } else if (resp.status == "failure") {
                        this.status = "failed";
                    }
                }
        );
        //Added by Pravin K on 17-APR-19 [to remove transaction from session storage] START
        this.contentSandbox.getSessionStorageItem(this.storedTransKey);
        //Added by Pravin K on 17-APR-19 [to remove transaction from session storage] START
    }

    changeSelection(selectedTran: any)
    {
        this.status = "loaded";

        if(! this.template)
        {
            this.template = selectedTran.detail.template;
        }

        var parsedHTML = this.createParsedHTML(selectedTran.detail);
        var excObj =this.contentSandbox.getSelectedTranObjectsByTemmplet(parsedHTML);

        if(excObj)
        {
            console.log(" Duplicate transaction .");
            return;
        }

        var pageInfo;
        console.log("for page 1-0 start");
        if(this.fileType  === 'pdf')
        {
            let docPages = this.content.docPages;
            pageInfo = {
                    "selectedPages": docPages == 1 ? 1+'' : "1-"+ docPages ,
                            "importantPages":"",
            };
        }else
        {
            pageInfo = {
                    "selectedPages": "" ,
                    "importantPages":"",
            };
        }
        console.log("for page 1-0 END")
        var transactionFeed : object | any = {};
        transactionFeed["selectedTemplate"] =  parsedHTML;
        transactionFeed["@page_info"] = pageInfo ;
        transactionFeed["@ref_id"] = selectedTran.detail["@ref_id"];
        transactionFeed["action"] = "I";

        this.contentSandbox.selectedTranObjects.splice(0,0,transactionFeed);
        // Added by Sonam K on 30-JUL-19
        let feed: any =this.addNewFeed(transactionFeed, true);

        //Commented by Sonam K on 30-JUL-19
       // let feed: any = this.createFeed(transactionFeed, true);


        /*if(this.divElement)
    {
        this.divElement.insertBefore(feed, this.divElement.firstChild);
    }
    else
    {
        this.divElement = this.elementReference.nativeElement;
        this.divElement.innerHTML="";
        this.divElement.appendChild(feed);
    }*/
        console.log("this.contentSandbox.selectedTranObjects : ",this.contentSandbox.selectedTranObjects);
    }
    onChangeValue(value: any)
    {
        console.log("onChangeValue event get called in filter - input " , value);
        this.filterValue = value;
    }

    // Added by Pravin K on 04-OCT-18 [for add new transaction ] START
    /* this method is to call the transaction PopUp*/
    addTransaction()
    {
        var objName = this.assocObject.obj_name;
        if (objName)
        {
            objName = objName.toLowerCase()
            if (objName.indexOf("w_") == 0)
            {
                objName = objName.substring(2);
            }
        }

        this.contentSandbox.getObjLinksDetails("file_assoc", objName,
                (resp: any) => {
                    console.log("Response in getObjLinksDetails",resp);
                    if(resp.result == "success"){
                        let link = resp.link;
                        let  feedData: any = {};
                        console.log("this.content.extractedData",this.content);
                        if(this.content.extractedData)
                        {
                            feedData = JSON.parse(this.content.extractedData);
                        }
                        // Changed by Pravin on 11-FEB-19 [to set document id for document] START
                        feedData['@fromAng'] = 'true';
                        // Added by Pravin K on 5-Feb-19 [to add document Id ] Start
                        feedData['docId'] =  this.content.docId;
                        feedData['docName'] =  this.content.docName;
                        //Added by Pravin K on 7-AUG-19 [DocumentType pdf logs] START
                        feedData['docType'] =  this.content.docType;
                        //Added by Pravin K on 7-AUG-19 [DocumentType pdf logs] END

                        // Added by Pravin K on 5-Feb-19 [to add document Id ] END
                        // Changed by Pravin on 11-FEB-19 [to set document id for document] END
                        console.log("content",this.content);
                        console.log("links : ",link);
                        console.log("feedData :- ",feedData);
                        //COMENT TO BE REMOVED
                        this.dashboardService.invokeDashboardLink(link, feedData, objName);
                        //Chnaged by Abhishek T. on 11-Feb-2019 [To show transaction popup hidden behind associate popup panel]
                        this.setPopupZindex(1);
                        if(!  (window as any)['ibaseAng'])
                        // if(!  window as { [key: string]: any }['ibaseAng'] as string)

                        {
                            (window as any)['ibaseAng'] = {};
                            (window as any)['ibaseAng']['addNewTranfeed'] = this.addNewTranfeed.bind(this);
                            console.log("window.ibaseAng.addNewTranfeed()..added",this);
                        }

                    }
                    else if(resp.result == "failure"){
                        alert(resp.error);
                    }
                }
        );
    }

    setPopupZindex(size: any){
        console.log("assoc-tran setPopupZindex :  "+size);
        var popupElement = document.getElementsByClassName("cdk-overlay-container");
        if(popupElement[0])
        {
            // popupElement[0].setAttribute("style","z-index: "+size+";");//tobe ch
            var el:any =  popupElement[0];
        el.style.zIndex = size;//tobe ch
        }
    }
    // This is the method use as call back after adding new transaction.
    addNewTranfeed(tranId: any)
    {

        console.log("new transaction added with tranId : "+tranId);
        var objName = this.assocObject.obj_name;
        if(objName)
        {
            objName = objName.toLowerCase()
            if(objName.indexOf("w_") == 0)
            {
                objName = objName.substring(2);
            }
        }
        // To get details of tranId (template,details..)
        //Added By pravin k for on 10-DEC-2018  START
        var objNameRefser =  "ASSOCIATE_TRANSACTION:"+this.assocObject.ref_ser
        var trand_id_col = this.assocObject.trand_id_col ;
        trand_id_col = trand_id_col.toUpperCase();
        //Added By pravin k for on 10-DEC-2018  END

        this.contentSandbox.getTransactionDetails(this.content.docId, this.content.docType, this.assocObject.ref_ser,
                objNameRefser, this.assocObject.table_name, trand_id_col, tranId,
                (resp: any) => {
                    console.log("Response in getTransactionDetails",resp);
                    if(resp.result == "success"){

                        console.log("assoc-transaction :: getTransactionDetails :: resp",resp);
                        if(this.status!="loaded")
                        {
                            this.status = "loaded";
                            this.zone.run(() => {
                                console.log( 'view refreshed' );
                            });
                        }
                        this.changeSelection(resp);
                    }
                    else if(resp.result == "failure"){
                        console.log(resp.error);
                    }
                    this.ramoveIbaseAng();
                    this.setPopupZindex(1000);
                }
        );
    }

    ramoveIbaseAng() {
        if((window as any)['ibaseAng']){
            delete (window as any)['ibaseAng']
            console.log("ibaseAng deleted .......");
        }
        console.log("component distroyed  and ibaseAng deleted .......");
    }
    // Added by Pravin K on 04-OCT-18 [for add new transaction ] END
}