import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { ChartService } from './chart.service';

import { ChartComponentComponent } from './chart-component.component';
import { BBChartsModule } from './bb-chart.directive';
import {sanitizeHtmlPipe} from './sanitizer.pipe';

@NgModule({
  declarations: [
    ChartComponentComponent,
    sanitizeHtmlPipe
  ],
  imports: [
    BrowserModule,
    BBChartsModule
  ],
  providers: [ChartService],
  bootstrap: [],
  exports: [ChartComponentComponent],
  entryComponents:[ChartComponentComponent],
})
export class ChartComponentModule { }
