import { BrowserModule } from '@angular/platform-browser';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';

import { HttpClientModule } from '@angular/common/http';


import { BackgroundJobStatusComponent } from './background-job-status.component';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { ReactiveFormsModule, FormsModule } from '@angular/forms';
import { BackgroundJobStatusService } from "./background-job-status.service";
import { BackgroundJobDetailComponent } from './background-job-details/background-job-detail.component';

@NgModule({
  declarations: [
    BackgroundJobStatusComponent,
    BackgroundJobDetailComponent
  ],
  imports: [
    BrowserModule,
    HttpClientModule,
    //new added
    FormsModule,
    ReactiveFormsModule,
    BrowserAnimationsModule,
  ],
  providers: [BackgroundJobStatusService],
  

  exports: [BackgroundJobStatusComponent],
  entryComponents:[BackgroundJobStatusComponent,BackgroundJobDetailComponent],
  schemas:[
    CUSTOM_ELEMENTS_SCHEMA,
  ],
})
export class BackgroundJobStatusModule { }
