import { Component, OnInit , ViewEncapsulation , AfterViewChecked ,ChangeDetectorRef ,Input} from '@angular/core';
import { SafeHtml } from '@angular/platform-browser';
import { DatePipe } from '@angular/common'
import { BackgroundJobStatusService } from "../background-job-status.service";

@Component({
  selector: 'background-job-detail',
  templateUrl: './background-job-detail.component.html',
  styleUrls: ['./background-job-detail.component.css'],
  encapsulation: ViewEncapsulation.None, 
  providers:[DatePipe]

})
export class BackgroundJobDetailComponent implements OnInit , AfterViewChecked  {
    
  public errorMsg: any;
  safeHtmlvalue:SafeHtml | any;
  public tableHtml: any;   
  public context:any = {};
  public docId:any;
  isContext: boolean = false;
   
  constructor(private cdr: ChangeDetectorRef, private _BackgroundjobService:BackgroundJobStatusService) { } 
  @Input('jobId') jobId: any;
  ngOnInit()
  {
    this._BackgroundjobService.getBackgroundjobStatus(this.jobId).subscribe(
      data=> {
        if(data)
        {
          this.isContext = true;
          this.context = data;
          console.log('context===',data); 
        }
      },
      error => this.errorMsg = error);
  }

  ngAfterViewChecked() {
    this.cdr.detectChanges();
  }
}