import { Component, OnInit,Input,OnDestroy } from '@angular/core';

@Component({
  selector: 'session-activity-data',
  templateUrl: './session-activity-data.component.html',
  styleUrls: ['./session-activity-data.component.css']
})
export class SessionActivityDataComponent implements OnInit,OnDestroy {

  @Input() allSessionData: any;
  @Input() hostUrl: any;
  ASSET_IMG_URL = "dashboard/assets/images";
  USR_ERR_URL: any;
  OBJ_ERR_URL: any;
  CLIENTAPP_URL: any;
  USR_URL: any;
  OBJ_URL: any;
  CLIENTAPP_ERR_URL: any;
    
  constructor() { }

  ngOnInit() {
      if(!this.hostUrl){
          this.ASSET_IMG_URL = "/ibase/E12BROWSER/"+this.ASSET_IMG_URL;
      }
      this.setUrls();
  }

  errorHandler( data: any, iconName: any, event: any ) {
      if ( data == 'userImage' ) {
          event.target.src = this.USR_ERR_URL;
      }
      else if ( data == 'object' ) {
          event.target.src = this.OBJ_ERR_URL;
      }
      else {
          event.target.src = this.CLIENTAPP_ERR_URL;
      }
  }
  imageUrl( data: any, iconName: any ) {
      if ( data == 'userImage' ) {
          return this.USR_URL + iconName + ".png";
      }
      else if ( data == 'object' ) {
          return this.OBJ_URL + iconName + ".png";
      }
      else {
          return this.CLIENTAPP_URL + iconName + ".png";
      }
  }
  
  //checkTime(hours,min,sec){
  checkTime(timeObject: any){
   // console.log('timeObject ',timeObject);
    if(timeObject)
    {
      var  hours=timeObject.hours;
      var  min=timeObject.minutes;
      var  sec=timeObject.seconds;
      if(hours==0 && min==0 && sec ==0){
          return "Few msecs";
      }
      else if(hours != 0 ){
          if(hours > 1 ){
              return hours+" hrs";
          }
          else{
              return hours+" hr";
          }
      }
      else if( min != 0 ){
          if(min > 1 ){
              return min+" mins";
          }
          else{
              return min+" min";
          }
       }
      else if(sec != 0 ){
          if(sec > 1 ){
              return sec+" secs";
          }
          else{
              return sec+" sec";
          }
      }
    }
    else
    {
        return '';
    }
  } 
  
  checkData(data: any){
      if(data)
      {
          return data;
      }
      else{
          return 'NA';
      }
      
      
  }
  
  setUrls(){
      if(!this.hostUrl){
          this.hostUrl = '';
      }
      this.USR_ERR_URL=this.hostUrl+'/ibase/images/userImages/errUser.png';
      this.USR_URL=this.hostUrl+'/ibase/images/userImages/';
      this.OBJ_ERR_URL=this.hostUrl+'/ibase/images/menuImages/mob/errMenu.png';
      this.OBJ_URL=this.hostUrl+'/ibase/images/menuImages/mob/';
      //CLIENTAPP_ERR_URL=this.ASSET_IMG_URL+'/icons/clientApp.png';
      this.CLIENTAPP_ERR_URL=this.ASSET_IMG_URL+'/svg/Browser.svg';
      this.CLIENTAPP_URL=this.ASSET_IMG_URL+'/icons/';
  }
  ngOnDestroy() 
  {
      console.log('session-activity ngOnDestroy..');
  }
  
}
