import { Component, OnInit, Input, ViewChild, ElementRef, ViewEncapsulation,OnDestroy} from '@angular/core';

@Component({
  selector: 'bb-battery',
  templateUrl: './bb-battery.component.html',
  styleUrls: ['./bb-battery.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class BBBatteryComponent implements OnInit ,OnDestroy{

  @ViewChild('baterryStart') batteryStart : ElementRef | any;
  @ViewChild('baterryEnd') batteryEnd : ElementRef | any;

  @Input('current') dataPercent: number = 70;
  @Input('min') dataPercentLow: number = 10;
  @Input('mid') dataPercentMed: number = 50;
  @Input('size') batterySize: string = 'large'; // large, medium, small

  @Input('width') batteryWidth: number = 100;
  
  constructor() { }

  ngOnInit() {
      console.log('ngOnInit dataPercent ', this.dataPercent);
  }

  ngOnChanges(changes: any){
    console.log('ngOnChanges dataPercent ', changes, this.dataPercent);
    if( this.batterySize === 'medium' )
    {
      this.batteryWidth = 75;
    }
    else if( this.batterySize === 'small' )
    {
      this.batteryWidth = 50;
    }

    if( changes.dataPercent )
    {
      console.log('dataPercent ', this.dataPercent);
      var startDiv = this.batteryStart.nativeElement;
      var endDiv = this.batteryEnd.nativeElement;
      if( this.dataPercent )
      {
        var width = ( this.dataPercent/100 * this.batteryWidth ) - 8 ;
        console.log('changes width ', width, this.batteryWidth);
        if( width > this.batteryWidth )
        {
          startDiv.style.width = (this.batteryWidth - 8) + 'px';
        }
        else if( width > 0 )
        {
          startDiv.style.width = width + 'px';
        }
        else 
        {
          startDiv.style.width = '0px';
        }
      }
      else 
      {
        startDiv.style.width = '0px';
      }
      
    }
  }
  
  getStatus()
  {
    if (this.dataPercent < this.dataPercentMed && this.dataPercent >= this.dataPercentLow + 1 ) 
    {
      return 'moderate';
    } 
    else if (this.dataPercent <= this.dataPercentLow) 
    {
      return 'critical';
    }
    return '';
  }
  ngOnDestroy() 
  {
      console.log('battery-activity ngOnDestroy..');
  }
  
}
