import { Component, OnInit, ViewEncapsulation,EventEmitter, Input, Output,OnDestroy } from '@angular/core';
// import { Subscription } from 'rxjs/Subscription';
import { AccountActivityService } from './account-activity.service';
import { Subscription } from 'rxjs';

@Component( {
    selector: 'account-activity',
    templateUrl: './account-activity.component.html',
    styleUrls: ['./account-activity.component.css'],
    //encapsulation: ViewEncapsulation.None
} )
export class AccountActivityComponent implements OnDestroy {

    constructor( public appService: AccountActivityService) { }
    jsonData: any[] = []; 
    allUserData: any[] = [];
    HOST_URL: any;
    
    subscription: Subscription | any;
    
    @Input('data') response : any;
    
    ngOnInit() 
    {
        this.HOST_URL = this.appService.getHostURL();
        console.log('response of account activity',this.response);
        this.readData();
    }

    readData() {
        //var result = JSON.parse(this.response.data);
        var result = this.response.data;
        console.log('result of account activity',result);
        this.allUserData = result["ACTIVITY_DATA"];
        console.log('allUserData',this.allUserData);
    }
    
    ngOnDestroy() 
    {
        console.log('AccountActivityComponent ngOnDestroy..');
        // unsubscribe to ensure no memory leaks
        //this.subscription.unsubscribe();
    }
        
}
