import { Component, OnInit, OnDestroy, ChangeDetectorRef,Input } from '@angular/core';
import { AmChartsService, AmChart } from '@amcharts/amcharts3-angular';

export const COLORS = {
  BROWSER : '#b5bafd', //violet: #b5bafd;
  MOBILE : '#fb9d9e', //peach: #fb9d9e;
  CHROME : '#fff36a', //yellow:#fff36a;
  INTEXP : '#8cb1fc', //blue: #8cb1fc;
  MOZILLA : '#fd7c82', //red :#fd7c82;
  ANDROID : '#53fa82', //green : #53fa82;
  IOS : '#a7a7a7', //gray: #a7a7a7;
  OTHER : '#d8b4fd' //violet: #d8b4fd;
}

@Component({
  selector: 'acc-activity-graph',
  templateUrl: './acc-activity-graph.component.html',
  styleUrls: ['./acc-activity-graph.component.css']
})
export class AccActivityGraphComponent implements OnInit, OnDestroy {
    
  @Input('data') response : any;

  activityData:any;
  
  public options: any;
  private chart1: AmChart | any;
  private chart2: AmChart | any;
  batteryPerc : number = 100;
  colors = COLORS;
  totalData: any;
  DATA = {
      BROWSER : {
        TOTAL : 0, 
        CHROME : 0, 
        INTEXP : 0, 
        FIREFOX : 0,
        OTHER : 0
      },  
      MOBILE : {
        TOTAL: 0, 
        ANDROID : 0, 
        IOS : 0, 
        OTHER : 0
      }
  };
  DATA_PERC = {
      BROWSER : {
        TOTAL : 0, 
        CHROME : 0, 
        INTEXP : 0, 
        FIREFOX : 0,
        OTHER : 0
      },  
      MOBILE : {
        TOTAL: 0, 
        ANDROID : 0, 
        IOS : 0, 
        OTHER : 0
      }
   };
  constructor(private AmCharts: AmChartsService, public changeDetectorRef : ChangeDetectorRef) {}

  ngOnInit() {
    console.log('response of account activity',this.response);
    this.readData();
    console.log('AccActivityGraphComponent activityData',this.activityData)
    if( this.activityData && this.activityData.BROWSER )
    {
        this.DATA = this.activityData;
        this.calcPercentage();
        this.createChart1();
        this.createChart2();
    }
  }
  readData() {
      //var result = JSON.parse(this.response.data);
        var result = this.response.data;
      console.log('result of account activity',result);
      this.activityData = result["ACTIVITY_GRAPH_DATA"];
  }

  createChart2()
  {
      console.log('createChart2',this.DATA);
      this.changeDetectorRef.detectChanges();

    this.chart2 = this.AmCharts.makeChart("chart2", {
      "type": "pie",
      "bringToFront": true,
      "dataProvider": [{
        "title": "Firefox",
        "value": this.DATA.BROWSER.FIREFOX,
        "perc": this.DATA_PERC.BROWSER.FIREFOX,
        "color": COLORS.MOZILLA
      }, {
        "title": "Internet Explorer",
        "value": this.DATA.BROWSER.INTEXP,
        "perc": this.DATA_PERC.BROWSER.INTEXP,
        "color": COLORS.INTEXP
      }, {
        "title": "Chrome",
        "value": this.DATA.BROWSER.CHROME,
        "perc": this.DATA_PERC.BROWSER.CHROME,
        "color": COLORS.CHROME
      }, {
        "title": "Other",
        "value": this.DATA.BROWSER.OTHER,
        "perc": this.DATA_PERC.BROWSER.OTHER,
        "color": COLORS.OTHER
      },{
        "title": "Android",
        "value": this.DATA.MOBILE.ANDROID,
        "perc": this.DATA_PERC.MOBILE.ANDROID,
        "color": COLORS.ANDROID
      }, {
        "title": "iOS",
        "value": this.DATA.MOBILE.IOS,
        "perc": this.DATA_PERC.MOBILE.IOS,
        "color": COLORS.IOS
      }, {
        "title": "Other",
        "value": this.DATA.MOBILE.OTHER,
        "perc": this.DATA_PERC.MOBILE.OTHER,
        "color": COLORS.OTHER
      }],
      "startAngle": 90 ,
      "startDuration": 0,
      "pullOutRadius": 0,
      "color": "#000",
      "fontSize": 9,
      "titleField": "title",
      "valueField": "value",
      "colorField": "color",
      "labelColor": "#000",
      "labelRadius": 80,
      "labelTickColor": "#000",
      "labelTickAlpha": "0.5",
      "radius": 80,
      "innerRadius": 0,
      "outlineAlpha": 1,
      "outlineThickness": 1,
      "labelText": "[[title]]",
      "balloonText": "[[title]]: [[perc]]",
       "responsive":{
          "enabled":true
        }
//      "legend" :{
//        "accessibleLabel": "[[title]]",
//        "combineLegend" : true,
//        "switchable" : false,
//        "useGraphSettings" : false,
//       // "divId": "lengend1",
//        //"position":"right",
//        //"marginRight":100,
//        "autoMargins":true
//       
//      }
    });
  }
  
  createChart1()
  {
      console.log('createChart1',this.DATA);
      this.changeDetectorRef.detectChanges();

    this.chart1 = this.AmCharts.makeChart("chart1", {
      "type": "pie",
      "bringToFront": true,
      "dataProvider": [{
        "title": "Browser",
        "value": this.DATA.BROWSER.TOTAL,
        "perc": this.DATA_PERC.BROWSER.TOTAL,
        "color": COLORS.BROWSER
      }, {
        "title": "Mobile",
        "value": this.DATA.MOBILE.TOTAL,
        "perc": this.DATA_PERC.MOBILE.TOTAL,
        "color": COLORS.MOBILE
      }],
      "startAngle": 90 ,
      "startDuration": 0,
      "pullOutRadius": 0,
      "color": "#000",
      "fontSize": 8,
      "titleField": "title",
      "valueField": "value",
      "colorField": "color",
      "labelColor": "#000",
      "labelRadius": -27,
      "labelTickColor": "#000",
      "labelTickAlpha": "0.5",
      "radius": 135,
      "innerRadius": 82,
      "outlineAlpha": 1,
      "outlineThickness": 1,
      "labelText": "[[title]]",
      "balloonText": "[[title]]: [[perc]]",
      "responsive":{
          "enabled":true
        }
//      "legend" :{
//        "accessibleLabel": "[[title]]",
//        "combineLegend" : true,
//        "switchable" : false,
//        "useGraphSettings" : false,
//      //  "divId": "lengend2",
//        //"position":"right",
//        //"marginRight":100,
//        "autoMargins":true
//        
//      }
    });
  }

  ngOnDestroy() {
    //clearInterval(this.timer);

    // Cleanup chartdiv2
    if (this.chart1) {
      this.AmCharts.destroyChart(this.chart1);
    }
    if (this.chart2) {
      this.AmCharts.destroyChart(this.chart2);
    }
  }
  
   calcPercentage()
    {
        console.log('calPerc ',this.DATA);
        
        this.DATA_PERC.BROWSER.FIREFOX = this.calcPerc(this.DATA.BROWSER.FIREFOX, this.DATA.BROWSER.TOTAL);

        this.DATA_PERC.BROWSER.CHROME = this.calcPerc(this.DATA.BROWSER.CHROME, this.DATA.BROWSER.TOTAL);
        
        this.DATA_PERC.BROWSER.INTEXP = this.calcPerc(this.DATA.BROWSER.INTEXP, this.DATA.BROWSER.TOTAL);
        
        this.DATA_PERC.BROWSER.OTHER = this.calcPerc(this.DATA.BROWSER.OTHER, this.DATA.BROWSER.TOTAL);
        
        this.DATA_PERC.MOBILE.ANDROID = this.calcPerc(this.DATA.MOBILE.ANDROID, this.DATA.MOBILE.TOTAL);
        
        this.DATA_PERC.MOBILE.IOS = this.calcPerc(this.DATA.MOBILE.IOS, this.DATA.MOBILE.TOTAL);
        
        this.DATA_PERC.MOBILE.OTHER = this.calcPerc(this.DATA.MOBILE.OTHER, this.DATA.MOBILE.TOTAL);

        var OVERALL_TOTAL = this.checkIntNull( this.DATA.BROWSER.TOTAL ) + this.checkIntNull( this.DATA.MOBILE.TOTAL );
        console.log('OVERALL_TOTAL',OVERALL_TOTAL);
        
        this.DATA_PERC.MOBILE.TOTAL = this.calcPerc(this.DATA.MOBILE.TOTAL, OVERALL_TOTAL);
        
        this.DATA_PERC.BROWSER.TOTAL = this.calcPerc(this.DATA.BROWSER.TOTAL, OVERALL_TOTAL);
        this.totalData=this.checkIntNull( this.DATA.BROWSER.TOTAL ) + this.checkIntNull( this.DATA.MOBILE.TOTAL );

        console.log('DATA_PERC:::',this.DATA_PERC);

    }
    
    calcPerc(value: any , total: any)
    {
        return Math.round(this.checkIntNull(value / total) * 100 * 100)/100;
    }
    
    checkIntNull(value: any)
    {
       if( value )
       {
           return value;
       }
       return 0;
    }
    
}
