import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

import { MatSelectModule } from '@angular/material/select';
import { MatInputModule } from '@angular/material/input';

import { UserTaskComponent } from './user-task.component';
import { BBAutosuggestModule } from 'base-blocks';
import { HttpClientModule } from '@angular/common/http';
import { UserTaskService } from './user-task.service';


import { ADD_PLUGINS } from '../../plugin/utils/bb-plugin-util';
ADD_PLUGINS('user-task', UserTaskComponent);

@NgModule({
  declarations: [ UserTaskComponent],
  imports: [
    CommonModule,
    MatSelectModule,
    MatInputModule,
    BBAutosuggestModule,
    HttpClientModule
  ],
  exports: [
    UserTaskComponent
  ],
  entryComponents: [
    UserTaskComponent
  ],
  providers: [UserTaskService],
})
export class UserTaskModule { }
