import { Component, OnInit, Input } from '@angular/core';
import { getAssetImgUrl }  from '../../shared/hostUrl';

@Component({
  selector: 'calls-info',
  templateUrl: './calls-info.component.html',
  styleUrls: ['./calls-info.component.css']
})
export class CallsInfoComponent implements OnInit {

  @Input() todaysCallInfo:any; 
  
  ASSET_IMG_URL:any;
  blockWidth = "calc(25% - 1px)";
    
  constructor() { }

  ngOnInit() {
      this.ASSET_IMG_URL = getAssetImgUrl();
      if(this.todaysCallInfo && this.todaysCallInfo.VISIT_SUMMARY)
      {
         switch (this.todaysCallInfo.VISIT_SUMMARY.length) {
             case 1:
        	    this.blockWidth = "calc(100% - 1px)";
        		break;
             case 2:
                this.blockWidth = "calc(50% - 1px)";
                break;
             case 3:
                this.blockWidth = "calc(33.33% - 1px)";
                break;
             case 4:
                this.blockWidth = "calc(25% - 1px)";
                break;
             default:
        		break;
        }
      }
  }
  
  getImgUrl(optionType:any) {
      var imgIcons = this.ASSET_IMG_URL;
      
      imgIcons = imgIcons + "/svg/cust_type_"+optionType+".svg";

      return imgIcons;
  }

}
