import { Injectable } from '@angular/core';
//import { Http,Response, RequestOptions,Headers} from '@angular/http';
// import 'rxjs/add/operator/map';
import { Observable } from 'rxjs';
import { HttpClient, HttpResponse, HttpHeaders } from '@angular/common/http';
//import { RequestOptions, Http, Response, Headers } from '@angular/http';
import { map } from 'rxjs/operators';

declare var getBBHostURL : any;


@Injectable({
  providedIn: 'root'
})

export class SellPlanningService {

  private url=  "/ibase/rest/SellStockService";
  private dashBoardUrl = "/ibase/rest/SellStockService/getSellPerformance";
  private _url: string = "/ibase/WEBITMRIARequestHandlerServlet?";
  private _urlPophelpFields = "/ibase/RIAWizardHandlerServlet?";

  constructor( private http:HttpClient) { }

  getSellsPlanDetails( data: any )
  {
    console.log( "getSellsPlanDetails method Called",JSON.stringify(data) );
    let url = getBBHostURL() + this.url + '/getSellsPlanData';
    let headers = new HttpHeaders( { 'Content-Type': 'application/json' });
    let options = {headers: headers};
    return this.http.post<any>(url, JSON.stringify(data) , options)
          .pipe( map( (res) => this.extractData(res) ) );
  }

  private extractData(res: HttpResponse<any>) {
    //let body = res.json();
     console.log('extractData[' + JSON.stringify(res) + ']');
     return res || { };
 }
  getHostURL() 
  {
    // var HOST_URL: string = '';
    var HOST_URL: any = '';
    HOST_URL = localStorage.getItem('HOST_URL');
    if (!HOST_URL) HOST_URL = '';
    console.log('getHostURL..[', HOST_URL, ']');
    return HOST_URL;
  }

 getSellPerformanceDashboardData( data: any ):Observable<any>
 {
    console.log( "onFinishSellPlanning method Called",JSON.stringify(data) );
    let url = getBBHostURL() + this.dashBoardUrl;
     let headers = new HttpHeaders( { 'Content-Type': 'application/json' });
    let options = {headers: headers};
   return this.http.post<any>(url, JSON.stringify(data) , options)
   .pipe( map( (res) => this.extractData(res) ) );
 } 

  //Added by Vikas L. on 16-Jan-2020-start
  itemChange(columnName: any,value: any,paramValue: any) : Observable<any>{ 
    var url = getBBHostURL() + this.url + "/itemChange" +"/" +columnName + "/" +value + "/" +paramValue;
    console.log("##### itemChange rest service ==>", url);
    let headers = new HttpHeaders({ 'Content-Type': 'application/json' });
    let options = {headers: headers};
    return this.http.get<any>( url , options) 
    // .map( (res: any) => this.extractData(res) );
    .pipe(map( (res) => this.extractData(res) ));
  }

  onValidation(columnName: any,value: any) : Observable<any>{ 
    var url = getBBHostURL() + this.url + "/getSellStockValidate" +"/" +columnName + "/" +value;
    console.log("##### onValidation rest service ==>", url);
    let headers = new HttpHeaders({ 'Content-Type': 'application/json' });
    let options = {headers: headers};
    return this.http.get<any>( url , options) 
    // .map( (res) => this.extractData(res) );
    .pipe(map( (res) => this.extractData(res) ));
  }

  defaultSellPlan() : Observable<any>{ 
    var url = getBBHostURL() + this.url + "/sellPlanningDefault" ;
    console.log("##### defaultSellPlan rest service ==>", url);
     let headers = new HttpHeaders({ 'Content-Type': 'application/json' });
    let options = {headers: headers};
    return this.http.get<any>( url , options) 
    // .map( (res) => this.extractData(res) );
    .pipe(map( (res) => this.extractData(res) ));
  }

  getEncodedParamString(paramMap: any): any 
  {
    var encodedString = "";
    for (let k in paramMap) {
      var key = k;
      var value = paramMap[k];
      var encod = encodeURIComponent(key) + "=" + encodeURIComponent(value) + "&";
      encodedString += encod;
    }
    encodedString = encodedString.substring(0, encodedString.length - 1);
    console.log("the encodedString :" + encodedString);
    return encodedString;
  }

  onFinishSellPlanning( data: any ): Observable<any>
  {
    console.log( "onFinishSellPlanning method Called",JSON.stringify(data) );
    let url = getBBHostURL() + this.url + '/planningDone';
     let headers = new HttpHeaders( { 'Content-Type': 'application/json' });
    let options = {headers: headers};
    return this.http.post<any>(url, JSON.stringify(data) , options)
          .pipe( map( (res) => this.extractData(res) ) );
  }
  //Added by Pooja S. on 10/04/2020-Start
  onSentBackSellPlanning( data: any ): Observable<any>
  {
    console.log( "onSentBackSellPlanning method Called",JSON.stringify(data) );
    let url = getBBHostURL() + this.url + '/sentBackPlan';
    let headers = new HttpHeaders( { 'Content-Type': 'application/json' });
    let options = {headers: headers};
    return this.http.post<any>(url, JSON.stringify(data) , options)
          .pipe( map( (res) => this.extractData(res) ) );
  }
  //Added by Pooja S. on 10/04/2020-End
  setLoading(flag : boolean)
  {
    try
    {
      (<any>window.parent).setLoading(flag);
    }
    catch{
      console.log('window.setLoading is not a function!!');        
    }
  }
  //Added by Vikas L. on 16-Jan-2020-End
//changed and Added by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ] Start
  getValidPopupMsg(msgType: string, message: string, errorMsg: string, desc? : string, trace? :String)
  {
    var msg = "";
    msgType = msgType? msgType : "";
    desc = desc? desc : "";
    trace = trace? trace : "";
    errorMsg = errorMsg? errorMsg : "";
   
    if(msgType.toUpperCase() == "E" || msgType.toUpperCase() == "X" || msgType.toUpperCase() == "W")
    {
      if(message.length == 0 && errorMsg.length == 0)
      {
        msg = (msgType.toUpperCase() == "E")? "Error" : (msgType.toUpperCase() == "W")? "Warning":"Exception";
      }
      else if(message.length == 0 && errorMsg.length > 0)
      {
        msg = errorMsg;
      }
      else if(message.length > 0 && errorMsg.length == 0)
      {
        msg = message;
      }
      else if ( trace != undefined )
      {
        msg = message + '.<br><br>' + errorMsg + '.<br><br>' + trace;
      }
      else
      {
        msg = message + '.<br><br>' + errorMsg;
      }
    }
    else if(desc != undefined)
    {
      msg = (desc && desc.length > 0)? desc : "Success";
    }
    //console.log(" ssssss msg = "+msg);
    return msg;
  }
    //changed and Added by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ] End

}
