import {Component, ViewEncapsulation, OnInit, Input, Output, EventEmitter, AfterViewInit, HostListener} from '@angular/core';

@Component({   
    selector: 'sell-planning-detail',
    styleUrls: ['sell-planning-detail.component.css'],
    templateUrl: 'sell-planning-detail.component.html',
    encapsulation: ViewEncapsulation.None
})
export class SellPlanningDetailComponent implements OnInit, AfterViewInit{

    @Input() displayFilter = true;
    @Input() displayPaginator = false; //should set false in case u need row wise total otherwise it goes in continuous loop
    @Input() ELEMENT_DATA: any[] = [];
    @Input() totalFlag = true;
    @Input() freezColumns = 2;//To set the freez callumns
    @Input() groupByRowCol = 2;//To set the group by rows in column
    @Input() rowWiseTotal = false; //To get row wise calculated total && displayPaginator should be false
    @Input() headerRotate = false;//to set the header label position
    @Input() _sumofKeys: any[]= [];//to get colum wise total at footer eg.['Sell In', 'Sell Out']
    @Input() rateWiseSumOfKeys: any[] = []; 
    @Input("finishButton") finishButton: string | any;
    @Input("cancelButton") cancelButton: string | any;
    @Input("saveButton") saveButton: string | any;
    @Input("sentBackButton") sentBackButton: string | any;

    optionPanelFlag = true; 
    @Output() onFinsh: EventEmitter<any> = new EventEmitter();
    @Output() onSentBack: EventEmitter<any> = new EventEmitter();
    @Output() save: EventEmitter<any> = new EventEmitter();

    @Input() dashBoardData :any[] = []
    _opened: boolean = false;
    @Input() period = "";
 // Added by Sainath T. on 29-09-2020
 @Input() definedCellTotalUpdates : boolean = false;
    options = {
        "options": [
        {
            "id":"1",
            "component": "sell-performance",
            "title": "Sales Performance", 
            "image": "sell_performance.svg",
            "tooltip": "To perform grouping on drop columns here"
        },
        ]
    };
    public componentName = "Sell Planning";
    private sideBarContainerHeight: number | any;
    definedCellTotalJson: any = {};
    @Output() cancel: EventEmitter<any> = new EventEmitter();
    
    // Sainath T. on 10-04-2020 -Start  
    @Input() isSubordinateCall :boolean = false;
    @Input() isSubmitDisable :boolean = false;
    // Sainath T. on 10-04-2020 - End
    //added by sainath t. on 29-09-2020
    @Input() isMobile = false;
    ngOnInit()
    {
        // console.log('in Sales planning ngOnInit!!' + JSON.stringify(this.ELEMENT_DATA));
        console.log('in Sales planning ngOnInit!!');
        this.setCompnentHeight();

    }

    ngAfterViewInit()
    {
        this.setCompnentHeight();
    }
    onDone(data: any[])
    {
        //console.log('in salespanning component data>>'+ JSON.stringify(data));
        this.onFinsh.emit(data);
    }
    //Added by Pooja S on 10/04/2020-Start
    onReset(data: any[])
    {
        //console.log('in salespanning component onSentBack  data>>'+ JSON.stringify(data));
        this.onSentBack.emit(data);
    }
    //Added by Pooja S on 10/04/2020-End
    saveSellsPlan(data: any[])
    {
        this.save.emit(data);
    }
   
    setCompnentHeight() {
        this.sideBarContainerHeight = window.innerHeight;
        //console.log('Sales planning setCompnentHeight!! sideBarContainerHeight>>' +this.sideBarContainerHeight);
        var sideBarContatiner: any = document.getElementsByTagName('ng-sidebar-container');
        //var bbTableContainer = document.getElementById('bb-table-container');
        var mobileContents = document.getElementById('MobileContents');
        
        if( mobileContents && sideBarContatiner ) //window.innerHeight < window.innerWidth for landscape  ---&& bbTableContainer 
        {
            // document.getElementById('MobileContents').style.height = (this.sideBarContainerHeight - 97)+'px';//105
            document.getElementById('MobileContents')!.style.height = (this.sideBarContainerHeight - 97)+'px';//105
        }
        if(sideBarContatiner && sideBarContatiner.item(0))
        {
            // Changed by Sainath T. on 29-09-2020
            let minusValue = this.isMobile ? 97 : 108;
            sideBarContatiner.item(0).setAttribute('style','height:'+(this.sideBarContainerHeight - minusValue )+'px');//105
        }
        /* if(bbTableContainer)
        {
            bbTableContainer.setAttribute('style','max-height:'+(this.sideBarContainerHeight - 206)+'px');
        }  */           
    }

    @HostListener('window:orientationchange', ['$event']) 
    orientationChange(event: any) 
    {
        this.setCompnentHeight();
    }

    @HostListener('window:resize')
    onKeyboardInvoke(){
      //console.log("onKeyboardInvoke window.innerWidth >>",window.innerWidth);
      this.setCompnentHeight();
    }

    emitDefinedColTotal( totalJson: any )
    {
        //console.log('<<<emitDefinedColTotal in sell planning>>>');
        this.definedCellTotalJson = totalJson;
    }
    onCancel()
    {
        this.cancel.emit();
    }
}