import { Component, OnInit, OnChanges, Input, Output, EventEmitter } from '@angular/core';
import { TOGGLE_SIDEPANEL_WIDTH } from '../sell-planning-util';
//import { BIReportComponent } from '../bi-report/bi-report.component';

@Component({
  selector: 'sell-option-panel',
  templateUrl: './sell-option-panel.component.html',
  styleUrls: ['./sell-option-panel.component.css']
})
export class SellOptionPanelComponent implements OnInit, OnChanges {

  @Input() _opened : boolean = false;
  @Input() _expand : boolean = false;
  @Input() column_list : any;
  @Input() qCount : any;
  @Input() fromMailIds: any; 
  @Input() biReportName : any;
  @Input() biReportSql : any; //24-10-2019
  
  @Input() options : any;
  @Output() optionChange: EventEmitter<any> = new EventEmitter();

  public selectedOpt: any = {};
  @Input() definedCellTotalJson = {};
  @Input() dashBoardData:any[] = [];
  @Input() period = "";
  @Input('clearAllParameters') isSubordinateCall :boolean = false;
  constructor() { }

  ngOnInit() 
  {
    this.resetOptions();    
  }
  
  ngOnChanges()
  {
      //console.log('sell-option definedCellTotalJson::',this.definedCellTotalJson);
  }

  public _toggleSidebar(option : any): void 
  {
    if( option )
    {
      if(this._opened)
      {
        if(option.id == this.selectedOpt.id )
        {
          this._opened = false;
          this.optionChange.emit(this._opened);
        }
        else 
        {
          this.resetOptions();
          option._opened = !option._opened;
        }
      }
      else
      {
        this._opened = true;
        this.optionChange.emit(this._opened);
        this.resetOptions();
        option._opened = !option._opened;
      }
      this.selectedOpt = option;
      
      TOGGLE_SIDEPANEL_WIDTH(this.selectedOpt.expand_state);
      
      //console.log(this._opened , option._opened);
    }
  }

  public resetOptions()
  {
    if( this.options && this.options.options ){
      this.options.options.map((option: any) => {
          option['_opened'] = false;
      });
    }
  }
  
  public _toggleSidebarWidth(state : boolean): void 
  {
  	TOGGLE_SIDEPANEL_WIDTH(state);
  	this.resetExpandState();
  }
  
  public resetExpandState()
  {
    if( this.options && this.options.options ){
      this.options.options.map((option: any) => {
         if(option.id == this.selectedOpt.id )
         {
         	option.expand_state= !option.expand_state;
         }
      });
    }
  }
}
