import { Component, Input,ElementRef } from '@angular/core';
import { DataModelService } from '../data-model.service';

@Component({
  selector: 'customer-info',
  templateUrl: './customer-info.component.html',
  styleUrls: ['./customer-info.component.css']
})
export class CustomerInfoComponent {

    @Input('data') dashboardData:any;
    customerInfo:any;
    hostUrl = '';
    ASSET_IMG_URL = "dashboard/assets/images";
    errorImg:any;
    //imgUrl = '/ibase/E12BROWSER/dashboard/assets/images/svg/';
    
    custImgUrl:any;
    
    constructor(private _dataService: DataModelService,public elementRef: ElementRef){
        
    }
    
    ngOnInit(){
        console.log('DashboardData:',this.dashboardData);
        
        this.hostUrl = this._dataService.getHostURL();
        if(!this.hostUrl){
            this.ASSET_IMG_URL = "/ibase/E12BROWSER/"+this.ASSET_IMG_URL;
        }
        this.errorImg = this.ASSET_IMG_URL+'/broken-image.png';
        
        this.customerInfo = this.dashboardData.data;
        var sc_code = this.customerInfo.SC_CODE ? this.customerInfo.SC_CODE.trim() : "";
        var sc_name = this.customerInfo.SC_NAME ? this.customerInfo.SC_NAME.trim() : "";
        
        this.custImgUrl = this.hostUrl + "/ibase/CustomMenuImageServlet?fldValue="+sc_code+"&ALT_FLD_VALUE="+sc_name;
        console.log('custImgUrl ::',this.custImgUrl);
        
        if(this.customerInfo.CALL_HISTORY){
            this.customerInfo.CALL_HISTORY.forEach(
                    (callHistory:any) => {
                        try {                            
                            var eventDateObj = new Date(callHistory.EVENT_DATE);
                            var eventDate = eventDateObj.getDate();
                            var eventMonth = eventDateObj.toLocaleString("en-us", { month: "short" });
                            var eventYear = eventDateObj.getFullYear().toString().substr(2,2);
                            
                            callHistory['eventDate'] = eventDate;
                            callHistory['eventMonth'] = eventMonth;
                            callHistory['eventYear'] = eventYear;
                        } catch(e){
                            console.log('Exception',e);
                        }
                        
                    }
            );
        }
    }

}
