import { Component, OnInit, Input } from '@angular/core';
import { SORT,GROUP_BY, DUAL_GROUP_BY, GROUP_BY_KEYS, SUM } from '../../plugin/utils/dashboard-plugin-util';

@Component({
  selector: 'line-bar-chart',
  templateUrl: './line-bar-chart.component.html',
  styleUrls: ['./line-bar-chart.component.css']
})
export class LineBarChartComponent implements OnInit {

  constructor() { }
  @Input('data') reportData : any;
  timelineData:any;
  feedData:any =[];
  configData:any;
  hostUrl:any ='';
  errorIcon:any='';
  
  ngOnInit() {
      
      console.log('Inside LineBarChartComponent ',this.reportData);
     // this.feedData=this.reportData.data;
      this.processData();
      console.log('Inside LineBarChartComponent feedData ',this.feedData);
      this.errorIcon=this.hostUrl+'/ibase/images/userImages/errUser.png'
  }
  
  processData(){

      var feedDataLocal:any = [];
      console.log('Feed data  getColumnData',data);
      try
      {
          feedDataLocal = JSON.parse(this.reportData.data);
      }
      catch(e:any)
      {
          feedDataLocal = this.reportData.data;
      }
      
      this.feedData = Object.assign([], feedDataLocal);


      var columnGroup=this.reportData.column_group;
      if(columnGroup[0] !=null)
      {
          for(var colGroup of columnGroup)
          {
             var columns=colGroup.columns;
             console.log('columns>>>>',columns)

             if( columns != null )
             {
                 if( columns instanceof Array )
                 {
                     for(var colms of columns)
                     {
                         console.log('columns::::',colms)
                        // column=colms.column;
                         var aggFunction=colms.aggFunction;
                         var value=colms.value;
                         var typeOfColumn=colms.type;
                         var order=colms.order;
                         if(aggFunction=='SORT_BY')
                         {
                             var notNullList = this.feedData.filter( (x:any) => {return x[value]});
                          
                             var nullList = this.feedData.filter( (x:any) => {return !x[value]});
                            
                             console.log('Null array',notNullList);
                             var sortedArray = SORT(notNullList,value ,typeOfColumn,order);
                             this.feedData = sortedArray.concat(nullList); 
                             console.log('after sort by',this.feedData);
                         }
                         else if(aggFunction=='GROUP_BY')
                         {
                               this.feedData = GROUP_BY(this.feedData,value);
                               for(var data of this.feedData)
                               {
                                    for(var objectData of data.objects){
                                        if(objectData.ORDER_DATE){
                                            var orderDate=objectData.ORDER_DATE;
                                            orderDate= this.formatDate(orderDate);
                                           // orderDate=this.datepipe.transform(orderDate,  this.dateFormat);
                                            objectData.ORDER_DATE=orderDate;
                                          //  console.log('order date>>>',objectData.ORDER_DATE);

                                         }
                                     }
                               }                              
                                   console.log('after group by',this.feedData);
                         }
                          //Added by Yogesh Mohite [ group by and sum ] 24/07/2019
                         else if(aggFunction=='GROUP_BY_KEYS')
                         {
                             this.feedData = GROUP_BY_KEYS(this.feedData, value);
                             console.log('After GROUP_BY_KEYS :: ' , value, this.feedData);
                         }
                         else if(aggFunction=='SUM')
                         {
                             this.feedData = SUM(this.feedData, value);
                             console.log('After SUM :: ' , value, this.feedData);
                         }
                     }                  
                 }
                 else
                 {
                     var aggFunction=columns.aggFunction;
                     var value=columns.value;
                     var typeOfColumn=columns.type;
                     if(aggFunction=='SORT_BY')
                     {
                         
                         console.log('aggFunction:::',aggFunction,value,typeOfColumn,this.feedData);
                         var notNullList = this.feedData.filter( (x:any) => {return x[value]});
                      
                         var nullList = this.feedData.filter( (x:any) => {return !x[value]});
                        
                         console.log('notNullList>>',notNullList);
                         console.log('nullList>>>',nullList);
                         var sortedArray = SORT(notNullList,value ,typeOfColumn,order);
                         this.feedData = sortedArray.concat(nullList); 
                   //    this.feedData = SORT(this.feedData,value,typeOfColumn);
                           console.log('after sort by',this.feedData);
                     }
                     else if(aggFunction=='GROUP_BY')
                     {
                           this.feedData = GROUP_BY(this.feedData,value);
                           for(var data of this.feedData)
                           {
                                for(var objectData of data.objects){
                                    if(objectData.ORDER_DATE){
                                        var orderDate=objectData.ORDER_DATE;
                                        orderDate= this.formatDate(orderDate);
                                      //  orderDate=this.datepipe.transform(orderDate,  this.dateFormat);
                                        objectData.ORDER_DATE=orderDate;
                                  //      console.log('order date::',objectData.ORDER_DATE);
                                     }
                                 }
                           } 
                           console.log('after group by',this.feedData);
                     }
                      // Added by Yogesh [group and sum ] 24/07/2019
                     else if(aggFunction=='GROUP_BY_KEYS')
                     {
                         this.feedData = GROUP_BY_KEYS(this.feedData, value);
                         console.log('After GROUP_BY_KEYS :: ' , value, this.feedData);
                     }
                     else if(aggFunction=='SUM')
                     {
                         this.feedData = SUM(this.feedData, value);
                         console.log('After SUM :: ' , value, this.feedData);
                     }
                 }    

             }
          }
       }
   
  }
  
  formatDate(date:any)
  {
    console.log('Date in  formatDate>>>>',date);    
    if(date.indexOf('/') > -1)
    {
        var splitDate =date.split("/");
        let firstdate= splitDate[0];
        let month= splitDate[1];
        var dateStr=month+'/'+firstdate+'/'+splitDate[2];
        console.log('updated formatDate::: :',dateStr);
    }
    else
    {
        var splitDate =date.split("-");
        let firstdate= splitDate[0];
        let month= splitDate[1];
        var dateStr=month+'-'+firstdate+'-'+splitDate[2];
        console.log('updated formatDate>>>>',dateStr);
    }
       return dateStr; 
  }
  

  
  getImgSrc(code:any,name:any) {
      if(code && code != '')
      {
            code = code.trim();
      }
      var thumbObj = "";
      var imgUrl;

          imgUrl = this.hostUrl + "/ibase/CustomMenuImageServlet?fldValue=" +code+ 
          "&ALT_FLD_VALUE="+name+"&object="+'employee'+"&objName="+'employee'+"&docAttachType="+'Icon';

      return imgUrl;
  }
  

}
