import { Component, OnInit, ViewChild,Input,NgZone,ViewEncapsulation } from '@angular/core';

import { FlexmonsterPivot } from "../../datagrid/flexmonster/flexmonster.angular4";
import {  RESIZE_EVENT } from '../../datagrid/window-resize';
import { DashboardService } from '../../dashboard/dashboard.service';

@Component({
  selector: 'bar-line-chart',
  templateUrl: './bar-line-chart.component.html',
  styleUrls: ['./bar-line-chart.component.css']
})
export class BarLineChartComponent implements OnInit {

    @ViewChild('pivotGrid') pivotGrid!: FlexmonsterPivot;
    @Input('data') reportData : any;
    licenseKey:any;
    @Input('elWidth') elWidth:any;
    hostUrl:any;
    contWidth:any;
    sortOrder:any;
    
    
  constructor(private dashboardService: DashboardService, public zone: NgZone) { }
  
  onPivotReady(): void {
         console.log("SimpleGridComponent [ready]", this.pivotGrid, this.reportData, this.contWidth, this.elWidth );
         //removeClass('fm-pivot-view','fm-ui-element');
  }

  ngOnInit() {
      console.log('Inside bar line component',this.reportData);
      this.hostUrl = this.dashboardService.getHostURL();
      this.licenseKey = this.reportData.licenseKey;
      if(this.hostUrl){            
          RESIZE_EVENT.subscribe(
                 ( clientWidth:any) => {
                      console.log('on device width resize:::',clientWidth);
                      this.elWidth = clientWidth;
                      if( this.pivotGrid )
                      {
                          this.pivotGrid.flexmonster.refresh();
                          this.zone.run(() => {
                              console.log( 'view refreshed::::' );
                          } );
                      }
                  }
          );
      }
      
      if(this.reportData.column_group){
          this.reportData.column_group.forEach(
                  (column_group:any) => {
                      if(column_group.columns && column_group.columns.length > 0){
                          column_group.columns.forEach(
                                 ( column:any) => {
                                      if(column.sortOrder && this.reportData.slice){
                                          this.sortOrder = column.sortOrder.split(',');
                                          console.log('Found Sort Order',this.sortOrder);
                                          this.reportData.slice.rows[0]["sortOrder"] = this.sortOrder;
                                      }
                                  }
                          );   
                      }
                  }
          );
      }
  }
  ngOnChanges() {
      console.log('ngOnChanges in Fm Chart',this.contWidth, this.elWidth );
      if(!this.hostUrl && this.elWidth != 0 && this.contWidth != this.elWidth && this.pivotGrid && this.pivotGrid.flexmonster){
          console.log('on element width resize');
          this.contWidth = this.elWidth;
          this.pivotGrid.flexmonster.refresh();
      }
  }

  
  onReportComplete(): void {
      var reportConfig = {
            container: "#pivot-container",
            dataSource: {
               dataSourceType: "json",
               data: this.reportData.data
            },
            options: {
                viewType: "charts",
                chart: {
                  type: "bar_line",
                  autoRange: false,
                  showFilter: false,
                  showMeasures: false,
                  showLegend: false
                },
                configuratorActive: false,
                configuratorButton : false,
                drillThrough: false,
                showCalculatedValuesButton: false,
                showDrillThroughConfigurator: false
              },
              rows: this.reportData.slice ? this.reportData.slice.rows : [],
                   //   columns: this.reportData.slice ? this.reportData.slice.columns : [],
                      measures: this.reportData.slice ? this.reportData.slice.measures : [],
               width: "100%",
               height: 370,
            formats: [
              {
                name: "",
                thousandsSeparator: ""
              }
            ],
       };
      console.log('report confing in bar line component ',reportConfig);
      if( this.pivotGrid )
      {
          this.pivotGrid.flexmonster.off( "reportcomplete" );
          this.pivotGrid.flexmonster.setReport(reportConfig);
      }
    }
      
}

