import { Component, ElementRef, Input, Output, EventEmitter, OnInit, ViewEncapsulation } from '@angular/core';
import * as WebDataRocks from 'webdatarocks';

@Component({
    selector: 'app-wbr-pivot',
    template: `<div><div class='wbr-ng-wrapper'></div></div>`,
    styleUrls: ['./webdatarocks.css'],
    encapsulation: ViewEncapsulation.None
})
export class WebdatarocksComponent implements OnInit{
	
    // params
    @Input() toolbar: boolean | any;
    // @Input() width: string | number;
    @Input() width: string | any;
    // @Input() height: string | number;
    @Input() height: string | any;
    @Input() report: WebDataRocks.Report | any;
    @Input() global: WebDataRocks.Report | any;	
    @Input() customizeCell: (cell: WebDataRocks.CellBuilder, data: WebDataRocks.CellData) => void;
    // events
    @Output() cellclick: EventEmitter<WebDataRocks.CellData> = new EventEmitter();
    @Output() celldoubleclick: EventEmitter<WebDataRocks.CellData> = new EventEmitter();
    @Output() dataerror: EventEmitter<object> = new EventEmitter();
    @Output() datafilecancelled: EventEmitter<object> | any = new EventEmitter();
    @Output() dataloaded: EventEmitter<object> | any = new EventEmitter();
    @Output() datachanged: EventEmitter<object> | any = new EventEmitter();
    @Output() fieldslistclose: EventEmitter<object> | any = new EventEmitter();
    @Output() fieldslistopen: EventEmitter<object> | any = new EventEmitter();
    @Output() filteropen: EventEmitter<object>  | any= new EventEmitter();
    @Output() fullscreen: EventEmitter<object> = new EventEmitter();
    @Output() loadingdata: EventEmitter<object> | any = new EventEmitter();
    @Output() loadinglocalization: EventEmitter<object> | any = new EventEmitter();
    @Output() loadingreportfile: EventEmitter<object> | any = new EventEmitter();
    @Output() localizationerror: EventEmitter<object> | any = new EventEmitter();
    @Output() localizationloaded: EventEmitter<object> | any = new EventEmitter();
    @Output() openingreportfile: EventEmitter<object> | any = new EventEmitter();
    @Output() querycomplete: EventEmitter<object> | any = new EventEmitter();
    @Output() queryerror: EventEmitter<object> | any = new EventEmitter();
    @Output() ready: EventEmitter<WebDataRocks.Pivot> | any = new EventEmitter();
    @Output() reportchange: EventEmitter<object> | any = new EventEmitter();
    @Output() reportcomplete: EventEmitter<object> | any = new EventEmitter();
    @Output() reportfilecancelled: EventEmitter<object> | any = new EventEmitter();
    @Output() reportfileerror: EventEmitter<object> | any = new EventEmitter();
    @Output() reportfileloaded: EventEmitter<object> | any = new EventEmitter();
    @Output() runningquery: EventEmitter<object> | any = new EventEmitter();
    @Output() update: EventEmitter<object> | any = new EventEmitter();
    @Output() beforetoolbarcreated: EventEmitter<object> = new EventEmitter();
    @Output() aftergriddraw: EventEmitter<object> = new EventEmitter();
    @Output() beforegriddraw: EventEmitter<object> = new EventEmitter();
    // api
    public webDataRocks: WebDataRocks.Pivot | any;
    // private
    private root: HTMLElement;

    constructor(private el: ElementRef) {
        this.root = <HTMLElement>el.nativeElement;        
        console.log('visibility', this.root.style.visibility);
    }

    ngOnInit() {
		console.log('Inside WebdatarocksComponent');
      this.root = this.el.nativeElement as HTMLElement;
	  console.log('this.root :: ', this.root);
	  console.log('report :: ', this.report);
      this.webDataRocks = new WebDataRocks({
          container: this.root.getElementsByClassName('wbr-ng-wrapper')[0],
          width: this.width,
          height: this.height,
          toolbar: this.toolbar,
          report: this.report,
          global: this.global,
          customizeCell: this.customizeCell,
          cellclick: (cell: WebDataRocks.CellData) => this.cellclick.next(cell),
          celldoubleclick: (cell: WebDataRocks.CellData) => this.celldoubleclick.next(cell),
          dataerror: (event: object) => this.dataerror.next(event),
          datafilecancelled: () => this.datafilecancelled.next(),
          dataloaded: () => this.dataloaded.next(),
          datachanged: (event: object) => this.datachanged.next(event),
          fieldslistclose: () => this.fieldslistclose.next(),
          fieldslistopen: () => this.fieldslistopen.next(),
          filteropen: () => this.filteropen.next(),
          loadingdata: () => this.loadingdata.next(),
          loadinglocalization: () => this.loadinglocalization.next(),
          loadingreportfile: () => this.loadingreportfile.next(),
          localizationerror: () => this.localizationerror.next(),
          localizationloaded: () => this.localizationloaded.next(),
          openingreportfile: () => this.openingreportfile.next(),
          querycomplete: () => this.querycomplete.next(),
          queryerror: () => this.queryerror.next(),
          ready: () => this.ready.next(this.webDataRocks),
          reportchange: () => this.reportchange.next(),
          reportcomplete: () => this.reportcomplete.next(),
          reportfilecancelled: () => this.reportfilecancelled.next(),
          reportfileerror: () => this.reportfileerror.next(),
          reportfileloaded: () => this.reportfileloaded.next(),
          runningquery: () => this.runningquery.next(),
          update: () => this.update.next(),
          beforetoolbarcreated: (toolbar: object) => this.beforetoolbarcreated.next(toolbar),
          aftergriddraw: (event: object) => this.aftergriddraw.next(event),
          beforegriddraw: (event: object) => this.beforegriddraw.next(event)
      });
      console.log('webDataRocks :: ', this.webDataRocks);
    }
}
