import { Component, OnInit, Input, ViewChild, Output, EventEmitter} from '@angular/core';
import { DatePipe } from '@angular/common';

import { BBPluginMetadata } from '../../../plugin/core/bb-plugin.metadata';
import { DashboardService } from '../dashboard.service';
import { ViewEncapsulation } from "@angular/core";

@Component({
  selector: 'dashboard-header',
  templateUrl: './dashboard-header.component.html',
  styleUrls: ['./dashboard-header.component.css'],
  providers: [DatePipe],
  encapsulation: ViewEncapsulation.None
})
export class DashboardHeaderComponent implements OnInit {

  @Input() dashboardData: any;
  @Input() metadataname: any;
  @Output() onViewChange: EventEmitter<any> = new EventEmitter();
  trigger: any;
  
  pageTitle: any;
  subTitle = "";
  subTitleOpts: any;
  
  showFilterOpt: any;
  showViewOpt: any;
  isOverlayOpen: any;
  optSelected: any;
  
  filterConfig: any;
  overlayWidth: any;
  viewList: any;
  data: any;
  defaultSubtitle: any;
  
  constructor( public dashboardService: DashboardService, private datePipe: DatePipe ) { }

  ngOnInit() {
      if(this.dashboardData){
          this.pageTitle = this.dashboardData.page_title;
          
          if(this.dashboardData.filters && this.dashboardData.filters.filter && this.dashboardData.filters.display == 'Y'){
              this.showFilterOpt = true;
              this.createFilterConfig();
          }
          
          if(this.dashboardData.view && this.dashboardData.view.length > 1){
              this.showViewOpt = true;
              this.viewList = this.dashboardData.view;
              console.log('DashboardHeaderComponent viewLIst=======',this.viewList);
          }
          this.subTitle = this.dashboardService.getDashboardSubtitle(this.dashboardData);
          this.defaultSubtitle = this.dashboardService.defaultSubtitle;
      }
  }

  toggleOverlay(optSelected: any, trigger: any, width: any){
      this.trigger = trigger;
      this.overlayWidth = width;
      this.optSelected = optSelected;
      switch(this.optSelected)
      {
          case "filterOpt" : 
              this.data = this.filterConfig; 
              break;
          case "viewOpt" : 
              this.data = this.viewList;
              break;
      }
      this.isOverlayOpen = !this.isOverlayOpen;
  }
  
  closeOverlay(){
      this.isOverlayOpen = false;
  }
  
  createFilterConfig(){
      this.filterConfig = new BBPluginMetadata();
      var dateFormat=localStorage.getItem('APPL_DATE_FORMAT');
      //TODO: Get dateformats from METADATA 
      console.log('e12navigator, applDateFormat::' , window as any['e12navigator']);
      if( !dateFormat && window as any['e12navigator'] )
      {
          dateFormat = (window as any) ['e12navigator'].applDateFormat;
      }
      console.log('dateFormat ::' , dateFormat );
      this.filterConfig.put('deviceType', 'BROWSER');
      this.filterConfig.put('metadataname', this.metadataname);
      this.filterConfig.put('dateFormat', dateFormat);
  }
  
  onSelect(event: any){
      console.log('event in On Select::',event,this.viewList, this.optSelected);
      
      this.isOverlayOpen = false;
      if(this.optSelected == 'viewOpt'){
          this.viewList = this.dashboardData.view;
          for(var view of this.viewList){
             if(view.id ==  event.id)
             {
                 view.selected = true;
             } 
             else
             {
                 view.selected = false;
             }
          }
          this.onViewChange.emit( event );
      }
      if(this.optSelected = "filterOpt"){
          this.setAppliedSubtitle(event);
      }
  }
  
  setAppliedSubtitle(filterValues: any){
      this.subTitle = "";
      if(filterValues){
          filterValues.forEach(
            (filter: any) => {
                if(filter.changedValue && filter.show_ontitle == "1"){              
                    if(this.subTitle){
                        this.subTitle = this.subTitle + ", "
                    }
                    this.subTitle = this.subTitle + filter.col_descr + " " + filter.changedValue;
                }
            }
          );
      }
      
      if(this.defaultSubtitle){
          //this.subTitle = this.subTitle + " " +this.defaultSubtitle
          this.subTitle = this.subTitle + " "
      }
  }  
}
