import { BrowserModule } from '@angular/platform-browser';
import { HttpClientModule } from '@angular/common/http';
import { FormsModule,ReactiveFormsModule } from '@angular/forms';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { NgModule } from '@angular/core';

import { MaterialModule } from 'base-blocks';

import { FilterDataService } from './filter-data.service';
import { FilterScreenComponent } from './filter-screen/filter-screen.component';
import { FilterInputComponent } from './filter-input/filter-input.component';
// import { AngPophelpComponent } from './ang-pophelp/ang-pophelp.component';
// import { SearchByPipe } from './ang-pophelp/search-by.pipe';
// import { PophelpService } from './ang-pophelp/ang-pophelp.service';

import { BBTextboxModule } from 'base-blocks';
import { BBButtonModule } from 'base-blocks';
import { BBAutosuggestModule } from 'base-blocks';
import { BBCheckboxModule } from 'base-blocks';
import { BBRadiobuttonGroupModule } from 'base-blocks';
import { BBDatePickerModule } from 'base-blocks';

import { DashboardFilterComponent } from './dashboard-filter.component';

import { BBChipInputModule } from 'base-blocks';

import { BBTreeViewModule } from 'base-blocks';

import { PophelpModule } from '../../ang-pophelp/pophelp.module';
import { SitePickerComponent } from './site-picker/site-picker.component';
import { BBSelectModule } from 'base-blocks';
import { BBCriteriaModule } from 'base-blocks';

@NgModule({
  declarations: [
    FilterScreenComponent,
    FilterInputComponent,
    // AngPophelpComponent,
    // SearchByPipe,
    DashboardFilterComponent,
    SitePickerComponent
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    HttpClientModule,
    FormsModule,
    ReactiveFormsModule,
    BBTextboxModule,
    BBButtonModule,
    BBAutosuggestModule,
    BBCheckboxModule,
    BBRadiobuttonGroupModule,
    MaterialModule,
    BBDatePickerModule,
    BBChipInputModule,
    BBTreeViewModule,
    PophelpModule,
    BBSelectModule,
    BBCriteriaModule
  ],
  exports : [
     FilterScreenComponent,
     FilterInputComponent,
     // AngPophelpComponent,
     DashboardFilterComponent,
     SitePickerComponent
  ],
  providers: [
     FilterDataService,
    //  PophelpService
  ],
  entryComponents: [DashboardFilterComponent],
  bootstrap: []
})
export class DashboardFilterModule { }
