import { Component,OnInit, Input,Output,EventEmitter } from '@angular/core';

@Component({
  selector: 'bb-custom-chart',
  templateUrl: './bb-custom-chart.component.html',
  styleUrls: ['./bb-custom-chart.component.css']
})
export class BBCustomChartComponent implements OnInit {

  @Input() chartType: any;
  // @Input() public data: number[] | any[]; // For chartType percentage, pie and doughnut
  // @Input() public datasets: any[]; // For chartType bar, horizontalBar etc. (other than pie and doughnut)
  @Input() public data: number[] | any; // For chartType percentage, pie and doughnut
  @Input() public datasets: any; // For chartType bar, horizontalBar etc. (other than pie and doughnut)
  @Input() public labels: Array<any> = [];
  @Input() public options: any = {};
  @Input() public parentData: any = {};
  @Input() public colors: any; //Added By Vikas Lagad on 12-02-2020
  @Input() chartHeight: any;
  @Input() legend: any;
  hostUrl: any;
  @Output() onDrillDown: EventEmitter<any> = new EventEmitter(); //Added by Pramod S on 16-APR-21 for bar chart
   
  percentFactorValue = 100;
 //colors;

 inlinePlugin: any;
 textPlugin: any;

  constructor() { }

  ngOnInit() {
    console.log('BBCustomChartComponent ngOnInit :', this.chartHeight);
    if( this.chartType === 'percentage'){
      this.buildPercentageData();
    }
    // inline plugin
    this.textPlugin = [{
      id: 'textPlugin',
      beforeDraw(chart: any): any {
        const width = chart.chart.width;
        const height = chart.chart.height;
        const ctx = chart.chart.ctx;
        ctx.restore();
        const fontSize = (height / 114).toFixed(2);
        ctx.font = `${fontSize}em sans-serif`;
        ctx.textBaseline = 'middle';
        const text = 'Text Plugin';
        const textX = Math.round((width - ctx.measureText(text).width) / 2);
        const textY = height / 2;
        ctx.fillText(text, textX, textY);
        ctx.save();
      }
    }];

    this.inlinePlugin = this.textPlugin;
  }
  buildPercentageData()
  {
    this.chartType = 'doughnut';
    var _data = Object.assign([], this.data);
    var percentValueData: any;

    console.log('parentData >>>', this.parentData);
    if( this.parentData && this.options && this.options.percentFactorColumn )
    {
        var _percentFactorValue = this.parentData[this.options.percentFactorColumn] ;
        if( _percentFactorValue != 'NA' || _percentFactorValue != '-1' ){
            if( (_percentFactorValue + '').indexOf('%')  == -1  ) {
                this.percentFactorValue  = _percentFactorValue || 100 ;
            }
            else {
                this.percentFactorValue  =  0;
            }
        }
    }
    // Added by Sonam on 25-JUn-20[START]
    if(  this.parentData && this.options && this.options.customChartCenterText )
    {     
      var color = 'black';  
      var customChartCenterText = this.parentData[ this.options.customChartCenterText ];     
      var chartCenterTextFont = "20px  Roboto,sans-serif";

      if ( customChartCenterText > 0 ) 
      {
        color = 'green';
      }
      else
      {
        color = 'red';
      }

      var options_ = this.options;    
      if( options_['chartCenterText'] ) {
            var chartCenterText2 = customChartCenterText + '%';
            var chartCenterTextColor2 = color;
            var chartCenterTextFont2 =  chartCenterTextFont;
            options_['chartCenterText2'] = chartCenterText2;
            options_['chartCenterTextColor2'] = chartCenterTextColor2;
            options_['chartCenterTextFont2'] = chartCenterTextFont;
        }
        this.options =  this.DEEP_CLONE(options_);  
    }
    // Added by Sonam on 25-JUn-20[END]
    if( this.percentFactorValue > 0 )
    {
        percentValueData = (_data[0] / this.percentFactorValue) * 100;
        percentValueData = parseInt( percentValueData );
    }
    else
    {
        percentValueData = _data[0];
    }

    if( percentValueData <= 100 )
    {
        this.data = [ percentValueData, 100 - percentValueData];
    }
    else
    {
        this.data = [ percentValueData, 0]; //This case is error where out of value should not be greater than 100 for % calculation
    }

    console.log('BBCustomChartComponent.buildPercentageData :', this.percentFactorValue, this.data);
  }
  
 // Added by Sonam on 01-JIL-20 [START]
 DEEP_CLONE( data: any )
 {
     try
     {
         var clonedData = JSON.parse(JSON.stringify(data));
         return clonedData
     }
     catch(e)
     {
         return data;
     }
 }
 // Added by Sonam on 01-JIL-20 [END	]

    //Added by Pramod S on 16-APR-21 TODO [START]
    onChartDrill(data: any)
    {
        // console.log("pramod caliing onchartdrill",this.onDrillDown);
        // console.log("pramod calling onchartdrillobj",data);
        // this.onDrillDown.emit(data);
    }
    //Added by Pramod S on 16-APR-21 TODO [START]



}
