import { Component, OnInit, Input, Output, EventEmitter} from '@angular/core';
import { VgAPI } from 'ngx-videogular';
import { DatePipe } from '@angular/common';
import { CourseAPIService } from '../../course-contents/course-api.service';

@Component({
  selector: 'video-playlist',
  templateUrl: './video-playlist.component.html',
  styleUrls: ['./video-playlist.component.css'],
  providers: [DatePipe]
})

export class VideoPlalistComponent implements OnInit {

  @Input() videoList : any;
  @Output() onSelect: EventEmitter<any> = new EventEmitter();
  onLoad: boolean = false;
  
  @Input() currentItem : any;
  showAll: boolean = true;
  displayLength = 6;

  previewImageErrorCount = 0;
  ASSET_IMG_URL = "dashboard/assets/images"
  isDummyImg: any;
  hostUrl: any;

  @Input() courseCodeData: any;
 
  constructor(private courseApiService: CourseAPIService) {} 

  ngOnInit() {
    this.hostUrl = this.courseApiService.hosturl;
  }
  

  onSelectVideo( videoItem :any , index: any ){
    console.log('on click of slected video in videoPlaylist');
    this.currentItem = videoItem;
    console.log((this.currentItem === videoItem), this.currentItem, videoItem );
    videoItem["index"] = index;
    this.onSelect.emit(videoItem);
    
  }


brokenImage(event: any,index: any) {
        if (this.previewImageErrorCount == 0) {
          if( ['mp4', 'avi', 'flv', 'swf' , 'mpg', 'mpeg', 'mkv'].indexOf( this.videoList[index].fileType.toLowerCase().trim() ) >= 0 ) {
              this.videoList[index].imagePath = this.ASSET_IMG_URL + '/svg'+ '/video-preview.svg';
          } else {
              this.videoList[index].imagePath = this.ASSET_IMG_URL + '/svg/'+ this.videoList[index]!.fileType!.trim()!.toLowerCase() + '-preview.svg';
          }
          
          this.previewImageErrorCount += 1;
      } else {
              this.isDummyImg = true;
              event.target.src = this.ASSET_IMG_URL + '/svg'+  '/broken-image.svg';
      }
  }

}
