import { Component, OnInit, Input, EventEmitter} from '@angular/core';
import { CourseAPIService } from '../../course-contents/course-api.service';
import { getAssetImgUrl } from '../../../shared/hostUrl';
// import { Subscription } from 'rxjs/Subscription';
import { Subscription } from 'rxjs';

@Component({
  selector: 'course-question',
  templateUrl: './course-question.component.html',
  styleUrls: ['./course-question.component.css'],
})

export class CourseQuestions implements OnInit {

  @Input() questionList : any;
  @Input() totalQues: any;
  categoryDesc: any;
  public pluginMetadata: any;
  currentQuestion = 1;
  courseInfo: any;
  template = 'questionsTempl';
  userInfo: any;
  courseName: any;
  ASSET_IMG_URL: any;
  pluginEvtEmitter: EventEmitter<any> = new EventEmitter();
  
  courseTestSubs : Subscription | any; 
      
  constructor( private courseApiService: CourseAPIService) {} 

  ngOnInit() {
      console.log('pluginMetadata==>',this.pluginMetadata);

      if(this.pluginMetadata && this.pluginMetadata['compData'].data)
      {
         this.courseInfo = this.pluginMetadata['compData'].data;
         this.courseName = this.courseInfo.descr;
         this.userInfo = this.courseApiService.getUserInfo();
         this.ASSET_IMG_URL = getAssetImgUrl();
         this.questionList = this.courseInfo.courseQuestions;
         console.log('questionList==>',this.questionList.length);
         this.categoryDesc = this.pluginMetadata['compData'].data.descr
         console.log('categoryDesc==>',this.categoryDesc);
      } 

     
  }

  onSelectPrevious(currentQuestion: any){
    this.currentQuestion = currentQuestion;
    console.log('questonList on previous==>',this.questionList);
  }
  
  onSelectNext(currentQuestion: any){
    this.currentQuestion = currentQuestion;
    console.log('questonList on next==>',this.questionList);
  }
/*
  {
    "quesSet" : "",
    "seqNo" : 1,
    "testData" : ""
  }
*/  
  onSelectFinish(){
      console.log('finsih function called');
      var courseCode;
      var quesResult = this.questionList.filter( (question: any) => {
        if( question.testData !== 'NA' )
        {
          courseCode = question.courseCode;
          return {
            "quesSet" : question.quesSet,
            "seqNo" : question.seqNo,
            "testData" : question.testData
          };
        }
      });
      
      if( quesResult.length != this.questionList.length )
      {
        alert("You have not answered all questions");
      }
      else
      {
        this.template = 'loaderTempl';
        var url = '/coursetest/'+courseCode;
        
        if(this.courseTestSubs)
        {
            this.courseTestSubs.unsubscribe();
        }
        this.courseTestSubs = this.courseApiService.saveCourseAttData(url, quesResult).subscribe(
                (resp: any) => {
                    
                    /*
                    if(resp.status == 'success'){
                        this.courseApiService.closeQuestionForm();
                    }else {
                        alert('Something went wrong. Try again.');
                    }
                    */
                    
                    this.template = 'thankyouTempl';
                }

        );  
         this.courseApiService.sendCourseCert(courseCode).subscribe(
          resp => {
          
          }

        );  
      }
      console.log('questonList on finish==>',quesResult ,this.questionList);
  }

  closeOverlay() {
    this.pluginEvtEmitter.emit();
    this.courseApiService.closeQuestionForm();
  }
  
}
