import { Component, OnInit, Input, EventEmitter, Output } from '@angular/core';

@Component({
  selector: 'course-question-header',
  templateUrl: './course-question-header.component.html',
  styleUrls: ['./course-question-header.component.css']
})
export class CourseQuestionHeaderComponent implements OnInit {

  @Output() onNext: EventEmitter<any> = new EventEmitter();
  @Output() onPrevious: EventEmitter<any> = new EventEmitter();
  @Output() onFinish: EventEmitter<any> = new EventEmitter();

  @Input() categoryDesc: any;
  @Input() totalQuestions: any;

  currentQuestion = 1;
  isFirstQuestion = true;
  isLastQuestion = false;
  
  constructor() { }

  ngOnInit() {
    this.isLastQuestion = this.totalQuestions == 1 ;
  }

  onSelectNext()
  {
    this.currentQuestion = this.currentQuestion + 1;
    this.onNext.emit(this.currentQuestion);

    this.updateNavState();
  }

  onSelectPrevious(){
    this.currentQuestion = this.currentQuestion - 1;
    this.onPrevious.emit(this.currentQuestion);

    this.updateNavState();
  }

  onSelectFinish(){
    this.onFinish.emit();
  }

  updateNavState()
  {
    this.isFirstQuestion = (this.currentQuestion == 1);
    this.isLastQuestion = (this.currentQuestion == this.totalQuestions);
  }
}
