import { Component, OnInit, Input, OnChanges} from '@angular/core';
import {FormControl} from '@angular/forms';

@Component({
  selector: 'course-question-contents',
  templateUrl: './course-question-contents.component.html',
  styleUrls: ['./course-question-contents.component.css']
})
export class CourseQuestionContentsComponent implements OnInit, OnChanges{
  @Input() currentQuestion: any;
  @Input() currQuesNo: any;
  
  multiTestData: any = [];
  selOpt: any;
  
  constructor() { }

  ngOnInit() {
    console.log('ngOnInit', this.currQuesNo,  this.currentQuestion);
  }

  ngOnChanges(){
      this.multiTestData = [];
      console.log('currentQuestion==>',this.currentQuestion);
	  if( this.currentQuestion && 
        this.currentQuestion.answType === '1' && 
        this.currentQuestion.testData!.indexOf('[') != -1 )
      {
        this.multiTestData = JSON.parse( this.currentQuestion.testData);
        console.log('ngOnInit multiTestData==>', this.multiTestData);
      }else if( this.currentQuestion && 
              this.currentQuestion.answType == '0')
      {
          this.selOpt = this.currentQuestion.testData;
      }
  }
  
  singleValueSelected(value: any)
  {
    console.log('singleValueSelected==>', value);
    this.currentQuestion.testData = value;
  }

  multiValueSelected(evt: any, value: any)
  {
    console.log('multiValueSelected==>', evt.checked, value);
    if( evt.checked )
    {
      this.multiTestData.push(value);
    }
    else
    {
      this.multiTestData.splice(this.multiTestData.indexOf(value), 1);
    }
    this.currentQuestion.testData = this.multiTestData.length > 0 ?  JSON.stringify( this.multiTestData ) : 'NA';
    console.log('multiValueSelected==>', this.currentQuestion.testData);
  }
}
