export function isArray (value: any): boolean {
  
  return Array.isArray(value);
}

export function isDeepObject (object: any) {
  
  return object.__isDeepObject__;
}


export function unwrapDeep (object: any) {
  
  if (isDeepObject(object)) {
    return object.data;
  }
  
  return object;
}
export class DeepWrapper {
  
  public __isDeepObject__: boolean = true;
  
  constructor (public data: any) {}
}



export function deepIndexOf (collection: any[], value: any) {
  
  let index = -1;
  const length = collection.length;
  
  while (++index < length) {
    if (deepEqual(value, collection[index])) {
      return index;
    }
  }
  
  return -1;
}

export function deepEqual (a: any, b: any) {
  
  if (a === b) {
    return true;
  }
  
  if (!(typeof a === 'object' && typeof b === 'object')) {
    return a === b;
  }
  
  const keysA = Object.keys(a);
  const keysB = Object.keys(b);
  
  if (keysA.length !== keysB.length) {
    return false;
  }
  
  // Test for A's keys different from B.
  var hasOwn = Object.prototype.hasOwnProperty;
  for (let i = 0; i < keysA.length; i++) {
    const key = keysA[i];
    if (!hasOwn.call(b, keysA[i]) || !deepEqual(a[key], b[key])) {
      return false;
    }
  }
  
  return true;
}
 
