import { Pipe, PipeTransform } from '@angular/core';

@Pipe({name: 'groupBy'})
export class GroupByPipe implements PipeTransform {
transform(value: Array<any>, field: string): Array<any> {
  //console.log(" GroupByPipe value ",value ,field);
  
     const groupedObj = value.reduce((prev, cur)=> {
       
        if(!prev[cur[field]]) {
          prev[cur[field]] = [cur];
        } else {
          prev[cur[field]].push(cur);
        }
        return prev;
      }, {});
      //console.log("returned data :::====>>>" , Object.keys(groupedObj).map(key => ({ key, value: groupedObj[key] })));
      return Object.keys(groupedObj).map(key => ({ key, value: groupedObj[key] }));
   }
}