import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'filterBy'
})
export class FilterByPipe implements PipeTransform {
  
    transform(contents: any[], filterText: string): any[]|undefined {
            console.log('In FilterByPipe--',contents,filterText);
           if(!filterText || !filterText.startsWith('#') || filterText.length < 4)
           {
             return ;
           }
           if (filterText)
           {
                return Object.assign([], contents).filter((
                        item:any) => item.toLowerCase().indexOf(filterText.toLowerCase()) > -1)
           }
    }
}
