import { Component, OnInit, HostListener, Input, Output, EventEmitter } from '@angular/core';
import { ContentService } from '../services/content.service';
import { ContentsApiClient } from '../services/contentsApiClient.service';
import { ContentsSandbox } from '../sandbox';

@Component({
  selector: 'content-pin',
  templateUrl: './content-pin.component.html',
  styleUrls: ['./content-pin.component.css']
})
export class ContentPinComponent implements OnInit {

  @Input() pinType:any; //Header / Card
  @Input() content:any;
  @Input() hostUrl !: string;

  @Output() onCardPin: EventEmitter<boolean> = new EventEmitter();

  active : boolean = false;
  ASSET_IMG_URL = "dashboard/assets/images";

  constructor(private contentService: ContentService , private contentsApiClient: ContentsApiClient,private contentSandbox: ContentsSandbox) { }

  ngOnInit()
  {
      //console.log("pinType & content--------->[",this.pinType,"][",this.content,"]");
      if(this.content && this.content.pinned == 'Y'){
        this.active = true;
      } else {
        this.active = false;
      }
      
      if(!this.hostUrl){
          this.ASSET_IMG_URL = "/ibase/E12BROWSER/"+this.ASSET_IMG_URL;
      }
  }

/*  @HostListener('click')
  click() {
    //console.log("hostlistner click event on pin[",this.pinType,"][",this.content,"]");
    this.active = !this.active;
    if(this.pinType === 'HEADER')
    {
      this.contentService.toggleHeaderPin();
    }
    else
    {
      this.content.pinned = this.active ? 'Y' : 'N';
      this.onCardPin.emit(this.active);
    }
  }*/
   
  updatePinned(docId:any, status:any)
  {
/*    if(this.pinType != "HEADER")
        {
        console.log("updatePin ::" ,docId,status);
        this.contentSandbox.updatePinned(docId , status);
        }
*/
    
    
    this.active = !this.active;
    if(this.pinType === 'HEADER')
    {
      this.contentService.toggleHeaderPin();
    }
    else
    {
      this.content.pinned = this.active ? 'Y' : 'N';
      this.onCardPin.emit(this.active);
      console.log("updatePin ::" ,docId,status);
      this.contentSandbox.updatePinned(docId , status);
    }
  
  }
  
}
