import { BrowserModule } from '@angular/platform-browser';
import { NgModule ,CUSTOM_ELEMENTS_SCHEMA} from '@angular/core';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { HttpClientModule } from '@angular/common/http';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { RouterModule, Routes } from '@angular/router';
import { HashLocationStrategy, LocationStrategy } from '@angular/common';

import { MaterialModule } from 'base-blocks';
import { OverlayModule } from '@angular/cdk/overlay';
import { MomentModule } from 'ngx-moment';


import { ContentsSandbox } from './shared/sandbox/';
import { ContentsApiClient } from './shared/services/contentsApiClient.service';
import { ContentHomeComponent } from './content-home/content-home.component';
import { ContentCard } from './shared/content-card/content-card.component';
import { ContentListComponent } from './content-list/content-list.component';
import { ContentHeaderComponent } from './content-header/content-header.component';
import { ContentPinComponent } from './shared/content-pin/content-pin.component';
import { ContentService } from './shared/services/content.service';
import { ContentSearchComponent } from './content-search/content-search.component';
import { ContentViewComponent } from './content-view/content-view.component';

import { OrderbyDatePipe } from './shared/pipes/orderby-date.pipe';
import { TimeAgoPipe } from './shared/pipes/time-ago.pipe';
import { SearchByPipe } from './shared/pipes/search-by.pipe';
import { GroupByPipe } from './shared/pipes/group-by.pipe';
import { OrderbyDataPipe } from './shared/pipes/orderby-data.pipe';
import { IntersectionPipe } from './shared/pipes/intersection.pipe';
import { HavingPipe } from './shared/pipes/having.pipe';
import { UnionPipe } from './shared/pipes/union.pipe';
import { FilterByPipe } from './shared/pipes/filter-by.pipe';

import { ContentLibraryComponent } from './content-library.component';
import { BBSelectModule } from 'base-blocks';

import { AssociateContainerComponent } from './shared/associate-container/associate-container.component';
import { AssociateFeedComponent } from './shared/associate-feed/associate-feed.component';
import { ContentAssocObjectsComponent } from './content-assoc-objects/content-assoc-objects.component';
import { ContentAssocTransactionsComponent } from './content-assoc-transactions/content-assoc-transactions.component';
import { ContentManagerComponent } from './content-manager/content-manager.component';//p
import { CustomOverlayDirective } from './shared/custom-overlay-directive';
import { ContentManagerModule} from './pdf-content-manager/content-manager.module';
import { HtmlContentManagerModule} from './html-manager/html-content-manager.module';
import { BBAutosuggestModule } from 'base-blocks';

import { DynamicPathGuard } from '../shared/dynamic-path-guard.guard';
import { NotFoundComponent } from '../not-found/not-found.component';
import {CdkTableModule} from '@angular/cdk/table';

const routes: Routes = [
                        { path: 'assocObjects', component: ContentAssocObjectsComponent },
                        { path: 'assocTransactions', component: ContentAssocTransactionsComponent },
                        { path: 'ManagerComponent', component: ContentManagerComponent }, //p a
                        { path: '**', canActivate: [DynamicPathGuard] , component: NotFoundComponent}
                      ];

@NgModule( {
    declarations: [
        ContentLibraryComponent,
        ContentHomeComponent,
        ContentCard,
        ContentListComponent,
        ContentHeaderComponent,
        ContentPinComponent,
        ContentSearchComponent,
        ContentViewComponent,
        OrderbyDatePipe,
        TimeAgoPipe,
        SearchByPipe,
        GroupByPipe,
        OrderbyDataPipe,
        IntersectionPipe,
        HavingPipe,
        UnionPipe,
        FilterByPipe,
        AssociateContainerComponent,
        AssociateFeedComponent,
        ContentAssocObjectsComponent,
        ContentAssocTransactionsComponent,
        CustomOverlayDirective,
        ContentManagerComponent,

        NotFoundComponent
    ],
    imports: [
        BrowserModule,
        BrowserAnimationsModule,
        HttpClientModule,
        FormsModule,
        ReactiveFormsModule,
        MaterialModule,
        BBSelectModule,
        OverlayModule,
        RouterModule.forRoot(routes),
        ContentManagerModule,
        HtmlContentManagerModule,
        BBAutosuggestModule,
        MomentModule,
        CdkTableModule
    ],
    exports: [
        ContentLibraryComponent,
        ContentHomeComponent,
        ContentCard,
        ContentListComponent,
        ContentHeaderComponent,
        ContentPinComponent,
        ContentSearchComponent,
        ContentViewComponent,
        AssociateContainerComponent,
        AssociateFeedComponent,
        ContentAssocObjectsComponent,
        ContentAssocTransactionsComponent,
        ContentManagerComponent
    ],
    providers: [
        ContentsApiClient,
        ContentsSandbox,
        ContentService,
        {provide: LocationStrategy, useClass: HashLocationStrategy}
    ],
    entryComponents: [ContentLibraryComponent],
    schemas:[
             CUSTOM_ELEMENTS_SCHEMA,
           ],
    bootstrap: []
} )
export class ContentLibraryModule { }
