import { Component, Input, Output, EventEmitter } from '@angular/core';

import { BBPlugin, getUniqueId } from '../../plugin/core/bb-plugin';
import { BBPluginMetadata } from "../../plugin/core/bb-plugin.metadata";

import { ContentsSandbox } from './shared/sandbox/content.sandbox';

@Component( {
    selector: 'content-library',
    templateUrl: './content-library.component.html',
    styleUrls: ['./content-library.component.css']
} )
export class ContentLibraryComponent implements BBPlugin {

    @Input() pluginId: string = getUniqueId( 'task' );
    @Input() title: string | any;
    @Input() pluginMetadata!: BBPluginMetadata;
    
    @Input('data') response : any;

    @Output() selected: EventEmitter<any> = new EventEmitter();
    @Output() onContentAttached: EventEmitter<any> = new EventEmitter();
    @Output() onLinksCreation: EventEmitter<any> = new EventEmitter();
    //Added by Saitej .D To Play video on click at content-library dashboard
    @Output() onFilePreview: EventEmitter<any> = new EventEmitter();

    constructor(public contentSandbox: ContentsSandbox) {
        //console.log( 'pluginMetadata of content-lib', this.pluginMetadata );

    }
    
    init(){
        //console.log( 'In init method', this.pluginMetadata );
        if(this.pluginMetadata){
            this.contentSandbox.loadContentList( "DUMMY" );
            this.contentSandbox.pluginMetadata = this.pluginMetadata.dataMap;
        }
    }
    
    ngOnInit(){
        console.log('OnInit of content-library component---',this.response);
        if(this.response){
            this.contentSandbox.setReponse(this.response.data);
        }
        this.contentSandbox.setUserRights(this.response);
        this.contentSandbox.onContentAttached.subscribe(
               resp => { 
                   this.onContentAttached.emit();
               }
        );
        this.contentSandbox.onLinksCreation.subscribe(
                links => { 
                    var obj_links;
                    if(this.response.obj_links && this.response.obj_links.length > 0)
                    {                        
                        obj_links = this.response.obj_links;
                        obj_links.concat(links);
                    }
                    else
                    {
                        obj_links = links;
                    }
                    this.onLinksCreation.emit(obj_links);
                }
         );
	//Added by Saitej .D To Play video on click at content-library dashboard Start
         this.contentSandbox.onFilePreview.subscribe(
            linkData => {
                this.onFilePreview.emit(linkData);
            }
         );
//Added by Saitej .D To Play video on click at content-library dashboard End
    }

}

export function getHostURL(): string {
    // let HOST_URL: string = '';
    let HOST_URL: any = '';
    HOST_URL = localStorage.getItem( 'HOST_URL' );

    if ( !HOST_URL ) HOST_URL = '';

    console.log( 'getHostURL[', HOST_URL, ']' );
    return HOST_URL;
}
