import { Component, OnInit, NgZone } from '@angular/core';
import { ContentLibraryComponent } from '../content-library.component';
import { ContentsSandbox } from '../shared/sandbox';

declare var saveDocInContentLibrary: any;
export enum KEY_CODE {
    ESCAPE = 27,
}
@Component( {
    selector: 'content-home',
    templateUrl: './content-home.component.html',
    styleUrls: ['./content-home.component.css'],
} )
export class ContentHomeComponent implements OnInit {
    
    contentData: any;
    searchValue: any;
    
    constructor(
            public contentLibComp: ContentLibraryComponent,
            public contentSandbox: ContentsSandbox,
            public zone: NgZone
    ) {}

    ngOnInit() {
        this.contentLibComp.init();
        
        this.contentSandbox.contentList$.subscribe(
                (contentData: any) => {
                    console.log( 'contentData on content home constructor', new Date(), contentData );
                    if ( contentData ) {
                        this.contentData = contentData;
                        this.zone.run(() => {
                            console.log( 'view refreshed' );
                        } );
                    }
                }
        );
    }
    
    setSearchVal( value: any ) {
        if ( value == 'search canceled' ) {
            this.searchValue = '';
        } else {
            this.searchValue = value;
        }
    }
}
