import { Injectable, Output, EventEmitter } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
// import { Observable } from 'rxjs/Observable';
// import { BehaviorSubject } from 'rxjs/BehaviorSubject';
// import { map } from 'rxjs/operators/map';
import { Observable } from 'rxjs';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';

@Injectable()
export class ChartService {
                
    
    private activityData = new BehaviorSubject<any>({});
    currentData = this.activityData.asObservable();
    
    constructor(private http: HttpClient) { }
    
    private SERVICE_URL = '/ibase/rest/accountActivity?';  // URL to web service
    getUserActivityData (queryParams:string): Observable<any> {
        console.log( "Inside getUserActivityData service queryParams =" + queryParams);
        let activityUrl =this.getHostURL() + this.SERVICE_URL + queryParams; //"?fromDate=10-02-18";  
        var httpHeaders = new HttpHeaders().set('Content-Type', 'application/json');
        var options = { headers: httpHeaders};
        console.log( "getUserActivityData>>>>>" + activityUrl); 
        return  this.http.get<any>(activityUrl, options)
        .pipe( map((res) => this.extractData(res)) )
    }
    
    private extractData(res: Response) {
        let body = res.json();
        console.log('extractData[' + JSON.stringify(body) + ']');
        return body || { };
    }

    
    setActivityData(activityData: any)
    {
        this.activityData.next(activityData);
    }
    
    public getHostURL(): string {
        // let HOST_URL: string = '';
        let HOST_URL: any = '';
        HOST_URL = localStorage.getItem( 'HOST_URL' );
        if ( !HOST_URL ) HOST_URL = '';
        console.log( 'getHostURL[', HOST_URL, ']' );
        return HOST_URL;
    }
}
