import { Component, OnInit, Input,Output, ViewChild,OnDestroy,EventEmitter } from '@angular/core';

import { AccountActivityService } from '../account-activity.service';
import {ImageDirective } from './../../shared/image.directive';

@Component( {
    selector: 'user-activity-data',
    templateUrl: './user-activity-data.component.html',
    styleUrls: ['./user-activity-data.component.css'],
    providers:[ImageDirective]
} )
export class UserActivityDataComponent implements OnInit,OnDestroy{

    @Input() userIdx: any;
    @Input() userdata: any;
    @Input() hostUrl: any;
    
    isSession: any;
    ASSET_IMG_URL = "dashboard/assets/images";
    USR_ERR_URL: any;
    OBJ_ERR_URL: any;
    CLIENTAPP_URL: any;
    USR_URL: any;
    OBJ_URL: any;
    CLIENTAPP_ERR_URL: any;
    configData: any;
    
    @ViewChild('exPanel') exPanel: any;

    constructor(private accountActivityService: AccountActivityService) { }

    ngOnInit() {
        if(!this.hostUrl){
            this.ASSET_IMG_URL = "/ibase/E12BROWSER/"+this.ASSET_IMG_URL;
        }
        this.setUrls();
        
        this.accountActivityService.toggle.subscribe(
            idx => {
                if(idx !== this.userIdx){
                    this.exPanel.close();
                }    
            }
            
        );
    }

    toggleSession( index: any ) {
        console.log( 'inside togggleSession', index, 'this.userIdx : ', this.userIdx, 'this.isSession : ', this.isSession );
        if ( this.isSession == index ) {
            this.isSession = null;
        }
        else {
            this.isSession = index;
        }
    }
    

    errorHandler( data: any, iconName: any, event: any ) {
        if ( data == 'userImage' ) {
            event.target.src = this.USR_ERR_URL;
        }
        else if ( data == 'object' ) {
            event.target.src = this.OBJ_ERR_URL;
        }
        else {
            event.target.src = this.CLIENTAPP_URL + iconName + ".png";
        }
    }
    imageUrl( data: any, iconName: any ) {
        if ( data == 'userImage' ) {
            return this.USR_URL + iconName + ".png";
        }
        else if ( data == 'object' ) {
            return this.OBJ_URL + iconName + ".png";
        }
        else {
            return this.CLIENTAPP_URL + iconName + ".png";
        }
    }
    
    setUrls(){
        if(!this.hostUrl){
            this.hostUrl = '';
        }
        this.USR_ERR_URL=this.hostUrl+'/ibase/images/userImages/errUser.png';
        this.USR_URL=this.hostUrl+'/ibase/images/userImages/';
        this.OBJ_ERR_URL=this.hostUrl+'/ibase/images/menuImages/mob/e12Menu.png';
        this.OBJ_URL=this.hostUrl+'/ibase/images/menuImages/mob/';
        //CLIENTAPP_ERR_URL=this.ASSET_IMG_URL+'/icons/clientApp.png';
        this.CLIENTAPP_ERR_URL=this.ASSET_IMG_URL+'/icons/clientApp.png';
        this.CLIENTAPP_URL=this.ASSET_IMG_URL+'/icons/';
    }
    
    togglePanel(){
        this.accountActivityService.togglePanel(this.userIdx);    
    }

    ngOnDestroy() 
    {
        console.log('user-activity ngOnDestroy..');
 
    }
    
    checkData(data: any){
        if(data)
        {
            return data;
        }
        else{
            return 'NA';
        }
        
        
    }
    
    public getConfigDet(data: any){
       // console.log('getConfigDet..',appName,data.CLIENT_APP);
        this.configData={
            hostUrl:this.hostUrl,
            fldValue:data.USER_ID,
            altFldValue:data.NAME,
            objName:'SALES_PERS',
            object:'SALES_PERS',
            docAttachType:'Icon',
            errorImage:this.USR_ERR_URL
        };          
       // console.log('getConfigDet userActivity:::',this.configData);
        return this.configData;
    }
    
}
