import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { HttpClientModule } from '@angular/common/http';

import { MaterialModule } from 'base-blocks';
import {CdkTableModule} from '@angular/cdk/table';

import { AccountActivityService } from './account-activity.service';

import { AccountActivityComponent } from './account-activity.component';
import { AccActivityGraphComponent } from './acc-activity-graph/acc-activity-graph.component';

import { BBBatteryComponent } from './bb-battery/bb-battery.component';
import { UserActivityDataComponent } from './user-activity-data/user-activity-data.component';
import { SessionActivityDataComponent } from './session-activity-data/session-activity-data.component';
import { TeamActivityDataComponent } from './team-activity-data/team-activity-data.component';

import { AmChartsModule } from '@amcharts/amcharts3-angular';
import {ImageDirective } from '../shared/image.directive';

@NgModule({
  declarations: [
    UserActivityDataComponent,
    SessionActivityDataComponent,
    TeamActivityDataComponent,
    BBBatteryComponent,
    ImageDirective,
    
    AccountActivityComponent,
    AccActivityGraphComponent
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    HttpClientModule,
    AmChartsModule,
    MaterialModule,
    CdkTableModule
  ],
  exports: [
    UserActivityDataComponent,
    SessionActivityDataComponent,
    TeamActivityDataComponent,
    BBBatteryComponent,
    ImageDirective,
    
    AccountActivityComponent,
    AccActivityGraphComponent
   ],
  providers: [AccountActivityService],
  bootstrap: []
})
export class AccountActivityModule { }
