import { Component } from '@angular/core';
import { BBPluginMetadata } from '../plugin/core/bb-plugin.metadata';

//export const PluginMetadata = BBPluginMetadata;

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  title = 'proteus-angular-dashboard';
  
  pluginMetadata: BBPluginMetadata | any; 

  jsonStr : any;
  jsonData : any;
  compData : any;
  compPluginData: any = {};
  
  constructor()
  {
    console.log('Dashboard component loading.................');    
    if (window["NATIVE"]) 
    {      
      if (window["NATIVE"]["ANG_DASHBOARD_DATA"]) 
      {
        this.jsonStr = window["NATIVE"]["ANG_DASHBOARD_DATA"];
        window["NATIVE"]["ANG_DASHBOARD_DATA"] = "undefined";
        try 
        {
          this.jsonData = JSON.parse(this.jsonStr);
          console.log('Inside constructor json data obj::'+this.jsonData);
          this.compData = {};
          this.compData.cacheComp = "false";
          this.compData.componentName = this.jsonData.componentName;
          this.compData.targetId = this.jsonData.componentName;

          this.compPluginData["cacheComp"] = "false";
          this.compPluginData["compData"] = this.compData;
          this.compPluginData["metadataname"] = this.jsonData.componentName;
          this.compPluginData["target-id"] = this.jsonData.componentName;

          this.pluginMetadata = this.compPluginData;
          console.log('Inside constructor pluginMetadata::'+this.pluginMetadata);
        }
        catch (ex) {
          console.log('Inside exception app component::'+ex);        
        }       
      }
      else 
      {
        console.log('No Data Found.');
      }
    }
  }  
}