package ibase.android.visionselfie;


import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;


/**
 * A simple {@link Fragment} subclass.
 */
public class ViewStickersFragment extends Fragment implements View.OnClickListener, StickerAdapter.RecyclerViewClickListener {


    private static final String TAG = "ViewStickersFragment";
    public static final int NUM_OF_COLUMN = 1;

    private RecyclerView mRecyclerView;

    private ArrayList<Item> items;

    private ArrayList<Drawable> mStickers = new ArrayList<>();
    private IMainActivity mIMainActivity;
    private StickerAdapter mStickerAdapter;

    public static ViewStickersFragment newInstance() {
        return new ViewStickersFragment();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_view_stickers, container, false);
        view.findViewById(R.id.init_sticker_icon).setOnClickListener(this);
        mRecyclerView = view.findViewById(R.id.recycler_view);
        items = new ArrayList<>();

        initRecyclerView();
//        getStickers();
        getStickersNew();

        return view;
    }

    private void getStickersNew() {
        int images[] = {

//                R.drawable.ic_great_place,
                /*R.drawable.a_great_place_frame,
                        R.drawable.b_smartwork_not_hard_frame,
                        R.drawable.c_we_love_proteus_frame,
                        R.drawable.d_small_team_doing_big_things_frame*/
//                R.drawable.ac_we_love_proteus_frame,

                R.drawable.aa_fun_at_proteus,
                R.drawable.ab_great_place_to_work,
                R.drawable.we_love_proteus_frame,
                R.drawable.great_placeto_work_frame,
                R.drawable.ad_work_smart_not_hard,
                R.drawable.i_love_base_blue_frame,
                R.drawable.i_love_base_white_frame

        };
        int i = 0;
        while (i < images.length) {
            items.add(new Item(images[i]));
            i++;
        }
        mRecyclerView.setAdapter(new StickerAdapter(items,this,getActivity()));
    }

    private void initRecyclerView() {
        if (mStickerAdapter == null) {
//            mStickerAdapter = new StickerAdapter(getActivity(), mStickers, this);
            mStickerAdapter = new StickerAdapter(items,this,getActivity());
        }

        mRecyclerView.setLayoutManager(new GridLayoutManager(getActivity(), NUM_OF_COLUMN));
        mRecyclerView.setAdapter(mStickerAdapter);
        mStickerAdapter.notifyDataSetChanged();

    }

    private void getStickers() {
        if (getActivity() != null) {
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfieapp_sicker_01));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfieapp_sicker_0200));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfieapp_sicker_03));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfieapp_sicker_01));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_app02));

//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.a1));
           /* mStickers.add(getActivity().getResources().getDrawable(R.drawable.a2));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.ic_great_place));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker2));*/
           /*thumbnails*/
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.a_great_place_thumb));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.b_smartwork_not_hard_thumb));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.c_we_love_proteus_frame_thumb));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.d_fun_at_proteus_thumb));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.e_i_love_base_blue_thumb));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.f_we_love_proteus_frame_thumb));

            mStickers.add(getActivity().getResources().getDrawable(R.drawable.a_great_place_frame));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.b_smartwork_not_hard_frame));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.c_we_love_proteus_frame));



//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker2));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker2));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.ic_small_team_doing_big_things));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.small_team_doing_big_things));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.work_smart_not_hard));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.ic_work_smart_not_hard));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfie_sticker1));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.selfisti));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.ic_vision_selfie_app_one));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.ic_vision_selfie_app_two));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.slightly_smiling_face_emoji));
           /* mStickers.add(getActivity().getResources().getDrawable(R.drawable.smiley_face_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.smiley_smiling_eyes_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.smiley_face_tightly_closed_eyes_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.smiley_with_sweat_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.tears_of_joy_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.sunglasses_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.nerd_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.smirking_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.unamused_emoji));
            mStickers.add(getActivity().getResources().getDrawable(R.drawable.penguin_emoji));*/
            /**/

//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.upside_down_face_emoji));
//            mStickers.add(getActivity().getResources().getDrawable(R.drawable.sad_emoji));
        }
    }

    @Override
    public void onClick(View v) {

        switch (v.getId()) {

            case R.id.init_sticker_icon: {
                mIMainActivity.toggleViewStickersFragment();
                break;
            }
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            mIMainActivity = (IMainActivity) getActivity();
        } catch (Exception e) {
            Log.e(TAG, "onAttach: " + e.getMessage());
        }

    }

    @Override
    public void onStickerClicked(int position) {
//        mIMainActivity.addSticker(mStickers.get(position));
        mIMainActivity.addSticker(getResources().getDrawable(items.get(position).getImage()));

        mIMainActivity.toggleViewStickersFragment();
    }
}
