package ibase.android.visionselfie;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.ArrayList;

public class StickerAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = "StickerAdapter";

    private ArrayList<Drawable> mStickers = new ArrayList<>();
    private ArrayList<Item> items;
    private RecyclerViewClickListener clickListener;
    private Context context;

    public StickerAdapter(ArrayList<Item> items, RecyclerViewClickListener clickListener, Context context) {
        this.items = items;
        this.clickListener = clickListener;
        this.context = context;
    }

    public StickerAdapter(Context context, ArrayList<Drawable> mStickers, RecyclerViewClickListener clickListener) {
        this.mStickers = mStickers;
        this.clickListener = clickListener;
        this.context = context;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.layout_sticker_list_item, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder(view, clickListener);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {

        ImageView imageView = viewHolder.itemView.findViewById(R.id.iv_sticker_list_item);


        RequestOptions requestOptions = new RequestOptions()
                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .skipMemoryCache(true)
                .dontTransform()
                .centerCrop();

//        GlideApp.with(context)
        Glide.with(context)
//                .setDefaultRequestOptions(requestOptions)
//                .load(mStickers.get(i))
                .load(items.get(i).getImage())
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .placeholder(R.mipmap.ic_launcher)
                .into(imageView);


/*        Glide.with(context)
                .load(ImageNicer.decodeSampledBitmapFromResource(context.getResources(),R.id.iv_sticker_list_item,100,100))
                .into(imageView);*/
//                .into(((ViewHolder) viewHolder).imageView);
//                .load(ImageNicer.decodeSampledBitmapFromResource(context.getResources(),mStickers.get(i),100,100))


//        imageView.setImageBitmap(ImageNicer.decodeSampledBitmapFromResource(context.getResources(),mStickers,100,100));
        /*Glide.with(context)
                .load(mStickers.get(i))
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .skipMemoryCache(true)
                .thumbnail(0.1f)
                .into(((ViewHolder) viewHolder).imageView);
//                .load(ImageNicer.decodeSampledBitmapFromResource(context.getResources(),mStickers.get(i),100,100))*/


    }

    @Override
    public int getItemCount()
    {
        return items.size();
//        return mStickers.size();
    }

//    public RecyclerView.ViewHolder


    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        ImageView imageView;
        RecyclerViewClickListener clickListener;

        public ViewHolder(@NonNull View itemView, RecyclerViewClickListener clickListener) {
            super(itemView);
            imageView = itemView.findViewById(R.id.iv_sticker_list_item);
            this.clickListener = clickListener;

            itemView.setOnClickListener(this);
        }

        @Override
        public void onClick(View v) {
            if (clickListener != null) {
                Log.d(TAG, "onClick: ");
                clickListener.onStickerClicked(getAdapterPosition());
            }
        }
    }

    public interface RecyclerViewClickListener {
        void onStickerClicked(int position);
    }

}

