package ibase.android.visionselfie;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;

import java.util.ArrayList;

public class DrawableImageView extends AppCompatImageView {

    private static final String TAG = "DrawableImageView";

    private static final int STICKER_STARTING_WIDTH = 300;
    private static final int STICKER_STARTING_HEIGHT = 300;
    private static final int MIN_STICKER_WIDTH = 50;
    private static final int MIN_STICKER_HEIGHT = 50;

    private Activity mHostActivity;


    // Stickers
    private ArrayList<Sticker> mStickers = new ArrayList<>();

    private class Sticker {


        Paint paint;
        Bitmap bitmap;
        Drawable drawable;
        int x, y;
        Rect rect;


        Sticker(Bitmap bitmap, Drawable drawable, int x, int y) {
            paint = new Paint();
            this.x = x;
            this.y = y;
            this.bitmap = bitmap;
            this.drawable = drawable;
//            rect = new Rect(x, y, x + STICKER_STARTING_WIDTH, y + STICKER_STARTING_HEIGHT);
            rect = new Rect(x, y, x + 1080, y + 1920);
        }

    }


    public DrawableImageView(Context context) {
        super(context);
        init(context);

    }

    public DrawableImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public DrawableImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }


    private void init(Context context) {
        Log.d(TAG, "init: ");
//        setWillNotDraw(false);
        setDrawingCacheEnabled(true);
        if (context instanceof Activity) {
            mHostActivity = (Activity) context;
        }
    }

    public void reset() {

        mStickers.clear();
        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.d(TAG, "onDraw: ");
        if (mStickers.size() > 0) {
            for (Sticker sticker : mStickers) {
                Log.d(TAG, "onDraw: ");

//                Rect frameToDraw = new Rect(0, 0, 1000, 1000);
                Rect frameToDraw = new Rect();
//                RectF whereToDraw = new RectF(0, 0, 200, 200);

                canvas.getClipBounds(frameToDraw); // get canvas size base screen size
//                canvas.drawBitmap(sticker.bitmap, new Rect(0,0,40,40), new Rect(0,0,24,13) , null);
                canvas.drawBitmap(sticker.bitmap, null, frameToDraw,null);
//                canvas.drawBitmap(sticker.bitmap, sticker.x, sticker.y, sticker.paint);
//                canvas.drawBitmap(scaleToActualAspectRatio(sticker.bitmap), sticker.x, sticker.y, sticker.paint);
            }
        }
    }



    public void addNewSticker(Drawable drawable) {
        if (mHostActivity != null) {
            if (mHostActivity instanceof MainActivity) {
                Log.d(TAG, "addNewSticker: adding new sticker to canvas.");
                Log.d(TAG, "addNewSticker: drawable: " + drawable);
                Bitmap newStickerBitmap = drawableToBitmap(drawable);
                Log.d(TAG, "addNewSticker: newStickerBitmap:Width " + newStickerBitmap.getWidth() + " Height " + newStickerBitmap.getHeight());

//                Sticker sticker = new Sticker(newStickerBitmap, drawable, 0, 200);
                DisplayMetrics displayMetrics = new DisplayMetrics();
//                getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);

                int height = displayMetrics.heightPixels;
                int width = displayMetrics.widthPixels;
                int leftPercentage = width * 60 / 100;
                int bottomPercentage = height * 60 / 100;
                Log.d(TAG, "addNewSticker: height: " + height + " width : " + width);
                Log.d(TAG, "addNewSticker: leftPercentage: "+leftPercentage+" bottomPercentage: "+bottomPercentage);


                Sticker sticker = new Sticker(newStickerBitmap, drawable, 0, 0);
                mStickers.add(sticker);
                invalidate();

            }
        }

    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = null;

        if (drawable instanceof BitmapDrawable) {
            Log.d(TAG, "drawableToBitmap: ");
            BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
            if (bitmapDrawable.getBitmap() != null) {
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), STICKER_STARTING_WIDTH, STICKER_STARTING_HEIGHT, false);
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), (drawable.getIntrinsicWidth() / 2), (drawable.getIntrinsicHeight()/2), false);
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), (drawable.getIntrinsicWidth() / 4), (drawable.getIntrinsicHeight()/4), false);
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), 1080,1776, false);
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), 800,1232, false);
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), drawable.getIntrinsicWidth() , drawable.getIntrinsicHeight(), false);
//                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), drawable.getMinimumWidth() , drawable.getMinimumHeight(), false);
                return Bitmap.createScaledBitmap(bitmapDrawable.getBitmap(), 1080 , 1920, false);
            }
        }

        if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            bitmap = Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888); // Single color bitmap will be created of 1x1 pixel
            Log.d(TAG, "drawableToBitmap: if ");
        } else {
//            bitmap = Bitmap.createBitmap(STICKER_STARTING_WIDTH, STICKER_STARTING_WIDTH, Bitmap.Config.ARGB_8888);
//            bitmap = Bitmap.createBitmap(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
            bitmap = Bitmap.createBitmap(1080, 1920, Bitmap.Config.ARGB_8888);
            Log.d(TAG, "drawableToBitmap: else ");
        }

        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }


    public Bitmap scaleToActualAspectRatio(Bitmap bitmap) {
        Log.d(TAG, "scaleToActualAspectRatio: ");
        if (bitmap != null) {
            boolean flag = true;

            int deviceWidth = mHostActivity.getWindowManager().getDefaultDisplay()
                    .getWidth();
            int deviceHeight = mHostActivity.getWindowManager().getDefaultDisplay()
                    .getHeight();

            int bitmapHeight = bitmap.getHeight();
            int bitmapWidth = bitmap.getWidth();

            if (bitmapWidth > deviceWidth) {
                flag = false;

// scale According to WIDTH
                int scaledWidth = deviceWidth;
                int scaledHeight = (scaledWidth * bitmapHeight) / bitmapWidth;

                try {
                    if (scaledHeight > deviceHeight)
                        scaledHeight = deviceHeight;
                    bitmap = Bitmap.createScaledBitmap(bitmap, scaledWidth,
                            scaledHeight, true);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (flag) {
                if (bitmapHeight > deviceHeight) {
                    // scale According to HEIGHT
                    int scaledHeight = deviceHeight;
                    int scaledWidth = (scaledHeight * bitmapWidth) / bitmapHeight;

                    try {
                        if (scaledWidth > deviceWidth)
                            scaledWidth = deviceWidth;
                        bitmap = Bitmap.createScaledBitmap(bitmap, scaledWidth,
                                scaledHeight, true);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return bitmap;
    }


}
