package ibase.sfa.reports;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CampActivity extends ValidatorEJB
  implements CampActivityLocal, CampActivityRemote
{
  public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams)
    throws RemoteException, ITMException
  {
    Document dom = null; Document dom1 = null; Document dom2 = null;
    String errString = "";
    E12GenericUtility genericUtility = new E12GenericUtility();
    try
    {
      System.out.println("CampActivity:::itemChanged:::xmlstring" + xmlString);
      System.out.println("CampActivity:::itemChanged:::xmlstring1" + xmlString1);
      System.out.println("CampActivity:::itemChanged:::xmlstring2" + xmlString2);

      if ((xmlString != null) && (xmlString.trim().length() != 0))
      {
        dom = genericUtility.parseString(xmlString);
      }
      if ((xmlString1 != null) && (xmlString1.trim().length() != 0))
      {
        dom1 = genericUtility.parseString(xmlString1);
      }
      if ((xmlString2 != null) && (xmlString2.trim().length() != 0))
      {
        dom2 = genericUtility.parseString(xmlString2);
      }
      errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
      System.out.println("CampActivity:::itemChanged:::ErrString :" + errString);
    }
    catch (Exception e)
    {
      System.out.println("CampActivity:::itemChanged:::Exception: itemchanged(String xmlString): " + e.getMessage() + ":");
      errString = genericUtility.createErrorString(e);
      e.printStackTrace();
    }
    return errString;
  }

  public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
  {
    NodeList parentNodeList = null; NodeList childNodeList = null;
    Node parentNode = null; Node childNode = null;
    int childNodeListLength = 0; int ctr = 0;
    String childNodeName = ""; String childNodeValue = "";
    String loginSite = ""; String empCode = "";
    int currentFormNo = 0;
    PreparedStatement pstmt = null;
    ResultSet resultSet = null;
    Connection conn = null;

    StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
    valueXmlString.append(editFlag).append("</editFlag></header>");
    valueXmlString.append("<Detail1>");
    E12GenericUtility genericUtility = new E12GenericUtility();
    try
    {
      ConnDriver connDriver = new ConnDriver();
      conn = connDriver.getConnectDB("Driver");

      if ((objContext != null) && (objContext.trim().length() > 0))
      {
        currentFormNo = Integer.parseInt(objContext);
      }

      switch (currentFormNo)
      {
      case 1:
        parentNodeList = dom.getElementsByTagName("Detail1");
        parentNode = parentNodeList.item(0);
        childNodeList = parentNode.getChildNodes();
        childNodeListLength = childNodeList.getLength();
        System.out.println("CampActivity:::itemChanged:::Child length is" + childNodeListLength);
        do
        {
          childNode = childNodeList.item(0);
          childNodeName = childNode.getNodeName();
          if (childNodeName.equals(currentColumn))
          {
            if (childNode.getFirstChild() != null)
            {
              childNodeValue = childNode.getFirstChild().getNodeValue();
              System.out.println("CampActivity:::itemChanged:::childNode value (itemchanged)" + childNodeValue);
            }
          }
          ctr++;
        }
        while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));

        if (currentColumn.equalsIgnoreCase("itm_default"))
        {
          loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
          System.out.println("loginCode....." + loginSite);
          valueXmlString.append("<as_user_id>").append("<![CDATA[" + loginSite + "]]>").append("</as_user_id>");

          String sql = "select emp_code from users where code = ? ";
          pstmt = conn.prepareStatement(sql);
          pstmt.setString(1, loginSite);

          resultSet = pstmt.executeQuery();
          if (resultSet.next()) {
            empCode = checkNull(resultSet.getString("emp_code"));
            System.out.println("@empCode>> " + empCode);
          }
          if (resultSet != null)
          {
            resultSet.close();
            resultSet = null;
          }

          if (pstmt != null)
          {
            pstmt.close();
            pstmt = null;
          }

          valueXmlString.append("<as_emp_code>").append("<![CDATA[" + empCode + "]]>").append("</as_emp_code>");
        }

        valueXmlString.append("</Detail1>");
      }

    }
    catch (Exception e)
    {
      throw new ITMException(e);
    }
    finally
    {
      try
      {
        if (conn != null)
        {
          conn.close();
          conn = null;
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
      }
    }
    valueXmlString.append("</Root>\r\n");
    System.out.println("CampActivity:::itemChanged:::valueXmlString....[" + valueXmlString.toString());
    return valueXmlString.toString();
  }

  private String checkNull(String input)
  {
    if ((input == null) || ("null".equalsIgnoreCase(input)))
    {
      input = "";
    }
    return input.trim();
  }
}