/***
 * Author:Santosh
 * Date:24-APR-2019
 */
package ibase.webitm.ejb.dis;

import java.io.File;
import java.io.FileWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;

import org.w3c.dom.Document;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

@Stateless
public class SalesConsolidationRulePrc extends ProcessEJB
		implements SalesConsolidationRulePrcLocal, SalesConsolidationRulePrcRemote {
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	@Override
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
			throws RemoteException, ITMException {
		String rtStr = "";
		Document dom = null;
		Document dom2 = null;
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
				System.out.println("Process Dom::::::::::::::::" + dom);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println("Process Dom2::::::::::::::::" + dom2);
			}
			rtStr = process(dom, dom2, windowName, xtraParams);
		} catch (Exception e) {
			System.out.println("::::" + this.getClass().getSimpleName() + "::processDataString" + e.getMessage());
			e.printStackTrace();
		}
		return rtStr;
	}

	@SuppressWarnings("null")
	@Override
	public String process(Document dom, Document dom2, String windowName, String xtraParams)
			throws RemoteException, ITMException {

		String errString = "", userID = "", prdCode = "", itemSer = "",itemSerSource = "", tranId = "", loginSiteCode = "", sql = "",
				sql1 = "", userId = "", xmlInEditMode = "", unit = "", empCode = "", posCode = "", custCode = "",
				itemCode = "", tranDateStr = "", retString = "", xmlParseStr = "", versionId = "", stanCode = "",stanCode1 = "",stanCode2 = "",
				stanCodeNew = "", terrCode = "", terrDescr = "", lastYrPrdCode = "";
		double opStock = 0.0, clStock = 0.0, OpValue = 0.0, clValue = 0.0, cyslsSecQty = 0.0, cyslsSecVal = 0.0,
				rcpBillQty = 0.0, rcpBillVal = 0.0, tranBillQty = 0.0, tranBillVal = 0.0, retQty = 0.0, retVal = 0.0,
				tranRepQty = 0.0, tranRepVal = 0.0, tranBonusQty = 0.0, lastYrsSale = 0.0, lastYrsSaleVal = 0.0,
				tranBonusVal = 0.0, rcpBonusQty = 0.0, rcpBonusVal = 0.0, rcpRplQty = 0.0, rcpRplVal = 0.0,
				grossQty = 0.0, grossRate = 0.0, grossVal = 0.0;
		Connection conn = null;
		String balGroup = "", descr = "", sqlExpr = "", sqlExpr1 = "", sqlExpr2 = "", sqlExpr3 = "", sqlExpr4 = "",
				sqlExpr5 = "", sqlExpr6 = "", sqlInput = "", FileName = "";
		String sqlExprMain = "";
		int lineNo = 0;
		String calMomnth = "", prdCodeFrom = "", prdCodeTo = "", acctPrd = "", source = "", ruleCode = "";// added by
																											// santosh
																											// on
																											// 09-MAY2019
		String itemSerNew = "", remarks = "", udfStr1 = "", udfStr2 = "", udfStr3 = "";
		double grossSalesQty = 0, grossSalesVal = 0, lyslsSecQty = 0, lyslsSecVal = 0;
		int ctr = 0, count = 0, cnt = 0, updCnt = 0, period = 0;
		String chgTerm = "", chgUser = "", overWrite = "", countryCode = "";
		PreparedStatement pstmt = null, pstmt1 = null, pstmt0 = null,pstmt2 = null,pstmt8 = null,pstmt9 = null,pstmt4 = null,pstmt99=null,pstmt77=null,pstmt88=null,pstmt777=null,pstmt888=null;
		ResultSet rs = null, rs1 = null, rs0 = null,rs2=null,rs00 = null,rs6=null,rs7=null,rs8=null,rs9=null,rs4=null,rs88=null,rs777=null;
		Timestamp tranDate = null, frDate = null, toDate = null;
		StringBuffer xmlBuff = null;
		System.out.println("Current DOM [" + genericUtility.serializeDom(dom) + "]");
		System.out.println("Header DOM [" + genericUtility.serializeDom(dom2) + "]");
		java.sql.Date sysDate = null;
		LinkedList secSalesList = new LinkedList();
		LinkedList priSalesList = new LinkedList();
		LinkedList adjSalesList = new LinkedList();
		LinkedList blockCustList = new LinkedList();
		LinkedList shiftCredList = new LinkedList();
		LinkedList finalAdjustmentList = new LinkedList();
		String finalPairArray[] = null;
		String finalCustCode = "", finalItemCode = "", finalItemSer = "", finalPosCode = "",finalStanCode="";
		String currLastDiff = "";
		int counter = 0;
		java.sql.Timestamp effDateMax = null;
		String itemSerOld = "", unitChange = "", stanCodeChange = "";
		boolean connBollen = false;
		String secSalesPair = "", priSalesPair = "",adjSalesPair="",finalAdjustPair="",blockCustPair="",shiftCredPair="";
		SalesConsolidateDetail SalesConsolidateDetail = null;
		SalesConsolidateDetail SalesConsolidateDetail1 = null;
		ArrayList<SalesConsolidateDetail> al = new ArrayList<SalesConsolidateDetail>();
		ConnDriver connDriver = new ConnDriver();
		Connection connection = null;
		Connection connDWH = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		PreparedStatement preparedStatement1 = null;
		ResultSet resultSet1 = null;
		List<HashMap<String, String>> ruleList1 = null;
		HashMap<String, String> dwhMap1 = null;
		List<HashMap<String, String>> ruleList2 = null;
		HashMap<String, String> dwhMap2 = null;
		try {
			SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss.SSS");
			java.util.Date now = new java.util.Date();
			String strDate = sdfDate.format(now);
			System.out.println("@S@>>>strDate[" + strDate + "]");
			System.out.println("In process Secondary and Primary Sales Consolidation:::");
			userId = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userID"));
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			// prdCode = checkNull(genericUtility.getColumnValue("prd_code", dom));
			prdCodeFrom = checkNull(genericUtility.getColumnValue("prd_code_from", dom));
			prdCodeTo = checkNull(genericUtility.getColumnValue("prd_code_to", dom));
			itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
			itemSerSource = checkNull(genericUtility.getColumnValue("item_ser", dom));
			versionId = checkNull(genericUtility.getColumnValue("version_id", dom));
			acctPrd = checkNull(genericUtility.getColumnValue("acct_prd", dom));
			overWrite = checkNull(genericUtility.getColumnValue("overwrite", dom));
			System.out.println("versionId>>>" + versionId + "acctPrd" + acctPrd + "]");
			System.out.println("prdCodeFrom>>>" + prdCodeFrom + "prdCodeTo" + prdCodeTo + ">>itemSer>>" + itemSer
					+ ">>overWrite>>" + overWrite);
			System.out.println("userId : " + userId);
			System.out.println("xtraParams ::: " + xtraParams);
			ConnDriver con = new ConnDriver();
			ConnDriver con1 = new ConnDriver();
			/* conn = con.getConnectDB("DriverITM"); */
			conn = getConnection();
			connection = con.getConnectDB("DWH");
			System.out.println("connection===>" + connection);
			connDWH = con1.getConnectDB("DWH2");
			System.out.println("connDWH===>" + connDWH);

			sql1 = "select sysdate from dual";
			pstmt = conn.prepareStatement(sql1);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				sysDate = rs.getDate(1);
			}
			if (rs != null) {
				rs.close();
				rs = null;

			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;

			}

			sql = "select count_code from state where "
					+ "state_code in (select state_code from site where site_code=?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				countryCode = checkNull(rs.getString("count_code")).trim();
				System.out.println("countryCode >>> :" + countryCode);
			}
			if (rs != null) {
				rs.close();
				rs = null;

			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;

			}
			if ("Y".equalsIgnoreCase(overWrite)) {
				cnt = 0;
				
				sql = "select distinct cal_month as cal_month from SALES_CONS_RULEWISE where cal_month between ? and ?  AND ITEM_SER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, prdCodeFrom);
				pstmt.setString(2, prdCodeTo);
				pstmt.setString(3, itemSer);
				rs = pstmt.executeQuery();
				System.out.println("outside delete");
				while (rs.next()) {
					calMomnth = checkNull(rs.getString("cal_month"));
					System.out.println("inside delete");
					sql1 = "DELETE FROM SALES_CONS_RULEWISE WHERE cal_month = ? AND ITEM_SER=?  ";
					//sql1 = "DELETE FROM SALES_CONS_RULEWISE WHERE cal_month = ? AND ITEM_SER=?  and rule_code in ('ES3R3','ES3R7','ES3R2','ES3R8','ES3R4','ES3R5','ES3R1','ES3R6','ADJCR') ";
					//sql1 = "DELETE FROM SALES_CONS_RULEWISE WHERE cal_month = ? AND ITEM_SER=?  and rule_code in ('ES3R3') ";

					pstmt1 = conn.prepareStatement(sql1);
					pstmt1.setString(1, calMomnth);
					pstmt1.setString(2, itemSer);
					cnt = pstmt1.executeUpdate();
					System.out.println("Delete count>>" + cnt);
					pstmt1.close();
					pstmt1 = null;
					System.out.println("Delete count>>" + cnt);
					

				}
				if (rs != null) {
					rs.close();
					rs = null;

				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;

				}

			}
			FileName = itemSer + "_" + prdCodeFrom + "_" + prdCodeTo + "_" + strDate;
			System.out.println("@S@>>FileName[" + FileName + "]");
			
			/*sql = "select a.bal_group,b.line_no,a.descr ,b.sql_expr,b.sql_expr1,b.sql_expr2,b.sql_expr3,b.sql_expr4,b.sql_expr5,b.sql_expr6,b.sql_input "
					+ "from tax_balance_grp a ,tax_bal_grp_det b where  a.bal_group=b.bal_group and b.ref_ser='D-ES3'  and b.bal_group not like '%R000%'  order by line_no ";*/
			
			/*sql = "select a.bal_group,b.line_no,a.descr ,b.sql_expr,b.sql_expr1,b.sql_expr2,b.sql_expr3,b.sql_expr4,b.sql_expr5,b.sql_expr6,b.sql_input "
					+ "from tax_balance_grp a ,tax_bal_grp_det b where  a.bal_group=b.bal_group and b.ref_ser='D-ES3' and b.bal_group in ('ES3R3')  and b.bal_group not like '%R000%'  order by line_no ";
			*/
			
			sql = "select a.bal_group,b.line_no,a.descr ,b.sql_expr,b.sql_expr1,b.sql_expr2,b.sql_expr3,b.sql_expr4,b.sql_expr5,b.sql_expr6,b.sql_input "
					+ "from tax_balance_grp a ,tax_bal_grp_det b where  a.bal_group=b.bal_group and b.ref_ser='D-ES3' and b.bal_group not in ('ES3R1')  and b.bal_group not like '%R000%'  order by line_no ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next()) {

				balGroup = checkNull(rs.getString(1));
				lineNo = rs.getInt(2);
				descr = checkNull(rs.getString(3));
				sqlExpr = checkNull(rs.getString(4));
				sqlExpr1 = checkNull(rs.getString(5));
				sqlExpr2 = checkNull(rs.getString(6));
				sqlExpr3 = checkNull(rs.getString(7));
				sqlExpr4 = checkNull(rs.getString(8));
				sqlExpr5 = checkNull(rs.getString(9));
				sqlExpr6 = checkNull(rs.getString(10));
				sqlInput = checkNull(rs.getString(11));
				sqlExprMain = sqlExpr + sqlExpr1;
				sql1 = sqlExprMain;
				System.out.println("sql1... +" + sql1);
				if (sql1 != null && sql1.trim().length() > 0) {
					pstmt1 = conn.prepareStatement(sql1);
					if ("ES3R0".equalsIgnoreCase(balGroup)) {
						String changeYearPair="",itemPrimary="",custPrimary="",stanPrimary="";
						ArrayList<String> custList= new ArrayList<String>();;
						
						String sql55="SELECT  item_code,cust_code,stan_code FROM   dwh_sales_fact WHERE   prd_code = ?  AND item_ser = ?";
						PreparedStatement ps1 = connDWH.prepareStatement(sql55);
						ps1.setString(1, prdCodeFrom);
						ps1.setString(2, itemSer);
						rs00 = ps1.executeQuery();
						while (rs00.next()) {
							itemPrimary = checkNull(rs00.getString("item_code"));
							custPrimary = checkNull(rs00.getString("cust_code"));
							stanPrimary = checkNull(rs00.getString("stan_code"));
							priSalesPair=custPrimary+":"+itemPrimary+":"+stanPrimary;
							if(!priSalesList.contains(priSalesPair))
							{
								priSalesList.add(priSalesPair);
							}
							
						}
						System.out.println("primary size==>"+priSalesList.size());
						rs00.close();
						rs00 = null;
						ps1.close();
						ps1 = null;
						
						
						String sqlQuery = "SELECT ( SELECT acct_prd FROM period WHERE code = prd_code AND ROWNUM = 1 ) AS acct_prd, prd_code AS cal_month, 'OPENG' AS rule_code, 'O' AS source, item_code, unit, item_ser AS item_ser, cust_code, terr_code, stan_code, 'O' AS carry_data, SUM(pri_net_sales_qty) AS cysls_pri_qty, SUM(pri_net_sales_val) AS cysls_pri_val, SUM(pri_lycm_sales_qty) AS lysls_pri_qty, SUM(pri_lycm_sales_val) AS lysls_pri_val, SUM(sec_net_sales_qty) AS cysls_sec_qty, SUM(sec_net_sales_val) AS cysls_sec_val, SUM(sec_lycm_sales_qty) AS lysls_sec_qty, SUM(sec_lycm_sales_val) AS lysls_sec_val, NULL AS remarks, NULL AS udf_str1, NULL AS udf_str2, NULL AS udf_str3, NULL AS add_user, NULL AS add_date, NULL AS add_term, NULL AS chg_user, NULL AS chg_date, NULL AS chg_term FROM ( SELECT prd_code, item_ser_new AS item_ser, item_code, unit, cust_code, NULL AS terr_code, stan_code_new AS stan_code, NULL AS pri_net_sales_qty, NULL AS pri_net_sales_val, NULL AS pri_lycm_sales_qty, NULL AS pri_lycm_sales_val, sales AS sec_net_sales_qty, sales_value AS sec_net_sales_val, lysls_sales_qty AS sec_lycm_sales_qty, lysls_sales_val AS sec_lycm_sales_val FROM sales_consolidation WHERE sales_consolidation.prd_code >= ? AND sales_consolidation.prd_code <= ? AND sales_consolidation.item_ser_new = ?) GROUP BY 'OPENG', prd_code, item_ser, item_code, stan_code, unit, cust_code, terr_code";
						//String sqlQuery = "SELECT ( SELECT acct_prd FROM period WHERE code = prd_code AND ROWNUM = 1 ) AS acct_prd, prd_code AS cal_month, 'OPENG' AS rule_code, 'O' AS source, item_code, unit, item_ser AS item_ser, cust_code, terr_code, stan_code, 'O' AS carry_data, SUM(pri_net_sales_qty) AS cysls_pri_qty, SUM(pri_net_sales_val) AS cysls_pri_val, SUM(pri_lycm_sales_qty) AS lysls_pri_qty, SUM(pri_lycm_sales_val) AS lysls_pri_val, SUM(sec_net_sales_qty) AS cysls_sec_qty, SUM(sec_net_sales_val) AS cysls_sec_val, SUM(sec_lycm_sales_qty) AS lysls_sec_qty, SUM(sec_lycm_sales_val) AS lysls_sec_val, NULL AS remarks, NULL AS udf_str1, NULL AS udf_str2, NULL AS udf_str3, NULL AS add_user, NULL AS add_date, NULL AS add_term, NULL AS chg_user, NULL AS chg_date, NULL AS chg_term FROM ( SELECT prd_code, item_ser_new AS item_ser, item_code, unit, cust_code, NULL AS terr_code, stan_code_new AS stan_code, NULL AS pri_net_sales_qty, NULL AS pri_net_sales_val, NULL AS pri_lycm_sales_qty, NULL AS pri_lycm_sales_val, sales AS sec_net_sales_qty, sales_value AS sec_net_sales_val, lysls_sales_qty AS sec_lycm_sales_qty, lysls_sales_val AS sec_lycm_sales_val FROM sales_consolidation WHERE sales_consolidation.prd_code >= ? AND sales_consolidation.prd_code <= ? AND sales_consolidation.item_ser_new = ? AND trim(sales_consolidation.item_code) = '6760' and trim(sales_consolidation.stan_code)='MH034') GROUP BY 'OPENG', prd_code, item_ser, item_code, stan_code, unit, cust_code, terr_code";

						pstmt99 = conn.prepareStatement(sqlQuery);
						pstmt99.setString(1, prdCodeFrom);
						pstmt99.setString(2, prdCodeTo);
						pstmt99.setString(3, itemSer);
						rs1 = pstmt99.executeQuery();
						while (rs1.next()) {
							System.out.println("inside while loop");
							prdCode = checkNull(rs1.getString("CAL_MONTH"));
							custCode = checkNull(rs1.getString("CUST_CODE"));
							itemSer = checkNull(rs1.getString("ITEM_SER"));
							itemCode = checkNull(rs1.getString("ITEM_CODE"));
							stanCode = checkNull(rs1.getString("STAN_CODE"));
							secSalesPair=custCode+":"+itemCode+":"+stanCode;
							System.out.println("secSalesPair==>"+secSalesPair);
							//secSalesList.add(secSalesPair);
							if(priSalesList.contains(secSalesPair))
							{
								priSalesList.remove(secSalesPair);
							}
							
							period = Integer.parseInt(prdCode);
							period = period - 100;
							System.out.println("period :::: "+period);
							lastYrPrdCode = period+"";
							System.out.println("lastYrPrdCode :::: "+lastYrPrdCode);
							unit = checkNull(rs1.getString("UNIT"));
							ruleCode = checkNull(rs1.getString("RULE_CODE"));
							
							cyslsSecQty = rs1.getDouble("CYSLS_SEC_QTY");// sales ->Sec curr sale
							cyslsSecVal = rs1.getDouble("CYSLS_SEC_VAL");// sales value->Sec curr sale value
							lyslsSecQty = rs1.getDouble("LYSLS_SEC_QTY");// lyslsSalesQty -> last year Sec sale
							lyslsSecVal = rs1.getDouble("LYSLS_SEC_VAL");// lyslsSalesVal-> last year Sec sales value
							
							//terr code calculation
							
							String terrSql = "SELECT      ha.level_code__parent   AS terr_cd FROM     hierarchy   ha,     hierarchy   hb,     hierarchy   hc,     hierarchy   hd,     hierarchy   hf,     station     hg,     hierarchy   hh WHERE     ha.version_id = hb.version_id     AND hb.version_id = hc.version_id     AND hc.version_id = hd.version_id     AND hd.version_id = hf.version_id     AND hf.version_id = hh.version_id     AND hf.level_code__parent = hh.level_code     AND hd.level_code__parent = hf.level_code     AND hc.level_code__parent = hd.level_code     AND hb.level_code__parent = hc.level_code     AND ha.level_code__parent = hb.level_code     AND ha.stan_code = hg.stan_code     AND ha.version_id = ?   AND HA.TABLE_NO  = ?     AND HA.STAN_CODE  >= '00'     AND HA.STAN_CODE  <= 'ZZ'     AND  HA.LEVEL_NO = 5      AND HA.VALID_UPTO >= SYSDATE     AND HA.LEVEL_CODE__PARENT  >= '00'     AND HA.LEVEL_CODE__PARENT  < = 'ZZ'     and HA.stan_code= ? ";
							pstmt2 = conn.prepareStatement(terrSql);
							pstmt2.setString(1, versionId);
							pstmt2.setString(2, itemSer);
							pstmt2.setString(3, stanCode);
							rs2 = pstmt2.executeQuery();
							if (rs2.next()) {
								terrCode = checkNull(rs2.getString("terr_cd")).trim();
								System.out.println("terrCode >>> :" + terrCode);
							}
							rs2.close();
							rs2 = null;
							pstmt2.close();
							pstmt2 = null;
							
							System.out.println("line no 341");
							//terrCode = checkNull(rs1.getString("TERR_CODE"));
							source = checkNull(rs1.getString("SOURCE"));
							remarks = checkNull(rs1.getString("REMARKS"));
							udfStr1 = checkNull(rs1.getString("UDF_STR1"));
							udfStr2 = checkNull(rs1.getString("UDF_STR2"));
							udfStr3 = checkNull(rs1.getString("UDF_STR3"));
							
							double cyslsPriQty = 0, cyslsPriVal = 0, lyslsPriQty = 0, lyslsPriVal = 0;
							Double closeQty=0.0,closeVal=0.0;
							
							String sql5="select sum(net_sales_qty) as net_sales_qty,sum(net_sales_val) as net_sales_val,sum(lycm_sales_qty) as lycm_sales_qty,sum(lycm_sales_val) as lycm_sales_val  from dwh_sales_fact where prd_code= ? and item_code= ? and cust_code= ?  and stan_code= ? and item_ser= ? ";
							PreparedStatement ps = connDWH.prepareStatement(sql5);
							ps.setString(1, prdCode);
							ps.setString(2, itemCode);
							ps.setString(3, custCode);
							ps.setString(4, stanCode);
							ps.setString(5, itemSer);
							rs0 = ps.executeQuery();
							while (rs0.next()) {
								cyslsPriQty = rs0.getDouble("net_sales_qty");// netSalesQty-> curr year pri sale
								cyslsPriVal = rs0.getDouble("net_sales_val");// netSalesVal->curr year pri value 
								lyslsPriQty = rs0.getDouble("lycm_sales_qty");// lycmSalesQty -> last year pri sale
								lyslsPriVal = rs0.getDouble("lycm_sales_val"); // lycmSalesVal -> last year pri sale value
							}
							
							rs0.close();
							rs0 = null;
							ps.close();
							ps = null;
							
							
							String sql6="SELECT  SUM(TRANSIT_QTY+TRANSIT_QTY__REPL+CL_STOCK+TRANSIT_QTY__FREE) as close_qty FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ? and stan_code= ? ";
							PreparedStatement ps6 = conn.prepareStatement(sql6);
							ps6.setString(1, prdCode);
							ps6.setString(2, itemCode);
							ps6.setString(3, custCode);
							ps6.setString(4, itemSerSource);
							ps6.setString(5, stanCode);
							rs6 = ps6.executeQuery();
							while (rs6.next()) {
								closeQty = rs6.getDouble("close_qty");// netSalesQty-> curr year pri sale
							}
							
							String sql7="SELECT  SUM(TRANSIT_BILL_VAL+TRANSIT_REPL_VAL+CL_VALUE + TRANSIT_FREE_VAL) as close_val FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ? and stan_code= ? ";
							PreparedStatement ps7 = conn.prepareStatement(sql7);
							ps7.setString(1, prdCode);
							ps7.setString(2, itemCode);
							ps7.setString(3, custCode);
							ps7.setString(4, itemSerSource);
							ps7.setString(5, stanCode);
							rs7 = ps7.executeQuery();
							while (rs7.next()) {
								closeVal = rs7.getDouble("close_val");// netSalesQty-> curr year pri sale
							}
							
							
							SalesConsolidateDetail = new SalesConsolidateDetail();
							SalesConsolidateDetail.setRuleCode(ruleCode);
							SalesConsolidateDetail.setPrdCode(prdCode);
							SalesConsolidateDetail.setPrdCodeFrom(prdCodeFrom);
							SalesConsolidateDetail.setPrdCodeTo(prdCodeTo);
							SalesConsolidateDetail.setCustCode(custCode);
							SalesConsolidateDetail.setItemCode(itemCode);
							SalesConsolidateDetail.setItemSer(itemSer);
							SalesConsolidateDetail.setUnit(unit);
							SalesConsolidateDetail.setStanCode(stanCode);
							
							SalesConsolidateDetail.setCyslsSecQty(cyslsSecQty);
							SalesConsolidateDetail.setCyslsSecVal(cyslsSecVal);
							SalesConsolidateDetail.setCyslsPriQty(cyslsPriQty);
							SalesConsolidateDetail.setCyslsPriVal(cyslsPriVal);
							SalesConsolidateDetail.setLyslsPriQty(lyslsPriQty);
							SalesConsolidateDetail.setLyslsPriVal(lyslsPriVal);
							SalesConsolidateDetail.setLyslsSecQty(lyslsSecQty);
							SalesConsolidateDetail.setLyslsSecVal(lyslsSecVal);
							SalesConsolidateDetail.setRemarks(remarks);
							SalesConsolidateDetail.setClosingQty(closeQty);
							SalesConsolidateDetail.setClosingVal(closeVal);
							SalesConsolidateDetail.setUdfStr3(udfStr3);
							SalesConsolidateDetail.setTerrCode(terrCode);
							SalesConsolidateDetail.setVersionId(versionId);
							SalesConsolidateDetail.setAcctPrd(acctPrd);
							SalesConsolidateDetail.setSource(source);
							errString = insertToPriSecSalesConsolidation(FileName, conn, xtraParams, sysDate,
									lastYrPrdCode, SalesConsolidateDetail);
							
							
							ps6.close();
							ps6 = null;
							rs6.close();
							rs6 = null;
							ps7.close();
							ps7 = null;
							rs7.close();
							rs7 = null;

						}
						if (rs1 != null) {
							rs1.close();
							rs1 = null;

						}
						if (pstmt99 != null) {
							pstmt99.close();
							pstmt99 = null;

						}
						
						
						//added by ketan for missing primary difference
						
						System.out.println("new size for Primary==>"+priSalesList.size());
						if(priSalesList.size()>0)
						{  
							for (Object object : priSalesList) 
						{
								String finalPair= object.toString();
								finalPairArray= finalPair.split(":");
								finalCustCode=finalPairArray[0];
								finalItemCode=finalPairArray[1];
								finalStanCode=finalPairArray[2];
								System.out.println("New changed1==>"+finalCustCode);
								System.out.println("New changed2==>"+finalItemCode);
								System.out.println("New changed3==>"+finalStanCode);
								ArrayList<String>stanList=new ArrayList<String>();
							prdCode = prdCodeFrom;
							String unitSql = "select unit from item where item_code= ? ";
							pstmt2 = conn.prepareStatement(unitSql);
							pstmt2.setString(1, finalItemCode);
							rs2 = pstmt2.executeQuery();
							if (rs2.next()) {
								unit = checkNull(rs2.getString("unit"));
								System.out.println(unit);
							}
							rs2.close();
							rs2 = null;
							pstmt2.close();
							pstmt2 = null;
							//unit = checkNull(rs1.getString("UNIT"));
							
							ruleCode = "OPENG";
									cyslsSecQty = 0;// sales ->Sec curr sale
									cyslsSecVal = 0;// sales value->Sec curr sale value
									
									lyslsSecQty = 0;// lyslsSalesQty -> last year Sec sale
									lyslsSecVal = 0;// lyslsSalesVal-> last year Sec sales value
									
									//terr code calculation
									
									String terrSql = "SELECT      ha.level_code__parent   AS terr_cd FROM     hierarchy   ha,     hierarchy   hb,     hierarchy   hc,     hierarchy   hd,     hierarchy   hf,     station     hg,     hierarchy   hh WHERE     ha.version_id = hb.version_id     AND hb.version_id = hc.version_id     AND hc.version_id = hd.version_id     AND hd.version_id = hf.version_id     AND hf.version_id = hh.version_id     AND hf.level_code__parent = hh.level_code     AND hd.level_code__parent = hf.level_code     AND hc.level_code__parent = hd.level_code     AND hb.level_code__parent = hc.level_code     AND ha.level_code__parent = hb.level_code     AND ha.stan_code = hg.stan_code     AND ha.version_id = ?   AND HA.TABLE_NO  = ?     AND HA.STAN_CODE  >= '00'     AND HA.STAN_CODE  <= 'ZZ'     AND  HA.LEVEL_NO = 5      AND HA.VALID_UPTO >= SYSDATE     AND HA.LEVEL_CODE__PARENT  >= '00'     AND HA.LEVEL_CODE__PARENT  < = 'ZZ'     and HA.stan_code= ? ";
									pstmt8 = conn.prepareStatement(terrSql);
									pstmt8.setString(1, versionId);
									pstmt8.setString(2, itemSer);
									pstmt8.setString(3, finalStanCode);
									rs8 = pstmt8.executeQuery();
									if (rs8.next()) {
										terrCode = checkNull(rs8.getString("terr_cd")).trim();
										System.out.println("terrCode >>> :" + terrCode);
									}
									rs8.close();
									rs8 = null;
									pstmt8.close();
									pstmt8 = null;
									
									//terrCode = checkNull(rs1.getString("TERR_CODE"));
									source = "O";
									remarks = "";
									udfStr1 = "";
									udfStr2 = "";
									udfStr3 = "";
									
									
									
									double cyslsPriQty = 0, cyslsPriVal = 0, lyslsPriQty = 0, lyslsPriVal = 0;
									
									String sql5="select sum(net_sales_qty) as net_sales_qty,sum(net_sales_val) as net_sales_val,sum(lycm_sales_qty) as lycm_sales_qty,sum(lycm_sales_val) as lycm_sales_val  from dwh_sales_fact where prd_code= ? and item_code= ? and cust_code= ? and stan_code= ? and item_ser= ? ";
									PreparedStatement ps = connDWH.prepareStatement(sql5);
									ps.setString(1, prdCode);
									ps.setString(2, finalItemCode);
									ps.setString(3, finalCustCode);
									ps.setString(4, finalStanCode);
									ps.setString(5, itemSer);
									rs0 = ps.executeQuery();
									while (rs0.next()) {
										cyslsPriQty = rs0.getDouble("net_sales_qty");// netSalesQty-> curr year pri sale
										cyslsPriVal = rs0.getDouble("net_sales_val");// netSalesVal->curr year pri value 
										lyslsPriQty = rs0.getDouble("lycm_sales_qty");// lycmSalesQty -> last year pri sale
										lyslsPriVal = rs0.getDouble("lycm_sales_val"); // lycmSalesVal -> last year pri sale value
									}
									
									rs0.close();
									rs0 = null;
									ps.close();
									ps = null;
									
									
									SalesConsolidateDetail = new SalesConsolidateDetail();
									SalesConsolidateDetail.setRuleCode(ruleCode);
									SalesConsolidateDetail.setPrdCode(prdCode);
									SalesConsolidateDetail.setPrdCodeFrom(prdCodeFrom);
									SalesConsolidateDetail.setPrdCodeTo(prdCodeTo);
									SalesConsolidateDetail.setCustCode(finalCustCode);
									SalesConsolidateDetail.setItemCode(finalItemCode);
									SalesConsolidateDetail.setItemSer(itemSer);
									SalesConsolidateDetail.setUnit(unit);
									SalesConsolidateDetail.setStanCode(finalStanCode);
									//27-12-21
									//SalesConsolidateDetail.setCyslsSecQty(cyslsAdjQty);
									//SalesConsolidateDetail.setCyslsSecVal(cyslsAdjVal);
									SalesConsolidateDetail.setCyslsSecQty(0.0);
									SalesConsolidateDetail.setCyslsSecVal(0.0);
									SalesConsolidateDetail.setCyslsPriQty(cyslsPriQty);
									SalesConsolidateDetail.setCyslsPriVal(cyslsPriVal);
									SalesConsolidateDetail.setLyslsPriQty(lyslsPriQty);
									SalesConsolidateDetail.setLyslsPriVal(lyslsPriVal);
									//27-12-21
									//SalesConsolidateDetail.setLyslsSecQty(lyslsAdjQty);
									//SalesConsolidateDetail.setLyslsSecVal(lyslsAdjVal);
									SalesConsolidateDetail.setLyslsSecQty(0.0);
									SalesConsolidateDetail.setLyslsSecVal(0.0);
									SalesConsolidateDetail.setRemarks(remarks);
									/*SalesConsolidateDetail.setUdfStr1(udfStr1);
									SalesConsolidateDetail.setUdfStr2(udfStr2);*/
									SalesConsolidateDetail.setClosingQty(0.0);
									SalesConsolidateDetail.setClosingVal(0.0);
									SalesConsolidateDetail.setUdfStr3(udfStr3);
									SalesConsolidateDetail.setTerrCode(terrCode);
									SalesConsolidateDetail.setVersionId(versionId);
									SalesConsolidateDetail.setAcctPrd(acctPrd);
									SalesConsolidateDetail.setSource(source);
									errString = insertToPriSecSalesConsolidation(FileName, conn, xtraParams, sysDate,
											lastYrPrdCode, SalesConsolidateDetail);
								//}
								

						}
					}
						

					}

					// added by adnan
					if ("ES3R1".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);

					}

					if ("ES3R2".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);

					}

					if ("ES3R3".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);
						pstmt1.setString(7, itemSer);
						pstmt1.setString(8, prdCodeFrom);
						pstmt1.setString(9, prdCodeTo);
						pstmt1.setString(10, acctPrd);
						pstmt1.setString(11, prdCodeFrom);
						pstmt1.setString(12, prdCodeTo);
						pstmt1.setString(13, itemSer);
						pstmt1.setString(14, itemSer);

					}

					if ("ES3R4".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);
						pstmt1.setString(7, itemSer);
						pstmt1.setString(8, prdCodeFrom);
						pstmt1.setString(9, prdCodeTo);
						pstmt1.setString(10, acctPrd);
						pstmt1.setString(11, prdCodeFrom);
						pstmt1.setString(12, prdCodeTo);
						pstmt1.setString(13, itemSer);
						pstmt1.setString(14, itemSer);

					}

					if ("ES3R5".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);

					}

					if ("ES3R6".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);

					}
					
					if ("ES3R7".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);

					}
					
					if ("ES3R8".equalsIgnoreCase(balGroup)) {
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeTo);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeTo);
						pstmt1.setString(6, itemSer);
						pstmt1.setString(7, itemSer);
						pstmt1.setString(8, prdCodeFrom);
						pstmt1.setString(9, prdCodeTo);
						pstmt1.setString(10, acctPrd);
						pstmt1.setString(11, prdCodeFrom);
						pstmt1.setString(12, prdCodeTo);
						pstmt1.setString(13, itemSer);
						pstmt1.setString(14, itemSer);

					}


					if (!"ES3R0".equalsIgnoreCase(balGroup)  && !"ES3R4".equalsIgnoreCase(balGroup)) {
						rs1 = pstmt1.executeQuery();
						while (rs1.next()) {
							System.out.println("inside while loop");
							// tranId = checkNull(rs1.getString("TRAN_ID"));//
							prdCode = checkNull(rs1.getString("CAL_MONTH")); // as prd_code
							custCode = checkNull(rs1.getString("CUST_CODE"));//
							itemSer = checkNull(rs1.getString("ITEM_SER"));
							itemCode = checkNull(rs1.getString("ITEM_CODE"));
							unit = checkNull(rs1.getString("UNIT"));
							ruleCode = checkNull(rs1.getString("RULE_CODE"));
							stanCode = checkNull(rs1.getString("STAN_CODE"));
							
							if("ES3R3".equalsIgnoreCase(balGroup)){
								stanCode1 = checkNull(rs1.getString("STAN_CODE1"));
								stanCode2 = checkNull(rs1.getString("STAN_CODE2"));
								shiftCredPair=custCode+":"+itemCode+":"+stanCode;
								String shiftCredPair11=custCode+":"+itemCode+":"+stanCode1;
								System.out.println("shiftCredPair==>"+shiftCredPair);
								System.out.println("shiftCredPair==>"+shiftCredPair11);
								if(!shiftCredList.contains(shiftCredPair))
								{
									shiftCredList.add(shiftCredPair);
								}
							}
							
							
							
							cyslsSecQty = rs1.getDouble("CYSLS_SEC_QTY")* ( - 1 );// sales ->Sec curr sale
							cyslsSecVal = rs1.getDouble("CYSLS_SEC_VAL")* ( - 1 );// sales value->Sec curr sale value
							lyslsSecQty = rs1.getDouble("LYSLS_SEC_QTY")* ( - 1 );// lyslsSalesQty -> last year Sec sale
							lyslsSecVal = rs1.getDouble("LYSLS_SEC_VAL")* ( - 1 );// lyslsSalesVal-> last year Sec sales value
							
							//terr code calculation
							
							String terrSql = "SELECT      ha.level_code__parent   AS terr_cd FROM     hierarchy   ha,     hierarchy   hb,     hierarchy   hc,     hierarchy   hd,     hierarchy   hf,     station     hg,     hierarchy   hh WHERE     ha.version_id = hb.version_id     AND hb.version_id = hc.version_id     AND hc.version_id = hd.version_id     AND hd.version_id = hf.version_id     AND hf.version_id = hh.version_id     AND hf.level_code__parent = hh.level_code     AND hd.level_code__parent = hf.level_code     AND hc.level_code__parent = hd.level_code     AND hb.level_code__parent = hc.level_code     AND ha.level_code__parent = hb.level_code     AND ha.stan_code = hg.stan_code     AND ha.version_id = ?   AND HA.TABLE_NO  = ?     AND HA.STAN_CODE  >= '00'     AND HA.STAN_CODE  <= 'ZZ'     AND  HA.LEVEL_NO = 5      AND HA.VALID_UPTO >= SYSDATE     AND HA.LEVEL_CODE__PARENT  >= '00'     AND HA.LEVEL_CODE__PARENT  < = 'ZZ'     and HA.stan_code= ? ";
							pstmt2 = conn.prepareStatement(terrSql);
							pstmt2.setString(1, versionId);
							pstmt2.setString(2, itemSer);
							pstmt2.setString(3, stanCode);
							rs2 = pstmt2.executeQuery();
							if (rs2.next()) {
								terrCode = checkNull(rs2.getString("terr_cd")).trim();
								System.out.println("terrCode >>> :" + terrCode);
							}
							rs2.close();
							rs2 = null;
							pstmt2.close();
							pstmt2 = null;
							
							
							source = checkNull(rs1.getString("SOURCE"));
							remarks = checkNull(rs1.getString("REMARKS"));
							udfStr1 = checkNull(rs1.getString("UDF_STR1"));
							udfStr2 = checkNull(rs1.getString("UDF_STR2"));
							udfStr3 = checkNull(rs1.getString("UDF_STR3"));
							
							double cyslsPriQty = 0, cyslsPriVal = 0, lyslsPriQty = 0, lyslsPriVal = 0;
							double cyslsPriQtyOld = 0, cyslsPriValOld = 0, lyslsPriQtyOld = 0, lyslsPriValOld = 0;
							Double closeQty=0.0,closeVal=0.0;
							
							if ("ES3R5".equalsIgnoreCase(ruleCode) || "ES3R6".equalsIgnoreCase(ruleCode)){
								
								String sql66="select sum(net_sales_qty) as net_sales_qty,sum(net_sales_val) as net_sales_val,sum(lycm_sales_qty) as lycm_sales_qty,sum(lycm_sales_val) as lycm_sales_val  from dwh_sales_fact where prd_code= ? and item_code= ? and cust_code= ?  and stan_code= ? and item_ser= ? ";
								pstmt2 = connDWH.prepareStatement(sql66);
								pstmt2.setString(1, prdCode);
								pstmt2.setString(2, itemCode);
								pstmt2.setString(3, custCode);
								pstmt2.setString(4, stanCode);
								pstmt2.setString(5, itemSer);
								rs4 = pstmt2.executeQuery();
								while (rs4.next()) {
									cyslsPriQty = rs4.getDouble("net_sales_qty");// netSalesQty-> curr year pri sale
									cyslsPriVal = rs4.getDouble("net_sales_val");// netSalesVal->curr year pri value 
									lyslsPriQty = rs4.getDouble("lycm_sales_qty");// lycmSalesQty -> last year pri sale
									lyslsPriVal = rs4.getDouble("lycm_sales_val"); // lycmSalesVal -> last year pri sale value
								}
								rs4.close();
								rs4 = null;
								pstmt2.close();
								pstmt2 = null;
								
							}
							
							
							
							
							String sql6="SELECT  SUM(TRANSIT_QTY+TRANSIT_QTY__REPL+CL_STOCK+TRANSIT_QTY__FREE) as close_qty FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ? and stan_code= ? ";
							PreparedStatement ps6 = conn.prepareStatement(sql6);
							ps6.setString(1, prdCode);
							ps6.setString(2, itemCode);
							ps6.setString(3, custCode);
							ps6.setString(4, itemSerSource);
							ps6.setString(5, stanCode);
							rs6 = ps6.executeQuery();
							while (rs6.next()) {
								closeQty = rs6.getDouble("close_qty");// netSalesQty-> curr year pri sale
							}
							rs6.close();
							rs6 = null;
							ps6.close();
							ps6 = null;
							
							if(closeQty==0 && "ES3R3".equalsIgnoreCase(balGroup)){
								
								String sql60="SELECT  SUM(TRANSIT_QTY+TRANSIT_QTY__REPL+CL_STOCK+TRANSIT_QTY__FREE) as close_qty FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ? and stan_code= ? ";
								PreparedStatement ps60 = conn.prepareStatement(sql60);
								ps60.setString(1, prdCode);
								ps60.setString(2, itemCode);
								ps60.setString(3, custCode);
								ps60.setString(4, itemSerSource);
								ps60.setString(5, stanCode2);
								rs6 = ps60.executeQuery();
								while (rs6.next()) {
									closeQty = rs6.getDouble("close_qty");// netSalesQty-> curr year pri sale
								}
								rs6.close();
								rs6 = null;
								ps60.close();
								ps60 = null;
								
							}
							
							String sql7="SELECT  SUM(TRANSIT_BILL_VAL+TRANSIT_REPL_VAL+CL_VALUE + TRANSIT_FREE_VAL) as close_val FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ?  and stan_code= ? ";
							PreparedStatement ps7 = conn.prepareStatement(sql7);
							ps7.setString(1, prdCode);
							ps7.setString(2, itemCode);
							ps7.setString(3, custCode);
							ps7.setString(4, itemSerSource);
							ps7.setString(5, stanCode);
							rs7 = ps7.executeQuery();
							while (rs7.next()) {
								closeVal = rs7.getDouble("close_val");// netSalesQty-> curr year pri sale
							}
							rs7.close();
							rs7 = null;
							ps7.close();
							ps7 = null;
							
							if(closeVal==0 && "ES3R3".equalsIgnoreCase(balGroup)){
								
								String sql60="SELECT  SUM(TRANSIT_BILL_VAL+TRANSIT_REPL_VAL+CL_VALUE + TRANSIT_FREE_VAL) as close_val FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ?  and stan_code= ? ";
								PreparedStatement ps60 = conn.prepareStatement(sql60);
								ps60.setString(1, prdCode);
								ps60.setString(2, itemCode);
								ps60.setString(3, custCode);
								ps60.setString(4, itemSerSource);
								ps60.setString(5, stanCode2);
								rs6 = ps60.executeQuery();
								while (rs6.next()) {
									closeVal = rs6.getDouble("close_val");// netSalesQty-> curr year pri sale
								}
								rs6.close();
								rs6 = null;
								ps60.close();
								ps60 = null;
								
							}
							
							// Added To Bean
							SalesConsolidateDetail = new SalesConsolidateDetail();
							SalesConsolidateDetail.setRuleCode(ruleCode);
							SalesConsolidateDetail.setPrdCode(prdCode);
							SalesConsolidateDetail.setPrdCodeFrom(prdCodeFrom);
							SalesConsolidateDetail.setPrdCodeTo(prdCodeTo);
							SalesConsolidateDetail.setCustCode(custCode);
							SalesConsolidateDetail.setItemCode(itemCode);
							SalesConsolidateDetail.setItemSer(itemSer);
							SalesConsolidateDetail.setUnit(unit);
							SalesConsolidateDetail.setStanCode(stanCode);
							System.out.println("Ketan ruleCode==>"+ruleCode);
							System.out.println("Ketan balGroup==>"+balGroup);

							 if("ES3R3".equalsIgnoreCase(ruleCode) || "ES3R2".equalsIgnoreCase(ruleCode) || "ES3R1".equalsIgnoreCase(ruleCode)){
								SalesConsolidateDetail.setCyslsSecQty(cyslsSecQty);
								SalesConsolidateDetail.setCyslsSecVal(cyslsSecVal);
								SalesConsolidateDetail.setLyslsSecQty(lyslsSecQty);
								SalesConsolidateDetail.setLyslsSecVal(lyslsSecVal);
							}
								 if("ES3R5".equalsIgnoreCase(ruleCode) || "ES3R6".equalsIgnoreCase(ruleCode)){
								SalesConsolidateDetail.setCyslsSecQty(cyslsPriQty);
								SalesConsolidateDetail.setCyslsSecVal(cyslsPriVal);
								SalesConsolidateDetail.setLyslsSecQty(lyslsPriQty);
								SalesConsolidateDetail.setLyslsSecVal(lyslsPriVal);
							}
							
							SalesConsolidateDetail.setCyslsPriQty(cyslsPriQtyOld);
							SalesConsolidateDetail.setCyslsPriVal(cyslsPriValOld);
							SalesConsolidateDetail.setLyslsPriQty(lyslsPriQtyOld);
							SalesConsolidateDetail.setLyslsPriVal(lyslsPriValOld);
								System.out.println("In Ketan==>"+balGroup);
								if ("ES3R1".equalsIgnoreCase(balGroup) ||  "ES3R2".equalsIgnoreCase(balGroup) ||  "ES3R5".equalsIgnoreCase(balGroup) ||  "ES3R6".equalsIgnoreCase(balGroup)) {
									Double closeQtynew=0.0,closeValnew=0.0;
									closeQtynew=closeQty * (-1);
									closeValnew=closeVal * (-1);
									
									//SalesConsolidateDetail.setUdfStr1(closeQtynew.toString());
									//SalesConsolidateDetail.setUdfStr2(closeValnew.toString());
									
									SalesConsolidateDetail.setClosingQty(closeQtynew);
									SalesConsolidateDetail.setClosingVal(closeValnew);
									
								}else if("ES3R3".equalsIgnoreCase(balGroup)){
									if(stanCode.equalsIgnoreCase(stanCode1)){
										/*SalesConsolidateDetail.setUdfStr1(closeQty.toString());
										SalesConsolidateDetail.setUdfStr2(closeVal.toString());*/
										SalesConsolidateDetail.setClosingQty(closeQty);
										SalesConsolidateDetail.setClosingVal(closeVal);
									}else{
										Double closeQtynew=0.0,closeValnew=0.0;
										closeQtynew=closeQty * (-1);
										closeValnew=closeVal * (-1);
										/*SalesConsolidateDetail.setUdfStr1(closeQtynew.toString());
										SalesConsolidateDetail.setUdfStr2(closeValnew.toString());*/
										SalesConsolidateDetail.setClosingQty(closeQtynew);
										SalesConsolidateDetail.setClosingVal(closeValnew);
									}
									
								}else if("ES3R4".equalsIgnoreCase(balGroup)){
									if(!itemSer.equalsIgnoreCase(itemSerSource)){
										/*SalesConsolidateDetail.setUdfStr1(closeQty.toString());
										SalesConsolidateDetail.setUdfStr2(closeVal.toString());*/
										SalesConsolidateDetail.setClosingQty(closeQty);
										SalesConsolidateDetail.setClosingVal(closeVal);
									}else{
										Double closeQtynew=0.0,closeValnew=0.0;
										/*SalesConsolidateDetail.setUdfStr1(closeQtynew.toString());
										SalesConsolidateDetail.setUdfStr2(closeValnew.toString());*/
										SalesConsolidateDetail.setClosingQty(closeQtynew);
										SalesConsolidateDetail.setClosingVal(closeValnew);
									}
									
								}
								else{
									System.out.println("In Rule 8 or 7==>"+balGroup);
									Double closeQtynew=0.0,closeValnew=0.0;
									/*SalesConsolidateDetail.setUdfStr1(closeQtynew.toString());
									SalesConsolidateDetail.setUdfStr2(closeValnew.toString());*/
									SalesConsolidateDetail.setClosingQty(closeQtynew);
									SalesConsolidateDetail.setClosingVal(closeValnew);
								}
							
							SalesConsolidateDetail.setUdfStr3(udfStr3);
							SalesConsolidateDetail.setTerrCode(terrCode);
							SalesConsolidateDetail.setVersionId(versionId);
							SalesConsolidateDetail.setAcctPrd(acctPrd);
							SalesConsolidateDetail.setSource(source);
							int cnt1 =0;
								String sql55="select count(*) from sales_cons_rulewise where item_ser = ? and cal_month = ? AND item_code = ? AND cust_code = ? and stan_code= ? AND rule_code= ? ";
								PreparedStatement ps = conn.prepareStatement(sql55);
								ps.setString(1, itemSer);
								ps.setString(2, prdCode);
								ps.setString(3, itemCode);
								ps.setString(4, custCode);
								ps.setString(5, stanCode);
								ps.setString(6, ruleCode);
								rs0 = ps.executeQuery();
								if (rs0.next()) {
									cnt1  = rs0.getInt(1);
								}
								rs0.close();
								rs0 = null;
								ps.close();
								ps = null;
							
							if(cnt1==0){
								
								errString = insertToPriSecSalesConsolidation(FileName, conn, xtraParams, sysDate,
										lastYrPrdCode, SalesConsolidateDetail);
							}
							
							
							if("ES3R5".equalsIgnoreCase(balGroup) || "ES3R6".equalsIgnoreCase(balGroup)){
								

								PreparedStatement ps77=null;
								ResultSet rs77 = null;
								int cnt2 =0;
								System.out.println("cnt2 start==>"+cnt2);
								String sql555="select count(*) from sales_cons_rulewise where item_ser = ? and cal_month = ? AND item_code = ? AND cust_code = ?  AND rule_code= ? ";
								ps77 = conn.prepareStatement(sql555);
								ps77.setString(1, itemSer);
								ps77.setString(2, prdCode);
								ps77.setString(3, itemCode);
								ps77.setString(4, custCode);
								//ps77.setString(5, stanCode);
								ps77.setString(5, "ADJCR");
								rs77 = ps77.executeQuery();
								if (rs77.next()) {
									cnt2  = rs77.getInt(1);
								}
								System.out.println("cnt2==>"+cnt2);
								rs77.close();
								rs77 = null;
								ps77.close();
								ps77 = null;
							
							if(cnt2 > 0){
								
								sql1 = "DELETE FROM SALES_CONS_RULEWISE WHERE cal_month = ? AND ITEM_SER=?  and item_code = ? AND cust_code = ?  AND rule_code= ? ";

								ps77 = conn.prepareStatement(sql1);
								ps77.setString(1, prdCode);
								ps77.setString(2, itemSer);
								ps77.setString(3, itemCode);
								ps77.setString(4, custCode);
								//ps77.setString(5, stanCode);
								ps77.setString(5, "ADJCR");
								cnt = ps77.executeUpdate();
								System.out.println("Delete count in adjcr>>" + cnt);
								ps77.close();
								ps77 = null;
								System.out.println("Delete count adjcr>>" + cnt);
							}
							

							
							}
							
							
							

						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}
					
					if ("ES3R4".equalsIgnoreCase(balGroup)) {
						
						System.out.println("IN KETAN RULE 4");
						
						connection = con.getConnectDB("DWH");
						System.out.println("connection===>" + connection);
						
						String sql555="SELECT  item_code,cust_code,stan_code FROM   adjust_sales_credit WHERE   prd_code = ?  AND item_ser = ?";
						PreparedStatement ps11 = connection.prepareStatement(sql555);
						ps11.setString(1, prdCodeFrom);
						ps11.setString(2, itemSer);
						rs00 = ps11.executeQuery();
						while (rs00.next()) {
							itemCode = checkNull(rs00.getString("item_code"));
							custCode = checkNull(rs00.getString("cust_code"));
							stanCode = checkNull(rs00.getString("stan_code"));
							adjSalesPair=custCode+":"+itemCode+":"+stanCode;
							if(!adjSalesList.contains(adjSalesPair) )
							{
								adjSalesList.add(adjSalesPair);
							}
							
						}
						System.out.println("ADJ size==>"+adjSalesList.size());
						rs00.close();
						rs00 = null;
						ps11.close();
						ps11 = null;
						if (connection != null) {
							connection.close();
							connection = null;
						}
						
						
						period = Integer.parseInt(prdCodeFrom);
						period = period - 100;
						System.out.println("period :::: "+period);
						lastYrPrdCode = period+"";
						System.out.println("lastYrPrdCode :::: "+lastYrPrdCode);
						
						connection = con.getConnectDB("DWH");
						System.out.println("connection===>" + connection);
						
						String sql5555="SELECT  item_code,cust_code,stan_code FROM   adjust_sales_credit WHERE   prd_code = ?  AND item_ser = ?";
						PreparedStatement ps111 = connection.prepareStatement(sql5555);
						ps111.setString(1, lastYrPrdCode);
						ps111.setString(2, itemSer);
						rs00 = ps111.executeQuery();
						while (rs00.next()) {
							itemCode = checkNull(rs00.getString("item_code"));
							custCode = checkNull(rs00.getString("cust_code"));
							stanCode = checkNull(rs00.getString("stan_code"));
							adjSalesPair=custCode+":"+itemCode+":"+stanCode;
							if(!adjSalesList.contains(adjSalesPair))
							{
								adjSalesList.add(adjSalesPair);
							}
							
						}
						System.out.println("ADJ size final==>"+adjSalesList.size());
						rs00.close();
						rs00 = null;
						ps111.close();
						ps111 = null;
						
						if (connection != null) {
							connection.close();
							connection = null;
						}
						
						for (Object object : shiftCredList) 
						{
								String finalPair= object.toString();
								if(adjSalesList.contains(finalPair))
								{
									adjSalesList.remove(finalPair);
								}
						}
						
						System.out.println("ADJ size final after rule 3==>"+adjSalesList.size());

						if(adjSalesList.size()>0)
						{  
							for (Object object : adjSalesList) 
						{
								String finalPair= object.toString();
								finalPairArray= finalPair.split(":");
								finalCustCode=finalPairArray[0];
								finalItemCode=finalPairArray[1];
								finalStanCode=finalPairArray[2];
								System.out.println("New changed1==>"+finalCustCode);
								System.out.println("New changed2==>"+finalItemCode);
								System.out.println("New changed3==>"+finalStanCode);
								ArrayList<String>stanList=new ArrayList<String>();
							prdCode = prdCodeFrom;
							String unitSql = "select unit from item where item_code= ? ";
							pstmt2 = conn.prepareStatement(unitSql);
							pstmt2.setString(1, finalItemCode);
							rs2 = pstmt2.executeQuery();
							if (rs2.next()) {
								unit = checkNull(rs2.getString("unit"));
								System.out.println(unit);
							}
							rs2.close();
							rs2 = null;
							pstmt2.close();
							pstmt2 = null;
							
							ruleCode = "ADJCR";
									
									cyslsSecQty = 0;// sales ->Sec curr sale
									cyslsSecVal = 0;// sales value->Sec curr sale value
									
									lyslsSecQty = 0;// lyslsSalesQty -> last year Sec sale
									lyslsSecVal = 0;// lyslsSalesVal-> last year Sec sales value
									
									
									String terrSql = "SELECT      ha.level_code__parent   AS terr_cd FROM     hierarchy   ha,     hierarchy   hb,     hierarchy   hc,     hierarchy   hd,     hierarchy   hf,     station     hg,     hierarchy   hh WHERE     ha.version_id = hb.version_id     AND hb.version_id = hc.version_id     AND hc.version_id = hd.version_id     AND hd.version_id = hf.version_id     AND hf.version_id = hh.version_id     AND hf.level_code__parent = hh.level_code     AND hd.level_code__parent = hf.level_code     AND hc.level_code__parent = hd.level_code     AND hb.level_code__parent = hc.level_code     AND ha.level_code__parent = hb.level_code     AND ha.stan_code = hg.stan_code     AND ha.version_id = ?   AND HA.TABLE_NO  = ?     AND HA.STAN_CODE  >= '00'     AND HA.STAN_CODE  <= 'ZZ'     AND  HA.LEVEL_NO = 5      AND HA.VALID_UPTO >= SYSDATE     AND HA.LEVEL_CODE__PARENT  >= '00'     AND HA.LEVEL_CODE__PARENT  < = 'ZZ'     and HA.stan_code= ? ";
									pstmt8 = conn.prepareStatement(terrSql);
									pstmt8.setString(1, versionId);
									pstmt8.setString(2, itemSer);
									pstmt8.setString(3, finalStanCode);
									rs8 = pstmt8.executeQuery();
									if (rs8.next()) {
										terrCode = checkNull(rs8.getString("terr_cd")).trim();
										System.out.println("terrCode >>> :" + terrCode);
									}
									rs8.close();
									rs8 = null;
									pstmt8.close();
									pstmt8 = null;
									
									source = "A";
									remarks = "";
									udfStr1 = "";
									udfStr2 = "";
									udfStr3 = "";
									
									double cyslsPriQty = 0, cyslsPriVal = 0, lyslsPriQty = 0, lyslsPriVal = 0;
									
									connection = con.getConnectDB("DWH");
									System.out.println("connection===>" + connection);
									
									
									double cyslsAdjQty = 0.0, cyslsAdjVal = 0.0;
									String sql4 = "SELECT sum(sales_rule.fls_qty)  AS cysls_sec_qty, sum(sales_rule.fls_value) AS cysls_sec_val FROM adjust_sales_credit sales_rule WHERE sales_rule.item_ser =? AND TRIM(sales_rule.cust_code) = ?  AND item_code = ? AND stan_code = ? AND prd_code = ?";
									pstmt4 = connection.prepareStatement(sql4);
									pstmt4.setString(1, itemSer);
									pstmt4.setString(2, finalCustCode);
									pstmt4.setString(3, finalItemCode);
									pstmt4.setString(4, finalStanCode);
									pstmt4.setString(5, prdCode);
									rs4 = pstmt4.executeQuery();
									if (rs4.next()) {
										cyslsAdjQty=rs4.getDouble("cysls_sec_qty");
										cyslsAdjVal=rs4.getDouble("cysls_sec_val");
									}
									rs4.close();
									rs4 = null;
									pstmt4.close();
									pstmt4 = null;
									
									if (connection != null) {
										connection.close();
										connection = null;
									}
									
									period = Integer.parseInt(prdCode);
									period = period - 100;
									System.out.println("period :::: "+period);
									lastYrPrdCode = period+"";
									System.out.println("lastYrPrdCode :::: "+lastYrPrdCode);
									
									double lyslsAdjQty = 0.0, lyslsAdjVal = 0.0;	
									
									connection = con.getConnectDB("DWH");
									System.out.println("connection===>" + connection);
									
									String sql44 = "SELECT sum(sales_rule.fls_qty)  AS cysls_sec_qty, sum(sales_rule.fls_value) AS cysls_sec_val FROM adjust_sales_credit sales_rule WHERE sales_rule.item_ser =? AND TRIM(sales_rule.cust_code) = ?  AND item_code = ? AND stan_code = ? AND prd_code = ?";
									pstmt4 = connection.prepareStatement(sql44);
									pstmt4.setString(1, itemSer);
									pstmt4.setString(2, finalCustCode);
									pstmt4.setString(3, finalItemCode);
									pstmt4.setString(4, finalStanCode);
									pstmt4.setString(5, lastYrPrdCode);
									rs4 = pstmt4.executeQuery();
									if (rs4.next()) {
										lyslsAdjQty=rs4.getDouble("cysls_sec_qty");
										lyslsAdjVal=rs4.getDouble("cysls_sec_val");
									}
									rs4.close();
									rs4 = null;
									pstmt4.close();
									pstmt4 = null;
									
									if (connection != null) {
										connection.close();
										connection = null;
									}
									
									
										
										SalesConsolidateDetail1 = new SalesConsolidateDetail();
										SalesConsolidateDetail1.setRuleCode("ADJCR");
										SalesConsolidateDetail1.setPrdCode(prdCode);
										SalesConsolidateDetail1.setPrdCodeFrom(prdCodeFrom);
										SalesConsolidateDetail1.setPrdCodeTo(prdCodeTo);
										SalesConsolidateDetail1.setCustCode(finalCustCode);
										SalesConsolidateDetail1.setItemCode(finalItemCode);
										SalesConsolidateDetail1.setItemSer(itemSer);
										SalesConsolidateDetail1.setUnit(unit);
										SalesConsolidateDetail1.setStanCode(finalStanCode);
										//27-12-21
										SalesConsolidateDetail1.setCyslsSecQty(cyslsAdjQty);
										SalesConsolidateDetail1.setCyslsSecVal(cyslsAdjVal);
										SalesConsolidateDetail1.setCyslsPriQty(0.0);
										SalesConsolidateDetail1.setCyslsPriVal(0.0);
										SalesConsolidateDetail1.setLyslsPriQty(0.0);
										SalesConsolidateDetail1.setLyslsPriVal(0.0);
										SalesConsolidateDetail1.setLyslsSecQty(lyslsAdjQty);
										SalesConsolidateDetail1.setLyslsSecVal(lyslsAdjVal);
										SalesConsolidateDetail1.setRemarks(remarks);
										/*SalesConsolidateDetail1.setUdfStr1("0.0");
										SalesConsolidateDetail1.setUdfStr2("0.0");*/
										SalesConsolidateDetail1.setClosingQty(0.0);
										SalesConsolidateDetail1.setClosingVal(0.0);
										SalesConsolidateDetail1.setUdfStr3(udfStr3);
										SalesConsolidateDetail1.setTerrCode(terrCode);
										SalesConsolidateDetail1.setVersionId(versionId);
										SalesConsolidateDetail1.setAcctPrd(acctPrd);
										SalesConsolidateDetail1.setSource("A");
										errString = insertToPriSecSalesConsolidation(FileName, conn, xtraParams, sysDate,
												lastYrPrdCode, SalesConsolidateDetail1);
										

						}
					}
						
						//continue for rule 4 data
						rs1 = pstmt1.executeQuery();
						while (rs1.next()) {
							System.out.println("inside while loop");
							prdCode = checkNull(rs1.getString("CAL_MONTH")); // as prd_code
							custCode = checkNull(rs1.getString("CUST_CODE"));//
							itemSer = checkNull(rs1.getString("ITEM_SER"));
							itemCode = checkNull(rs1.getString("ITEM_CODE"));
							unit = checkNull(rs1.getString("UNIT"));
							ruleCode = checkNull(rs1.getString("RULE_CODE"));
							stanCode = checkNull(rs1.getString("STAN_CODE"));
							
							cyslsSecQty = rs1.getDouble("CYSLS_SEC_QTY")* ( - 1 );// sales ->Sec curr sale
							cyslsSecVal = rs1.getDouble("CYSLS_SEC_VAL")* ( - 1 );// sales value->Sec curr sale value
							lyslsSecQty = rs1.getDouble("LYSLS_SEC_QTY")* ( - 1 );// lyslsSalesQty -> last year Sec sale
							lyslsSecVal = rs1.getDouble("LYSLS_SEC_VAL")* ( - 1 );// lyslsSalesVal-> last year Sec sales value
							
							
							String terrSql = "SELECT      ha.level_code__parent   AS terr_cd FROM     hierarchy   ha,     hierarchy   hb,     hierarchy   hc,     hierarchy   hd,     hierarchy   hf,     station     hg,     hierarchy   hh WHERE     ha.version_id = hb.version_id     AND hb.version_id = hc.version_id     AND hc.version_id = hd.version_id     AND hd.version_id = hf.version_id     AND hf.version_id = hh.version_id     AND hf.level_code__parent = hh.level_code     AND hd.level_code__parent = hf.level_code     AND hc.level_code__parent = hd.level_code     AND hb.level_code__parent = hc.level_code     AND ha.level_code__parent = hb.level_code     AND ha.stan_code = hg.stan_code     AND ha.version_id = ?   AND HA.TABLE_NO  = ?     AND HA.STAN_CODE  >= '00'     AND HA.STAN_CODE  <= 'ZZ'     AND  HA.LEVEL_NO = 5      AND HA.VALID_UPTO >= SYSDATE     AND HA.LEVEL_CODE__PARENT  >= '00'     AND HA.LEVEL_CODE__PARENT  < = 'ZZ'     and HA.stan_code= ? ";
							pstmt2 = conn.prepareStatement(terrSql);
							pstmt2.setString(1, versionId);
							pstmt2.setString(2, itemSer);
							pstmt2.setString(3, stanCode);
							rs2 = pstmt2.executeQuery();
							if (rs2.next()) {
								terrCode = checkNull(rs2.getString("terr_cd")).trim();
								System.out.println("terrCode >>> :" + terrCode);
							}
							rs2.close();
							rs2 = null;
							pstmt2.close();
							pstmt2 = null;
							
							
							source = checkNull(rs1.getString("SOURCE"));
							remarks = checkNull(rs1.getString("REMARKS"));
							udfStr1 = checkNull(rs1.getString("UDF_STR1"));
							udfStr2 = checkNull(rs1.getString("UDF_STR2"));
							udfStr3 = checkNull(rs1.getString("UDF_STR3"));
							
							double cyslsPriQty = 0, cyslsPriVal = 0, lyslsPriQty = 0, lyslsPriVal = 0;
							double cyslsPriQtyOld = 0, cyslsPriValOld = 0, lyslsPriQtyOld = 0, lyslsPriValOld = 0;
							Double closeQty=0.0,closeVal=0.0;
							
							
							
							String sql6="SELECT  SUM(TRANSIT_QTY+TRANSIT_QTY__REPL+CL_STOCK+TRANSIT_QTY__FREE) as close_qty FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ? and stan_code = ? ";
							PreparedStatement ps6 = conn.prepareStatement(sql6);
							ps6.setString(1, prdCode);
							ps6.setString(2, itemCode);
							ps6.setString(3, custCode);
							ps6.setString(4, itemSerSource);
							ps6.setString(5, stanCode);
							rs6 = ps6.executeQuery();
							while (rs6.next()) {
								closeQty = rs6.getDouble("close_qty");// netSalesQty-> curr year pri sale
							}
							
							String sql7="SELECT  SUM(TRANSIT_BILL_VAL+TRANSIT_REPL_VAL+CL_VALUE + TRANSIT_FREE_VAL) as close_val FROM  sales_consolidation WHERE prd_code=? and item_code = ? AND cust_code = ? and item_ser_new= ? and stan_code = ? ";
							PreparedStatement ps7 = conn.prepareStatement(sql7);
							ps7.setString(1, prdCode);
							ps7.setString(2, itemCode);
							ps7.setString(3, custCode);
							ps7.setString(4, itemSerSource);
							ps7.setString(5, stanCode);
							rs7 = ps7.executeQuery();
							while (rs7.next()) {
								closeVal = rs7.getDouble("close_val");// netSalesQty-> curr year pri sale
							}

							// Added To Bean
							SalesConsolidateDetail = new SalesConsolidateDetail();
							SalesConsolidateDetail.setRuleCode(ruleCode);
							SalesConsolidateDetail.setPrdCode(prdCode);
							SalesConsolidateDetail.setPrdCodeFrom(prdCodeFrom);
							SalesConsolidateDetail.setPrdCodeTo(prdCodeTo);
							SalesConsolidateDetail.setCustCode(custCode);
							SalesConsolidateDetail.setItemCode(itemCode);
							SalesConsolidateDetail.setItemSer(itemSer);
							SalesConsolidateDetail.setUnit(unit);
							SalesConsolidateDetail.setStanCode(stanCode);
							System.out.println("Ketan ruleCode==>"+ruleCode);
							System.out.println("Ketan balGroup==>"+balGroup);
							SalesConsolidateDetail.setCyslsSecQty(cyslsSecQty);
							SalesConsolidateDetail.setCyslsSecVal(cyslsSecVal);
							SalesConsolidateDetail.setLyslsSecQty(lyslsSecQty);
							SalesConsolidateDetail.setLyslsSecVal(lyslsSecVal);
							
							SalesConsolidateDetail.setCyslsPriQty(cyslsPriQtyOld);
							SalesConsolidateDetail.setCyslsPriVal(cyslsPriValOld);
							SalesConsolidateDetail.setLyslsPriQty(lyslsPriQtyOld);
							SalesConsolidateDetail.setLyslsPriVal(lyslsPriValOld);
							
							SalesConsolidateDetail.setRemarks(remarks);
							
								System.out.println("In Ketan==>"+balGroup);
									if(!itemSer.equalsIgnoreCase(itemSerSource)){
										/*SalesConsolidateDetail.setUdfStr1(closeQty.toString());
										SalesConsolidateDetail.setUdfStr2(closeVal.toString());*/
										SalesConsolidateDetail.setClosingQty(closeQty);
										SalesConsolidateDetail.setClosingVal(closeVal);
									}else{
										Double closeQtynew=0.0,closeValnew=0.0;
										/*SalesConsolidateDetail.setUdfStr1(closeQtynew.toString());
										SalesConsolidateDetail.setUdfStr2(closeValnew.toString());*/
										SalesConsolidateDetail.setClosingQty(closeQtynew);
										SalesConsolidateDetail.setClosingVal(closeValnew);
									}
									
							
							SalesConsolidateDetail.setUdfStr3(udfStr3);
							SalesConsolidateDetail.setTerrCode(terrCode);
							SalesConsolidateDetail.setVersionId(versionId);
							SalesConsolidateDetail.setAcctPrd(acctPrd);
							SalesConsolidateDetail.setSource(source);
							int cnt1 =0;
								String sql55="select count(*) from sales_cons_rulewise where item_ser = ? and cal_month = ? AND item_code = ? AND cust_code = ? and stan_code= ? AND rule_code= ? ";
								PreparedStatement ps = conn.prepareStatement(sql55);
								ps.setString(1, itemSer);
								ps.setString(2, prdCode);
								ps.setString(3, itemCode);
								ps.setString(4, custCode);
								ps.setString(5, stanCode);
								ps.setString(6, ruleCode);
								rs0 = ps.executeQuery();
								if (rs0.next()) {
									cnt1  = rs0.getInt(1);
								}
								rs0.close();
								rs0 = null;
								ps.close();
								ps = null;
							
							if(cnt1==0){
								
								errString = insertToPriSecSalesConsolidation(FileName, conn, xtraParams, sysDate,
										lastYrPrdCode, SalesConsolidateDetail);
							}
							
							
							rs6.close();
							rs6 = null;
							ps6.close();
							ps6 = null;
							rs7.close();
							rs7 = null;
							ps7.close();
							ps7 = null;
							

						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}

				}

			}
			System.out.println("errStringTest==>" + errString);
			
			if (rs != null) {
				rs.close();
				rs = null;

			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;

			}
			
			
			//added sales target cahnges
			
			String salesConsRrulewiseQuery1 = "select distinct item_code as item_code from sales_target where prd_code =?  and item_ser=?";
			
			String salesConsRrulewiseQuery11 = "select distinct level_code as terr_code from sales_target where prd_code =?  and item_ser=?";
			
			String salesConsRrulewiseQuery2 = "select distinct cal_month as cal_month from SALES_CONS_RULEWISE where cal_month between ? and ?  AND ITEM_SER = ? ";
			
			String salesTargetQuery1 = "select sum(quantity) as quantity, sum(amount) as amount from sales_target where item_ser=? and item_code=? and prd_code=? and level_code=? ";
			
			String salesTargetConInsertQuery ="insert into SALES_CONS_RULEWISE(TRAN_ID,TRAN_DATE,ACCT_PRD,CUST_CODE,CAL_MONTH,PRD_CODE_FROM,PRD_CODE_TO,"
					+ "TERR_CODE,VERSION_ID,SOURCE,ITEM_CODE,UNIT,ITEM_SER,STAN_CODE," + "CYSLS_SEC_QTY,CYSLS_SEC_VAL,"
					+ "LYSLS_SEC_QTY,LYSLS_SEC_VAL,CYSLS_PRI_QTY,CYSLS_PRI_VAL,LYSLS_PRI_QTY,LYSLS_PRI_VAL"
					+ ",REMARKS,TARGET_QTY,TARGET_VAL,UDF_STR3,RULE_CODE,"
					+ "ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM)"
					+ "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

			int totalRecord = 0;
			
			connection = con.getConnectDB("DWH");
			System.out.println("connection===>" + connection);
			
			
			pstmt = connection.prepareStatement(salesConsRrulewiseQuery1);
			pstmt.setString(1, prdCodeFrom);
			pstmt.setString(2, itemSer);
			rs = pstmt.executeQuery();
			PreparedStatement pstmt3 = conn.prepareStatement(salesTargetConInsertQuery);
			while (rs.next()) 
			{
				itemCode = checkNull(rs.getString("item_code"));
				
				pstmt1 = conn.prepareStatement(salesConsRrulewiseQuery2);
				pstmt1.setString(1, prdCodeFrom);
				pstmt1.setString(2, prdCodeTo);
				pstmt1.setString(3, itemSer);
				rs1 = pstmt1.executeQuery();
				
				while (rs1.next()) 
				{
					calMomnth = checkNull(rs1.getString("cal_month"));	
					
					pstmt4 = connection.prepareStatement(salesConsRrulewiseQuery11);
					pstmt4.setString(1, calMomnth);
					pstmt4.setString(2, itemSer);
					rs4 = pstmt4.executeQuery();
					while (rs4.next()) 
					{
						terrCode = checkNull(rs4.getString("terr_code"));	
						
					pstmt2 = connection.prepareStatement(salesTargetQuery1);
					pstmt2.setString(1,itemSer);
					pstmt2.setString(2, itemCode);
					pstmt2.setString(3, calMomnth);
					pstmt2.setString(4, terrCode);
					rs2 = pstmt2.executeQuery();
					while (rs2.next()) 
					{
						Double quantity = rs2.getDouble("quantity");
						Double amount = rs2.getDouble("amount");
						
						tranId = generateTranIDForSalesConsolidationProcess("sales_consolidation_rule", loginSiteCode,
								itemSerSource, conn);
						
						 pstmt3.setString(1, tranId);
						 pstmt3.setDate(2, sysDate);
						 pstmt3.setString(3, acctPrd);
						 pstmt3.setString(4, "XXXXXX");
						 pstmt3.setString(5, calMomnth);
						 pstmt3.setString(6, prdCodeFrom);
						 pstmt3.setString(7, prdCodeTo);
						 pstmt3.setString(8, terrCode);
						 pstmt3.setString(9, versionId);
						 pstmt3.setString(10, "T");
						 pstmt3.setString(11, itemCode);
						 pstmt3.setString(12, "");
						 pstmt3.setString(13, itemSerSource);
						 pstmt3.setString(14, "XXXXX");
						 pstmt3.setDouble(15, 0.0);
						 pstmt3.setDouble(16, 0.0);
						 pstmt3.setDouble(17, 0.0);
						 pstmt3.setDouble(18, 0.0);
						 pstmt3.setDouble(19, 0.0);
						 pstmt3.setDouble(20, 0.0);
						 pstmt3.setDouble(21, 0.0);
						 pstmt3.setDouble(22, 0.0);
						 pstmt3.setString(23, "");
						 pstmt3.setDouble(24, quantity);
						 pstmt3.setDouble(25, amount);
						 pstmt3.setString(26, "");
						 pstmt3.setString(27, "TARGT");
						 pstmt3.setDate(28, sysDate);
						 pstmt3.setString(29, chgUser);
						 pstmt3.setString(30, chgTerm);
						 pstmt3.setDate(31, sysDate);
						 pstmt3.setString(32, chgUser);
						 pstmt3.setString(33, chgTerm); 
						 
						 
						pstmt3.addBatch();
						System.out.println("INSERT INTO SALES_TARGET_CONSOLIDATION(item_ser ,item_code ,prd_code ,quantity ,amount )VALUES("+itemSer+","+itemCode+","+calMomnth+","+quantity+","+amount+")");
						totalRecord++;
					}
					rs2.close();
					rs2 = null;
					pstmt2.close();
					pstmt2 = null;
					
				}
					rs4.close();
					rs4 = null;
					pstmt4.close();
					pstmt4 = null;
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
			}
			
			if (connection != null) {
				connection.close();
				connection = null;
			}
			
			
			
			
			
			int[] results = pstmt3.executeBatch();
			System.out.println("results.length.."+results.length+"  totalRecord...."+totalRecord);
			if(results.length == totalRecord) {
					errString = "";
					System.out.println("Data inserted!!!");
					
					
					String terrSql = " SELECT     DISTINCT item_code FROM     es3_rule_hdr,     es3_rule_det,     sales_cons_rulewise sales_rule,     (         SELECT             MIN(fr_date) AS para_fr_dt,             MAX(to_date) AS para_to_dt         FROM             period         WHERE             code IN (                 ? ,             ?            )     ) WHERE     es3_rule_hdr.tran_id = es3_rule_det.tran_id     AND es3_rule_hdr.rule_code = 'ES3R1'     AND es3_rule_hdr.active = 'Y'     AND TRIM(sales_rule.item_code) = es3_rule_det.apply_on_from     AND sales_rule.rule_code = 'OPENG'     AND sales_rule.acct_prd = ?     AND sales_rule.cal_month BETWEEN ? AND ?     AND sales_rule.item_ser = ?     AND ( para_fr_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR para_to_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR ( para_fr_dt < es3_rule_det.valid_from                AND es3_rule_det.valid_to < para_to_dt ) )";
					pstmt88 = conn.prepareStatement(terrSql);
					pstmt88.setString(1, prdCodeFrom);
					pstmt88.setString(2, prdCodeFrom);
					pstmt88.setString(3, acctPrd);
					pstmt88.setString(4, prdCodeFrom);
					pstmt88.setString(5, prdCodeFrom);
					pstmt88.setString(6, itemSerSource);
					rs88 = pstmt88.executeQuery();
					while (rs88.next()) {
						String itemCodeUpdate = checkNull(rs88.getString("item_code")).trim();
						System.out.println("itemCodeUpdate >>> :" + itemCodeUpdate);
						
						
						
						String updateSql = "update sales_cons_rulewise set block_flag='Y' where item_code= ? and acct_prd= ? and cal_month= ? and item_ser= ?";
					
						System.out.println( "upd sql " + updateSql );
						pstmt77 = conn.prepareStatement( updateSql );
						pstmt77.setString( 1, itemCodeUpdate );
						pstmt77.setString( 2, acctPrd );
						pstmt77.setString(3, prdCodeFrom);
						pstmt77.setString( 4, itemSerSource );
						int chkupdt = pstmt77.executeUpdate();
						System.out.println("chkupdt==>"+ chkupdt);

						pstmt77.close();
						pstmt77 = null;
					}
					rs88.close();
					rs88 = null;
					pstmt88.close();
					pstmt88 = null;
					
					
					
					String blockdataSql = "SELECT     distinct (sales_rule.cust_code)     AS cust_code    FROM     es3_rule_hdr,     es3_rule_det,     sales_cons_rulewise sales_rule,     (         SELECT             MIN(fr_date) AS para_fr_dt,             MAX(to_date) AS para_to_dt         FROM             period         WHERE             code IN (       ? ,      ?     )     ) WHERE     es3_rule_hdr.tran_id = es3_rule_det.tran_id     AND es3_rule_hdr.rule_code = 'ES3R2'     AND es3_rule_hdr.active = 'Y'     AND TRIM(sales_rule.cust_code) = es3_rule_det.apply_on_from     AND sales_rule.rule_code = 'OPENG'     AND sales_rule.acct_prd = ?     AND sales_rule.cal_month BETWEEN ? AND ?     AND sales_rule.item_ser = ?     AND sales_rule.item_ser BETWEEN es3_rule_hdr.item_ser_from AND es3_rule_hdr.item_ser_to     AND ( para_fr_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR para_to_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR ( para_fr_dt < es3_rule_det.valid_from                AND es3_rule_det.valid_to < para_to_dt ) )";
					pstmt88 = conn.prepareStatement(blockdataSql);
					pstmt88.setString(1, prdCodeFrom);
					pstmt88.setString(2, prdCodeFrom);
					pstmt88.setString(3, acctPrd);
					pstmt88.setString(4, prdCodeFrom);
					pstmt88.setString(5, prdCodeFrom);
					pstmt88.setString(6, itemSerSource);
					rs88 = pstmt88.executeQuery();
					while (rs88.next()) {
						String custBlock = checkNull(rs88.getString("cust_code")).trim();
						System.out.println("itemCodeUpdate >>> :" + custBlock);
						
						String divisionSql = "SELECT       distinct ( sales_rule.item_ser )      AS item_ser     FROM     es3_rule_hdr,     es3_rule_det,     sales_cons_rulewise sales_rule,     (         SELECT             MIN(fr_date) AS para_fr_dt,             MAX(to_date) AS para_to_dt         FROM             period         WHERE             code IN (       ? ,    ?    )     ) WHERE     es3_rule_hdr.tran_id = es3_rule_det.tran_id     AND TRIM(es3_rule_hdr.rule_code) = 'ES3R4'     AND es3_rule_hdr.active = 'Y'     AND TRIM(sales_rule.item_code) = es3_rule_det.apply_on_from     AND sales_rule.rule_code = 'OPENG'     AND sales_rule.acct_prd = ?    AND sales_rule.cal_month BETWEEN ? AND ?     AND sales_rule.item_ser = ?     AND es3_rule_hdr.item_ser_from = ?     AND ( para_fr_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR para_to_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR ( para_fr_dt < es3_rule_det.valid_from                AND es3_rule_det.valid_to < para_to_dt ) ) UNION SELECT         distinct (es3_rule_hdr.item_ser_to)   AS item_ser FROM     es3_rule_hdr,     es3_rule_det,     sales_cons_rulewise sales_rule,     (         SELECT             MIN(fr_date) AS para_fr_dt,             MAX(to_date) AS para_to_dt         FROM             period         WHERE             code IN (       ? ,     ?   )     ) WHERE     es3_rule_hdr.tran_id = es3_rule_det.tran_id     AND TRIM(es3_rule_hdr.rule_code) = 'ES3R4'     AND es3_rule_hdr.active = 'Y'     AND TRIM(sales_rule.item_code) = es3_rule_det.apply_on_from     AND sales_rule.rule_code = 'OPENG'     AND sales_rule.acct_prd = ?     AND sales_rule.cal_month BETWEEN ? AND ?     AND sales_rule.item_ser = ?     AND es3_rule_hdr.item_ser_from = ?    AND ( para_fr_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR para_to_dt BETWEEN es3_rule_det.valid_from AND es3_rule_det.valid_to           OR ( para_fr_dt < es3_rule_det.valid_from                AND es3_rule_det.valid_to < para_to_dt ) )";
						pstmt1 = conn.prepareStatement(divisionSql);
						pstmt1.setString(1, prdCodeFrom);
						pstmt1.setString(2, prdCodeFrom);
						pstmt1.setString(3, acctPrd);
						pstmt1.setString(4, prdCodeFrom);
						pstmt1.setString(5, prdCodeFrom);
						pstmt1.setString(6, itemSerSource);
						pstmt1.setString(7, itemSerSource);
						pstmt1.setString(8, prdCodeFrom);
						pstmt1.setString(9, prdCodeFrom);
						pstmt1.setString(10, acctPrd);
						pstmt1.setString(11, prdCodeFrom);
						pstmt1.setString(12, prdCodeFrom);
						pstmt1.setString(13, itemSerSource);
						pstmt1.setString(14, itemSerSource);
						rs1 = pstmt1.executeQuery();
						while (rs1.next()) {
							String itemSerBlock = checkNull(rs1.getString("item_ser")).trim();
							System.out.println("itemSerBlock >>> :" + itemSerBlock);
							
							String insertSql = "select * from sales_cons_rulewise where cal_month=? and cust_code=? and rule_code='ES3R4' and item_ser= ? and (cysls_sec_val > 0 or lysls_sec_val > 0)";
							
							System.out.println( "upd sql " + insertSql );
							pstmt777 = conn.prepareStatement( insertSql );
							pstmt777.setString( 1, prdCodeFrom );
							pstmt777.setString( 2, custBlock );
							pstmt777.setString( 3, itemSerBlock );
							rs777 = pstmt777.executeQuery();
							while (rs777.next()) {
								
								chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
								chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
								loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
								System.out.println("@S@ inside insertToSalesConsolidation method");
								terrCode = "";
								terrDescr = "";
								// tranId=salesValueFormList.getTranId();
								String tranIdNew = generateTranIDForSalesConsolidationProcess("sales_consolidation_rule", loginSiteCode,
										itemSerSource, conn);
								
								sql1 = "insert into SALES_CONS_RULEWISE(TRAN_ID,TRAN_DATE,ACCT_PRD,CUST_CODE,CAL_MONTH,PRD_CODE_FROM,PRD_CODE_TO,"
										+ "TERR_CODE,VERSION_ID,SOURCE,ITEM_CODE,UNIT,ITEM_SER,STAN_CODE," + "CYSLS_SEC_QTY,CYSLS_SEC_VAL,"
										+ "LYSLS_SEC_QTY,LYSLS_SEC_VAL,CYSLS_PRI_QTY,CYSLS_PRI_VAL,LYSLS_PRI_QTY,LYSLS_PRI_VAL"
										+ ",REMARKS,CLOSING_QTY,CLOSING_VAL,UDF_STR3,RULE_CODE,"
										+ "ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM)"
										+ "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";// ,?,?,?)";//,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
								pstmt888 = conn.prepareStatement(sql1);
								pstmt888.setString(1, tranIdNew);
								pstmt888.setDate(2, sysDate);
								pstmt888.setString(3, checkNull(rs777.getString("ACCT_PRD")).trim());
								pstmt888.setString(4, checkNull(rs777.getString("CUST_CODE")).trim());
								pstmt888.setString(5, checkNull(rs777.getString("CAL_MONTH")).trim());
								pstmt888.setString(6, checkNull(rs777.getString("PRD_CODE_FROM")).trim());
								pstmt888.setString(7, checkNull(rs777.getString("PRD_CODE_TO")).trim());
								pstmt888.setString(8, checkNull(rs777.getString("TERR_CODE")).trim());
								pstmt888.setString(9, checkNull(rs777.getString("VERSION_ID")).trim());
								pstmt888.setString(10, checkNull(rs777.getString("SOURCE")).trim());
								pstmt888.setString(11, checkNull(rs777.getString("ITEM_CODE")).trim());
								pstmt888.setString(12, checkNull(rs777.getString("UNIT")).trim());
								pstmt888.setString(13, checkNull(rs777.getString("ITEM_SER")).trim());
								pstmt888.setString(14, checkNull(rs777.getString("STAN_CODE")).trim());
								pstmt888.setDouble(15, rs777.getDouble("CYSLS_SEC_QTY")*(-1));// Secondary Current Year Qty
								pstmt888.setDouble(16, rs777.getDouble("CYSLS_SEC_VAL")*(-1));// Secondary Current Year Value
								pstmt888.setDouble(17, rs777.getDouble("LYSLS_SEC_QTY")*(-1));// Secondary Last Year Qty
								pstmt888.setDouble(18, rs777.getDouble("LYSLS_SEC_VAL")*(-1));// Secondary Last Year Value
								pstmt888.setDouble(19, rs777.getDouble("CYSLS_PRI_QTY")*(-1));// Primary Current Year Qty
								pstmt888.setDouble(20, rs777.getDouble("CYSLS_PRI_VAL")*(-1));// Primary Current Year value
								pstmt888.setDouble(21, rs777.getDouble("LYSLS_PRI_QTY")*(-1));// Primary Last Year Qty
								pstmt888.setDouble(22, rs777.getDouble("LYSLS_PRI_VAL")*(-1));// Primary Last Year value
								pstmt888.setString(23, checkNull(rs777.getString("REMARKS")).trim());
								pstmt888.setDouble(24, rs777.getDouble("CLOSING_QTY")*(-1));
								pstmt888.setDouble(25, rs777.getDouble("CLOSING_VAL")*(-1));
								pstmt888.setString(26, checkNull(rs777.getString("UDF_STR3")).trim());
								pstmt888.setString(27, "ES3R2");
								pstmt888.setDate(28, sysDate);
								pstmt888.setString(29, chgUser);
								pstmt888.setString(30, chgTerm);
								pstmt888.setDate(31, sysDate);
								pstmt888.setString(32, chgUser);
								pstmt888.setString(33, chgTerm);
								updCnt = pstmt888.executeUpdate();
								if (updCnt > 0) {
									errString = "";
									System.out.println("Data inserted!!!");
									conn.commit();

								} else {
									System.out.println("Data insertion fail!!!");
									errString = itmDBAccessEJB.getErrorString("", "VTDATAFAIL", "", "", conn);
								}

								pstmt888.close();
								pstmt888 = null;
								
							}
							

							rs777.close();
							rs777 = null;
							pstmt777.close();
							pstmt777 = null;
							
						}
						
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
						
						
					}
					rs88.close();
					rs88 = null;
					pstmt88.close();
					pstmt88 = null;
					
					
					
					conn.commit();
					System.out.println("**Successfully inserted data into database***");
					if (pstmt3 != null) {
						pstmt3.close();
						pstmt3 = null;

					}
			}
			else 
			{
					System.out.println("Data insertion fail!!!");
					errString = itmDBAccessEJB.getErrorString("", "VTDATAFAIL", "", "", conn);
					if (pstmt3 != null) {
						pstmt3.close();
						pstmt3 = null;

					}
			}
			
			
			
			
		} catch (Exception e) {
			System.out.println("::::Exception::::" + this.getClass().getSimpleName() + ":::::" + e.getMessage());
			e.printStackTrace();
			errString = itmDBAccessEJB.getErrorString("", "VTDATAFAIL", "", "", conn);
			printLog(FileName, "Data Outer Execption", "Processing for Tran_Id :: | Status-| " + errString + "", conn);
			connBollen = true;
			throw new ITMException(e);
		} finally {
			try {

				if ((errString == null || errString.trim().length() == 0) && !connBollen) {
					System.out.println("Connection Commited");
					errString = itmDBAccessEJB.getErrorString("", "VTDATASUCC", "", "", conn);
					printLog(FileName, "Inside finally Commited",
							"Processing for Tran_Id :: | Status-| " + errString + "", conn);
					conn.commit();

				} else if (errString.equalsIgnoreCase("nodatafound")) {
					errString = itmDBAccessEJB.getErrorString("", "NODATAFND", "", "", conn);
					printLog(FileName, "Inside finally No data found",
							"Processing for Tran_Id :: | Status-| " + errString + "", conn);
				} else {
					errString = itmDBAccessEJB.getErrorString("", "VTDATAFAIL", "", "", conn);
					printLog(FileName, "Inside finally fail", "Processing for Tran_Id :: | Status-| " + errString + "",
							conn);
					conn.rollback();
				}
				if (conn != null) {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;

					}
					
					conn.close();

				}
				if (connection != null) {
					connection.close();

				}
				if (connDWH != null) {
					connDWH.close();
					

				}
				conn = null;
				connection = null;
				connDWH = null;
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		return errString;
	}

	// Data To Be inserted in New sales consolidation Table
	private String insertToPriSecSalesConsolidation(String fileName, Connection conn, String xtraParams, Date sysDate,
			String lastYrPrdCode, SalesConsolidateDetail salesConsolidateDetail) throws RemoteException, ITMException {
		String terrCode = "", terrDescr = "", tranId = "", errString = "";
		String chgTerm = "", chgUser = "", loginSiteCode = "";
		PreparedStatement pstmt11 = null;
		ResultSet rs1 = null;
		String sql1 = "";
		int period = 0, updCnt = 0, lineNo = 0;
		double lastYrsSale = 0.0, lastYrsSaleVal = 0.0;
		try {
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			System.out.println("@S@ inside insertToSalesConsolidation method");
			terrCode = "";
			terrDescr = "";
			// tranId=salesValueFormList.getTranId();
			tranId = generateTranIDForSalesConsolidationProcess("sales_consolidation_rule", loginSiteCode,
					salesConsolidateDetail.getItemSer(), conn);
			printLog(fileName, "Inside Insert",
					"Processing for Tran_Id :: <" + tranId + "> | Status-| " + errString + "", conn);

			sql1 = "insert into SALES_CONS_RULEWISE(TRAN_ID,TRAN_DATE,ACCT_PRD,CUST_CODE,CAL_MONTH,PRD_CODE_FROM,PRD_CODE_TO,"
					+ "TERR_CODE,VERSION_ID,SOURCE,ITEM_CODE,UNIT,ITEM_SER,STAN_CODE," + "CYSLS_SEC_QTY,CYSLS_SEC_VAL,"
					+ "LYSLS_SEC_QTY,LYSLS_SEC_VAL,CYSLS_PRI_QTY,CYSLS_PRI_VAL,LYSLS_PRI_QTY,LYSLS_PRI_VAL"
					+ ",REMARKS,CLOSING_QTY,CLOSING_VAL,UDF_STR3,RULE_CODE,"
					+ "ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM)"
					+ "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";// ,?,?,?)";//,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmt11 = conn.prepareStatement(sql1);
			pstmt11.setString(1, tranId);
			pstmt11.setDate(2, sysDate);
			pstmt11.setString(3, salesConsolidateDetail.getAcctPrd());
			pstmt11.setString(4, salesConsolidateDetail.getCustCode());
			pstmt11.setString(5, salesConsolidateDetail.getPrdCode());
			pstmt11.setString(6, salesConsolidateDetail.getPrdCodeFrom());
			pstmt11.setString(7, salesConsolidateDetail.getPrdCodeTo());
			pstmt11.setString(8, salesConsolidateDetail.getTerrCode());
			pstmt11.setString(9, salesConsolidateDetail.getVersionId());
			pstmt11.setString(10, salesConsolidateDetail.getSource());
			pstmt11.setString(11, salesConsolidateDetail.getItemCode());
			pstmt11.setString(12, salesConsolidateDetail.getUnit());
			pstmt11.setString(13, salesConsolidateDetail.getItemSer());
			pstmt11.setString(14, salesConsolidateDetail.getStanCode());
			pstmt11.setDouble(15, salesConsolidateDetail.getCyslsSecQty());// Secondary Current Year Qty
			pstmt11.setDouble(16, salesConsolidateDetail.getCyslsSecVal());// Secondary Current Year Value
			pstmt11.setDouble(17, salesConsolidateDetail.getLyslsSecQty());// Secondary Last Year Qty
			pstmt11.setDouble(18, salesConsolidateDetail.getLyslsSecVal());// Secondary Last Year Value
			pstmt11.setDouble(19, salesConsolidateDetail.getCyslsPriQty());// Primary Current Year Qty
			pstmt11.setDouble(20, salesConsolidateDetail.getCyslsPriVal());// Primary Current Year value
			pstmt11.setDouble(21, salesConsolidateDetail.getLyslsPriQty());// Primary Last Year Qty
			pstmt11.setDouble(22, salesConsolidateDetail.getLyslsPriVal());// Primary Last Year value
			pstmt11.setString(23, salesConsolidateDetail.getRemarks());
			pstmt11.setDouble(24, salesConsolidateDetail.getClosingQty());
			pstmt11.setDouble(25, salesConsolidateDetail.getClosingVal());
			pstmt11.setString(26, salesConsolidateDetail.getUdfStr3());
			pstmt11.setString(27, salesConsolidateDetail.getRuleCode());
			pstmt11.setDate(28, sysDate);
			pstmt11.setString(29, chgUser);
			pstmt11.setString(30, chgTerm);
			pstmt11.setDate(31, sysDate);
			pstmt11.setString(32, chgUser);
			pstmt11.setString(33, chgTerm);
			updCnt = pstmt11.executeUpdate();
			if (updCnt > 0) {
				errString = "";
				System.out.println("Data inserted!!!");
				conn.commit();
				printLog(fileName, "Data Insert Successs",
						"Processing for Tran_Id :: <" + tranId + "> | Status-| " + errString + "", conn);

			} else {
				System.out.println("Data insertion fail!!!");
				errString = itmDBAccessEJB.getErrorString("", "VTDATAFAIL", "", "", conn);
				printLog(fileName, "Data Insert Fail",
						"Processing for Tran_Id :: <" + tranId + "> | Status-| " + errString + "", conn);
			}

			pstmt11.close();
			pstmt11 = null;


		} catch (Exception e) {

			System.out.println("::::Exception::::" + this.getClass().getSimpleName() + ":::::" + e.getMessage());
			e.printStackTrace();
			errString = itmDBAccessEJB.getErrorString("", "VTDATAFAIL", "", "", conn);
			printLog(fileName, "Data Insert Fail Execption",
					"Processing for Tran_Id :: <" + tranId + "," + lineNo + "> | Status-| " + errString + "", conn);

		}
		return errString;
	}

	// Modified by santosh to get last year data D18CSUN007.end
	public String generateTranIDForSalesConsolidationProcess(String objName, String loginSiteCode, String itemSer,
			Connection conn) throws ITMException {
		String retString = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String keyString = "", refSer = "", sysDate = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try {
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			sysDate = sdf.format(new java.util.Date());
			System.out.println("SalesConsolidationProcess-ES3 :: objName =>" + objName);
			HashMap<String, String> transetupMap = new HashMap<String, String>();
			transetupMap = getTransetupMap("w_" + objName, conn);
			keyString = (String) transetupMap.get("key_string");
			refSer = (String) transetupMap.get("ref_ser");
			String xmlValues = "";
			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<TRAN_ID></TRAN_ID>";
			xmlValues = xmlValues + "<TRAN_DATE>" + sysDate + "</TRAN_DATE>";
			xmlValues = xmlValues + "<SITE_CODE>" + loginSiteCode + "</SITE_CODE>";
			xmlValues = xmlValues + "<ITEM_SER>" + itemSer + "</ITEM_SER>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues for Sales Consolidation :[" + xmlValues + "]");
			System.out.println("keyString>>>>" + keyString + ">>>refSer>>>" + refSer);
			TransIDGenerator tranIdGenerator = new TransIDGenerator(xmlValues, "SYSTEM", CommonConstants.DB_NAME);
			String tranIdGenerated = tranIdGenerator.generateTranSeqID(refSer, "tran_id", keyString, conn);
			System.out.println("tranIdGenerated for SalesConsolidationProcess-ES3 => " + tranIdGenerated);
			retString = tranIdGenerated;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return retString;
	}

	private HashMap<String, String> getTransetupMap(String winName, Connection conn) throws ITMException {
		String keyString = "";
		String refSer = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String, String> transetupMap = null;
		try {
			sql = "SELECT KEY_STRING, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, winName);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				keyString = rs.getString("KEY_STRING");
				refSer = rs.getString("REF_SER");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			System.out.println("ITWizardBean :: getKeyString :: keyString =>" + keyString);
			System.out.println("ITWizardBean :: getKeyString :: refSer =>" + refSer);
			transetupMap = new HashMap<String, String>();
			transetupMap.put("key_string", keyString);
			transetupMap.put("ref_ser", refSer);

		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return transetupMap;
	}

	private String checkNull(String input) {
		return input == null ? "" : input.trim();
	}

	// Modified by santosh
	public static class SalesConsolidateDetail {
		public String prdCode = null;
		public String prdCodeFrom = null;
		public String prdCodeTo = null;
		public String custCode = null;
		public String itemSer = null;
		public String itemCode = null;
		public String unit = null;
		public double cyslsSecQty = 0.0;
		public double cyslsSecVal = 0.0;
		public String terrCode = null;
		public String versionId = null;
		public String source = null;
		public Double cyslsPriQty = 0.0;
		public Double cyslsPriVal = 0.0;
		public Double lyslsPriQty = 0.0;
		public Double lyslsPriVal = 0.0;
		public Double lyslsSecQty = 0.0;
		public Double lyslsSecVal = 0.0;
		public Double closingQty = 0.0;
		public Double closingVal = 0.0;
		public Double targetQty = 0.0;
		public Double targetVal = 0.0;
		public String remarks = null;
		public String udfStr1 = null;
		public String udfStr2 = null;
		public String udfStr3 = null;
		public String tranId = null;
		public String ruleCode = null;
		public String acctPrd = null;
		public String stanCode = null;
		public String blockFlag = null;

		public String getPrdCode() {
			return prdCode;
		}

		public void setPrdCode(String prdCode) {
			this.prdCode = prdCode;
		}

		public String getPrdCodeFrom() {
			return prdCodeFrom;
		}

		public void setPrdCodeFrom(String prdCodeFrom) {
			this.prdCodeFrom = prdCodeFrom;
		}

		public String getPrdCodeTo() {
			return prdCodeTo;
		}

		public void setPrdCodeTo(String prdCodeTo) {
			this.prdCodeTo = prdCodeTo;
		}

		public String getCustCode() {
			return custCode;
		}

		public void setCustCode(String custCode) {
			this.custCode = custCode;
		}

		public String getItemSer() {
			return itemSer;
		}

		public void setItemSer(String itemSer) {
			this.itemSer = itemSer;
		}

		public String getItemCode() {
			return itemCode;
		}

		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}

		public String getUnit() {
			return unit;
		}

		public void setUnit(String unit) {
			this.unit = unit;
		}

		public double getCyslsSecQty() {
			return cyslsSecQty;
		}

		public void setCyslsSecQty(double cyslsSecQty) {
			this.cyslsSecQty = cyslsSecQty;
		}

		public double getCyslsSecVal() {
			return cyslsSecVal;
		}

		public void setCyslsSecVal(double cyslsSecVal) {
			this.cyslsSecVal = cyslsSecVal;
		}

		public String getTerrCode() {
			return terrCode;
		}

		public void setTerrCode(String terrCode) {
			this.terrCode = terrCode;
		}

		public String getVersionId() {
			return versionId;
		}

		public void setVersionId(String versionId) {
			this.versionId = versionId;
		}

		public String getSource() {
			return source;
		}

		public void setSource(String source) {
			this.source = source;
		}

		public Double getCyslsPriQty() {
			return cyslsPriQty;
		}

		public void setCyslsPriQty(Double cyslsPriQty) {
			this.cyslsPriQty = cyslsPriQty;
		}

		public Double getCyslsPriVal() {
			return cyslsPriVal;
		}

		public void setCyslsPriVal(Double cyslsPriVal) {
			this.cyslsPriVal = cyslsPriVal;
		}

		public Double getLyslsPriQty() {
			return lyslsPriQty;
		}

		public void setLyslsPriQty(Double lyslsPriQty) {
			this.lyslsPriQty = lyslsPriQty;
		}

		public Double getLyslsPriVal() {
			return lyslsPriVal;
		}

		public void setLyslsPriVal(Double lyslsPriVal) {
			this.lyslsPriVal = lyslsPriVal;
		}

		public Double getLyslsSecQty() {
			return lyslsSecQty;
		}

		public void setLyslsSecQty(Double lyslsSecQty) {
			this.lyslsSecQty = lyslsSecQty;
		}

		public Double getLyslsSecVal() {
			return lyslsSecVal;
		}

		public void setLyslsSecVal(Double lyslsSecVal) {
			this.lyslsSecVal = lyslsSecVal;
		}
		
		public Double getClosingQty() {
			return closingQty;
		}

		public void setClosingQty(Double closingQty) {
			this.closingQty = closingQty;
		}

		public Double getClosingVal() {
			return closingVal;
		}

		public void setClosingVal(Double closingVal) {
			this.closingVal = closingVal;
		}
		
		public Double getTargetQty() {
			return targetQty;
		}

		public void setTargetQty(Double targetQty) {
			this.targetQty = targetQty;
		}

		public Double getTargetVal() {
			return targetVal;
		}

		public void setTargetVal(Double targetVal) {
			this.targetVal = targetVal;
		}
		
		

		public String getRemarks() {
			return remarks;
		}

		public void setRemarks(String remarks) {
			this.remarks = remarks;
		}

		public String getUdfStr1() {
			return udfStr1;
		}

		public void setUdfStr1(String udfStr1) {
			this.udfStr1 = udfStr1;
		}

		public String getUdfStr2() {
			return udfStr2;
		}

		public void setUdfStr2(String udfStr2) {
			this.udfStr2 = udfStr2;
		}

		public String getUdfStr3() {
			return udfStr3;
		}

		public void setUdfStr3(String udfStr3) {
			this.udfStr3 = udfStr3;
		}

		public String getTranId() {
			return tranId;
		}

		public void setTranId(String tranId) {
			this.tranId = tranId;
		}

		public String getRuleCode() {
			return ruleCode;
		}

		public void setRuleCode(String ruleCode) {
			this.ruleCode = ruleCode;
		}

		public String getAcctPrd() {
			return acctPrd;
		}

		public void setAcctPrd(String acctPrd) {
			this.acctPrd = acctPrd;
		}

		public String getStanCode() {
			return stanCode;
		}

		public void setStanCode(String stanCode) {
			this.stanCode = stanCode;
		}
		
		public String getBlockFlag() {
			return blockFlag;
		}

		public void setBlockFlag(String blockFlag) {
			this.blockFlag = blockFlag;
		}

		@Override
		public String toString() {
			return "SalesConsolidateDetail [prdCode=" + prdCode + ", prdCodeFrom=" + prdCodeFrom + ", prdCodeTo="
					+ prdCodeTo + ", custCode=" + custCode + ", itemSer=" + itemSer + ", itemCode=" + itemCode
					+ ", unit=" + unit + ", cyslsSecQty=" + cyslsSecQty + ", cyslsSecVal=" + cyslsSecVal + ", terrCode="
					+ terrCode + ", versionId=" + versionId + ", source=" + source + ", cyslsPriQty=" + cyslsPriQty
					+ ", cyslsPriVal=" + cyslsPriVal + ", lyslsPriQty=" + lyslsPriQty + ", lyslsPriVal=" + lyslsPriVal
					+ ", lyslsSecQty=" + lyslsSecQty + ", lyslsSecVal=" + lyslsSecVal + ", remarks=" + remarks
					+ ", udfStr1=" + udfStr1 + ", udfStr2=" + udfStr2 + ", udfStr3=" + udfStr3 + ", tranId=" + tranId
					+ ", ruleCode=" + ruleCode + ", acctPrd=" + acctPrd + ", stanCode=" + stanCode + "]";
		}

	}

	private void printLog(String fileName, String title, String msg, Connection conn) {
		String logFile = "";
		String logDir = "", filePath = "";
		File logFileDir = null;
		FileWriter fileWriter = null;

		try {

			Calendar calendar = Calendar.getInstance();
			calendar.setTime(new java.sql.Timestamp(System.currentTimeMillis()));
			String logFileName = "";
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			logFileName = fileName;

			ibase.webitm.ejb.fin.FinCommon finCommon = new ibase.webitm.ejb.fin.FinCommon();
			System.out.println("@S@ inside printLog logFileName[" + logFileName + "]");
			logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "salesConsRulewise";


			logFileDir = new File(logDir);

			if (!logFileDir.exists()) {
				logFileDir.mkdirs();
			}

			logFile = logDir + File.separator + logFileName + ".log";

			SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
			java.util.Date now = new java.util.Date();
			String strDate = sdfDate.format(now);

			fileWriter = new FileWriter(logFile, true);

			fileWriter.write("\r\n");
			fileWriter.write(strDate + " " + "INFO" + " " + "[" + title + "] : " + msg);
		} catch (Exception ex) {
			ex.printStackTrace();
			printLog(fileName, "STDOUT", "Inside Exception [getLog]>>" + ex.toString(), conn);
		} finally {
			try {
				if (fileWriter != null) {
					fileWriter.flush();
					fileWriter.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
