package ibase.webitm.ejb.fin.advfield;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.json.JSONObject;

public class AdvVouchCommon  extends ActionHandlerEJB {

	Connection conn = null;
	String sql = "";
	PreparedStatement pstmt = null;
	ResultSet rs;
	
	public AdvVouchCommon(){
		try {
			ConnDriver connDriver = new ConnDriver();
			//Comment By sanket J as request by Manoj sir on [21/06/2018]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
		} catch (Exception e) {
			// TODO: handle exception
		}
	}
	
	public Double getPrvOs(String sundry_code,String sundry_type)
	{
		System.out.println("Inside getPrvOs::::: sundry_code"+sundry_code+"sundry_type::"+sundry_type);
		String retString="";
		double prvAmt=0;
		JSONObject json=null;
		try
		{
			String sql="SELECT FN_PRV_OS(?,?) FROM DUAL";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, sundry_type); 
			pstmt.setString(2, sundry_code);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				prvAmt=rs.getDouble(1);
			}
			
			System.out.println("prvAmt:::::"+prvAmt);
						
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return prvAmt;
	}
	
	public String getAttachList(String tranId,String refSer)
	{
		StringBuffer valueXmlString = new StringBuffer();
		try{
			int domID=0;
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
		    valueXmlString.append( "A" ).append( "</editFlag>\r\n</Header>\r\n" ); 
		    
			String sql="SELECT DOC_CONTENTS.DOC_ID,DOC_NAME,DOC_TYPE,CHG_DATE,CHG_USER,ADD_DATE,ADD_USER,USER_ID__CHKOUT " +
					"FROM DOC_CONTENTS, DOC_TRANSACTION_LINK WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND REF_SER = ? " +
					"AND REF_ID = ? ORDER BY DOC_CONTENTS.DOC_ID";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refSer); 
			pstmt.setString(2, tranId);
			
			rs=pstmt.executeQuery();
			
			while(rs.next())
			{
				domID++;
				valueXmlString.append("<Detail1 domID='"+ domID +"' selected=\"N\">\r\n" );
				valueXmlString.append("<tran_id><![CDATA[").append(rs.getString("DOC_ID")).append("]]></tran_id>\r\n");
				valueXmlString.append("<name><![CDATA[").append(rs.getString("DOC_NAME")).append("]]></name>\r\n");
				valueXmlString.append("<type><![CDATA[").append(rs.getString("DOC_TYPE")).append("]]></type>\r\n");
				valueXmlString.append("<chg_date><![CDATA[").append(TimestampStringToDate(rs.getString("CHG_DATE"))).append("]]></chg_date>\r\n");
				valueXmlString.append("<chg_user><![CDATA[").append(rs.getString("CHG_USER")).append("]]></chg_user>\r\n");
				valueXmlString.append("<add_date><![CDATA[").append(TimestampStringToDate(rs.getString("ADD_DATE"))).append("]]></add_date>\r\n");
				valueXmlString.append("<add_user><![CDATA[").append(rs.getString("ADD_USER")).append("]]></add_user>\r\n");
				valueXmlString.append("<chk_out><![CDATA[").append(rs.getString("USER_ID__CHKOUT")).append("]]></chk_out>\r\n");
				valueXmlString.append("</Detail1>\r\n");
			}
			valueXmlString.append( "</Root>\r\n" );	
			
			pstmtrsNull(pstmt, rs);
		}catch (Exception e) {
			System.out.println("Exception : "+e);
		}
		return valueXmlString.toString();
	}
	
	public String openAttach(String docId)
	{
		String filePath ="";
		try {
			sql = "SELECT DOC_OBJECT,DOC_NAME FROM DOC_CONTENTS WHERE DOC_ID =?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, docId.trim());
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				           
				String url = CommonConstants.JBOSSHOME+File.separator+"server"+File.separator+"default"+File.separator+"deploy"+File.separator+
							"ibase.ear"+File.separator+"ibase.war"+File.separator+"temp"+File.separator;
				System.out.println("File path : "+url);
				if(!new File(url).exists())
				{
					new File(url).mkdir();
				}
				url = url + rs.getString("DOC_NAME");
				filePath = url ;
				System.out.println("File path : "+url);
				
				File image = new File(filePath);
                FileOutputStream fos = new FileOutputStream(image);

                byte[] buffer = new byte[256];
                
                InputStream is = rs.getBinaryStream("DOC_OBJECT");
                while (is.read(buffer) > 0) {
                    fos.write(buffer);
                }

                fos.close();
			}
			
			pstmtrsNull(pstmt, rs);
			
			if(filePath.trim().length() != 0)
			{
			File file = new File(filePath);
			Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file);
			}
			
		} catch (Exception e) {
			System.out.println("In create file : "+e);
		}
		return filePath;
	}
	
	public String TimestampStringToDate(String inputString) 
	{
		inputString = checkNull(inputString);
		//System.out.println("inputString ------- "+inputString+" lENGHT : "+inputString.trim().length());
		 String temp="";
		try{
			if(inputString.trim().length() > 0){
		E12GenericUtility genericUtility = new E12GenericUtility(); 
		DateFormat formatter;
		
	     formatter = new SimpleDateFormat(genericUtility.getDBDateFormat());
	     java.util.Date upto_date_temp = (java.util.Date)formatter.parse(inputString.trim());
	     java.sql.Date convertedDate = new java.sql.Date(upto_date_temp.getTime());
	     //System.out.println("Converted "+convertedDate);
	     SimpleDateFormat format = new SimpleDateFormat(genericUtility.getApplDateFormat());   
	     temp=format.format(convertedDate);    
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	     return temp;

	}
	
	public String checkNull(String input) {
		if (input == null) {
			input = "";
		} else {
			input = input.trim();
		}
		return input;
	}
	
	public void pstmtrsNull(PreparedStatement pstmt,ResultSet rs)
	{
		try {
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
	}
}
