package ibase.webitm.ejb.fin.advfield;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.sys_UTL.CommonFunctions;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


@Stateless
public class VoucherAdvField extends ValidatorEJB implements VoucherAdvFieldRemote, VoucherAdvFieldLocal
{
	
	CommonFunctions commonFunctions = null;
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData() throws RemoteException, ITMException 
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("In EJB [" + this.getClass().getSimpleName() + "] called [wfValData] [S]");
		String retString = "";
		Document dom = null, dom1 = null, dom2 = null;
		try 
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1); 
			if (xmlString2.trim().length() > 0 )
			dom2 = parseString("<Root>" + xmlString2+ "</Root>");
		
			String termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			commonFunctions = new CommonFunctions(termId, dom2);
			//end - bipin on 17/03/2010

			retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception in EJB[ " + this.getClass().getSimpleName() + " ]");
			e.printStackTrace();
		}
		System.out.println("In EJB [" + this.getClass().getSimpleName() + "] called [wfValData] [S] END.\nReturning " + retString);
		return retString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("In EJB [" + this.getClass().getSimpleName() + "] called [wfValData] [D] START");
		String errString = "", errCode = "", userId = "", loginSite = "", loginEmp = "", childNodeName = "", appDateFormat = "", dbDateFormat = "", fieldValue = "", convAcctCode = "", taxEnv = "", stanFrom = "", acct_code_conv = "", sql = "";
		String siteCode = "";
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		int count = 0;
		int valCount = 0;
		PreparedStatement pstmt = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		double AMTLIMIT = 20000.00;
		double netAmt = 0.00;
		int ctr, currentFormNo = 0;
		int childNodeListLength;
		int cnt = 0;
		java.util.Date tranDateParse,billDateParse =null;
		Double amtParse = 0d, claimAmount = 0d;
		System.out.println("commonFunctions  :  [" + commonFunctions + "]");
		StringBuffer errStringXml = new StringBuffer();
		String emploginCode = getValueFromXTRA_PARAMS(xtraParams,
				"loginEmpCode");

		errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");

		System.out.println("\n\n\n\n\n\n\n\nVoucherAdvField[wfValData()]");
		try 
		{
			appDateFormat = getApplDateFormat();
			dbDateFormat = getDBDateFormat();
		}
		catch (Exception e)
		{
			System.out.println("Exception :[VoucherAdvField]While Getting Date Format"+ e.getMessage());
		}
		SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yy");
		java.util.Date DateFrom = null;
		java.util.Date DateTo = null;
		java.util.Date currentDate = new java.util.Date();
		java.text.SimpleDateFormat dtf = new SimpleDateFormat(appDateFormat);
		java.text.SimpleDateFormat sdfDatabase = new SimpleDateFormat(dbDateFormat);
		try 
		{
			// conn = getConnection(); //Haneesh 30/10/09 commented
			// Haneesh 30/10/09 begin
			ConnDriver connDriver = new ConnDriver();
			//Comment By sanket J as request by Manoj sir on [21/06/2018]
			//conn = connDriver.getConnectDB("Driver");
			conn = getConnection();
			// Haneesh 30/10/09 end
			stmt = conn.createStatement();
			System.out.println(xtraParams);
			userId = getValueFromXTRA_PARAMS(xtraParams, "userId");
			System.out.println("userId:::" + userId);
			String acct_code__conv = getValueFromFinparam("999999",
					"DEFT_ACCT_CODE_CONV", conn);
			String paySite = "";
			String cashCode = "";
			String bankCode = "";
			String payMode = "";
			String finEntity = "";
			String finFarmEntity = "";
			String orgPaySite = "";
			String orgFinEntity = "";
			sql = " SELECT PAY_SITE FROM EMPLOYEE WHERE EMP_CODE=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, emploginCode);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				orgPaySite = rs.getString("PAY_SITE");
			}
			//Added by Vikas L on 10-05-19[Start]
			closeRs(rs);
			if(pstmt!=null) 
			{
				pstmt.close();
				pstmt=null;
			}
			//Added by Vikas L on 10-05-19[End]
			sql = " SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE=? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, orgPaySite);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				orgFinEntity = rs.getString("FIN_ENTITY");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo)
			{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength" + childNodeListLength);
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					fieldValue = genericUtility.getColumnValue(childNodeName,dom);
					if (childNodeName.equals("site_code"))
					{
						siteCode = genericUtility.getColumnValue(childNodeName,dom);

						System.out.println("Site code is ...." + siteCode);

						if (fieldValue == null || fieldValue.trim().length() == 0)
						{
							errString = getErrorString("site_code","VMSITECD1", userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E"))
								break;
						}
						cnt = getCount("SITE", "SITE_CODE", fieldValue, conn);
						if (cnt == 0)
						{
							errString = getErrorString("site_code", "VMSITE1",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E"))
								break;
						}
					}
					else if (childNodeName.equals("tran_type"))
					{
						System.out.println("----Validation For tran_type.11..... "+ fieldValue);
						if (fieldValue == null || fieldValue.trim().length() == 0)
						{
							errCode = "VTTRANTYPE";
							errString = getErrorString("tran_type", errCode,userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E"))
								break;
						}

					}

					// ------------- Manoj Sarode
					// ----------17-Jun-2013----start----

					if (childNodeName.equals("emp_code")) 
					{
						if (fieldValue == null || fieldValue.trim().length() == 0) 
						{
							errString = getErrorString("emp_code", "BLNKEMPCD",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, fieldValue).equalsIgnoreCase("E"))
								break;

						} 
						else
						{
							sql = " SELECT COUNT(*) FROM EMPLOYEE WHERE EMP_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, fieldValue.trim());
							rs = pstmt.executeQuery();
							if (rs.next()) {
								count = rs.getInt(1);
							}
							//Added by Vikas L on 10-05-19[Start]
							closeRs(rs);
							pstmt.close();
							pstmt=null;
							//Added by Vikas L on 10-05-19[End]
							if (count == 0)
							{
								errString = getErrorString("emp_code","VTINVEMPCD", userId);
								if (commonFunctions.errorType(conn, errString,errStringXml, fieldValue).equalsIgnoreCase("E"))
									break;
							} 
							else
							{
								/**
								 * 
								 * Following validation is added as discussed
								 * with Hemant Sir & Sumit S. on 01-Mar-2014 If
								 * Bank code & Pay mode value of requester
								 * employee is null or one of them is null then
								 * System will not allow to save the
								 * transaction. Start .....
								 * 
								 * */

								sql = " SELECT BANK_CODE, PAY_MODE FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, fieldValue);
								rs = pstmt.executeQuery();
								while (rs.next()) 
								{
									bankCode = rs.getString("BANK_CODE");
									payMode = rs.getString("PAY_MODE");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (bankCode == null || bankCode.trim().length() == 0) 
								{
									sql = " SELECT BANK_CODE FROM SITE WHERE SITE_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, siteCode);
									rs = pstmt.executeQuery();
									while (rs.next())
									{
										cashCode = rs.getString("BANK_CODE");

									}

									System.out.println("BANK cash code is ... ."+ cashCode);
									
									if (rs != null) {
										rs.close();
										rs = null;
									}
									if (pstmt != null) {
										pstmt.close();
										pstmt = null;
									}

									if (cashCode == null || cashCode.trim().length() == 0)
									{
										errString = getErrorString("emp_code","VTNTDFND", userId);
										if (commonFunctions.errorType(conn,errString, errStringXml,fieldValue).equalsIgnoreCase("E"))
											break;
									}
								}

								/**
								 * * If Bank code & Pay mode value of requester
								 * employee is null or one of them is null then
								 * System will not allow to save the
								 * transaction.
								 * 
								 * End......
								 * 
								 * */

								String tempSundryCode = checkCodeInDetail(dom2);

								if (tempSundryCode != null && (tempSundryCode.trim().length() > 0) && (!tempSundryCode.trim().equalsIgnoreCase(fieldValue.trim())))
								{
									System.out.println("Requester Code & Sundry Code are not same.....");
									System.out.println("Requester Code ["+ fieldValue.trim() + "]");
									System.out.println("Sundry Code ["+ tempSundryCode.trim() + "]");
									errString = getErrorString("emp_code","VTINVSNDCD", userId);

									if (commonFunctions.errorType(conn, errString,errStringXml, fieldValue).equalsIgnoreCase("E"))
										break;
								}

								/*
								 * sql =
								 * " SELECT PAY_SITE FROM EMPLOYEE WHERE EMP_CODE=?"
								 * ; pstmt = conn.prepareStatement(sql);
								 * pstmt.setString(1, fieldValue); rs =
								 * pstmt.executeQuery(); while(rs.next()) {
								 * paySite=rs.getString("PAY_SITE"); }
								 * 
								 * sql =
								 * " SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ? "
								 * ; pstmt = conn.prepareStatement(sql);
								 * pstmt.setString(1, paySite); rs =
								 * pstmt.executeQuery(); while(rs.next()) {
								 * finEntity=rs.getString("FIN_ENTITY"); }
								 * 
								 * if(!orgFinEntity.trim().equalsIgnoreCase(
								 * finEntity.trim())) { errString =
								 * getErrorString
								 * ("emp_code","INVREQCODE",userId); if
								 * (commonFunctions.errorType(conn,
								 * errString,errStringXml
								 * ,fieldValue).equalsIgnoreCase("E")) break; }
								 * rs.close(); rs=null; pstmt.close();
								 * pstmt=null;
								 * 
								 * sql =
								 * "SELECT VAR_VALUE FROM FINPARM WHERE VAR_NAME='FLD_STAFF_FINENT' "
								 * ; pstmt = conn.prepareStatement(sql); rs =
								 * pstmt.executeQuery(); while(rs.next()) {
								 * finFarmEntity = rs.getString("VAR_VALUE"); }
								 * rs.close(); rs=null; pstmt.close();
								 * pstmt=null;
								 * 
								 * 
								 * 
								 * sql =
								 * " Select COUNT(EMP_CODE) as count From Employee Emp, FINENT FN, SITE ST WHERE FN.FIN_ENTITY = ST.FIN_ENTITY AND EMP.PAY_SITE = ST.SITE_CODE AND ST.FIN_ENTITY = '"
								 * +finFarmEntity+"' AND " +
								 * " EMP.EMP_CODE = '"+fieldValue.trim()+"' ";
								 * pstmt = conn.prepareStatement(sql); rs =
								 * pstmt.executeQuery(); while(rs.next()) {
								 * count = rs.getInt(1); } if(count == 0) {
								 * errString =
								 * getErrorString("emp_code","INVREQCODE"
								 * ,userId); if (commonFunctions.errorType(conn,
								 * errString
								 * ,errStringXml,fieldValue).equalsIgnoreCase
								 * ("E")) break; }
								 * 
								 * rs.close(); rs=null; pstmt.close();
								 * pstmt=null;
								 */
							}
						}
					}
					if (childNodeName.equals("emp_code__aprv"))
					{
						if (fieldValue == null || fieldValue.trim().length() == 0) 
						{
							errString = getErrorString("emp_code__aprv","BLNKEMPCD", userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, fieldValue).equalsIgnoreCase("E"))
								break;

						} 
						else
						{
							sql = " SELECT COUNT(*) FROM EMPLOYEE WHERE EMP_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, fieldValue.trim());
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								count = rs.getInt(1);
							}
							if (count == 0)
							{
								errString = getErrorString("emp_code__aprv","VTAPRVCD", userId);
								if (commonFunctions.errorType(conn, errString,errStringXml, fieldValue).equalsIgnoreCase("E"))
									break;
							}
							pstmt.close();
							pstmt = null;
							rs.close();
							rs = null;

							// sql =
							// " SELECT COUNT(*) AS COUNT FROM GENCODES WHERE FLD_NAME='EMP_CODE__APRV' AND MOD_NAME='W_VOUCHER_ADVFIELD' AND FLD_VALUE = ? ";

							// MANOJ SARODE- COMMENT THE FOLLOWING CODE AS
							// CHANGES SUGGESTED BY CLIENT ON 15-NOV-2013 START

							/*
							 * sql=
							 * " SELECT COUNT(GEN.FLD_VALUE) AS EMP_CODE FROM GENCODES GEN, EMPLOYEE EMP WHERE TRIM(GEN.FLD_VALUE)= TRIM(EMP.EMP_CODE) AND GEN.MOD_NAME='W_VOUCHER_ADVFIELD' AND GEN.FLD_NAME='EMP_CODE__APRV' AND GEN.ACTIVE='Y' AND GEN.FLD_VALUE = ? "
							 * ; pstmt = conn.prepareStatement(sql);
							 * pstmt.setString(1,fieldValue.trim()); rs =
							 * pstmt.executeQuery(); if(rs.next()) { valCount =
							 * rs.getInt(1); } if(valCount == 0) { errString =
							 * getErrorString
							 * ("emp_code__aprv","VTAPRVCD",userId); if
							 * (commonFunctions.errorType(conn,
							 * errString,errStringXml
							 * ,fieldValue).equalsIgnoreCase("E")) break; }
							 * 
							 * pstmt.close(); pstmt=null; rs.close(); rs=null;
							 */

							// MANOJ SARODE- COMMENT THE FOLLOWING CODE AS
							// CHANGES SUGGESTED BY CLIENT ON 15-NOV-2013 END
						}
					}
					if (childNodeName.equals("proj_code"))
					{

						if (fieldValue != null && fieldValue.trim().length() > 0)
						{
							String sql1 = "";
							sql1 = " SELECT COUNT(GEN.FLD_NAME) AS COUNT FROM GENCODES GEN, PROJECT PROJ WHERE TRIM(PROJ.PROJ_CODE) = TRIM(GEN.FLD_VALUE) AND GEN.MOD_NAME = 'W_VOUCHER_ADVFIELD' AND GEN.FLD_NAME = 'PROJ_CODE' AND GEN.ACTIVE = 'Y' AND GEN.FLD_VALUE = '"
									+ fieldValue.trim() + "' ";
							System.out.println("inside proj_code********"+ sql1);
							if(stmt == null)
							{
								stmt=conn.createStatement();
							}
							rs = stmt.executeQuery(sql1);

							if (rs.next())
							{
								cnt = rs.getInt(1);
								System.out.println("cnt ********" + cnt);
								if (cnt == 0) 
								{
									errString = getErrorString("proj_code","VTINVPRJCD", userId);
									if (commonFunctions.errorType(conn,errString, errStringXml,emploginCode).equalsIgnoreCase("E"))
										break;
								}
							}
							closeRs(rs);//Added by Vikas L on 10-05-19
						}

					}// end of if

					// Following block is added by Manoj Sarode on 26-Sep-2014
					// If 2nd detail blank & status = 'S' to be validate start
					// .....
					if (childNodeName.equals("status"))
					{
						String tempRec = checkCodeInDetail(dom2);

						System.out.println(" Status value...." + fieldValue);
						System.out.println(" tempRec...." + tempRec);

						if (fieldValue.equals("S") && tempRec != null && (tempRec.trim().length() == 0)) 
						{
							errString = getErrorString("status", "VTDETNTEXT",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, fieldValue).equalsIgnoreCase("E"))
								break;
						}
					}
					// Above block is added by Manoj Sarode on 26-Sep-2014 If
					// 2nd detail blank & status = 'S' to be validate End .....

					if (childNodeName.equals("net_amt"))
					{
						double netAmount = 0;
						if (fieldValue != null) 
						{
							netAmount = Double.parseDouble(fieldValue);
							if (netAmount < 0) 
							{
								errString = getErrorString("net_amt","VTAMOUNT3", userId);
								if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
									break;
							}

						}// EOF IF CHILDNODE
					}

					if (childNodeName.equals("purpose"))
					{
						if (fieldValue == null || fieldValue.trim().length() == 0)
						{
							errString = getErrorString("purpose", "VTPURPOSE",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E"))
								break;
						} 
						else 
						{
							//Added by Dipali [Start]
							System.out.println("Validation for : purpose");
							
							System.out.println("purpose : ["+fieldValue+"]");
							sql="SELECT count(*) FROM GENCODES WHERE MOD_NAME='W_VOUCHER_ADVSUPP' AND FLD_NAME='PURPOSE'  AND ACTIVE='Y' AND FLD_VALUE=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,fieldValue);
							rs = pstmt.executeQuery();
							
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
										errCode = "VTINPAYMOD";
										errString = getErrorString("purpose",errCode,userId);
										if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) //added by bipin on 17/03/2010 [reason: To allow error & warning]
										break;
								}	
							}
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							//Added by Dipali [End]
							/*
							 * String sql1=""; sql1=
							 * "SELECT COUNT(*) FROM GENCODES WHERE MOD_NAME='W_VOUCHER_ADVFIELD' AND FLD_NAME='REMARKS1' AND FLD_VALUE='"
							 * +fieldValue.trim()+"'" ;
							 * rs=stmt.executeQuery(sql1); if (rs.next()) { cnt
							 * =rs.getInt(1); if(cnt ==0 ) { errString =
							 * getErrorString("remarks1","VTPURPOSE",userId); if
							 * (commonFunctions.errorType(conn,
							 * errString,errStringXml
							 * ,emploginCode).equalsIgnoreCase("E")) break; } }
							 */
						}

					}
					if (childNodeName.equals("remarks"))
					{
						if (fieldValue == null || fieldValue.trim().length() == 0) 
						{
							errString = getErrorString("remarks", "VTREMARKS",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E"))
								break;
						}
					}

                   //Added By Ramagya on 31/08/20 {Start}]
						else if(childNodeName.equals("tran_date"))
                       {
                        String tranDate = genericUtility.getColumnValue("tran_date",dom1);
                           if (tranDate == null || tranDate.length() == 0)
                            {
                               errString = getErrorString("tran_date","VTRAENULL",userId);
                                if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) //added by bipin on 17/03/2010 [reason: To allow error & warning]
                                break;

                             }
                           else {
                            try
                               {
                                     tranDateParse = dtf.parse(tranDate);
                              }
                               catch(Exception ex)
                              {
                            System.out.println("Date Format Parsing Exception in tran_date");

                            errString = getErrorString("tran_date","VTRAENULL",userId);

                         if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) 
                         break;

                       }
                       }
					    //Added By Ramagya on 31/08/20 [End]
             }
			
				}// end of for
				break;
			case 2:
				System.out.println("Case 2 of wfValData()::VoucherAdvField");
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					fieldValue = genericUtility.getColumnValue(childNodeName,dom, "2");
					System.out.println("childNodeName [" + childNodeName+ "] : fieldValue [" + fieldValue + "]");

					if (childNodeName.equals("sundry_type"))
					{
						System.out.println("Validation for : sundry_type");
						String tranType = genericUtility.getColumnValue("tran_type", dom1);
						System.out.println("tranType : [" + tranType + "]");
						int countDetail = countDetail(dom2, "Detail2");
						System.out.println("countDetail : [" + countDetail+ "]");
						if (tranType.equalsIgnoreCase("A") && countDetail > 1)
						{
							errCode = "VTCVDETAIL";
							errString = getErrorString("sundry_type", errCode,userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
								break;
						}
					}

					//Added by Dipali [Start]
					if(childNodeName.equals("chq_name"))
					{
						System.out.println("Validation for : chq_name");
						String purpose = genericUtility.getColumnValue("purpose",dom1);
						System.out.println("purpose : ["+purpose+"]");
						
						if(purpose.equalsIgnoreCase("Cheque Mode")) 
						{
							if(fieldValue == null || fieldValue.trim().length()==0)
							{
							//errCode = "VTSASCQNRQ";
							errString = getErrorString("chq_name","VTSASCQNRQ",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) //added by bipin on 17/03/2010 [reason: To allow error & warning]
							break;
						    }
						}
					}
					//Added by Dipali [End]
					
					if (childNodeName.equals("acct_code"))
					{

						String acctCode = genericUtility.getColumnValue("acct_code", dom, "2");
						String tranType = genericUtility.getColumnValue("tran_type", dom1);
						acctCode = (acctCode == null) ? "" : acctCode.trim();
						System.out.println("acctCode : [" + acctCode + "]");
						System.out.println("tranType : [" + tranType + "]");
						int countAcctInGen = countAccountInGencodes(conn,"W_VOUCHER_ADVFIELD", "ACCT_CODE", acctCode,tranType);
						System.out.println("countAcctInGen : ["+ countAcctInGen + "]");

						if (acctCode.length() == 0) 
						{
							errCode = "VTCVACTNUL";
							errString = getErrorString("acct_code", errCode,userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
								break;
						}
						else if (countAcctInGen == 0)
						{
							errCode = "VTCVACT1";
							errString = getErrorString("acct_code", errCode,userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010[reason: To allow  error & warning]
								break;
						}

						String lineNo = " ";
						lineNo = genericUtility.getColumnValue("line_no", dom,"2");
						String domAcctCode = "";
						System.out.println("acct_code__conv ["+ acct_code__conv + "]fieldValue[" + fieldValue+ "]");
						if (acct_code__conv.equals(fieldValue.trim()))
						{
							domAcctCode = getAccountCode(dom2, lineNo,fieldValue);
							System.out.println("domAcctCode [" + domAcctCode+ "]fieldValue[" + fieldValue + "]");
							if (domAcctCode.trim().equals(fieldValue.trim()))
							{
								errCode = "VTDUPLREC";
								errString = getErrorString("acct_code",errCode, userId);
								if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
									break;
							}
						}
					}
					// end of if outer loop Arvind 23/08/07----Begin----------
					if (childNodeName.trim().equals("cctr_code"))
					{
						if (fieldValue == null) 
						{
							errString = getErrorString("cctr_code", "VTCCTR1",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
								break;
						} 
						else 
						{
							cnt = getCount("COSTCTR", "CCTR_CODE", fieldValue,conn);
							if (cnt == 0)
							{
								errString = getErrorString("cctr_code","VTINCCCODE ", userId);
								if (commonFunctions.errorType(conn, errString,errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on  17/03/2010 [reason: To allow error & warning]
									break;
							}
							// ---------pradeep--begin--12/09/07
							else
							{
								cnt = 0;
								String fieldValue_acctcode = "";
								fieldValue_acctcode = genericUtility.getColumnValue("acct_code", dom, "2");
								cnt = getCountMultivalue("ACCOUNTS_CCTR","CCTR_CODE", "ACCT_CODE", fieldValue,fieldValue_acctcode, conn);
								if (cnt == 0) 
								{
									errString = getErrorString("cctr_code","VMCCTR2", userId);
									if (commonFunctions.errorType(conn,errString, errStringXml,emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason:
																					// To
																					// allow
																					// error
																					// &
																					// warning]
										break;
								}
							}
							// ---------pradeep--end--12/09/07
						}
					}// EOF IF CCTR CODE
					if (childNodeName.trim().equals("anal_code"))
					{
						if (fieldValue == null|| fieldValue.trim().length() == 0) 
						{
							// start - commented by bipin on 13/03/2010[reason:according to sumit sir]
							errString = getErrorString("anal_code", "VTANAL2",userId);
							break;
							// end - commented by bipin on 13/03/2010
						} 
						else
						{
							/*
							 * cnt=getCount("ANALYSIS","ANAL_CODE",fieldValue,conn
							 * ); System.out.println("inside ANAL CODE "+cnt);
							 * if (cnt == 0) { errString =
							 * getErrorString("anal_code","VTANAL1",userId); if
							 * (commonFunctions.errorType(conn,
							 * errString,errStringXml
							 * ,emploginCode).equalsIgnoreCase("E")) //added by
							 * bipin on 17/03/2010 [reason: To allow error &
							 * warning] break; }
							 */
							/*
							 * System.out.println("fieldValue::::::"+fieldValue);
							 * cnt
							 * =getCount("ANALYSIS","ANAL_CODE",fieldValue,conn
							 * ); System.out.println("inside ANAL CODE "+cnt);
							 * if (cnt == 0) { errString =
							 * getErrorString("anal_code","VTANAL1",userId); if
							 * (commonFunctions.errorType(conn,
							 * errString,errStringXml
							 * ,emploginCode).equalsIgnoreCase("E")) //added by
							 * bipin on 17/03/2010 [reason: To allow error &
							 * warning] break; }
							 * //-------------------PRADEEP--BEGIN--12/09/07
							 * //validate enterted accu-code and cost_center
							 * must exist in acctounts_cctr table else { cnt=0;
							 * String fieldValue_acctcode = " ";
							 * fieldValue_acctcode =
							 * E12GenericUtility.getColumnValue
							 * ("acct_code",dom,"2");
							 * System.out.println("fieldValue_acctcodee:::::"
							 * +fieldValue_acctcode);
							 * cnt=getCountMultivalue("ACCOUNTS_ANALYSIS"
							 * ,"ANAL_CODE"
							 * ,"ACCT_CODE",fieldValue,fieldValue_acctcode
							 * ,conn);
							 * System.out.println("inside ACCOUNT  code 2 "
							 * +cnt); //start - bipin on 19/02/2010 String
							 * cctrCode =
							 * E12GenericUtility.getColumnValue("cctr_code"
							 * ,dom,"2"); int
							 * countCctrAnal=getCountMultivalue("CCTR_ANAL"
							 * ,"ANAL_CODE"
							 * ,"CCTR_CODE",fieldValue,cctrCode,conn);
							 * System.out
							 * .println("countCctrAnal : ["+countCctrAnal+"]");
							 * //end - bipin on 19/02/2010 if (cnt == 0) {
							 * errString =
							 * getErrorString("anal_code","VMANAL2 ",userId); if
							 * (commonFunctions.errorType(conn,
							 * errString,errStringXml
							 * ,emploginCode).equalsIgnoreCase("E")) //added by
							 * bipin on 17/03/2010 [reason: To allow error &
							 * warning] break; } //start - bipin on 19/02/2010
							 * else if (countCctrAnal == 0) { errString =
							 * getErrorString("anal_code","VMANAL5",userId); if
							 * (commonFunctions.errorType(conn,
							 * errString,errStringXml
							 * ,emploginCode).equalsIgnoreCase("E")) //added by
							 * bipin on 17/03/2010 [reason: To allow error &
							 * warning] break; }
							 */// end - bipin on 19/02/2010

							String sql1 = "";
							sql1 = " SELECT COUNT(GEN.FLD_VALUE) AS ANAL FROM GENCODES GEN, ANALYSIS ANAL WHERE TRIM(GEN.FLD_VALUE) = TRIM(ANAL.ANAL_CODE) AND GEN.MOD_NAME='W_VOUCHER_ADVFIELD' AND GEN.FLD_NAME='ANAL_CODE' AND GEN.ACTIVE='Y' AND FLD_VALUE='"
									+ fieldValue + "'";
							System.out.println("inside analcode********" + sql1);
							if(stmt == null)
							{
								stmt=conn.createStatement();
							}
							rs = stmt.executeQuery(sql1);

							if (rs.next())
							{
								cnt = rs.getInt(1);
								System.out.println("cnt ********" + cnt);
								if (cnt == 0)
								{
									errString = getErrorString("anal_code","VMANAL2", userId);
									if (commonFunctions.errorType(conn,errString, errStringXml,emploginCode).equalsIgnoreCase("E"))
										break;
								}
							}
						}

					}
					//Added by Kuldeep on 31/07/2020 [START]
					if (childNodeName.trim().equals("period_code"))
					{
						System.out.println("In period_code::"+fieldValue);
						if (fieldValue == null || fieldValue.trim().length()==0)
						{
						  	errString = getErrorString("period_code","VTPRDCODE",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml,fieldValue).equalsIgnoreCase("E")) 
							break;
					
						}
						if (fieldValue != null && fieldValue.trim().length()>0)
						{
							
						String sql1="";
						sql1="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME='W_VOUCHER_ADVSUPP' AND FLD_NAME='PERIOD_CODE' AND FLD_VALUE='"+fieldValue.trim()+"' AND ACTIVE='Y' " ;
						System.out.println("inside Event Month********"+sql1);
						if(stmt == null)
						{
							stmt=conn.createStatement();
						}
						rs=stmt.executeQuery(sql1);
						
							if (rs.next())
							{
								cnt =rs.getInt(1);
								System.out.println("cnt ********"+cnt);
								if(cnt ==0 )
								{
									errString = getErrorString("period_code","VTINVEVENT",userId);
									if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) 
									break;
								}								
							}
						}
						
					}
					//Added by Kuldeep on 31/07/2020 [END]

				/*	if (childNodeName.trim().equals("period_code")) 
					{
						if (fieldValue != null && fieldValue.trim().length() > 0)
						{
																	 * 
																	 * String
																	 * sql1="";
																	 * sql1=
																	 * "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME='W_VOUCHER_ADVFIELD' AND FLD_NAME='PERIOD_CODE' AND FLD_VALUE='"
																	 * +
																	 * fieldValue
																	 * .trim()+
																	 * "' AND ACTIVE='Y' "
																	 * ;
																	 * System.out
																	 * .println(
																	 * "inside Event Month********"
																	 * +sql1);
																	 * rs=stmt.
																	 * executeQuery
																	 * (sql1);
																	 * 
																	 * if
																	 * (rs.next
																	 * ()) { cnt
																	 * =
																	 * rs.getInt
																	 * (1);
																	 * System
																	 * .out
																	 * .println(
																	 * "cnt ********"
																	 * +cnt);
																	 * if(cnt
																	 * ==0 ) {
																	 * errString
																	 * =
																	 * getErrorString
																	 * (
																	 * "period_code"
																	 * ,
																	 * "VTINVEVENT"
																	 * ,userId);
																	 * if (
																	 * commonFunctions
																	 * .
																	 * errorType
																	 * (conn,
																	 * errString
																	 * ,
																	 * errStringXml
																	 * ,
																	 * emploginCode
																	 * ).
																	 * equalsIgnoreCase
																	 * ("E"))
																	 * break; }
																	 * }
																	 
						}
						//Modified by Mony on 30/07/2020 Start
						else {
							errString = getErrorString("period_code", "VTPRDCODE",userId);
							break;
						}
						//Modified by Mony on 30/07/2020 End
					}*/
					if (childNodeName.equals("bill_no")) {
					System.out.println("bill_no VALIDATION:::::::");	
						//Added by Dipali [Start]
						/*System.out.println("In bill_no::::"+fieldValue);

						if (fieldValue == null || fieldValue.trim().length()==0)
						{
							errString = getErrorString("bill_no","VTBILNONUL",userId);
							if (commonFunctions.errorType(conn, errString,errStringXml,fieldValue).equalsIgnoreCase("E")) 
							break;
					
						}*/
					}
						//Added by Dipali [End]}
					if (childNodeName.equals("apply_tax")) {}
					if (childNodeName.equals("bill_amt")) 
					{
						double amount = 0;
						if (fieldValue == null || fieldValue.trim().length() == 0)
						{
							errString = getErrorString("bill_amt", "VTAMT2 ", userId);
							if (commonFunctions.errorType(conn, errString, errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
								break;
						} 
						else 
						{
							amount = Double.parseDouble(fieldValue);
							if (amount <= 0)
							{
								errString = getErrorString("bill_amt", "VTAMOUNT3", userId);
								if (commonFunctions.errorType(conn, errString, errStringXml, emploginCode).equalsIgnoreCase("E")) // added by bipin on 17/03/2010 [reason: To allow error & warning]
									break;
							} 
							else 
							{
								//Added by Tajuddin Mahadi to Validate as per requestor, bill_amt and period_code
								String sundryCode = genericUtility.getColumnValue("sundry_code", dom);
								String periodCode = genericUtility.getColumnValue("period_code", dom);
								String tranId = genericUtility.getColumnValue("tran_id", dom);
								tranId = tranId==null ? "" : tranId.trim();
								
								sql = "select count(*) as count from cash_voucher_det d, cash_voucher h where h.tran_id = d.tran_id and d.sundry_code  = ? and d.bill_amt = ? and d.period_code = ?";
								
								
								if(tranId.length() > 0) {
									sql += " and d.tran_id <> ?";
								}
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, sundryCode);
								pstmt.setString(2, fieldValue);
								pstmt.setString(3, periodCode);
								
								if(tranId.length() > 0) {
									pstmt.setString(4, tranId);
								}

								rs = pstmt.executeQuery();

								if (rs.next()) {
									cnt = rs.getInt("count");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if (cnt > 0) 
								{
									errString = getErrorString("bill_no", "VTDUPEAEDE", userId);
									if(commonFunctions.errorType(conn, errString, errStringXml, emploginCode).equalsIgnoreCase("E"))
										break;
								}
							}

						}
					}
					if (childNodeName.equals("net_amt")) {/*
														 * if(fieldValue !=
														 * null) {
														 * netAmt=checkNetAmount
														 * (dom,dom2,conn);
														 * System
														 * .out.println("netAmt===>"
														 * +netAmt); if (netAmt
														 * > AMTLIMIT) {
														 * errString =
														 * getErrorString
														 * ("net_amt", "VNAMT",
														 * userId); if
														 * (commonFunctions
														 * .errorType(conn,
														 * errString
														 * ,errStringXml
														 * ,emploginCode
														 * ).equalsIgnoreCase
														 * ("E")) //added by
														 * bipin on 17/03/2010
														 * [reason: To allow
														 * error & warning]
														 * break; } }
														 */
					}// EOF IF NET AMT
						// ----------pradeep------end-----13/11/07
					
					// added by ramagya on 31/08/2020 [start]
					
					 else if(childNodeName.equals("bill_date"))
                       {/*
                        String billDate = genericUtility.getColumnValue("bill_date",dom2);
                           if (billDate == null || billDate.length() == 0)
                            {
                               errString = getErrorString("bill_date","VBIILENULL",userId);
                                if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) 
                                break;

                            }
                            else {
                               try
                               {
                                     billDateParse = dtf.parse(billDate);
                               }
                                catch(Exception ex)
                                   {
                                 System.out.println("Date Format Parsing Exception in billDate");

                                    errString = getErrorString("bill_date","VBIILENULL",userId);

                                 if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
                                 break;

                                    }
                                 }   
                       */}
					   
					else if (childNodeName.equals("amount"))
                     {
                         String  amt=genericUtility.getColumnValue("amount",dom2);
                        if (amt == null || amt.length() == 0)
                       {
                         errString = getErrorString("amount", "VAMTENULL", userId);
                         if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) 
                         break;
                       }else
                    {
                     try
                    {
                      amtParse = Double.parseDouble(amt);
                    }
                     catch(Exception ex)
                      {
                        System.out.println("Number Format Exception in amount");

                        errString = getErrorString("amount", "VAMTENULL", userId);
                      if (commonFunctions.errorType(conn, errString,errStringXml,emploginCode).equalsIgnoreCase("E")) 
                     break;
                     }
                 }
               }
					// added by ramagya on 31/08/2020 [End]
				}// eof FOR()
				break;
			/*
			 * case 3:
			 * System.out.println("Case 3 of wfValData()::nCashVoucherEJB");
			 * parentNodeList = dom2.getElementsByTagName("Detail3"); parentNode
			 * = parentNodeList.item(0); childNodeList =
			 * parentNode.getChildNodes(); childNodeListLength =
			 * childNodeList.getLength(); for(ctr = 0; ctr <
			 * childNodeListLength; ctr++) { childNode =
			 * childNodeList.item(ctr); childNodeName = childNode.getNodeName();
			 * fieldValue = E12GenericUtility.getColumnValue(childNodeName,
			 * dom); if (childNodeName.equals("conv_type")) { String
			 * reasDescr=""; System.out.println("Validating conv_type");
			 * reasDescr = E12GenericUtility.getColumnValue("reas_descr",dom);
			 * if(fieldValue.equals("T")) { if ( reasDescr == null ||
			 * reasDescr.trim().length()==0 ) { errString =
			 * getErrorString("conv_type","VTREASDESC",userId); if
			 * (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } } //---------------------pradeep----begin--18/09/07 else
			 * if(!fieldValue.equals("T")) {
			 * System.out.println("inside others::::::::::::::::::"); }
			 * //---------------------pradeep----end--18/09/07 } if
			 * (childNodeName.equals("reas_descr")) { String convType=""; String
			 * reasDescr=""; System.out.println("Validating conv_type");
			 * convType = E12GenericUtility.getColumnValue("conv_type",dom);
			 * reasDescr = E12GenericUtility.getColumnValue("reas_descr",dom);
			 * System.out.println("reasDescr==>["+reasDescr+"]"); if
			 * (!convType.equals("T")) { if (!reasDescr.equals("")) { errString
			 * = getErrorString("reas_descr","VTNOREAS",userId); break; } } } if
			 * (childNodeName.trim().equals("stan_code__to")) {
			 * //--------PRADEEP ------------BEGIN-------------18/09/07
			 * if(fieldValue == null) { errString =
			 * getErrorString("stan_code__to","VTINVTOSTA",userId); if
			 * (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } else { stanFrom =
			 * E12GenericUtility.getColumnValue("stan_code__from",dom); //
			 * ARVIND --06/09/07 --BEGIN // ARVIND --06/09/07 --END if
			 * (stanFrom.equals(fieldValue)) { errString =
			 * getErrorString("stan_code__to","VTSTANMIS",userId); if
			 * (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } } }//eof if //--------PRADEEP
			 * ----------------END-------------18/09/07 if
			 * (childNodeName.equals("stan_code__from")) { if (fieldValue ==
			 * null) { errString =
			 * getErrorString("stan_code__from","VTINVFRSTA",userId); if
			 * (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } }//eof if if (childNodeName.equals("conv_date")) { if
			 * (fieldValue == null) { errString = getErrorString("conv_date",
			 * "VTCVDTNUL3", userId); if (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } } //07/05/07 RICHA: ==> Updations so that amount can not
			 * be null or should be a non zero positive value. if
			 * (childNodeName.equals("amount")) { if (fieldValue == null) {
			 * errString = getErrorString("amount", "VTAMOUNT3", userId); if
			 * (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } else { double amount=Double.parseDouble(fieldValue);
			 * if(amount<0) { errString = getErrorString("amount", "VTAMOUNT3",
			 * userId); if (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } int counter = 0; NodeList parentNodeList2 = null;
			 * NodeList childNodeList2 = null; Node parentNode2 = null;
			 * parentNodeList2 = dom2.getElementsByTagName("Detail3"); int
			 * parentNodeListLength = parentNodeList2.getLength();
			 * 
			 * double totBillAmount = 0.00; while(counter <
			 * parentNodeListLength) { parentNode2 =
			 * parentNodeList2.item(counter); childNodeList2 =
			 * parentNode2.getChildNodes(); int childNodeListLength2 =
			 * childNodeList2.getLength(); for(int ctr2 = 0; ctr2 <
			 * childNodeListLength2; ctr2++) { Node childNode2 =
			 * childNodeList2.item(ctr2); String childNodeName2 =
			 * childNode2.getNodeName();
			 * //================PRADEEP===BEGIN===09/05/08 if
			 * (childNodeName2.equals("attribute")) { String
			 * updateFlag=childNode2
			 * .getAttributes().getNamedItem("updateFlag").getNodeValue();
			 * System.out.println("updateFlag........"+updateFlag); if
			 * (updateFlag.equals("D")) { break; } }
			 * //==================PRADEEP===BEGIN==09/05/08 if
			 * ("amount".equals(childNodeName2)) { totBillAmount = totBillAmount
			 * + Double.parseDouble(childNode2.getFirstChild().getNodeValue());
			 * break; } } counter++; }
			 * System.out.println("amtConv1====>"+totBillAmount); boolean flag
			 * =true; // boolean flag =false; flag =
			 * getNetAmountForConvAcctCode(dom,dom1,dom2,acct_code__conv,
			 * totBillAmount); System.out.println("flag......"+flag); if(flag ==
			 * false) // if(flag == true) { errString = getErrorString("amount",
			 * "VTAMOUNT4 ", userId); if (commonFunctions.errorType(conn,
			 * errString,errStringXml,emploginCode).equalsIgnoreCase("E"))
			 * //added by bipin on 17/03/2010 [reason: To allow error & warning]
			 * break; } //07/06/07 RICHA: ==> Updation to take care that amount
			 * in conveyance must not be greater than the bill amount entered in
			 * the first detail :- Other expences. } } }//FOR() LOOP break;
			 */
			}// switch
		}// eof try
		catch (Exception e)
		{
			System.out.println("Exception : VoucherAdvField : wfValData(String xmlString) : ==>\n"+ e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null) 
				{
					conn.close();
					conn = null;
				}
				//Added by Vikas L on 10-05-19[Start]
				if(stmt!=null) 
				{
					stmt.close();
					stmt=null;
				}
				//Added by Vikas L on 10-05-19[End]
			}
			catch (SQLException se)
			{
				System.out.println("inside finally" + se.getMessage());
				se.printStackTrace();
			}
		}
		// start - bipin on 17/03/2010 [reason: To allow error & warning]
		errStringXml.append("</Errors></Root>\r\n");
		if (errStringXml.toString().indexOf("</error>") != -1) 
		{
			errString = errStringXml.toString();
		}
		System.out.println("### FINAL errStringXml###\n==" + errStringXml);
		// end - bipin on 17/03/2010
		System.out.println("In EJB [" + this.getClass().getSimpleName() + "] called [wfValData] [D] END.\nReturning " + errString);
		return errString;
	}// 23/04/07wfValData()

	public String itemChanged() throws RemoteException, ITMException 
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try 
		{
			dom = parseString(xmlString); // returns the DOM Object for the passed XML Stirng
			dom1 = parseString(xmlString1); // returns the DOM Object for the passed XML Stirng
			if (xmlString2.trim().length() > 0)
			{
				dom2 = parseString("<Root>" + xmlString2 + "</Root>");
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext,currentColumn, editFlag, xtraParams);
		} 
		catch (Exception e)
		{
			System.out.println("Exception : [CashVoucherEJB][itemChanged(String,int)] :==>\n"+ e);
			e.printStackTrace();
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException 
	{
		String sql = "", columnValue = "", loginSite = "", loginCode = "", format = "", taxClass = "", taxChap = "", taxEnv = "", totalCumulativeAmt = "", convAmt = "", balanceAmount = "";
		String returnValue = "";// Haneesh 30/10/09 added
		String accValue = "";
		String remarks = "";
		String reqstrCode = "";
		String reqstrCodeDescr = "";
		int ctr = 0, n = 0;
		int currentFormNo = 0;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String payMode = "",payModeDb="";
		StringBuffer valueXmlString = new StringBuffer();
		System.out.println("\n\n\n\n\n\n\n\n\n\n\nVoucherAdvField[itemChanged()]");
		// SimpleDateFormat date1 = new
		// SimpleDateFormat(sourceDateFormat+" HH:mm:ss.S");
		// SimpleDateFormat uoutput = new SimpleDateFormat(targetDateFormat);
		// SimpleDateFormat uoutputTime = new
		// SimpleDateFormat(targetDateFormat+" HH:mm:ss");
		try
		{
			format = getApplDateFormat();
		} catch (Exception e)
		{
			System.out.println("Exception :[\nVoucherAdvField]While Getting Date Format"+ e.getMessage());
		}
		java.util.Date DateX = new java.util.Date();
		java.text.SimpleDateFormat dtf = new SimpleDateFormat(format);
		String emploginCode = getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
		loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
		loginCode = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
		try 
		{
			// conn = getConnection(); //This function is to connect with
			// oracle....
			// Haneesh 30/10/09 begin
			ConnDriver connDriver = new ConnDriver();
			//Comment By sanket J as request by Manoj sir on [21/06/2018]
			//conn = connDriver.getConnectDB("Driver");
			conn = getConnection();
			// Haneesh 30/10/09 end
			stmt = conn.createStatement();
			if (objContext != null && objContext.trim().length() > 0)
			currentFormNo = Integer.parseInt(objContext);
			System.out.println("[nVoucherAdvField] [itemChanged] :currentFormNo ....."+ currentFormNo);
			// valueXmlString = new
			// StringBuffer("<?xml  		version=\"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			// valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='"+CommonConstants.ENCODING+"'?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			columnValue = genericUtility.getColumnValue(currentColumn, dom);
			switch (currentFormNo) {
			case 1:
				valueXmlString.append("<Detail1>\r\n");
				System.out.println("*Before itm_default.");
				// valueXmlString.append("<chg_date><![CDATA[").append(dtf.format(DateX)).append("]]></chg_date>");

				/*
				 * Follwing line is conmmented by Manoj Sarode on 11-Apr-2014
				 * start As the chg_user is going null into WF_PRC_DATA table
				 * after clicking on Submit button.
				 */
				// 20-01-2015 Santosh Divekar Removed comment as mail from Dylan
				// valueXmlString.append("<chg_user><![CDATA[").append(loginCode).append("]]></chg_user>");

				/*
				 * Follwing line is conmmented by Manoj Sarode on 11-Apr-2014
				 * start As the chg_user is going null into WF_PRC_DATA table
				 * after clicking on Submit button.
				 */
				if (currentColumn.trim().equals("itm_default")) 
				{
					//Commented by Dipali
					//valueXmlString.append("<status><![CDATA[").append("O").append("]]></status>");
					valueXmlString.append("<status protect =\"1\" ><![CDATA[").append("O").append("]]></status>");    //Modified by Dipali
					valueXmlString.append("<tran_type><![CDATA[").append("A").append("]]></tran_type>");
					valueXmlString.append("<curr_code><![CDATA[").append("RS").append("]]></curr_code>");
					valueXmlString.append("<exch_rate><![CDATA[").append("1").append("]]></exch_rate>");

					valueXmlString.append("<tran_date><![CDATA[").append(dtf.format(DateX)).append("]]></tran_date>");
					 valueXmlString.append("<chg_user><![CDATA[").append(loginCode.trim()).append("]]></chg_user>");
					 valueXmlString.append("<chg_mail><![CDATA[").append(emploginCode.trim()).append("]]></chg_mail>");

					// ---------PRADEEP---BEGIN----07/04/2008

					/*
					 * String
					 * empCodeAprv=getValueFromRefTable("EMPLOYEE","EMP_CODE"
					 * ,emploginCode,"report_to",conn) ;
					 * System.out.println("===empCodeAprv====>"
					 * +empCodeAprv+"======");
					 * valueXmlString.append("<emp_code__aprv>"
					 * ).append(empCodeAprv).append("</emp_code__aprv>"); String
					 * sql1=
					 * "select emp_fname,emp_mname,emp_lname from employee where emp_code='"
					 * +empCodeAprv+"'";
					 * System.out.println("===sql1====>"+sql1); rs =
					 * stmt.executeQuery(sql1); if(rs.next()) {
					 * valueXmlString.append
					 * ("<employee_emp_fname><![CDATA[").append
					 * (rs.getString(1)==null ? "" :rs.getString(1)
					 * ).append("]]></employee_emp_fname>\r\n");
					 * valueXmlString.append
					 * ("<employee_emp_mname><![CDATA[").append
					 * (rs.getString(2)==null ? "" :rs.getString(2)
					 * ).append("]]></employee_emp_mname>\r\n");
					 * valueXmlString.append
					 * ("<employee_emp_lname><![CDATA[").append
					 * (rs.getString(3)==null ? "" :rs.getString(3)
					 * ).append("]]></employee_emp_lname>\r\n"); }
					 */

					// Commented By Manoj Sarode on 22-Nov-2013 - As per client
					// suggestion (SUMITS) Start

					/*
					 * valueXmlString.append("<emp_code>").append(emploginCode).
					 * append("</emp_code>"); sql=
					 * "select employee.emp_fname,employee.emp_mname,employee.emp_lname,"
					 * +
					 * "employee.designation,employee.dept_code,department.descr from employee,department "
					 * +
					 * "where employee.dept_code= department.dept_code and employee.emp_code ='"
					 * +emploginCode+"'"; System.out.println("*SQL:"+sql); rs =
					 * stmt.executeQuery(sql); if(rs.next()) {
					 * valueXmlString.append
					 * ("<tran_date><![CDATA[").append(dtf.format
					 * (DateX)).append("]]></tran_date>");
					 * valueXmlString.append(
					 * "<emp_fname><![CDATA[").append(rs.getString(1)==null ? ""
					 * :rs.getString(1) ).append("]]></emp_fname>\r\n");
					 * valueXmlString
					 * .append("<emp_mname><![CDATA[").append(rs.getString
					 * (2)==null ? "" :rs.getString(2)
					 * ).append("]]></emp_mname>\r\n");
					 * valueXmlString.append("<emp_lname><![CDATA["
					 * ).append(rs.getString(3)==null ? "" :rs.getString(3)
					 * ).append("]]></emp_lname>\r\n");
					 * valueXmlString.append("<designation><![CDATA["
					 * ).append(rs.getString(4)==null ? "" :rs.getString(4)
					 * ).append("]]></designation>\r\n");
					 * valueXmlString.append("<dept_code><![CDATA["
					 * ).append(rs.getString(5)==null ? "" :rs.getString(5)
					 * ).append("]]></dept_code>\r\n");
					 * valueXmlString.append("<department_descr><![CDATA["
					 * ).append(rs.getString(6)==null ? "" :rs.getString(6)
					 * ).append("]]></department_descr>\r\n"); }//end of if next
					 * valueXmlString
					 * .append("<site_code><![CDATA[").append((loginSite
					 * ==null)?"":loginSite).append("]]></site_code>\r\n");
					 */

					// Commented By Manoj Sarode on 22-Nov-2013 - As per client
					// suggestion (SUMITS) End

				} else if (currentColumn.trim().equals("site_code"))
				{
					String currCode = "";
					returnValue = getValueFromRefTable("SITE", "SITE_CODE",columnValue, "DESCR", conn);
					valueXmlString.append("<site_descr><![CDATA[").append(returnValue).append("]]></site_descr>");
					// --pradeep--begin--22/12/07
					sql = "SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY IN (SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE='"+ columnValue + "')";
					System.out.println("*SQL:****************" + sql);
					if(stmt == null)
					{
						stmt=conn.createStatement();
					}
					rs = stmt.executeQuery(sql);
					if (rs.next())
					currCode = rs.getString(1);
					else
					currCode = "";
					returnValue = getValueFromRefTable("CURRENCY", "CURR_CODE",currCode, "DESCR", conn);
					valueXmlString.append("<curr_code><![CDATA[").append(currCode).append("]]></curr_code>\r\n");
					valueXmlString.append("<currency_descr><![CDATA[").append(returnValue).append("]]></currency_descr>");
					valueXmlString.append("<co_date><![CDATA[").append(dtf.format(DateX)).append("]]></co_date>");

					closeRs(rs);//Added by Vikas L on 10-05-19

				}
				// ----------pradeep----begin---31/08/07
				if (currentColumn.trim().equals("proj_code")) 
				{
					if (columnValue != null && columnValue.trim().length() > 0) 
					{
						String sql1 = "";

						sql1 = "SELECT GEN.FLD_VALUE AS PROJECT_CODE, GEN.DESCR  FROM GENCODES GEN, PROJECT PROJ WHERE TRIM(PROJ.PROJ_CODE) = TRIM(GEN.FLD_VALUE) AND GEN.MOD_NAME='W_VOUCHER_ADVFIELD' AND GEN.FLD_NAME ='PROJ_CODE' AND GEN.ACTIVE = 'Y' AND FLD_VALUE='"+ columnValue.trim() + "' ";
						System.out.println("inside proj_code********" + sql1);
						if(stmt == null)
						{
							stmt=conn.createStatement();
						}
						rs = stmt.executeQuery(sql1);

						if (rs.next())
						{
							returnValue = rs.getString("DESCR");
						}
						closeRs(rs);//Added by Vikas L on 10-05-19
						valueXmlString.append("<project_descr><![CDATA[").append(returnValue).append("]]></project_descr>\r\n");
					} else 
					{
						valueXmlString.append("<project_descr><![CDATA[]]></project_descr>\r\n");
					}

				}
				if (currentColumn.trim().equals("emp_code__aprv")) 
				{
					if (columnValue != null && columnValue.trim().length() > 0)
					{
						// String
						// empCodeAprv=getValueFromRefTable("EMPLOYEE","EMP_CODE__APRV",columnValue,"report_to",conn)
						// ;
						// System.out.println("===empCodeAprv====>"+empCodeAprv+"=if IC=====");
						valueXmlString.append("<emp_code__aprv>").append(columnValue).append("</emp_code__aprv>\r\n");
						String sql1 = "select emp_fname,emp_mname,emp_lname from employee where emp_code='"+ columnValue + "'";
						if(stmt == null)
						{
							stmt=conn.createStatement();
						}
						rs = stmt.executeQuery(sql1);
						if (rs.next())
						{
							valueXmlString.append("<employee_emp_fname><![CDATA[").append(rs.getString(1) == null ? "" : rs.getString(1)).append("]]></employee_emp_fname>\r\n");
							valueXmlString.append("<employee_emp_mname><![CDATA[").append(rs.getString(2) == null ? "" : rs.getString(2)).append("]]></employee_emp_mname>\r\n");
							valueXmlString.append("<employee_emp_lname><![CDATA[").append(rs.getString(3) == null ? "" : rs.getString(3)).append("]]></employee_emp_lname>\r\n");
						}
						closeRs(rs);//Added by Vikas L on 10-05-19
					}else 
					{
						valueXmlString.append("<employee_emp_fname><![CDATA[]]></employee_emp_fname>\r\n");
						valueXmlString.append("<employee_emp_mname><![CDATA[]]></employee_emp_mname>\r\n");
						valueXmlString.append("<employee_emp_lname><![CDATA[]]></employee_emp_lname>\r\n");
						valueXmlString.append("<emp_code__aprv><![CDATA[]]></emp_code__aprv>\r\n");
					}
				}

				if (currentColumn.trim().equals("emp_code")) 
				{
					// System.out.println("----Itemchange Called in Case 1----emp_code......."+columnValue);
					if (columnValue != null && columnValue.trim().length() > 0) 
					{
						// valueXmlString.append("<emp_code>").append(columnValue).append("</emp_code>");
						sql = "select employee.emp_fname,employee.emp_mname,employee.emp_lname,employee.designation,employee.dept_code,department.descr,employee.pay_mode,employee.cur_city from employee,department where employee.dept_code= department.dept_code and employee.emp_code ='"+ columnValue + "'";
						if(stmt == null)
						{
							stmt=conn.createStatement();
						}
						rs = stmt.executeQuery(sql);

						if (rs.next())
						{
							// valueXmlString.append("<tran_date><![CDATA[").append(dtf.format(DateX)).append("]]></tran_date>");
							valueXmlString.append("<emp_fname><![CDATA[").append(rs.getString(1) == null ? "" : rs.getString(1)).append("]]></emp_fname>\r\n");
							valueXmlString.append("<emp_mname><![CDATA[").append(rs.getString(2) == null ? "" : rs.getString(2)).append("]]></emp_mname>\r\n");
							valueXmlString.append("<emp_lname><![CDATA[").append(rs.getString(3) == null ? "" : rs.getString(3)).append("]]></emp_lname>\r\n");
							valueXmlString.append("<designation><![CDATA[").append(rs.getString(4) == null ? "" : rs.getString(4)).append("]]></designation>\r\n");
							valueXmlString.append("<dept_code><![CDATA[").append(rs.getString(5) == null ? "" : rs.getString(5)).append("]]></dept_code>\r\n");
							valueXmlString.append("<department_descr><![CDATA[").append(rs.getString(6) == null ? "" : rs.getString(6)).append("]]></department_descr>\r\n");
							valueXmlString.append("<emp_code>").append(columnValue).append("</emp_code>\r\n");
							//Added by dipali
							payModeDb = rs.getString(7) == null ? "" : rs.getString(7);
							if(payModeDb.equalsIgnoreCase("T")) {
								payMode = "Transfer";
							}
							else if(payModeDb.equalsIgnoreCase("Q")) {
								payMode = "Cheque Mode";
							}
							else if(payModeDb.equalsIgnoreCase("D")) {
								payMode = "Demand Draft";
							}
							else if(payModeDb.equalsIgnoreCase("N")) {
								payMode = "NEFT";
							}
							else if(payModeDb.equalsIgnoreCase("C")) {
								payMode = "Cash";
							}
							else if(payModeDb.equalsIgnoreCase("")){
								payMode = "";
							}
							valueXmlString.append("<purpose><![CDATA[").append(payMode).append("]]></purpose>\r\n");
							valueXmlString.append("<cur_city><![CDATA[").append(rs.getString(8) == null ? "" : rs.getString(8)).append("]]></cur_city>\r\n");

						}// end of if next
						closeRs(rs);///Added by Vikas L on 10-05-19
						
						/*
						 * String
						 * empCodeAprv=getValueFromRefTable("EMPLOYEE","emp_code"
						 * ,columnValue,"report_to",conn) ;
						 * System.out.println("===empCodeAprv====>"
						 * +empCodeAprv+"=if IC=====");
						 * valueXmlString.append("<emp_code__aprv>"
						 * ).append(empCodeAprv).append("</emp_code__aprv>");
						 * String sql1=
						 * "select emp_fname,emp_mname,emp_lname from employee where emp_code='"
						 * +empCodeAprv+"'";
						 * 
						 * rs = stmt.executeQuery(sql1);
						 * 
						 * if(rs.next()) {
						 * valueXmlString.append("<employee_emp_fname><![CDATA["
						 * ).append(rs.getString(1)==null ? "" :rs.getString(1)
						 * ).append("]]></employee_emp_fname>\r\n");
						 * valueXmlString
						 * .append("<employee_emp_mname><![CDATA[")
						 * .append(rs.getString(2)==null ? "" :rs.getString(2)
						 * ).append("]]></employee_emp_mname>\r\n");
						 * valueXmlString
						 * .append("<employee_emp_lname><![CDATA[")
						 * .append(rs.getString(3)==null ? "" :rs.getString(3)
						 * ).append("]]></employee_emp_lname>\r\n"); } else {
						 * valueXmlString.append(
						 * "<employee_emp_fname><![CDATA[]]></employee_emp_fname>\r\n"
						 * ); valueXmlString.append(
						 * "<employee_emp_mname><![CDATA[]]></employee_emp_mname>\r\n"
						 * ); valueXmlString.append(
						 * "<employee_emp_lname><![CDATA[]]></employee_emp_lname>\r\n"
						 * );
						 * 
						 * }
						 */
					}
					else 
					{
						// valueXmlString.append("<tran_date><![CDATA[]]></tran_date>");
						valueXmlString.append("<emp_fname><![CDATA[]]></emp_fname>\r\n");
						valueXmlString.append("<emp_mname><![CDATA[]]></emp_mname>\r\n");
						valueXmlString.append("<emp_lname><![CDATA[]]></emp_lname>\r\n");
						valueXmlString.append("<designation><![CDATA[]]></designation>\r\n");
						valueXmlString.append("<dept_code><![CDATA[]]></dept_code>\r\n");
						valueXmlString.append("<department_descr><![CDATA[]]></department_descr>\r\n");
						valueXmlString.append("<emp_code><![CDATA[]]></emp_code>");
						//Added by Dipali
						valueXmlString.append("<pupose><![CDATA[]]></purpose>");
					}
				}
				valueXmlString.append("</Detail1>\r\n");
				break;
			case 2:
				valueXmlString.append("<Detail2>\r\n");
				System.out.println("*Before itm_default OF CASE 2.");
				System.out.println("currentColumn:::::" + currentColumn);

				if (currentColumn.trim().equals("itm_default"))
				{
					System.out.println("Inside itm_default");
					taxClass = genericUtility.getColumnValue("tax_class", dom1);
					taxChap = genericUtility.getColumnValue("tax_chap", dom1);
					taxEnv = genericUtility.getColumnValue("tax_env", dom1);
					String taxAmt = genericUtility.getColumnValue("tax_amt",dom);
					String billAmt = genericUtility.getColumnValue("bill_amt",dom2, "2");
					// added by Ramagya on 1/09/2020 [Start]
						billAmt = billAmt == null ? "0" : billAmt.trim();
						taxAmt =taxAmt == null ? "0" : taxAmt.trim();
						double billAmountDom = Double.parseDouble(billAmt);
						double taxAmtDom = Double.parseDouble(taxAmt);
						double netAmount = taxAmtDom + billAmountDom;
						String netAmount1 = Double.toString(netAmount);
						// added by Ramagya on 1/09/2020 [End]

					remarks = genericUtility.getColumnValue("remarks", dom1);
					System.out.println("-----Remarks For Detail 2--dom1--------------"+remarks);
					if (remarks == null)
						remarks = "";

					reqstrCode = genericUtility.getColumnValue("emp_code", dom1);
					reqstrCodeDescr = genericUtility.getColumnValue("emp_fname", dom1)+genericUtility.getColumnValue("emp_mname", dom1)+genericUtility.getColumnValue("emp_lname", dom1);

					String netAmt = genericUtility.getColumnValue("net_amt",dom);
					valueXmlString.append("<exp_date><![CDATA[").append(dtf.format(DateX)).append("]]></exp_date>");
					valueXmlString.append("<tax_class><![CDATA[").append((taxClass == null) ? "" : taxClass).append("]]></tax_class>\r\n");
					valueXmlString.append("<tax_chap><![CDATA[").append((taxChap == null) ? "" : taxChap).append("]]></tax_chap>\r\n");
					valueXmlString.append("<tax_env><![CDATA[").append((taxEnv == null) ? "" : taxEnv).append("]]></tax_env>\r\n");
					valueXmlString.append("<sundry_type><![CDATA[").append("E").append("]]></sundry_type>\r\n");

					valueXmlString.append("<tax_amt><![CDATA[").append((taxAmt == null) ? "0" : taxAmt).append("]]></tax_amt>");
					//valueXmlString.append("<net_amt><![CDATA[").append((netAmt == null) ? "0" : taxAmt + billAmt).append("]]></net_amt>");
					valueXmlString.append("<net_amt><![CDATA[").append((netAmt==null)?"0":netAmount1).append("]]></net_amt>"); // added by Ramagya on 1/09/2020

					// valueXmlString.append("<sundry_code protect =\"1\"><![CDATA[").append("").append("]]></sundry_code>\r\n")
					// ;
					// valueXmlString.append("<sundry_name protect =\"0\"><![CDATA[").append("").append("]]></sundry_name>\r\n")
					// ;

					valueXmlString.append("<sundry_code><![CDATA[").append(reqstrCode).append("]]></sundry_code>\r\n");
					valueXmlString.append("<sundry_name><![CDATA[").append(reqstrCodeDescr).append("]]></sundry_name>\r\n");

					valueXmlString.append("<apply_tax><![CDATA[").append("N").append("]]></apply_tax>\r\n");
					// --PRADEEP---BEGIN---04/04/08

					/**
					 * changes calculate the CCTR code on the basis of requestor
					 * code.
					 * */

					returnValue = getValueFromRefTable("EMPLOYEE", "EMP_CODE",reqstrCode, "CCTR_CODE__SAL", conn);
					valueXmlString.append("<cctr_code><![CDATA[").append(returnValue).append("]]></cctr_code>\r\n>");
					System.out.println("----Itemchange for CCTR code  - req code from header  "+reqstrCode);

					returnValue = getValueFromRefTable("COSTCTR", "CCTR_CODE",returnValue, "DESCR", conn);
					valueXmlString.append("<costctr_descr><![CDATA[").append(returnValue).append("]]></costctr_descr>\r\n");

					System.out.println("----ICCTR descr - returnValue   "+returnValue);

					sql = "SELECT VAR_VALUE, DESCR FROM FINPARM WHERE VAR_NAME='ADV_ACCT_CODE_FIELD '";
					if(stmt == null)
					{
						stmt=conn.createStatement();
					}
					rs = stmt.executeQuery(sql);
					String acctDescr = "";

					if (rs.next())
					{
						accValue = rs.getString("VAR_VALUE");
						acctDescr = rs.getString("DESCR");
					}
					closeRs(rs);//Added by Vikas L on 10-05-19
					valueXmlString.append("<acct_code><![CDATA[").append(accValue).append("]]></acct_code>\r\n");
					valueXmlString.append("<acct_descr><![CDATA[").append(acctDescr).append("]]></acct_descr>\r\n");
					valueXmlString.append("<remarks><![CDATA[").append(remarks).append("]]></remarks>\r\n");

					String tranType = genericUtility.getColumnValue(
							"tran_type", dom1);
					System.out.println("tranType : [" + tranType + "]");
					valueXmlString.append("<cc_tran_type><![CDATA[")
							.append(tranType).append("]]></cc_tran_type>\r\n");

				}
				/*
				 * if(currentColumn.trim().equals("sundry_type")) {
				 * if(columnValue.equals("O")) {
				 * valueXmlString.append("<sundry_code protect =\"1\" ><![CDATA["
				 * ).append("").append("]]></sundry_code>\r\n");
				 * valueXmlString.append
				 * ("<sundry_name  protect =\"0\" ><![CDATA["
				 * ).append("").append("]]></sundry_name>\r\n"); }
				 * 
				 * if(columnValue.equals("S")) {
				 * valueXmlString.append("<sundry_code protect =\"0\" ><![CDATA["
				 * ).append("").append("]]></sundry_code>\r\n");
				 * valueXmlString.append
				 * ("<sundry_name  protect =\"1\" ><![CDATA["
				 * ).append("").append("]]></sundry_name>\r\n"); }
				 * 
				 * } if (currentColumn.trim().equals("sundry_code")) {
				 * 
				 * returnValue=getValueFromRefTable("SUPPLIER","SUPP_CODE",
				 * columnValue,"SUPP_NAME",conn) ;
				 * valueXmlString.append("<sundry_name><![CDATA["
				 * ).append(returnValue).append("]]></sundry_name>\r\n");
				 * 
				 * }//eof sundry_code
				 */if (currentColumn.trim().equals("acct_code"))
				 {
					// valueXmlString.append(getItemChangeString(columnValue,"ACCT_CODE","acct_descr"
					// ,1 ,conn,"W_CASHVOUCHER"));
					String acctCode = genericUtility.getColumnValue("acct_code", dom);
					String tranType = genericUtility.getColumnValue("tran_type", dom1);
					acctCode = (acctCode == null) ? "" : acctCode.trim();
					System.out.println("acctCode : [" + acctCode + "]");
					System.out.println("tranType : [" + tranType + "]");
					String acctDescr = getAccountDescr(conn,"W_VOUCHER_ADVFIELD", "ACCT_CODE", acctCode,tranType);
					valueXmlString.append("<acct_descr><![CDATA[").append(acctDescr).append("]]></acct_descr>\r\n");
				}

				if (currentColumn.trim().equals("cctr_code"))
				{
					returnValue = getValueFromRefTable("COSTCTR", "CCTR_CODE",columnValue, "DESCR", conn);
					valueXmlString.append("<costctr_descr><![CDATA[").append(returnValue).append("]]></costctr_descr>\r\n");
				}

				if (currentColumn.trim().equals("anal_code"))
				{
					if (columnValue != null && columnValue.trim().length() > 0) 
					{
						sql = "	SELECT DESCR FROM GENCODES WHERE MOD_NAME='W_VOUCHER_ADVFIELD' AND FLD_NAME='ANAL_CODE' AND ACTIVE='Y' AND FLD_VALUE ='"
								+ columnValue + "'";
						if(stmt == null)
						{
							stmt=conn.createStatement();
						}
						rs = stmt.executeQuery(sql);
						String acctDescr = "";

						if (rs.next()) {
							acctDescr = rs.getString("DESCR");
						}
						 closeRs(rs);//Added By Vikas L on 10/05/19[End]
						valueXmlString.append("<analysis_descr><![CDATA[").append(acctDescr).append("]]></analysis_descr>\r\n");
					}
				}// END OF anal_code
				if (currentColumn.trim().equals("period_code")) 
				{
					if (columnValue != null && columnValue.trim().length() > 0) 
					{
						sql = "SELECT DDF_GET_PERIOD_DESCR('"+ columnValue.trim() + "') AS DESCR FROM DUAL ";
						if(stmt == null)
						{
							stmt=conn.createStatement();
						}
						rs = stmt.executeQuery(sql);
						String acctDescr = "";

						if (rs.next()) 
						{
							acctDescr = rs.getString("DESCR");
						}
						valueXmlString.append("<period_code_descr><![CDATA[").append(acctDescr).append("]]></period_code_descr>\r\n");
					}
				}// END OF anal_code
				if (currentColumn.trim().equals("bill_amt")) 
				{
					if (columnValue != null && columnValue.trim().length() > 0) 
					{
						valueXmlString.append("<amount><![CDATA[").append(columnValue == null ? "0.0": columnValue).append("]]></amount>\r\n");
						System.out.println("billAmount::::::::" + columnValue);
						// ---------------------------------------------------
						String taxAmt = genericUtility.getColumnValue("tax_amt", dom) == null ? "0.0" : genericUtility.getColumnValue("tax_amt", dom);
						valueXmlString.append("<tax_amt><![CDATA[").append((taxAmt == null) ? "0.0" : taxAmt).append("]]></tax_amt>");
						String netAmt = genericUtility.getColumnValue("net_amt", dom) == null ? "0.0" : genericUtility.getColumnValue("net_amt", dom);
						double taxAmtDom = Double.parseDouble(taxAmt);
						double billAmountDom = Double.parseDouble(columnValue);
						double netAmount = taxAmtDom + billAmountDom;
						String netAmount1 = Double.toString(netAmount);
						valueXmlString.append("<net_amt><![CDATA[").append((netAmt == null) ? "0" : netAmount1).append("]]></net_amt>");
					}
				}// end of bill_amt
				valueXmlString.append("</Detail2>\r\n");
				break;
			/*
			 * case 3:
			 * System.out.println("Case 3 of ITEMCHANGED::nCashVoucherEJB");
			 * valueXmlString.append("<Detail3>\r\n");
			 * System.out.println("*Before itm_default."); if
			 * (currentColumn.trim().equals("itm_default")) { String
			 * acct_code__conv =
			 * getValueFromFinparam("999999","DEFT_ACCT_CODE_CONV",conn);
			 * convAmt
			 * =e12GenericUtilityObj.getColumnValue("net_amt__conv",dom1,"1");
			 * System.out.println("convAmt:::::::"+convAmt);
			 * valueXmlString.append
			 * ("<conv_amt__acct><![CDATA[").append(convAmt==
			 * null?"":convAmt).append("]]></conv_amt__acct>");
			 * valueXmlString.append
			 * ("<conv_date><![CDATA[").append(dtf.format(DateX
			 * )).append("]]></conv_date>");
			 * valueXmlString.append("<conv_type><![CDATA["
			 * ).append("A").append("]]></conv_type>");
			 * valueXmlString.append("<reas_descr protect =\"1\" ><![CDATA["
			 * ).append("").append("]]></reas_descr>"); }
			 * if(currentColumn.trim().equals("conv_type")) {
			 * if(!columnValue.equalsIgnoreCase("T"))
			 * valueXmlString.append("<reas_descr protect =\"1\" ><![CDATA["
			 * ).append("").append("]]></reas_descr>"); else
			 * valueXmlString.append
			 * ("<reas_descr protect =\"0\" ><![CDATA[").append
			 * ("").append("]]></reas_descr>"); }
			 * if(currentColumn.equals("amount")) { double cumAmt=0.0;
			 * cumAmt=getNetCumAmt(dom2);
			 * totalCumulativeAmt=Double.toString(cumAmt);
			 * valueXmlString.append(
			 * "<conv_amt__cuml><![CDATA[").append((totalCumulativeAmt
			 * ==null)?"0":totalCumulativeAmt).append("]]></conv_amt__cuml>");
			 * convAmt
			 * =e12GenericUtilityObj.getColumnValue("net_amt__conv",dom1);
			 * double cnvAmt=Double.parseDouble(convAmt); double balAmt=0.0;
			 * balAmt=cnvAmt-cumAmt; balanceAmount=Double.toString(balAmt);
			 * valueXmlString
			 * .append("<conv_amt__baln><![CDATA[").append((balanceAmount
			 * ==null)?"0":balanceAmount).append("]]></conv_amt__baln>"); }
			 * valueXmlString.append("</Detail3>\r\n"); break;
			 */
			}// switch()
			valueXmlString.append("</Root>\r\n");
		} 
		catch (Exception e) 
		{
			System.out.println("Exception :[VoucherAdvField]While Getting Date Format"+ e.getMessage());
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
				//Added By Vikas L on 10/05/19[Start]
				if(stmt!=null) 
				{
					System.out.println("Inside Closing Statement...........");
					stmt.close();
					stmt=null;
				}
				//Added By Vikas L on 10/05/19[End]
			} catch (SQLException se)
			{
				System.out.println("inside finally" + se.getMessage());
				se.printStackTrace();
			}
		}
		return valueXmlString.toString();
	} // 23/04/07end of itemChanged()
		// ////////////////////////////

	private String getValueFromRefTable(String tableName, String fieldName,String fieldValue, String reqdField, Connection conn) 
	{
		Statement stmt = null;
		ResultSet rs = null;
		String returnValue = "";
		try
		{
			if (fieldValue == null)
				fieldValue = "";
			stmt = conn.createStatement();
			String sql = "SELECT " + reqdField + " FROM " + tableName+ " WHERE " + fieldName + " = '" + fieldValue + "'";
			rs = stmt.executeQuery(sql);
			if (rs.next())
				returnValue = rs.getString(1);
			rs.close();
			stmt.close();
		} 
		catch (Exception e) 
		{
			System.out.println("Inside getValueFromRefTable Exception *******"+ e.getMessage());
			e.printStackTrace();
		}
		if (returnValue == null)
			returnValue = "";
		return returnValue;
	}

	/*
	 * private String ValidateEmployee(String empCode,String
	 * dateToCompare,String errorCode1,String errorCode2 ,String
	 * errorCode3,Connection conn) { java.sql.Date relieveDate=null; String
	 * empCodeFromTable=""; String appDateFormat = ""; String dbDateFormat="";
	 * String errString=""; Statement stmt=null; ResultSet rs=null; String
	 * sql=""; try { appDateFormat= getApplDateFormat();
	 * dbDateFormat=getDBDateFormat(); } catch(Exception e) {
	 * System.out.println("Exception :Date Format"+e.getMessage()); }
	 * 
	 * java.text.SimpleDateFormat dtf= new SimpleDateFormat(appDateFormat);
	 * java.text.SimpleDateFormat sdfDatabase= new
	 * SimpleDateFormat(dbDateFormat); try { if(empCode !=null) {
	 * sql="select relieve_date ,emp_code  from employee where emp_code='"
	 * +empCode+"' "; stmt=conn.createStatement(); rs=stmt.executeQuery(sql);
	 * if(rs.next()) { relieveDate=rs.getDate(1);
	 * empCodeFromTable=rs.getString(2); } if(relieveDate != null) if(
	 * relieveDate.before(dtf.parse(dateToCompare)) ) { errString = errorCode1;
	 * } if( empCodeFromTable.equals("") ) { errString = errorCode2; } }//end of
	 * if else { errString = errorCode3; } } catch (Exception e) {
	 * System.out.println
	 * ("In the catch block  of validate employee"+e.getMessage()); errString =
	 * errorCode2; } return errString; }
	 */
	// ////////////////////////////

	private String getItemChangeString(String columnValue, String fieldName,String tagName, int identifier, Connection conn, String mod_name)
	{
		String stationDescr3 = "";
		String sql = "";
		int checkmodeNamePresent = 0;
		StringBuffer valueXmlString = new StringBuffer();
		ResultSet rs = null;
		Statement stmt = null;
		if (columnValue != null)
		{
			try
			{
				stmt = conn.createStatement();
				if (identifier == 1)
				{
					sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME='" + mod_name+ "' AND FLD_NAME='"+ fieldName + "' AND ACTIVE='Y' ";
					System.out.println("sql is ::" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next())
						checkmodeNamePresent = rs.getInt("COUNT");
					if (checkmodeNamePresent > 0)
						sql = " select descr from gencodes where mod_name = '"+ mod_name + "' and fld_name = '" + fieldName+ "' and active = 'Y' and fld_value = '"+ columnValue + "' ";
					else
						sql = " select descr from gencodes where mod_name = 'X' and fld_name = '"+ fieldName+ "' and active = 'Y' and fld_value = '"+ columnValue + "' ";
				}// eof if (identifier==1)
				else
					sql = "SELECT DESCR FROM STATION WHERE STAN_CODE ='"+ columnValue + "'  AND STAN_TYPE='I' ";
				rs = stmt.executeQuery(sql);
				if (rs.next())
				stationDescr3 = rs.getString(1) == null ? "" : rs.getString(1);
				valueXmlString.append("<" + tagName + ">").append("<![CDATA[" + stationDescr3 + "]]>").append("</" + tagName + ">");
				rs.close();
			}// end of try
			catch (Exception e)
			{
				System.out.println("Exception :[VoucherAdvField ][itemChanged::case 1::item_ser] :==>\n"+ e.getMessage());
			}// end of catch
			finally
			{
				try
				{
					stmt.close();
					System.out.println("connection is closed");
				} 
				catch (Exception exc)
				{
					exc.printStackTrace();
				}
			}// end of finally
		}// eof if
		else
		valueXmlString.append("<" + tagName + ">").append("<![CDATA[" + stationDescr3 + "]]>").append("</" + tagName + ">");
		System.out.println(" from method valueXmlString is : "+ valueXmlString.toString());
		return valueXmlString.toString();
	}// eof method
		// ////////////////////

	private String validateFromGencodes(String fieldValue, String mod_name,String fld_name, String errCode, String errCode2, String userId,Connection conn)
	{
		String sql = "";
		String errString = "";
		Statement stmt = null;
		ResultSet rs = null;
		int cnt = 0;
		int checkmodeNamePresent = 0;// if zero then there is no entry with the given mod name so check with mod name='X'
		try 
		{
			stmt = conn.createStatement();
			if (fieldValue != null)
			{
				// String fldValue =
				// childNode.getFirstChild().getNodeValue().trim();
				// //.trim();28/04/06
				sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME='"+ mod_name + "' AND FLD_NAME='" + fld_name+ "' AND ACTIVE='Y' ";
				System.out.println("sql is ::" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
					checkmodeNamePresent = rs.getInt("COUNT");
				System.out.println("checkmodeNamePresent ::"+ checkmodeNamePresent);
				if (checkmodeNamePresent > 0) 
				{
					sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = '"+ mod_name+ "' AND FLD_NAME = '"+ fld_name+ "' AND FLD_VALUE = '"+ fieldValue.trim()+ "' AND ACTIVE = 'Y'";
					System.out.println("sql is ::" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next()) 
					{
						cnt = rs.getInt("COUNT");
						System.out.println("inside " + mod_name+ " value of count =" + cnt);
					}
				}// end of if (checkmodeNamePresent>0)
				else 
				{
					sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = 'X' AND FLD_NAME = '"+ fld_name+ "' AND FLD_VALUE = '"+ fieldValue.trim() + "' AND ACTIVE = 'Y'";
					System.out.println("sql is ::" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next())
						cnt = rs.getInt("COUNT");
				} // end of else
				if (cnt == 0)
					errString = getErrorString(fld_name, errCode, userId);
			}// eof child
			else
			{
				System.out.println("Error: " + errCode2 + " field_name "+ fld_name + " userId " + userId+ " found in validateFromGencodes()");
				errString = getErrorString(fld_name, errCode2, userId);
			}
			stmt.close();
			stmt = null;
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return errString;
	}// end od valid from gencodes
		// Pradeep-----------BEGIN---------20/09/07
		// THIS METOD IS USED HERE TO GET THE VALUE FROM A TABLE

	int getCountMultivalue(String tableName, String fieldName1,String fieldName2, String fieldValue1, String fieldValue2,Connection conn) 
	{
		Statement stmt = null;
		ResultSet rs = null;
		int cnt = 0;
		try
		{
			System.out.println("fieldValue1" + fieldValue1);
			System.out.println("fieldValue2" + fieldValue2);
			if (fieldValue1 == null || fieldValue2 == null)
			{
				fieldValue1 = "";
				fieldValue2 = "";
			}
			stmt = conn.createStatement();
			String sql = "SELECT COUNT(*) AS COUNT FROM " + tableName+ " WHERE " + fieldName1 + " = '" + fieldValue1 + "' and "+ fieldName2 + " = '" + fieldValue2 + "'";
			rs = stmt.executeQuery(sql);
			if (rs.next())
				cnt = rs.getInt("COUNT");
			rs.close();
			stmt.close();
		}// end of try
		catch
		(Exception e)
		{
			System.out.println("Inside getCount Exception *******"+ e.getMessage());
			e.printStackTrace();
		}// end of catch
		return cnt;
	}

	// // Pradeep-----------END---------20/09/07
	// Arvind- begin
	int getCount(String tableName, String fieldName, String fieldValue,Connection conn) 
	{
		Statement stmt = null;
		ResultSet rs = null;
		int cnt = 0;
		try 
		{
			if (fieldValue == null)
				fieldValue = "";
			stmt = conn.createStatement();
			String sql = "SELECT COUNT(*) AS COUNT FROM " + tableName+ " WHERE " + fieldName + " = '" + fieldValue + "'";
			System.out.println("sql::" + sql);
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				cnt = rs.getInt("COUNT");
				System.out.println("************* COUNT IN  " + tableName+ " ********" + cnt);
			}
			rs.close();
			stmt.close();
		}// end of try
		catch (Exception e)
		{
			System.out.println("Inside getCount Exception *******"+ e.getMessage());
			e.printStackTrace();
		}// end of catch
		return cnt;
	}

	// Arvind- end
	// ///////////////////////////////
	// TO GET THE VALUE OF net_amt FOR THE ACCOUNT CODE THAT COMES FROM
	// CONVEYANCE ACCOUNT CODE
	private boolean getNetAmountForConvAcctCode(Document dom, Document dom1,Document dom2, String acct_code__conv, double amtConv) throws ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "", acctCode = "", netAmount = " ";
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		double netAmount1 = 0.0;
		boolean flag = false;
		parentNodeList = dom2.getElementsByTagName("Detail2");
		parentNodeListLength = parentNodeList.getLength();
		for (int rowCount = 0; rowCount < parentNodeListLength; rowCount++) 
		{
			parentNode = parentNodeList.item(rowCount);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (int childRow = 0; childRow < childNodeListLength; childRow++)
			{
				childNode = childNodeList.item(childRow);
				childNodeName = childNode.getNodeName();
				if (childNodeName.equals("net_amt")) 
				{
					if (childNode.getFirstChild() != null) 
					{
						netAmount = childNode.getFirstChild().getNodeValue();
						netAmount1 = Double.parseDouble(netAmount);
						System.out.println("netAmount1====>" + netAmount1);
						System.out.println("amtConv====>" + amtConv);
					}
				}// eof if
				if (childNodeName.equals("acct_code"))
				{
					if (childNode.getFirstChild() != null)
						acctCode = childNode.getFirstChild().getNodeValue();
				}// eof if acct_code
			}// close for loop
				// getNetAmountForConvAcctCode
			if (acctCode.trim().equals(acct_code__conv))
			{
				System.out.println("netAmount1>=amtConv===>"+ (netAmount1 >= amtConv));
				System.out.println("amtConv>=netAmount1===>"+ (amtConv >= netAmount1));
				if (netAmount1 >= amtConv) 
				{
					flag = true;
					return flag;
				}
			}
		}// eof outer for loop
		return flag;// totBillAmt
	}

	// ////////////THIS METHOD IS ADDED HERE TO CHECK IS THERE ANY DUPLICATE
	// ACCOUNT CODE IN THE SAME FORM

	// //PRADEEP////////// BEGIN/13/09/07
	private String getAccountCode(Document dom2, String lineNo, String acctCode) throws ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String currentAcctCode = "0000";
		String domAcctCode = "0";
		String updateFlag = "";
		String domLineNo = "";
		parentNodeList = dom2.getElementsByTagName("Detail2");
		parentNodeListLength = parentNodeList.getLength();
		for (int rowCount = 0; rowCount < parentNodeListLength; rowCount++) 
		{
			parentNode = parentNodeList.item(rowCount);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (int childRow = 0; childRow < childNodeListLength; childRow++)
			{
				childNode = childNodeList.item(childRow);
				childNodeName = childNode.getNodeName();
				if (childNodeName.equals("acct_code")) 
				{
					if (childNode.getFirstChild() != null)
						domAcctCode = childNode.getFirstChild().getNodeValue().trim();
				} // eof if acct_code
				if (childNodeName.equals("line_no")) 
				{
					if (childNode.getFirstChild() != null)
						domLineNo = childNode.getFirstChild().getNodeValue().trim();
				} // eof if line_no
				if (childNodeName.equals("attribute"))
				{
					System.out.println("childNodeName=====>" + childNodeName);
					System.out.println("childNodeList=>"+ childNode.getAttributes().getNamedItem("updateFlag"));
					updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					System.out.println("updateFlag===2222=====>" + updateFlag);
				}
			} // eof for inner
			if ((!domLineNo.trim().equalsIgnoreCase(lineNo)) && (!updateFlag.equals("D")))
			{
				if (domAcctCode.equalsIgnoreCase(acctCode))
				{
					currentAcctCode = acctCode;
					break;
				}
			}// END OF IF
		} // eof for outer
		return currentAcctCode;
	}

	// getAccountcode

	/*
	 * //Haneesh 30/10/09 commented because now submit button is added, so no
	 * need of presave ////PRADEEP//
	 * END////13/09/07/////////////////////////////10/09/08 public String
	 * preSave(String xmlString, String editFlag, String xtraParams, Connection
	 * conn) throws RemoteException,ITMException { Document dom=null; dom =
	 * parseString(xmlString);
	 * System.out.println("value of edit flag is :::::::::: "+editFlag);
	 * System.out.println(
	 * "?????????????this is from preSave method  to check whether it is called or not??????????????"
	 * ); return ""; } //////////////////04/10/2007/////////////pradeep //THIS
	 * METHOD IS CALLED BEFORE WE SAVE A TRANSACTION // public String
	 * preSaveRec(String xmlString, String xmlString1,String xmlString2, String
	 * objContext, String editFlag, Connection conn ,String xtraParam) throws
	 * RemoteException,ITMException public String preSaveRec(String xmlString,
	 * String xmlString1,String xmlString2, String editFlag, String xtraParam,
	 * Connection conn ,String objContext) throws RemoteException,ITMException {
	 * //pradeep 12/11/08 begin Document dom = null; Document dom1 = null;
	 * Document dom2 = null; dom = parseString(xmlString); dom1 =
	 * parseString(xmlString1); dom2 = parseString(xmlString2); String status =
	 * ""; String errString=""; e12GenericUtilityObj e12GenericUtilityObj =
	 * e12GenericUtilityObj.getInstance(); status =
	 * e12GenericUtilityObj.getColumnValue("status",dom);
	 * System.out.println("status in presaverec --> "+status); if
	 * (status.equals("O") ) {
	 * System.out.println("status is o so skipping presaverec"); } else {
	 * //pradeep 12/11/08 end String
	 * sgDescription="",msgDescription1="",acct_code__conv =
	 * "",lineNo="",tranId="",sql=""; double amountConvence =0.0; boolean isForm
	 * = false; boolean bothForm = false; String userId =
	 * getValueFromXTRA_PARAMS(xtraParam,"userId"); boolean flag = false;
	 * PreparedStatement prStmt=null; acct_code__conv =
	 * getValueFromFinparam("999999","DEFT_ACCT_CODE_CONV",conn); amountConvence
	 * = isOthAmountSameConvAmts(dom,dom2);
	 * System.out.println("amountConvence====>"+amountConvence);
	 * System.out.println("objContext====>"+objContext);
	 * System.out.println("editFlag====>"+editFlag);
	 * System.out.println("xtraParam====>"+xtraParam); /*THIS IS USED HERE IS
	 * THERE ANY ACCT_CODE IS AVAILABLE IN THE DETAIL 2 OR NOT IF ACCT_CODE IS
	 * AVAILABE THEN IT CHECK THE AMOUNT AVAILABE IN THE DETAIL3.IF ACCT_CODE
	 * THAT COMES FROM FINPARM IS NOT AVAILABE THEN THE FORM IS SAVED OTHER WISE
	 * IT SHOWS THE ERROR
	 */
	// e12GenericUtilityObj e12GenericUtilityObj =
	// e12GenericUtilityObj.getInstance();
	// System.out.println("editFlag1:::::"+editFlag);
	// anil added 21-10-08:begin
	// Checking detail 1 and detail 2 page is empty then it gives error .
	/*
	 * bothForm =checkBlankFormsAllDetails(dom2,dom,dom1); if (bothForm == true)
	 * { errString = getErrorString("status", "VTRLNM1", userId);
	 * System.out.println("errString"+errString); //return errString; throw new
	 * ITMException(new Exception(errString));
	 * 
	 * // then exception could display in eclipse if above line is comented }
	 * //anil aded 21-10-08:end isForm
	 * =isSubmitExpense(dom2,dom,dom1,acct_code__conv);//THIS IS USED HERE TO
	 * CHECK THE AMOUNT IS SAME OR NOT IN BOTH 2 & 3 FORMS.
	 * System.out.println("isForm:::::::::::"+isForm); ////// if true : Amount
	 * Not Matching ////////////////////// if (isForm == true) { errString =
	 * getErrorString("status", "VTAMOUNT4", userId);
	 * System.out.println("errString"+errString); throw new ITMException(new
	 * Exception(errString)); }
	 * 
	 * }//pradeep 12/11/08 return errString; }
	 */
	// 04/10/2007///pradeep
	// //////////////////////////10/09/08
	// ========Pradeep===begin====06/11/09
	public String postValData(String xmlString, String xmlString1,
			String xmlString2, String objContext, String winName,
			String xtraParam) throws RemoteException, ITMException {
		return "";
	}

	// ========Pradeep===end=====06/11/09
	// THIS METHOD IS USED HERE TO GET A VALUE FROM FINPARM TABLE

	private String getValueFromFinparam(String prdCode, String varName,Connection conn) throws ITMException 
	{
		String returnValue = "";
		String sql = "";
		ResultSet rs = null;
		Statement stmt = null;
		try 
		{
			stmt = conn.createStatement();
			sql = "SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE ='" + prdCode+ "' AND VAR_NAME ='" + varName + "'";
			System.out.println("sql of fin praram" + sql);
			rs = stmt.executeQuery(sql);
			if (rs.next()) 
			{
				returnValue = rs.getString(1);
			} 
			else 
			{
				returnValue = "NULLFOUND";
			}
			if (stmt != null)
				stmt.close();
		}// eof try
		catch (Exception e)
		{
			throw new ITMException(e);
		}// eof catch
		return (returnValue);
	}

	// ------------------pradeep--17/09/07-----begin

	private double getAmount(Document dom2) throws ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		String childNodeName = "";
		String amount = "0";
		String updateFlag = "";// pradeep 11/11/08

		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		double amount1 = 0;
		double totAmt = 0;

		parentNodeList = dom2.getElementsByTagName("Detail3");
		parentNodeListLength = parentNodeList.getLength();
		System.out.println("parentNodeListLength=1811==>"
				+ parentNodeListLength);
		for (int rowCount = 0; rowCount <= parentNodeListLength - 1; rowCount++)
		{
			parentNode = parentNodeList.item(rowCount);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (int childRow = 0; childRow < childNodeListLength; childRow++) 
			{
				childNode = childNodeList.item(childRow);
				childNodeName = childNode.getNodeName();
				// pradeep 11/11/08 begin
				if (childNodeName.equals("attribute")) 
				{
					updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					System.out.println("updateFlag===>" + updateFlag);
				}
				if (!updateFlag.equals("D")) 
				{
					// pradeep 11/11/08 end
					if (childNodeName.equals("amount"))
					{
						if (childNode.getFirstChild() != null)
						{
							amount = childNode.getFirstChild().getNodeValue();
							amount1 = Double.parseDouble(amount);
							System.out.println("amount==>" + amount1);
							totAmt = totAmt + amount1;
							System.out.println("totAmt==>" + totAmt);
						}
					}
				}// pradeep 11/11/08
			}// inner loop
		}// close for outer loop
		return totAmt;
	}// getAmount

	/*
	 * //Haneesh 30/10/09 commented because now not using this method //anil
	 * added 21-10-08:begin private boolean checkBlankFormsAllDetails(Document
	 * dom2,Document dom,Document dom1) throws ITMException { NodeList
	 * parentNodeList2 = null; NodeList parentNodeList3 = null; NodeList
	 * childNodeList = null; Node parentNode = null; Node childNode = null;
	 * String childNodeName = ""; int parentNodeListLength2 = 0; int
	 * parentNodeListLength3 = 0; int childNodeListLength = 0; String
	 * returnValue=""; boolean flag = false; String status =""; parentNodeList2
	 * = dom2.getElementsByTagName("Detail2"); parentNodeList3 =
	 * dom2.getElementsByTagName("Detail3"); parentNodeListLength2 =
	 * parentNodeList2.getLength();
	 * System.out.println("parentNodeListLength2=oo=="+parentNodeListLength2);
	 * parentNodeListLength3 = parentNodeList3.getLength();
	 * System.out.println("parentNodeListLength3=oo="+parentNodeListLength3);
	 * e12GenericUtilityObj e12GenericUtilityObj =
	 * e12GenericUtilityObj.getInstance();
	 * status=e12GenericUtilityObj.getColumnValue("status",dom);
	 * System.out.println
	 * ("status==DOM1========>"+e12GenericUtilityObj.getColumnValue
	 * ("status",dom1,"1")); System.out.println("status=========oooo=>"+status);
	 * if (status.equals("S")) { System.out.println("inside stastus "+status);
	 * try{ System.out.println("inside stastus=== "+status); if
	 * ((parentNodeListLength3 == 0)&&(parentNodeListLength2==0)) {
	 * System.out.println("inside stastus//////???? "+status); flag = true; } }
	 * catch(Exception e) {
	 * System.out.println("Exception Arises. in ..checkBlankFormsallDetails.."
	 * +e); e.printStackTrace(); }
	 * 
	 * }//end if
	 * 
	 * return flag; } //anil added 21-10-08:end
	 * ////--------------pradeep-----------begin-----------01/10/02007
	 * 
	 * private boolean isSubmitExpense(Document dom2,Document dom,Document
	 * dom1,String acct_code__conv) throws ITMException { NodeList
	 * parentNodeList2 = null; NodeList parentNodeList3 = null; NodeList
	 * childNodeList = null; Node parentNode = null; Node childNode = null;
	 * String childNodeName = ""; int parentNodeListLength2 = 0; int
	 * parentNodeListLength3 = 0; int childNodeListLength = 0; String acctCode =
	 * ""; boolean flag = false; parentNodeList2 =
	 * dom2.getElementsByTagName("Detail2"); parentNodeList3 =
	 * dom2.getElementsByTagName("Detail3"); e12GenericUtilityObj
	 * e12GenericUtilityObj = e12GenericUtilityObj.getInstance();
	 * //==========pradeep===04/06/08 double totAmountConvFrmDet3=0.0;//pradeep
	 * String netAmount="";//pradeep double convAmtFrmDet2=0.0;//pradeep
	 * //==========pradeep===04/06/08 parentNodeListLength2 =
	 * parentNodeList2.getLength(); parentNodeListLength3 =
	 * parentNodeList3.getLength();
	 * System.out.println("parentNodeListLength2====>"+parentNodeListLength2);
	 * if (parentNodeListLength2 > 0) { if (checkIsDeleteForm(dom2,"Detail2")) {
	 * System.out.println(
	 * "There is only one record in Detail 2 and that is already deleted. ");
	 * flag = true; return flag; } convAmtFrmDet2 =
	 * getNetAmtFrmDom(dom2,acct_code__conv);
	 * System.out.println("Conveyance Amount from Detail 2 '"
	 * +convAmtFrmDet2+"'");
	 * System.out.println("checkIsDeleteForm2 "+(checkIsDeleteForm
	 * (dom2,"Detail2")));
	 * System.out.println("parentNodeListLength3====>"+parentNodeListLength3);
	 * System
	 * .out.println("checkIsDeleteForm3 "+(checkIsDeleteForm(dom2,"Detail3")));
	 * if (convAmtFrmDet2 <= 0 ) { if (parentNodeListLength3 == 0) {
	 * System.out.println(
	 * "There is no Conveyence Account in Detail2 and no record in Detail 3 so skipping the rest of process "
	 * ); } else if (parentNodeListLength3 > 0 &&
	 * checkIsDeleteForm(dom2,"Detail3") ) { System.out.println(
	 * "There is no Conveyence Account in Detail2 and no record in Detail 3 so skipping the rest of process ** "
	 * ); } else if (parentNodeListLength3 > 0 ) { System.out.println(
	 * "There is no Conveyence Account in Detail2 but there is detail entry in Detail 3 so Should not allow to submit"
	 * ); flag = true; return flag; } } else { if (parentNodeListLength3 > 0) {
	 * totAmountConvFrmDet3=getAmount(dom2);
	 * System.out.println("Total amount from Detail 3 "+totAmountConvFrmDet3);
	 * if ( convAmtFrmDet2 != totAmountConvFrmDet3 ) { return true; } else {
	 * System.out.println("Success.....Congratulation Saving the record"); } }
	 * else { System.out.println("There is no record in Detail3"); return true;
	 * } } } else {
	 * System.out.println("Inside the else of parent node list lenngth2"); flag
	 * = true; } return flag; }//end of method
	 * ////--------------pradeep-----------end-----------01/10/2007
	 * //--------------pradeep-------------begin---------03/10/2007
	 * 
	 * private double isOthAmountSameConvAmts(Document dom,Document dom2) throws
	 * ITMException { NodeList parentNodeList = null; NodeList childNodeList =
	 * null; Node parentNode = null; Node childNode = null; String childNodeName
	 * = ""; int parentNodeListLength = 0; int childNodeListLength = 0; double
	 * amount1=0.0; boolean flag = false; double totAmount = 0.0; String
	 * amount=" "; String updateFlag = ""; parentNodeList =
	 * dom2.getElementsByTagName("Detail3"); parentNodeListLength =
	 * parentNodeList.getLength(); for(int rowCount = 0; rowCount <
	 * parentNodeListLength; rowCount++) { parentNode =
	 * parentNodeList.item(rowCount); childNodeList =
	 * parentNode.getChildNodes(); childNodeListLength =
	 * childNodeList.getLength(); for (int childRow = 0; childRow <
	 * childNodeListLength; childRow++) { childNode =
	 * childNodeList.item(childRow); childNodeName = childNode.getNodeName();
	 * //pradeep 11/11/08 begin if (childNodeName.equals("attribute")) {
	 * updateFlag
	 * =childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
	 * System.out.println("updateFlag===3333=====>"+updateFlag); } //pradeep
	 * 11/11/08 end if (childNodeName.equals("amount")) { if
	 * (!updateFlag.equals("D")) { if(childNode.getFirstChild() != null) {
	 * amount= childNode.getFirstChild().getNodeValue(); amount1 =
	 * Double.parseDouble(amount); } } } }//inner loop totAmount = totAmount +
	 * amount1; System.out.println("total amount!!!!!!!!!!!!45===!"+totAmount);
	 * }//outer loop return totAmount; }
	 */
	// -----------------------------------------------------------
	private boolean getBillNoValidate(Document dom, Document dom2,Connection con)
	{
		boolean unitFlag = false;
		try 
		{
			Node childNode = null;
			Node parentNode = null;
			NodeList childNodeList = null;
			NodeList parentNodeList = null;

			String lineNoDom = genericUtility.getColumnValue("line_no", dom).trim();
			String childNodeName = "", billno = "", lineno = "", sundryCode = "", billDate = "";
			String billNoDom = genericUtility.getColumnValue("bill_no", dom);
			String billDateDom = genericUtility.getColumnValue("bill_date", dom) == null ? "" : genericUtility.getColumnValue("bill_date", dom);

			int ParentLen = 0;
			int childNodeListLen = 0;

			String sundryCodeDom = genericUtility.getColumnValue("sundry_code",dom) == null ? "" : genericUtility.getColumnValue("sundry_code", dom);
			String updateFlag = "";
			System.out.println("sundryCodeDom---->" + sundryCodeDom);
			System.out.println("billDateDom........" + billDateDom);
			parentNodeList = dom2.getElementsByTagName("Detail2");
			ParentLen = parentNodeList.getLength();
			boolean flag = true;
			for (int j = 0; j < ParentLen; j++) 
			{
				parentNode = parentNodeList.item(j);
				childNodeList = parentNode.getChildNodes();
				childNodeListLen = childNodeList.getLength();
				for (int i = 0; i < childNodeListLen; i++) 
				{
					childNode = childNodeList.item(i);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals("attribute"))
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					if (childNodeName.equals("bill_no"))
					{
						if (childNode.getFirstChild() != null)
							billno = childNode.getFirstChild().getNodeValue();
						else
							billno = "";
					}
					if (childNodeName.equals("line_no"))
					{
						if (childNode.getFirstChild() != null)
							lineno = childNode.getFirstChild().getNodeValue();
					}
					if (childNodeName.equals("sundry_code")) 
					{
						if (childNode.getFirstChild() != null)
							sundryCode = childNode.getFirstChild().getNodeValue();
						else
							sundryCode = "";
					}
					if (childNodeName.equals("bill_date")) 
					{
						if (childNode.getFirstChild() != null)
						{
							billDate = childNode.getFirstChild().getNodeValue();
							System.out.println("billDate......" + billDate);
						}
						else 
						{
							billDate = "";
							System.out.println("Inside else");
						}
					}
				}// eof for inner loop
				System.out.println("updateFlag========>" + updateFlag);
				if (!lineNoDom.trim().equalsIgnoreCase(lineno) && !updateFlag.equals("D")) 
				{
					if (!billDateDom.trim().equalsIgnoreCase(billDate))
						unitFlag = true;
					else
					{
						if (sundryCode.trim().equalsIgnoreCase(sundryCodeDom))
						{
							if (billno.equalsIgnoreCase(billNoDom))
							{
								unitFlag = false;
								break;
							}
						}
					}
				}// EOF LINE NO IF
				else
					unitFlag = true;
			}// eof for outer loop
		}// eof try
		catch (Exception e) 
		{
			System.out.println("Exception occures in xmlDocument :" + e);
			e.printStackTrace();
		}
		return unitFlag;
	}// eof of method
		// ------------------------pradeep------------end-----27/10/07

	/*
	 * //Haneesh 30/10/09 commented because this method is currently not using
	 * //!!!!!!!!!!!!!!!!!!!!PRADEEP!!!!!!!!!!!BEGIN!!!!!06/11/07 private
	 * boolean getBillNoCountFrommiscVoucher(Document dom,Connection conn) {
	 * Statement stmt = null; ResultSet rs = null; int count =0; boolean
	 * miscFlag=true; try { String billno=""; String sundryCode=""; String
	 * tranId=""; String billDate=""; e12GenericUtilityObj e12GenericUtilityObj
	 * = e12GenericUtilityObj.getInstance(); billno =
	 * e12GenericUtilityObj.getColumnValue("bill_no",dom); billDate =
	 * e12GenericUtilityObj.getColumnValue("bill_date",dom);
	 * sundryCode=e12GenericUtilityObj.getColumnValue("sundry_code",dom);
	 * System.out.println("sundryCode...."+sundryCode); stmt =
	 * conn.createStatement(); String sql=
	 * "SELECT COUNT(*) AS COUNT FROM MISC_VOUCHDET WHERE MISC_VOUCHDET.BILL_DATE =TO_DATE('"
	 * +
	 * billDate+"','DD/MM/YY') AND MISC_VOUCHDET.SUNDRY_CODE__FOR = '"+sundryCode
	 * +"'AND MISC_VOUCHDET.BILL_NO='"+billno+"'"; rs = stmt.executeQuery(sql);
	 * if (rs.next()) { count = rs.getInt("COUNT"); } if (count != 0) { miscFlag
	 * = false; } else { miscFlag = true; } }// eof try
	 * 
	 * catch(Exception e) {
	 * System.out.println("Inside getBillNoCountFrommiscVoucher Exception *******"
	 * +e.getMessage()); e.printStackTrace(); } return miscFlag; }
	 */
	// -----------------------pradeep--------begin----13/11/07
	private double checkNetAmount(Document dom, Document dom2, Connection conn)throws ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		String childNodeName = "";
		String netAmount = "";

		int childNodeListLength = 0;
		int ctr = 0;
		int ParentLen = 0;
		double netAmount1 = 0.0;
		double totNetAmount = 0.00;

		parentNodeList = dom2.getElementsByTagName("Detail2");
		ParentLen = parentNodeList.getLength();
		// e12GenericUtilityObj genericUtilty =
		// e12GenericUtilityObj.getInstance();
		for (int j = 0; j < ParentLen; j++)
		{
			parentNode = parentNodeList.item(j);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				if (childNodeName.equals("net_amt")) 
				{
					if (childNode.getFirstChild() != null) 
					{
						netAmount = childNode.getFirstChild().getNodeValue();
						// netAmount = genericUtilty.getColumnValue("net_amt",dom);
						System.out.println("netAmount====>" + netAmount);
						netAmount1 = Double.parseDouble(netAmount);
						totNetAmount = totNetAmount + netAmount1;
					}
				}
			}// inner for loop
		}// outer loop
		return totNetAmount;
	}

	// -----------------------pradeep--------end----13/11/07
	// ---------------PRADEEP--------BEGIN----23/11/07
	// THE METOD IS ADDED HERE TO CALCULATE THE TOTAL AMOUNT OF CONVEYANCE
	private double getNetCumAmt(Document dom2) throws ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		String childNodeName = "";
		String fieldValue = null;
		String updateFlag = "";// pradeep 09/05/08

		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		double amount = 0.0;
		double totcumAmount = 0.0;

		parentNodeList = dom2.getElementsByTagName("Detail3");
		parentNodeListLength = parentNodeList.getLength();
		for (int rowCount = 0; rowCount < parentNodeListLength; rowCount++) 
		{
			parentNode = parentNodeList.item(rowCount);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (int childRow = 0; childRow < childNodeListLength; childRow++)
			{
				childNode = childNodeList.item(childRow);
				childNodeName = childNode.getNodeName();
				// ===============PRADEEP====BEGIN=====09/05/08
				if (childNodeName.equals("attribute")) 
				{
					updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					System.out.println("updateFlag=====>[" + updateFlag + "]");
					if (updateFlag.equals("D"))
						break;
				}
				// ===============PRADEEP====END====09/05/08
				if (childNodeName.equals("amount")) 
				{
					if (childNode.getFirstChild() != null) 
					{
						fieldValue = childNode.getFirstChild().getNodeValue();
						amount = Double.parseDouble(fieldValue);
						totcumAmount = totcumAmount + amount;
					}// eof if childnode
				}// eof if childnodename
			}
			System.out.println("totcumAmount=====>[" + totcumAmount + "]");
		}
		return totcumAmount;
	}// eof getNetCumAmt method

	/*
	 * //THIS METHOD IS USED HERE TO GET THE UPDATE FLAG
	 * //================pradeep======begin====27/04/08 public String
	 * getUpdateFlag(Document dom2) { NodeList parentNodeList,childNodeList=
	 * null; Node parentNode,childNode = null; String childNodeName = ""; int
	 * parentNodeListLength,childNodeListLength = 0; String updateFlag="";
	 * parentNodeList = dom2.getElementsByTagName("Detail3");
	 * parentNodeListLength = parentNodeList.getLength();
	 * System.out.println("parentNodeListLength==33333===>"
	 * +parentNodeListLength); for(int rowCount = 0; rowCount <
	 * parentNodeListLength; rowCount++) { parentNode =
	 * parentNodeList.item(rowCount); childNodeList =
	 * parentNode.getChildNodes(); childNodeListLength =
	 * childNodeList.getLength(); for (int childRow = 0; childRow <
	 * childNodeListLength; childRow++) { childNode =
	 * childNodeList.item(childRow); childNodeName = childNode.getNodeName(); if
	 * (childNodeName.equals("attribute")) {
	 * updateFlag=childNode.getAttributes()
	 * .getNamedItem("updateFlag").getNodeValue();
	 * System.out.println("updateFlag===3333=====>"+updateFlag); } } } return
	 * updateFlag; } //================pradeep======end====27/04/08
	 * //================pradeep======begin====27/04/08 public String
	 * getUpdateFlagDetail(Document dom2) { NodeList
	 * parentNodeList,childNodeList= null; Node parentNode,childNode = null;
	 * String childNodeName = ""; int parentNodeListLength,childNodeListLength =
	 * 0; String updateFlag=""; parentNodeList =
	 * dom2.getElementsByTagName("Detail2"); parentNodeListLength =
	 * parentNodeList.getLength(); for(int rowCount = 0; rowCount <
	 * parentNodeListLength; rowCount++) { parentNode =
	 * parentNodeList.item(rowCount); childNodeList =
	 * parentNode.getChildNodes(); childNodeListLength =
	 * childNodeList.getLength();
	 * 
	 * for (int childRow = 0; childRow < childNodeListLength; childRow++) {
	 * childNode = childNodeList.item(childRow); childNodeName =
	 * childNode.getNodeName(); if (childNodeName.equals("attribute")) {
	 * updateFlag
	 * =childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
	 * System.out.println("updateFlag===2222=====>"+updateFlag); } } } return
	 * updateFlag; }
	 */
	// Haneesh 03/11/09 begin
	private int getDetailLength(Document dom, String Detail) 
	{
		NodeList parentNodeList, childNodeList = null;
		Node parentNode, childNode = null;
		String updateFlag = "";
		String childNodeName = "";
		int count = 0, parentNodeListLength = 0, childNodeListLength = 0;
		try 
		{
			parentNodeList = dom.getElementsByTagName(Detail);
			parentNodeListLength = parentNodeList.getLength();
			for (int rowCount = 0; rowCount < parentNodeListLength; rowCount++)
			{
				parentNode = parentNodeList.item(rowCount);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (int childRow = 0; childRow < childNodeListLength; childRow++) 
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals("attribute")) 
					{
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						break;
					}
				}
				if (!updateFlag.equals("D"))
					count = count + 1;
			}
		} 
		catch (Exception ex) 
		{
			System.out.println("Exception - " + ex.getMessage());
			ex.printStackTrace();
		}
		return count;
	}

	// Haneesh 03/11/09 end
	// ================pradeep======end====27/04/08
	/*
	 * //Haneesh 30/10/09 commented because now this msg is not using
	 * //!!!!!!!!!!!!!!!!!!!!PRADEEP!!!!!!!!!!!END!!!!!06/11/07
	 * //=========================== 25/05/07============================ public
	 * double getNetAmtFrmDom(Document dom, String acct_code__conv) { NodeList
	 * parentNodeList,childNodeList= null; Node parentNode,childNode = null;
	 * String childNodeName = ""; String acctCode = ""; double netAmt = 0.0;
	 * String updateFlag = ""; int parentNodeListLength = 0, childNodeListLength
	 * = 0; parentNodeList = dom.getElementsByTagName("Detail2");
	 * parentNodeListLength = parentNodeList.getLength(); for (int rowCount = 0;
	 * rowCount < parentNodeListLength; rowCount++) { parentNode =
	 * parentNodeList.item(rowCount); childNodeList =
	 * parentNode.getChildNodes(); childNodeListLength =
	 * childNodeList.getLength(); for (int childRow = 0; childRow <
	 * childNodeListLength; childRow++) { childNode =
	 * childNodeList.item(childRow); childNodeName = childNode.getNodeName(); if
	 * (childNodeName.equals("attribute")) {
	 * updateFlag=childNode.getAttributes()
	 * .getNamedItem("updateFlag").getNodeValue(); } if
	 * (!updateFlag.equals("D")) { if (childNodeName.equals("acct_code")) {
	 * acctCode = childNode.getFirstChild().getNodeValue().trim(); } if
	 * (childNodeName.equals("net_amt")) {
	 * System.out.println("acct_code__conv ["
	 * +acct_code__conv+"] : acctCode ["+acctCode+"]"); if
	 * (acct_code__conv.equals(acctCode)) { netAmt =
	 * Double.parseDouble(childNode.getFirstChild().getNodeValue());
	 * System.out.println("returning net amount from inner loop "+netAmt);
	 * return netAmt; } } } else {
	 * System.out.println("updateFlag in getNetAmtFrmDom"+updateFlag); }
	 * }//inner for loop }//outer for loop
	 * System.out.println("returning net amount from outer loop "+netAmt);
	 * return netAmt; } public boolean checkIsDeleteForm(Document dom2,String
	 * detail) { NodeList parentNodeList,childNodeList= null; Node
	 * parentNode,childNode = null; String childNodeName = ""; String updateFlag
	 * = ""; int childNodeListLength = 0,parentNodeListLength=0,count=0;
	 * parentNodeList = dom2.getElementsByTagName(detail); parentNodeListLength
	 * = parentNodeList.getLength(); for (int rowCount = 0; rowCount <
	 * parentNodeListLength; rowCount++) { parentNode =
	 * parentNodeList.item(rowCount); childNodeList =
	 * parentNode.getChildNodes(); childNodeListLength =
	 * childNodeList.getLength(); for (int childRow = 0; childRow <
	 * childNodeListLength; childRow++) { childNode =
	 * childNodeList.item(childRow); childNodeName = childNode.getNodeName(); if
	 * (childNodeName.equals("attribute")) {
	 * updateFlag=childNode.getAttributes()
	 * .getNamedItem("updateFlag").getNodeValue(); } } if
	 * (updateFlag.equals("D")) { count=count+1;
	 * System.out.println("count.."+count); } }//innner for loop if (count ==
	 * parentNodeListLength) { return true; } return false; }
	 */

	// Haneesh 24/11/09 begin : purpose - if line no sequence is not proper,
	// then for updating the line no sequence properly.
	// If Line no is not in sequential order then it will cause Null Pointer
	// exception while submitting the transaction

	public String postSave() throws RemoteException, ITMException {
		return "";
	}

	public String postSave(String xmlString, String xmlString1,String xmlString2, String objContext, String xtraParams,Connection conn) throws RemoteException, ITMException 
	{
		System.out.println("- - - - - - - In Post Save start -----");
		PreparedStatement pstmt = null, pstmt1 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs = null;
		String sql = "", sql1 = "";
		String tranId = "";
		String billAmt = "";
		String taxAmt = "";
		String netAmt = "";
		String updateFlag = "";
		String exchRate = "";
		String acctCode = "";
		String accValue = "";
		String netAmtConvVal = "0";
		Document headerDoc = null;
		headerDoc = parseString(xmlString1);
		Document domStr = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node childNode = null;
		Node parentNode = null;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String childNodeName = "";
		Statement stmt = null;
		String sundryType="",status="";
		String userId = getValueFromXTRA_PARAMS(xtraParams, "userId");
		try
		{
			System.out.println(" All Doms xmlString2 ----->" + xmlString2);
			exchRate = genericUtility.getColumnValue("exch_rate", headerDoc);
			System.out.println("exchRate --> " + exchRate);
			stmt = conn.createStatement();

			System.out.println("- - - - - - - - - - - - - - -F o r D e t a i l 2- - - - - - - - - - - - - - -");
			if (xmlString2 != null && xmlString2.trim().length() != 0)
			{
				domStr = parseString(xmlString2);
			}
			String empCode = genericUtility.getColumnValue("emp_code", domStr,"1");
			parentNodeList = null;
			parentNodeList = domStr.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();

			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++) 
			{
				String period_code = "";
				int cnt = 0;
				parentNode = parentNodeList.item(selectedRow);

				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					updateFlag = getAttribValue(parentNode, "attribute","updateFlag"); // (parentNode, "attribute",// "status"));

					if (!updateFlag.equalsIgnoreCase("D")) 
					{
						if ("tran_id".equalsIgnoreCase(childNodeName)) 
						{
							tranId = childNode.getFirstChild().getNodeValue().trim();
						}
						if ("bill_amt".equalsIgnoreCase(childNodeName)) 
						{
							billAmt = checkNull(childNode.getFirstChild().getNodeValue()).trim();
						}
						if ("tax_amt".equalsIgnoreCase(childNodeName)) 
						{
							taxAmt = checkNull(childNode.getFirstChild().getNodeValue()).trim();
						}
						if ("net_amt".equalsIgnoreCase(childNodeName))
						{
							netAmt = checkNull(childNode.getFirstChild().getNodeValue()).trim();
						}

						if ("acct_code".equalsIgnoreCase(childNodeName)) 
						{
							acctCode = checkNull(childNode.getFirstChild().getNodeValue()).trim();
						}

						if ("period_code".equalsIgnoreCase(childNodeName)) 
						{
							period_code = checkNull(childNode.getFirstChild().getNodeValue()).trim();
						}
					}

				}
				period_code = null;
			}

			sql = "SELECT VAR_VALUE FROM FINPARM WHERE VAR_NAME='ADV_ACCT_CODE_FIELD '";
			rs = stmt.executeQuery(sql);

			if (rs.next()) {
				accValue = rs.getString("VAR_VALUE");

			}
			System.out.println("accValue>>>"+accValue);

			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			if (acctCode.equalsIgnoreCase(accValue)) 
			{
				netAmtConvVal = "1";

			}

			if ((netAmt != null && netAmt.trim().length() > 0) && (taxAmt != null && taxAmt.trim().length() > 0))
			{
				sql1 = "UPDATE CASH_VOUCHER SET TOT_AMT = ?, TAX_AMT = ?, NET_AMT = ?, NET_AMT__CONV = ?, NET_AMT__BC =?  WHERE TRAN_ID ='"
						+ tranId + "' ";
				System.out.println("sql1-->" + sql1);
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setDouble(1, Double.parseDouble(netAmt)); // Total amount
				pstmt1.setDouble(2, Double.parseDouble(taxAmt)); // Tax amount
				pstmt1.setDouble(3, Double.parseDouble(netAmt)); // Net amount
				pstmt1.setDouble(4,(Double.parseDouble(netAmt))* (Double.parseDouble(netAmtConvVal))); // NET_AMT__CONV amount
				pstmt1.setDouble(5,Double.parseDouble(netAmt)* (Double.parseDouble(exchRate.trim()))); // NET_AMT__BC amount
				//pstmt1.setString(6,"S"); // chg status to "S" from "O"(Open)
				int i = pstmt1.executeUpdate();
				System.out.println("----- Rows To Be Updated ......" + i);
				pstmt1.close();
				pstmt1=null;
			
			}

			//Added by Dipali on 16/Feb/2021 [Start]
			
			Date date=null;
			java.sql.Date date1=null;
			SimpleDateFormat sdf;
			
			sdf = new SimpleDateFormat(
					genericUtility.getApplDateFormat());
		
			Calendar currentDate = Calendar.getInstance();
		   	String sysDate = sdf.format(currentDate.getTime());
		   	date=sdf.parse(sysDate);
		   	date1 = new java.sql.Date(date.getTime());
	
			
			sql1 = "select status from cash_voucher where tran_id = ? ";
			System.out.println("sql1-->"+sql1);
			pstmt2 = conn.prepareStatement(sql1);
			pstmt2.setString(1,tranId); 
			rs=pstmt2.executeQuery();
			if (rs.next())
		      {
		        status = rs.getString("status").trim();
		      }
			
			System.out.println("status====>>>>>"+status);
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt2!=null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			
			
			if(status.equalsIgnoreCase("X")) {
				sql1="update cash_voucher set cancelled_date=? where tran_id = ?";
				System.out.println("sql1-->"+sql1);
				pstmt2 = conn.prepareStatement(sql1);
				pstmt2.setDate(1,date1);
				pstmt2.setString(2,tranId); 
				int cnt =pstmt2.executeUpdate();
				System.out.println("----- Rows To Be Updated ......"+cnt);
				pstmt2.close();
				pstmt2 = null;
			}
			//Added by Dipali on 16/Feb/2021 [End]
			
			System.out.println("- - - - - - - In Post Save end -----");

		} catch (Exception ex) 
		{
			System.out.println("Exception in postSaveRec[CashVoucher] :"+ ex.getMessage());
			ex.printStackTrace();
			throw new ITMException(ex);
		} finally
		{
			try 
			{
				if (pstmt1 != null) 
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if (pstmt2 != null) {
					pstmt2.close();
					pstmt2 = null;
				}
			} catch (SQLException se) 
			{
				throw new ITMException(se);
			}
		}

		/*
		 * String errString = ""; Document dom=null; NodeList detailNodeList =
		 * null; PreparedStatement pstmt1 = null; PreparedStatement pstmt2 =
		 * null; ResultSet rst = null; String lineNo = ""; String sql1 = "",
		 * sql2 = ""; String tranId = ""; String updateFlag = ""; String status
		 * = ""; int lineNoInt = 0; int noOfDetailChlid = 0; int counter = 0,
		 * updCount = 0; try { E12GenericUtility E12GenericUtility =
		 * E12GenericUtility.getInstance();
		 * System.out.println("xmlString ----->"+xmlString); dom =
		 * parseString(xmlString); status =
		 * E12GenericUtility.getColumnValue("status", dom);
		 * System.out.println("Status --> "+status); status = status == null ?
		 * "" :status; if (status.equals("O")) { detailNodeList =
		 * dom.getElementsByTagName("Detail2"); noOfDetailChlid =
		 * detailNodeList.getLength(); int newLine = 1; System.out.println(
		 * "- - - - - - - - - - - - - - -F o r D e t a i l 2- - - - - - - - - - - - - - -"
		 * ); for (int recCtr = 0; recCtr < noOfDetailChlid; recCtr++) { Node
		 * detailNode = detailNodeList.item(recCtr); NodeList detailChlidList =
		 * detailNode.getChildNodes(); int noOfColumns =
		 * detailChlidList.getLength(); for (int ctr = 0; ctr < noOfColumns;
		 * ctr++) { Node chlidNode = detailChlidList.item(ctr); String chlidName
		 * = chlidNode.getNodeName(); if (chlidName.equals("#text")) continue;
		 * System.out.println("headerChlidName ("+chlidName+"]"); if
		 * (chlidName.equals("attribute"))
		 * updateFlag=chlidNode.getAttributes().getNamedItem
		 * ("updateFlag").getNodeValue(); else if ( chlidName.equals("tran_id")
		 * ) tranId = chlidNode.getFirstChild().getNodeValue().trim(); else if (
		 * chlidName.equals("line_no") ) { lineNo =
		 * chlidNode.getFirstChild().getNodeValue().trim(); lineNoInt =
		 * Integer.parseInt(lineNo); break; } }
		 * System.out.println("tran_id ["+tranId
		 * +"]\tlineNo ["+lineNoInt+"]\tcurrItr ["+newLine+"]"); if (lineNoInt
		 * != newLine && (!updateFlag.equals("D"))) { sql1 =
		 * "update cash_voucher_det set line_no = '"
		 * +newLine+"' where tran_id ='"
		 * +tranId+"' and line_no = '"+lineNoInt+"' ";
		 * System.out.println("sql1-->"+sql1); pstmt1 =
		 * conn.prepareStatement(sql1); updCount = pstmt1.executeUpdate(); if
		 * (updCount > 0) { sql2 =
		 * "select count(1) as count from taxtran where  tran_code = 'C-VOU' and tran_id ='"
		 * +tranId+"' and line_no = '  "+lineNoInt+"' ";
		 * System.out.println("sql1-->"+sql2); pstmt2 =
		 * conn.prepareStatement(sql2); rst = pstmt2.executeQuery(); int
		 * recCount = 0; if (rst.next()) recCount = rst.getInt(1); rst.close();
		 * rst=null; pstmt2.close(); pstmt2 = null; if (recCount > 0) { sql2 =
		 * "update taxtran set line_no = '  "
		 * +newLine+"' where tran_code = 'C-VOU' and tran_id ='"
		 * +tranId+"' and line_no = '  "+lineNoInt+"' ";
		 * System.out.println("sql1-->"+sql2); pstmt2 =
		 * conn.prepareStatement(sql2); updCount = pstmt2.executeUpdate(); if
		 * (updCount > 0) { counter = counter+1;
		 * System.out.println("Connection Committing"); conn.commit(); } else {
		 * System.out.println("Connection Rollbacked"); conn.rollback(); } }
		 * else { counter = counter+1;
		 * System.out.println("Connection Committing"); conn.commit(); } }
		 * pstmt1.close(); pstmt1 = null; } if (!updateFlag.equals("D")) newLine
		 * = newLine+1; } System.out.println(
		 * "- - - - - - - - - - - - - - -F o r D e t a i l 3- - - - - - - - - - - - - - -"
		 * ); detailNodeList = dom.getElementsByTagName("Detail3");
		 * noOfDetailChlid = detailNodeList.getLength(); newLine = 1; for (int
		 * recCtr = 0; recCtr < noOfDetailChlid; recCtr++) { Node detailNode =
		 * detailNodeList.item(recCtr); NodeList detailChlidList =
		 * detailNode.getChildNodes(); int noOfColumns =
		 * detailChlidList.getLength(); for (int ctr = 0; ctr < noOfColumns;
		 * ctr++) { Node chlidNode = detailChlidList.item(ctr); String chlidName
		 * = chlidNode.getNodeName(); if (chlidName.equals("#text")) continue;
		 * System.out.println("headerChlidName ("+chlidName+"]"); if
		 * (chlidName.equals("attribute"))
		 * updateFlag=chlidNode.getAttributes().getNamedItem
		 * ("updateFlag").getNodeValue(); else if ( chlidName.equals("tran_id")
		 * ) tranId = chlidNode.getFirstChild().getNodeValue().trim(); else if (
		 * chlidName.equals("line_no") ) { lineNo =
		 * chlidNode.getFirstChild().getNodeValue().trim(); lineNoInt =
		 * Integer.parseInt(lineNo); break; } }
		 * System.out.println("tran_id ["+tranId
		 * +"]\tlineNo ["+lineNoInt+"]\tcurrItr ["+newLine+"]"); if (lineNoInt
		 * != newLine && (!updateFlag.equals("D"))) { sql1 =
		 * "update cash_voucher_conv set line_no = '"
		 * +newLine+"' where tran_id ='"
		 * +tranId+"' and line_no = '"+lineNoInt+"' ";
		 * System.out.println("sql1-->"+sql1); pstmt1 =
		 * conn.prepareStatement(sql1); updCount = pstmt1.executeUpdate(); if
		 * (updCount > 0) { counter = counter+1;
		 * System.out.println("Connection Committing"); conn.commit(); } else {
		 * System.out.println("Updation Failed so Connection Rollbacked");
		 * conn.rollback(); } pstmt1.close(); pstmt1 = null; } if
		 * (!updateFlag.equals("D")) newLine = newLine+1; } } } catch (Exception
		 * ex) {
		 * System.out.println("Exception in postSaveRec[CashVoucher] :"+ex.
		 * getMessage()); ex.printStackTrace(); throw new ITMException(ex); }
		 * finally { try { if (pstmt1 != null) { pstmt1.close(); pstmt1 = null;
		 * } if (pstmt2 != null) { pstmt2.close(); pstmt2 = null; } } catch
		 * (SQLException se) { throw new ITMException(se); } }
		 */

		return "";
	}

	// Haneesh 24/11/09 end
	// start - bipin on 19/02/2010
	private int countAccountInGencodes(Connection conn, String modName,String fldName, String fldValue, String tranType) throws Exception 
	{
		System.out.println("Start - countAccountInGencodes()");
		int count = 0;
		String sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE MOD_NAME = ? AND FLD_NAME = ? AND FLD_VALUE = ? AND UDF_STR1=? AND ACTIVE = 'Y'";
		PreparedStatement pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, modName);
		pstmt.setString(2, fldName);
		pstmt.setString(3, fldValue);
		pstmt.setString(4, tranType);

		System.out.println("countAccountInGencodes :  [" + sql + "]");
		ResultSet rs = pstmt.executeQuery();
		if (rs.next()) {
			count = rs.getInt(1);
		}
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		System.out.println("end - countAccountInGencodes()");
		return count;
	}

	private String getAccountDescr(Connection conn, String modName,String fldName, String fldValue, String tranType) throws Exception 
	{
		System.out.println("Start - getAccountDescr()");
		String descr = "";
		String sql = "SELECT descr FROM GENCODES WHERE MOD_NAME = ? AND FLD_NAME = ? AND FLD_VALUE = ? AND UDF_STR1=? AND ACTIVE = 'Y'";
		PreparedStatement pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, modName);
		pstmt.setString(2, fldName);
		pstmt.setString(3, fldValue);
		pstmt.setString(4, tranType);

		System.out.println("getAccountDescr :  [" + sql + "]");
		ResultSet rs = pstmt.executeQuery();
		if (rs.next()) {
			descr = rs.getString("descr");
		}
		if (rs != null) {
			rs.close();
			rs = null;
		}
		if (pstmt != null) {
			pstmt.close();
			pstmt = null;
		}
		System.out.println("end - getAccountDescr()");
		return descr;
	}

	// end - bipin on 19/02/2010
	// start - bipin on 10/03/2010
	private int countDetail(Document dom2, String detail) throws ITMException 
	{
		System.out.println("\n\n\n\n\n\t:::::: [VoucherAdvFieldr:countDetail()] is Called::::::");
		NodeList parentNodeList = null;
		int parentNodeListLength = 0;
		parentNodeList = dom2.getElementsByTagName(detail);
		parentNodeListLength = parentNodeList.getLength();
		System.out.println("parentNodeListLength : [" + parentNodeListLength+ "]");
		return parentNodeListLength;
	}

	private boolean checkTranTypeInDetail(Document dom2, String detail,String tranType) throws ITMException 
	{
		System.out.println("\n\n\n\n\n\t:::::: [VoucherAdvFieldr:checkTranTypeInDetail()] is Called::::::");
		NodeList parentNodeList = null, attributeList = null, childNodeList = null;
		Node parentNode = null, attributeNode = null, childNode = null;
		String childNodeName = "", ccTranType = "", updateFlag = "";
		int parentNodeListLength = 0, childNodeListLength = 0, attributeListLength = 0;
		boolean flag = false;

		parentNodeList = dom2.getElementsByTagName(detail);
		parentNodeListLength = parentNodeList.getLength();

		for (int rowCount = 0; rowCount < parentNodeListLength; rowCount++) 
		{
			parentNode = parentNodeList.item(rowCount);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();

			for (int childRow = 0; childRow < childNodeListLength; childRow++) 
			{
				childNode = childNodeList.item(childRow);
				childNodeName = childNode.getNodeName();
				if (childNodeName.equals("attribute"))
				{
					System.out.println("[VoucherAdvFieldr:checkTranTypeInDetail()Inside attribute tag::::::");
					updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
					System.out.println("[VoucherAdvField:checkTranTypeInDetail()] updateFlag ["+ updateFlag + "]::::::");
				}

				if (childNodeName.equals("cc_tran_type")) 
				{
					if (childNode.getFirstChild() != null) 
					{
						ccTranType = childNode.getFirstChild().getNodeValue().trim();
						ccTranType = (ccTranType == null) ? "" : ccTranType.trim();
					}
				}
			} // eof for inner

			System.out.println("ccTranType : [" + ccTranType + "]");

			if (!tranType.equalsIgnoreCase(ccTranType)) 
			{
				System.out.println("Unmatched.......");
				flag = true;
				break;
			}// END OF IF
			else 
			{
				System.out.println("Matched.....");
				flag = false;
			}
		} // eof for outer
		return flag;
	}

	private String getAttribValue(Node detailNode, String nodeName,String attribStr)
	{
		String attribValue = "";
		try 
		{
			String domStr = genericUtility.serializeDom(detailNode);
			Document dom = genericUtility.parseString(domStr);
			if (dom != null /* && dom.getAttributes() != null */) 
			{
				Node attributeNode = dom.getElementsByTagName(nodeName).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}

	private String getAttribValue(Node detailNode, String attribStr) {
		String attribValue = "";
		try {
			if (detailNode != null && detailNode.getAttributes() != null) {
				Node attribNode = detailNode.getAttributes().getNamedItem(
						attribStr);
				if (attribNode != null) {
					attribValue = checkNull(attribNode.getNodeValue());
				}
			}
		} catch (Exception e) {
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}
		return input;
	}

	// end - bipin on 10/03/2010
	private String checkCodeInDetail(Document dom2) throws ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String updateFlag = "";
		String sundryCode = "";
		parentNodeList = dom2.getElementsByTagName("Detail2");

		if (parentNodeList != null)
		{
			parentNodeListLength = parentNodeList.getLength();
			for (int rowCount = 0; rowCount < parentNodeListLength; rowCount++) 
			{
				parentNode = parentNodeList.item(rowCount);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for (int childRow = 0; childRow < childNodeListLength; childRow++) 
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();

					updateFlag = getAttribValue(parentNode, "attribute","updateFlag"); // (parentNode, "attribute", "status"));

					if (!updateFlag.equalsIgnoreCase("D"))
					{
						if (childNodeName.equals("sundry_code")) 
						{
							if (childNode.getFirstChild() != null)
								sundryCode = childNode.getFirstChild().getNodeValue().trim();
						}
					}
				} // eof for inner

			}
		}// eof for outer
		return sundryCode;
	}
	//Added By Vikas L on 10/05/19[Start]
	public static void closeRs (ResultSet rs) 
	{
		try 
		{
			System.out.println("Inside Close Resultset");
			if( rs!= null) {
				rs.close();
				rs=null;
			}
		} 
		catch(Exception e) {
			System.out.println("Exception in ");
		}
	}
	//Added By Vikas L on 10/05/19[End]

}// end of class

