package ibase.webitm.ejb.fin.advfield;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;

import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class AdvanceVoucherReject  extends ActionHandlerEJB implements AdvanceVoucherRejectLocal,AdvanceVoucherRejectRemote{

	private UserInfoBean userInfoBean = null;
	
	public UserInfoBean getUserInfoBean() {
		return userInfoBean;
	}

	public void setUserInfoBean(UserInfoBean userInfoBean) {
		this.userInfoBean = userInfoBean;
	}

	public String reject() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String reject(String tranId,String xtraParams, String forcedFlag,String userInfo) throws RemoteException,ITMException //added by Ramagya On 10/08/2020[added userInfo parameter]
	{
		String result = "";
		try
		{
			System.out.println("AdvanceVoucherReject>>reject>>userInfo>>"+userInfo);
			setUserInfoBean(new UserInfoBean(userInfo));
			System.out.println("Reject Advance Voucher...");			 
			 result =rejectCashVoucher(tranId, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		return result;
	}

	private	String rejectCashVoucher(String tranId, String xtraParams)throws RemoteException,Exception,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		
		
		String sql = "";
	
		String empLogin = "",returnValue="",signRemrk="";
		
		String errorString = "";
		
		E12GenericUtility e12GenericUtilityObj =  new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		
		ConnDriver connDriver = new ConnDriver();	
		try
		{
		
			empLogin = e12GenericUtilityObj.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("empLogin--advanceVocuherConfirm---["+empLogin+"]");
			ibase.utility.UserInfoBean userInfo = null;
			if(getUserInfoBean() == null)
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				userInfo = commonDBAccessEJB.createUserInfo(empLogin);
			}
			if(userInfo == null)
			{
				userInfo = getUserInfoBean();
			}
			System.out.println("@@ras::::UserInfo=> "+userInfo);
			
			conn = connDriver.getConnectDB(userInfo == null  ? "Driver" : userInfo.getTransDB());
			
			conn.setAutoCommit(false);
		
			sql="select SIGN_REMARKS  from OBJ_SIGN_TRANS a where  REF_ID =? and "
				+"	 line_no = (select max(LINE_NO) from OBJ_SIGN_TRANS B where  B.REF_ID = A.REF_ID )";

			//sql="select SIGN_REMARKS from OBJ_SIGN_TRANS where ref_id =? and sign_status='R'";

			//sql = "SELECT EMAIL_ID_OFF FROM obj WHERE EMP_CODE = ?" ;
			System.out.println("*****getValueFromRefTable******* DESCR QUERY IS  "+sql);	
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			System.out.println("*****get Value From EMPLOYEE Table******* DESCR QUERY IS  "+sql);	
			
			if (rs.next())
			{
				returnValue = rs.getString("SIGN_REMARKS");
				System.out.println("*************Return VALUE IS*******"+returnValue );	
				
				
			}
			signRemrk=returnValue.toUpperCase();
			System.out.println("*************Return VALUE IS*signRemrk******"+signRemrk );	

			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

		//	sql="update OBJ_SIGN_TRANS set SIGN_REMARKS=? where ref_id =? and sign_status='R'";
			sql=" update OBJ_SIGN_TRANS A set SIGN_REMARKS=? where ref_id =? and sign_status='R' and "+
					 "line_no = (select max(LINE_NO) from OBJ_SIGN_TRANS B where  B.REF_ID = A.REF_ID )";

			System.out.println("sql-->"+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,signRemrk);
			pstmt.setString(2,tranId); 
			int cnt1 =pstmt.executeUpdate();
			System.out.println("----- Rows To Be Updated ......"+cnt1);
			if(cnt1 > 0) {
				//conn.commit();
				System.out.println("OBJ_SIGN_TRANS status updated");
			}
			pstmt.close();
			pstmt = null;
			
			
			sql="update cash_voucher set status=? where tran_id = ?";
			System.out.println("sql-->"+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"O");
			pstmt.setString(2,tranId); 
			int cnt =pstmt.executeUpdate();
			System.out.println("----- Rows To Be Updated ......"+cnt);
			if(cnt > 0) {
				//conn.commit();
				System.out.println("cash_voucher status updated");
			}
			pstmt.close();
			pstmt = null;
			
		}
		catch(Exception e)
		{
			conn.rollback();   
			System.out.println("Exception  :: [CashVoucherRejectEJB]  EXCEPTION"+e.getMessage());
		//	return itmDBAccessEJB.getErrorString("","VTADHOC1","","",conn);
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.commit(); 
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception inside finally" + e.getMessage());
				conn.rollback();
				return itmDBAccessEJB.getErrorString("","VTADHOC1","","",conn);
			}
		}// END OF finally
	
	

	return errorString;
	}

	
}
