package ibase.webitm.ejb.hr;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SalarySlipIC extends ValidatorEJB
  implements SalarySlipICLocal, SalarySlipICRemote
{
  public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams)
    throws RemoteException, ITMException
  {
    Document dom = null;
    Document dom1 = null;
    Document dom2 = null;
    String errString = null;
    E12GenericUtility genericUtility = new E12GenericUtility();
    try
    {
      System.out.println("SalarySlipIC:itemChanged value of xmlString [" + xmlString + "]");
      System.out.println("SalarySlipIC:itemChanged value of xmlString [" + xmlString1 + "]");
      System.out.println("SalarySlipIC:itemChanged value of xmlString [" + xmlString2 + "]");
      System.out.println("SalarySlipIC:objContext [" + objContext + "]");
      System.out.println("SalarySlipIC:currentColumn [" + currentColumn + "]");
      System.out.println("SalarySlipIC:editFlag [" + editFlag + "]");
      System.out.println("SalarySlipIC:xtraParams [" + xtraParams + "]");
      if ((xmlString != null) && (xmlString.trim().length() != 0))
      {
        dom = genericUtility.parseString(xmlString);
      }
      if ((xmlString1 != null) && (xmlString1.trim().length() != 0))
      {
        dom1 = genericUtility.parseString(xmlString1);
      }
      if ((xmlString2 != null) && (xmlString2.trim().length() != 0))
      {
        dom2 = genericUtility.parseString(xmlString2);
      }
      errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
      System.out.println("ErrString :" + errString);
    }
    catch (Exception e)
    {
      System.out.println("Exception:SalarySlipIC:itemChanged" + e.getMessage() + ":");
      e.printStackTrace();
      throw new ITMException(e);
    }

    return errString;
  }

  public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
  {
    E12GenericUtility genericUtility = null;
    Connection conn = null;
    ConnDriver connDriver = null;
    PreparedStatement pstmt = null;
    ResultSet rs = null;
    StringBuffer valueXmlString = null;
    int currentFormNo = 0;
    String empCode = ""; String sql = ""; String loginEmpCode = ""; String userId = ""; String empCodeLink = "";
    System.out.println("objContext ..:: [" + objContext + "]");
    System.out.println("currentColumn ..:: [" + currentColumn + "]");
    System.out.println("editFlag ..:: [" + editFlag + "]");
    System.out.println("xtraParams ..:: [" + xtraParams + "]");
    if ((objContext != null) && (objContext.trim().length() > 0))
    {
      currentFormNo = Integer.parseInt(objContext);
    }
    try
    {
      genericUtility = new E12GenericUtility();
      connDriver = new ConnDriver();
      loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
      userId = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId"));
      conn = getConnection();
      conn.setAutoCommit(false);

      valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
      valueXmlString.append(editFlag).append("</editFlag></header>");
      String objNameDefault = checkNull(getObjName(dom, "1"));
      System.out.println("objNameDefault ..:: [" + objNameDefault + "]");
      switch (currentFormNo)
      {
      case 1:
        valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='" + objNameDefault + "' selected='Y'>\r\n");
        if (currentColumn.equalsIgnoreCase("itm_default"))
        {
          System.out.println("SalarySlipIC Inside itm_default ..::");
          empCode = loginEmpCode;
          System.out.println("Login employee code is -->" + loginEmpCode);
          System.out.println("Employee code is -->" + empCode);
          sql = "SELECT  (B.EMP_CODE) as emp_code__link  FROM EMPLOYEE B START WITH B.EMP_CODE = ? CONNECT BY PRIOR B.EMP_CODE__LINK = B.EMP_CODE";
          pstmt = conn.prepareStatement(sql);
          pstmt.setString(1, empCode);
          rs = pstmt.executeQuery();
          while (rs.next())
          {
            if ((empCodeLink != null) && (empCodeLink.trim().length() > 0))
            {
              empCodeLink = empCodeLink + ",";
            }
            empCodeLink = empCodeLink + checkNull(rs.getString("emp_code__link"));
            System.out.println("@vkc::empCodeLink >>" + empCodeLink);
          }
          rs.close();
          rs = null;
          pstmt.close();
          pstmt = null;
          if ((empCodeLink != null) && (empCodeLink.trim().length() > 0) && (empCodeLink.lastIndexOf(",") == empCodeLink.length() - 1))
          {
            empCodeLink = empCodeLink.substring(0, empCodeLink.length() - 1);
          }
          valueXmlString.append("<emp_code__link><![CDATA[").append(empCodeLink).append("]]></emp_code__link>\r\n");
          valueXmlString.append("<as_empcode><![CDATA[").append(empCode).append("]]></as_empcode>\r\n");
        }
        valueXmlString.append("</Detail1>\r\n");
      }

    }
    catch (Exception er)
    {
      er.printStackTrace();
      throw new ITMException(er);
    }
    finally
    {
      try
      {
        if (rs != null)
        {
          rs.close();
          rs = null;
        }
        if (pstmt != null)
        {
          pstmt.close();
          pstmt = null;
        }
        if (conn != null)
        {
          conn.close();
          conn = null;
        }
      }
      catch (Exception es)
      {
        es.printStackTrace();
        throw new ITMException(es);
      }
    }
    valueXmlString.append("</Root>\r\n");
    return valueXmlString.toString();
  }

  private String getObjName(Document dom, String objContext) {
    Node elementName = null;
    NodeList elementList = null;
    String objName = "";
    elementList = dom.getElementsByTagName("Detail" + objContext);
    elementName = elementList.item(0);
    if ((elementName != null) && (("Detail" + objContext).equalsIgnoreCase(elementName.getNodeName())))
    {
      NamedNodeMap etlAttributes = elementName.getAttributes();
      if (etlAttributes != null)
      {
        if (etlAttributes.getNamedItem("objName") != null)
        {
          objName = etlAttributes.getNamedItem("objName").getNodeValue();
        }
      }
    }
    return objName;
  }

  private String checkNull(String input) {
    if ((input == null) || ("null".equalsIgnoreCase(input)))
    {
      input = "";
    }
    return input.trim();
  }
}