package ibase.webitm.ejb.chcscheduler;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CHCReportSch
  implements Schedule
{
  String mailAddress = "";

  public String schedule(HashMap arg0)
    throws Exception
  {
    return null;
  }

  public String schedule(String arg0) throws Exception
  {
    System.out.println("Inside schedule  " + arg0);
    return performOp(arg0);
  }

  public String schedulePriority(String arg0)
    throws Exception
  {
    System.out.println("Inside schedule priority " + arg0);
    return performOp(arg0);
  }

  public String performOp(String scheduleParamXML)
    throws ITMException
  {
    String retString = "";
    Connection conn = null;
    Connection connection = null;

    boolean isError = false;
    try
    {
      ConnDriver connDriver = new ConnDriver();
      ConnDriver con = new ConnDriver();

      conn = connDriver.getConnectDB("DriverITM");
      connection = con.getConnectDB("DWH");
      System.out.println("connection===>" + connection);

      if (conn != null) {
        System.out.println("Connected to the database!");
        retString = performOp(scheduleParamXML, conn, connection);
      }

    }
    catch (Exception e)
    {
      isError = true;
      e.printStackTrace();
      throw new ITMException(e);
    }
    finally
    {
      try
      {
        if (conn != null)
        {
          if (isError)
          {
            conn.rollback();
          }
          else
          {
            conn.commit();
          }
          conn.close();
          conn = null;
        }
        if (connection != null)
        {
          if (isError)
          {
            connection.rollback();
          }
          else
          {
            connection.commit();
          }
          connection.close();
          connection = null;
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        throw new ITMException(e);
      }
    }
    return retString;
  }

  public String performOp(String scheduleParamXML, Connection conn, Connection connection)
    throws ITMException, Exception
  {
    String retString = "";
    String zoneEmailId = "";
    String siteCity = ""; String regionCode = ""; String zone = "";
    String sql = ""; String objName = ""; String argumentString = ""; String jrxmlName = "";
    String lineNo = ""; String sqlExpr = ""; String sqlExpr1 = ""; String sqlExpr2 = ""; String sqlExpr3 = ""; String sqlExpr4 = ""; String sqlExpr5 = ""; String sqlExpr6 = ""; String errfilePath = "";
    String compSql = "";
    PreparedStatement pstmt = null; PreparedStatement pstmt1 = null;
    ResultSet rs = null; ResultSet rs1 = null;
    ArrayList objtNamelist = new ArrayList();
    String objtNames = "";
    String driver = ""; String reportGroup = null;
    UserInfoBean userInfo = null;
    E12GenericUtility genericUtility = new E12GenericUtility();
    ArrayList valueContainer = new ArrayList();
    JSONArray chcReportJsonArray = new JSONArray();
    boolean mailSent = false;
    String transInfo = "";

    String mailFormat = "";

    System.out.println("scheduler xml content:" + scheduleParamXML);
    try
    {
      userInfo = new UserInfoBean(scheduleParamXML);
      Document dom = genericUtility.parseString(scheduleParamXML);

      NodeList paramList = dom.getElementsByTagName("SCHEDULE");
      Node currDetail = null;
      int noOfParam = paramList.getLength();
      NodeList parentNodeList = null; NodeList childNodeList = null;
      Node parentNode = null; Node childNode = null;
      String DisparmSites = "";
      int childNodeListLength = 0;
      String childNodeName = null;
      int index = 0;

      parentNodeList = dom.getElementsByTagName("ACTUALPARAMETERS");

      parentNode = parentNodeList.item(0);
      childNodeList = parentNode.getChildNodes();
      childNodeListLength = childNodeList.getLength();

      sql = "select line_no,sql_expr,sql_input,sql_expr1,sql_expr2,sql_expr3,sql_expr4, sql_expr5,sql_expr6 from tax_bal_grp_det where bal_group=? order by line_no ";

      pstmt = conn.prepareStatement(sql);
      pstmt.setString(1, "CHCTS");
      rs = pstmt.executeQuery();
      System.out.println("SQL>>>::::" + sql);
      while (rs.next()) {
        lineNo = checkNull(rs.getString("line_no"));
        sqlExpr = checkNull(rs.getString("sql_expr"));
        sqlExpr1 = checkNull(rs.getString("sql_expr1"));
        sqlExpr2 = checkNull(rs.getString("sql_expr2"));
        sqlExpr3 = checkNull(rs.getString("sql_expr3"));
        sqlExpr4 = checkNull(rs.getString("sql_expr4"));
        sqlExpr5 = checkNull(rs.getString("sql_expr5"));
        sqlExpr6 = checkNull(rs.getString("sql_expr6"));
        objtNames = checkNull(rs.getString("sql_input"));

        compSql = sqlExpr + " " + sqlExpr1 + " " + sqlExpr2 + " " + sqlExpr3 + " " + sqlExpr4 + " " + sqlExpr5 + " " + sqlExpr6;
        System.out.println("Combine SQL::::" + compSql);

        int count = 0;
        if ((compSql == null) || (compSql.trim().length() <= 0))
          continue;
        System.out.println("Combine SQL not null::::" + compSql);

        pstmt1 = connection.prepareStatement(compSql);
        rs1 = pstmt1.executeQuery();

        HashMap<String,List<String>> app = new HashMap<String,List<String>>();
        HashMap<String,HashSet<String>> emailApp = new HashMap<String,HashSet<String>>();
        StringBuffer emailheaderStr = new StringBuffer();
        ResultSetMetaData rsmd= null;
        while (rs1.next())
        {
          StringBuffer emailBodyStr = new StringBuffer();

          rsmd = rs1.getMetaData();

          emailBodyStr.append("<tr>");
          for (int i = 1; i <= rsmd.getColumnCount(); i++) {
            System.out.println("Inside for::::");
            System.out.println("count==>" + count);
            JSONObject chcReportJsonObj = new JSONObject();
            String colName = rsmd.getColumnName(i);

            System.out.println("col name ::::" + colName);

            if (count < 1)
            {
              if (!colName.equalsIgnoreCase("zone_email")) {
                System.out.println("emailheaderStr=====>>>" + emailheaderStr.length());
                System.out.println("rsmd.getColumnCount()=====>>>" + rsmd.getColumnCount());
                emailheaderStr.append("<th>");
                if (colName.equalsIgnoreCase("report_dt")) {
                  emailheaderStr.append("Report Date");
                }
                if (colName.equalsIgnoreCase("zone")) {
                  emailheaderStr.append("Zone");
                }
                if (colName.equalsIgnoreCase("region")) {
                  emailheaderStr.append("Region");
                }
                if (colName.equalsIgnoreCase("site_city")) {
                  emailheaderStr.append("Site City");
                }
                if (colName.equalsIgnoreCase("stockist_city")) {
                  emailheaderStr.append("Stockist City");
                }
                if (colName.equalsIgnoreCase("cattegory")) {
                  emailheaderStr.append("Category");
                }
                if (colName.equalsIgnoreCase("division")) {
                  emailheaderStr.append("Division");
                }
                if (colName.equalsIgnoreCase("order_date")) {
                  emailheaderStr.append("Order Date");
                }
                if (colName.equalsIgnoreCase("ord_value")) {
                  emailheaderStr.append("Order Value");
                }
                if (colName.equalsIgnoreCase("sale_order")) {
                  emailheaderStr.append("Sale Order");
                }
                if (colName.equalsIgnoreCase("sku")) {
                  emailheaderStr.append("SKU");
                }
                if (colName.equalsIgnoreCase("threshold_limit")) {
                  emailheaderStr.append("Threshold Limit");
                }
                if (colName.equalsIgnoreCase("outstanding_amt")) {
                  emailheaderStr.append("Outstanding Amt");
                }
                if (colName.equalsIgnoreCase("blocked_ord_val")) {
                  emailheaderStr.append("Blocked Order Val");
                }
                if (colName.equalsIgnoreCase("status")) {
                  emailheaderStr.append("Status");
                }
                if (colName.equalsIgnoreCase("chg_user")) {
                  emailheaderStr.append("Chg User");
                }
                if (colName.equalsIgnoreCase("user_name")) {
                  emailheaderStr.append("User Name");
                }
                emailheaderStr.append("</th>");
              }
            }
            System.out.println("colName=====>>>" + colName);
            int type = rsmd.getColumnType(i);
            System.out.println("type=====>>>" + type);

            if ((type == 12) || (type == 1)) {
              System.out.print("VARCHAR field varchar==>>:" + rs1.getString(colName));

              if (!colName.equalsIgnoreCase("zone_email")) {
                System.out.print("column name>>:" + rs1.getString(colName));
                chcReportJsonObj.put(colName, rs1.getString(colName));

                emailBodyStr.append("<td>");
                emailBodyStr.append(rs1.getString(colName));
                emailBodyStr.append("</td>");
              }
              if (colName.equalsIgnoreCase("zone_email")) {
                zoneEmailId = rs1.getString(colName);
              }
              if (colName.equalsIgnoreCase("site_city")) {
                siteCity = rs1.getString(colName);
              }
              if (colName.equalsIgnoreCase("region")) {
                regionCode = rs1.getString(colName);
              }
              if (colName.equalsIgnoreCase("zone")) {
                zone = rs1.getString(colName);
              }
            }
            else if ((type == 4) || (type == -5)) {
              System.out.print("VARCHAR field Int:" + rs1.getInt(colName));

              chcReportJsonObj.put(colName, rs1.getInt(colName));
              emailBodyStr.append("<td>");
              emailBodyStr.append(rs1.getInt(colName));
              emailBodyStr.append("</td>");
            }
            else if ((type == 8) || (type == 6)) {
              System.out.print("VARCHAR field double:" + rs1.getDouble(colName));
              chcReportJsonObj.put(colName, rs1.getDouble(colName));
              emailBodyStr.append("<td>");
              emailBodyStr.append(rs1.getDouble(colName));
              emailBodyStr.append("</td>");
            }
            else if (type == 91) {
              System.out.print("DATE field date:" + rs1.getDate(colName));
              String dateAsString = rs1.getDate(colName).toString();
              DateFormat sourceFormat = new SimpleDateFormat("yyyy-MM-dd");
              SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yy");
              java.util.Date date = sourceFormat.parse(dateAsString);
              System.out.println(formatter.format(date));

              chcReportJsonObj.put(colName, formatter.format(date));
              emailBodyStr.append("<td>");
              emailBodyStr.append(formatter.format(date));
              emailBodyStr.append("</td>");
            }
            else if (type == 93) {
              System.out.print("TIMESTAMP field:" + rs1.getDate(colName));

              chcReportJsonObj.put(colName, rs1.getTimestamp(colName));
              emailBodyStr.append("<td>");
              emailBodyStr.append(rs1.getTimestamp(colName));
              emailBodyStr.append("</td>");
            }
            else if (type == 2) {
              System.out.print("NUMERIC field:" + rs1.getInt(colName));
              if (!colName.equalsIgnoreCase("zone_email")) {
                chcReportJsonObj.put(colName, rs1.getInt(colName));
                emailBodyStr.append("<td>");
                emailBodyStr.append(rs1.getInt(colName));
                emailBodyStr.append("</td>");
              }

            }
            else if (type == -6) {
              System.out.print("TINYINT field:" + rs1.getInt(colName));

              chcReportJsonObj.put(colName, rs1.getInt(colName));
              emailBodyStr.append("<td>");
              emailBodyStr.append(rs1.getInt(colName));
              emailBodyStr.append("</td>");
            }
            else if (type == 5) {
              System.out.print("SMALLINT field:" + rs1.getInt(colName));

              chcReportJsonObj.put(colName, rs1.getInt(colName));
              emailBodyStr.append("<td>");
              emailBodyStr.append(rs1.getInt(colName));
              emailBodyStr.append("</td>");
            }
            else if (type == 92) {
              System.out.print("TIME field:" + rs1.getTime(colName));

              chcReportJsonObj.put(colName, rs1.getTime(colName));
              emailBodyStr.append("<td>");
              emailBodyStr.append(rs1.getTime(colName));
              emailBodyStr.append("</td>");
            }
            else
            {
              System.out.println("Exceptional case where data type may be different");
            }

            chcReportJsonArray.put(chcReportJsonObj);
          }
          System.out.println("123456==>" + count);

          count++;
          System.out.println("987654==>" + count);

          System.out.println("zoneEmailId" + zoneEmailId);
          System.out.println("siteCity" + siteCity);
          System.out.println("regionCode" + regionCode);
          System.out.println("zone" + zone);
          String combineKey = siteCity + "," + regionCode+ "," + zone;
          System.out.println("combineKey" + combineKey);
          System.out.println("app" + app.toString());
          String emailbd = (emailBodyStr != null) && (emailBodyStr.length() > 0) ? emailBodyStr.toString().replaceAll("\\[|\\]", "") : "";
          System.out.println("emailbd" + emailbd);
          if (!app.containsKey(combineKey)) {
        	  System.out.println("Inside if app not contains key");
              List<String> ls = new ArrayList();
              ls.add(emailbd);
              app.put(combineKey, ls);
              HashSet emailSet = new HashSet();
              emailSet.add(zoneEmailId);
              emailApp.put(combineKey, emailSet);
          }
          else if (app.containsKey(combineKey))
          {
            System.out.println("Inside if app contains key");
            List<String> ls = (List)app.get(combineKey);
            System.out.println("ls=======>" + ls);
            ls.add(emailbd);
            app.put(combineKey, ls);
            
            HashSet emailSet = (HashSet)emailApp.get(combineKey);
            emailSet.add(zoneEmailId);
            emailApp.put(combineKey, emailSet);
          }

          emailBodyStr.append("</tr>");
          System.out.println("chcReportJsonArray size:::" + chcReportJsonArray.length());

          index++;
        }
        if (index == 0) {
          System.out.println("Check index");
          printLog("No Data Found", "Please Enter Valid Query to Return data");
        }
        else
        {
        	 for (Map.Entry emailData : app.entrySet())
          {
            System.out.println("Inside for loop to check map entry");
            HashSet<String> emailGet = emailApp.get(emailData.getKey());
            System.out.println("emailGet==>" + emailGet);
            for (String emailD : emailGet)
            {
              zoneEmailId = emailD;
              StringBuffer emailStr = new StringBuffer();
              emailStr.append("<html><head><style type='text/css'>table, th, td {border:1px solid black;}</style></head><body><table>");

              emailStr.append("<thead>");
              emailStr.append("<tr>");
              emailStr.append(emailheaderStr.toString());
              emailStr.append("</tr>");
              emailStr.append("</thead>");
              emailStr.append("<tbody>");

              String emailbdData = emailData.getValue() != null ? ((List)emailData.getValue()).toString().replaceAll("\\[|\\]|,", "") : "";
              emailStr.append(emailbdData);

              emailbdData = emailData.getValue() != null ? emailbdData.replaceAll("<tr>|<td>|</tr>", " ") : "";
              if (emailbdData != null)
              {
                String[] emailbdDataa = emailbdData.split("</td>");
                System.out.println("zone>>>==>" + emailbdData);
                zone = emailbdDataa[1];
                siteCity = emailbdDataa[3];
              }
              else
              {
                zone = "";
                siteCity = "";
              }

              System.out.println("zone>>>==>" + zone);
              System.out.println("siteCity>>>==>" + siteCity);

              System.out.println("zone>>>==>" + zone);
              System.out.println("siteCity>>>==>" + siteCity);
              emailStr.append("</tbody>");
              emailStr.append("</body>");
              emailStr.append("</html>");

              String chcReportData = emailStr.toString();
              System.out.println("chcReportData====>" + chcReportData);

              chcReportData = "Dear All,<br><br>Please find the CHC Deviation Report(Orders Blocked)<br><br> \n" + chcReportData + "\n" + "<br>This is autogenerated mail , kindly do not reply to this mail id<br><br> <b style='color:red;'>Disclaimer: This data shows  the blocked status as per mentioned date time stamp and may not reflect any changes done on the order release application in the interim.</b> <br><br>Regards,<br>BI team.";

              System.out.println("chcReportData222====>" + chcReportData);

              System.out.println("zoneEmailId>>>" + zoneEmailId);
              mailSent = sendMail(chcReportData, zoneEmailId, transInfo, zone, siteCity, lineNo,conn);
              if (mailSent)
              {
                printLog(zoneEmailId, "", "", mailSent);
                System.out.println("Succesfully send the mail");
              }
              else {
                printLog(zoneEmailId, "", "", mailSent);
                System.out.println("failure while sending the mail");
              }

            }

          }

        }

        rs1.close();
        rs1 = null;
        pstmt1.close();
        pstmt1 = null;
      }

      rs.close();
      rs = null;
      pstmt.close();
      pstmt = null;
    }
    catch (SQLException e1)
    {
      System.out.println("Error_Code::::" + e1.getErrorCode());
      System.out.println(e1);
      String err = String.valueOf(e1.getErrorCode());
      System.out.println("err::::" + err);
      printLog("STDERR", "GENERIC REPORTS :: FAIL_SQL compSql ==>" + compSql);
      printLog("STDERR", "GENERIC REPORTS :: FAIL_SQL e1==>" + e1);
    }
    catch (Exception e)
    {
      throw new Exception(e);
    }
    finally
    {
      if (rs != null)
      {
        rs.close();
        rs = null;
      }
      if (pstmt != null)
      {
        pstmt.close();
        pstmt = null;
      }
    }
    return retString;
  }

  private void printLog(String title, String msg)
  {
    String logFile = "";
    String logDir = "";
    File logFileDir = null;
    FileWriter fileWriter = null;
    try
    {
      String logFileName = "";
      SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
      logFileName = "CHCReportScheduler_" + sdf.format(new java.util.Date());

      System.out.println("Inside the print log method");

      logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "CHCReportScheduler_";
      System.out.println("Log direction: " + logDir);

      logFileDir = new File(logDir);

      if (!logFileDir.exists())
      {
        logFileDir.mkdirs();
      }

      logFile = logDir + File.separator + logFileName + ".log";

      SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
      java.util.Date now = new java.util.Date();
      String strDate = sdfDate.format(now);

      fileWriter = new FileWriter(logFile, true);

      fileWriter.write("\r\n");
      fileWriter.write("[ERROR] " + msg);
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
      printLog("STDERR", ex);
      printLog("STDOUT", "Inside Exception [getLog]>>" + ex.toString());
      try
      {
        if (fileWriter != null)
        {
          fileWriter.flush();
          fileWriter.close();
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        printLog("STDERR", e);
      }

      try
      {
        if (fileWriter != null)
        {
          fileWriter.flush();
          fileWriter.close();
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        printLog("STDERR", e);
      }
    }
    finally
    {
      try
      {
        if (fileWriter != null)
        {
          fileWriter.flush();
          fileWriter.close();
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        printLog("STDERR", e);
      }
    }
  }

  private void printLog(String maildId, String tranId, String fileName, boolean mailSent)
  {
    String logFile = "";
    String logDir = "";
    File logFileDir = null;
    FileWriter fileWriter = null;
    try
    {
      String logFileName = "";
      SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
      logFileName = "ReportScheduler_" + sdf.format(new java.util.Date());

      System.out.println("Inside the print log method");

      logDir = CommonConstants.JBOSSHOME + File.separator + "applnlog" + File.separator + "ReportScheduler_";
      System.out.println("Log direction: " + logDir);

      logFileDir = new File(logDir);

      if (!logFileDir.exists())
      {
        logFileDir.mkdirs();
      }

      logFile = logDir + File.separator + logFileName + ".log";

      SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
      java.util.Date now = new java.util.Date();
      String strDate = sdfDate.format(now);

      fileWriter = new FileWriter(logFile, true);

      fileWriter.write("\r\n");
      if (mailSent) {
        fileWriter.write("Succesfully Sent mail to [" + tranId + "] " + "With File Name" + " [" + fileName + "] on Mail Id " + "[" + maildId + "]");
      }
      else {
        fileWriter.write("Mail is not Sent to [" + tranId + "] " + "With File Name" + " [" + fileName + "] on Mail Id " + "[" + maildId + "]");
      }
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
      printLog("STDERR", ex);
      printLog("STDOUT", "Inside Exception [getLog]>>" + ex.toString());
      try
      {
        if (fileWriter != null)
        {
          fileWriter.flush();
          fileWriter.close();
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        printLog("STDERR", e);
      }

      try
      {
        if (fileWriter != null)
        {
          fileWriter.flush();
          fileWriter.close();
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        printLog("STDERR", e);
      }
    }
    finally
    {
      try
      {
        if (fileWriter != null)
        {
          fileWriter.flush();
          fileWriter.close();
        }
      }
      catch (Exception e)
      {
        e.printStackTrace();
        printLog("STDERR", e);
      }
    }
  }

  private void printLog(String title, Exception e)
  {
    try
    {
      StringWriter strError = new StringWriter();
      e.printStackTrace(new PrintWriter(strError));
      String err = strError.toString();
      printLog(title, err);
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
      printLog("STDERR", "Inside Exception [getLog]>>" + ex.toString());
    }
  }

  private String checkNull(String input)
  {
    if (input == null) {
      input = "";
    }
    return input.trim();
  }
  
  public boolean sendMail(String reportFilePath, String emailId, String transInfo, String ZoneStr, String SiteCityStr,String lineNo,Connection conn)
		    throws ITMException
		  {
		    System.out.println("Inside sent mail: ");

		    boolean sentMail = false;

		    //String lineNo = "1";
		    String emailType = "page";
		    StringBuffer valueXmlString = null;
		    String retValue = "";
		    try
		    {
		    	DistCommon disCommon = new DistCommon();
				String ccId = disCommon.getDisparams("999999", "CHC_REPORT_CC", conn);
				System.out.println("ccId>>>>"+ ccId);
				
				if(ccId == null || ccId.trim().length() == 0 || ccId.trim().equalsIgnoreCase("NULLFOUND")) 
				{
					ccId = "Prachi.Joshi@sunpharma.com";
				}
		    	//String ccId="Rajesh.Sutar@sunpharma.com,Prachi.Joshi@sunpharma.com";
		    	//String ccId="ketan.patil@baseinformation.com";
		    	//String ccId="Prachi.Joshi@sunpharma.com";
		      System.out.println("Inside try: ");
		      valueXmlString = new StringBuffer("<ROOT>");

		      valueXmlString.append("<MAILINFO>");
		      valueXmlString.append("<EMAIL_TYPE>").append("null").append("</EMAIL_TYPE>");
		   //   emailId="pravin.nevage@proteustech.in";
		      valueXmlString.append("<TO_ADD>").append("<![CDATA[" + emailId + "]]>").append("</TO_ADD>");
		      valueXmlString.append("<CC_ADD>").append("<![CDATA[" + ccId + "]]>").append("</CC_ADD>");
		      System.out.println("emailId: " + emailId);
		      System.out.println("lineNo: " + lineNo);
		      if(lineNo.equalsIgnoreCase("1")){
		    	  valueXmlString.append("<SUBJECT>").append("<![CDATA[CHC Deviation Report : NSM - For Zone -" + ZoneStr + "]]>").append("</SUBJECT>");
		      }
		      if(lineNo.equalsIgnoreCase("2")){
		    	  valueXmlString.append("<SUBJECT>").append("<![CDATA[CHC Deviation Report : ZSM - For Zone -" + ZoneStr + "]]>").append("</SUBJECT>");
		      }
		      if(lineNo.equalsIgnoreCase("3")){
		    	  valueXmlString.append("<SUBJECT>").append("<![CDATA[CHC Deviation Report : BUHEAD - For Zone -" + ZoneStr + "]]>").append("</SUBJECT>");
		      }

		      valueXmlString.append("<BODY_TEXT>").append("<![CDATA[" + reportFilePath + "]]>").append("</BODY_TEXT>");
		      valueXmlString.append("</MAILINFO>");
		      valueXmlString.append("<XML_DATA>").append(transInfo).append("</XML_DATA>");
		      valueXmlString.append("</ROOT>");

		      String mailDomStr = valueXmlString.toString();
		      System.out.println("valueXmlString: " + valueXmlString);
		      Document xmlDom = null;
		      System.out.println("@@## [Generic Report]  :sendMail mailDomStr :-->" + mailDomStr);
		      EMail email = new EMail();
		      email.sendMail(mailDomStr, "ITM");

		      System.out.println("[Pdf]  mail delivered successfully");
		    }
		    catch (ITMException itme)
		    {
		      System.out.println("@@## ITMException [[Generic Report]] :sendMail  :sendMail :sendMail() :==>\n");
		      throw itme;
		    }
		    catch (Exception e)
		    {
		      System.out.println("Exception :[[Generic Report]] :sendMail() :==>\n" + e.getMessage());
		      throw new ITMException(e);
		    }
		    return sentMail;
		  }

  public boolean sendMail1(String reportFilePath, String emailId, String transInfo, String ZoneStr, String SiteCityStr, String lineNo, Connection conn)
    throws ITMException
  {
    System.out.println("Inside sent mail: ");

    boolean sentMail = false;

    String emailType = "page";
    StringBuffer valueXmlString = null;
    String retValue = "";
    try
    {
    	
		DistCommon disCommon = new DistCommon();
		String ccId = disCommon.getDisparams("999999", "CHC_REPORT_CC", conn);
		System.out.println("ccId>>>>"+ ccId);
		
		if(ccId == null || ccId.trim().length() == 0 || ccId.trim().equalsIgnoreCase("NULLNOTFOUND")) 
		{
			ccId = "Rajesh.Sutar@sunpharma.com,Prachi.Joshi@sunpharma.com";
		}
		
		

      System.out.println("Inside try: ");
      valueXmlString = new StringBuffer("<ROOT>");

      valueXmlString.append("<MAILINFO>");
      valueXmlString.append("<EMAIL_TYPE>").append("null").append("</EMAIL_TYPE>");

      valueXmlString.append("<TO_ADD>").append("<![CDATA[" + emailId + "]]>").append("</TO_ADD>");
      valueXmlString.append("<CC_ADD>").append("<![CDATA[" + ccId + "]]>").append("</CC_ADD>");
      System.out.println("emailId: " + emailId);
      System.out.println("lineNo: " + lineNo);
      if (lineNo.equalsIgnoreCase("1")) {
        valueXmlString.append("<SUBJECT>").append("<![CDATA[CHC Deviation Report : NSM - For Zone -" + ZoneStr + "]]>").append("</SUBJECT>");
      }
      if (lineNo.equalsIgnoreCase("2")) {
        valueXmlString.append("<SUBJECT>").append("<![CDATA[CHC Deviation Report : ZSM - For Zone -" + ZoneStr + "]]>").append("</SUBJECT>");
      }
      if (lineNo.equalsIgnoreCase("3")) {
        valueXmlString.append("<SUBJECT>").append("<![CDATA[CHC Deviation Report : BUHEAD - For Zone -" + ZoneStr + "]]>").append("</SUBJECT>");
      }

      valueXmlString.append("<BODY_TEXT>").append("<![CDATA[" + reportFilePath + "]]>").append("</BODY_TEXT>");
      valueXmlString.append("</MAILINFO>");
      valueXmlString.append("<XML_DATA>").append(transInfo).append("</XML_DATA>");
      valueXmlString.append("</ROOT>");

      String mailDomStr = valueXmlString.toString();
      System.out.println("valueXmlString: " + valueXmlString);
      Document xmlDom = null;
      System.out.println("@@## [Generic Report]  :sendMail mailDomStr :-->" + mailDomStr);
      EMail email = new EMail();
      email.sendMail(mailDomStr, "ITM");

      System.out.println("[Pdf]  mail delivered successfully");
    }
    catch (ITMException itme)
    {
      System.out.println("@@## ITMException [[Generic Report]] :sendMail  :sendMail :sendMail() :==>\n");
      throw itme;
    }
    catch (Exception e)
    {
      System.out.println("Exception :[[Generic Report]] :sendMail() :==>\n" + e.getMessage());
      throw new ITMException(e);
    }
    return sentMail;
  }

  public boolean checkEmailAddress(String emailValue)
  {
    Pattern pattern = Pattern.compile("[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
    Matcher mat = pattern.matcher(emailValue);
    return mat.matches();
  }

  private String getDomString(String emailIdPer) throws ITMException
  {
    String retString = "";
    StringBuffer valueXmlString = new StringBuffer();
    try
    {
      valueXmlString.append("<ROOT>");
      valueXmlString.append("<Detail1>");
      valueXmlString.append("<email_id_cust>").append("<![CDATA[" + emailIdPer + "]]>").append("</email_id_cust>");
      valueXmlString.append("</Detail1>");
      valueXmlString.append("</ROOT>");
      retString = valueXmlString.toString();
    }
    catch (Exception e)
    {
      e.printStackTrace();
      printLog("ERROR", e);
    }
    return retString;
  }
}