package ibase.webitm.ejb.phizzy;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;

public class PhyziiIC extends ValidatorEJB implements PhyziiICLocal, PhyziiICRemote

{

	E12GenericUtility genericUtility = new E12GenericUtility();
	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,String allFrmXmlStr, String objContext, String editFlag,String xtraParams) throws RemoteException 
	{
		System.out.println("In PriSecSalesConsolidationIC wfValData");
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		try 
		{
			System.out.println("currFrmXmlStr..." + currFrmXmlStr);
			System.out.println("hdrFrmXmlStr..." + hdrFrmXmlStr);
			System.out.println("allFrmXmlStr..." + allFrmXmlStr);
			if ((currFrmXmlStr != null) && (currFrmXmlStr.trim().length() != 0)) 
			{
				currDom = parseString(currFrmXmlStr);
			}
			if ((hdrFrmXmlStr != null) && (hdrFrmXmlStr.trim().length() != 0)) 
			{
				hdrDom = parseString(hdrFrmXmlStr);
			}
			if ((allFrmXmlStr != null) && (allFrmXmlStr.trim().length() != 0)) 
			{
				allDom = parseString(allFrmXmlStr);
			}
			errString = wfValData(currDom, hdrDom, allDom, objContext, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : [PriSecSalesConsolidationIC][wfValData(String currFrmXmlStr)] : ==>\n" + e.getMessage());
		}
		return errString;
	}

	public String wfValData(Document currDom, Document hdrDom, Document allDom,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
	E12GenericUtility genericUtility= new  E12GenericUtility();
	String errString = "" , loginSiteCode = "" , userId ="" , isPrdClosed = "",overWrite="" ;
	String childNodeName = "";
	String sql = "";
	int noOfChilds = 0;
	ResultSet rs = null;
	Connection conn = null;
	PreparedStatement pstmt = null;
	int currentFormNo = 0;
	int cnt = 0,count=0,unConfCnt=0,excnt=0;
	ConnDriver connDriver = null;
	Node childNode = null;
	String empCode="" , prdCode = "" ,maxPrdCode="" ,countryCode="", accPeriod="" ,versionId="",prdCodeFrm="",prdCodeTo="";
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	try {
		System.out.println("************xtraParams*************" + xtraParams);
		connDriver = new ConnDriver();
		conn = connDriver.getConnectDB("DriverITM");
		System.out.println("In wfValData PriSecSalesConsolidationIC :::");
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
		loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode"));
		System.out.println("**************loginCode************" + userId);
		
		if ((objContext != null) && (objContext.trim().length() > 0)) 
		{
			currentFormNo = Integer.parseInt(objContext);
		}
		NodeList parentList = currDom.getElementsByTagName("Detail"+ currentFormNo);
		NodeList childList = null;
		System.out.println("hdrDom..." + hdrDom.toString());
		switch (currentFormNo)
		{
		case 1:
		{
			childList = parentList.item(0).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++) 
			{
				childNode = childList.item(ctr);
				if (childNode.getNodeType() != 1) 
				{
					continue;
				}
				childNodeName = childNode.getNodeName();
				System.out.println("Editflag =" + editFlag);
				System.out.println("parentList = " + parentList);
				System.out.println("childList = " + childList);
				if ("emp_no".equalsIgnoreCase(childNodeName))
				{
					empCode = genericUtility.getColumnValue("emp_no", currDom);
					System.out.println("wfValData>>itemSer>>"+empCode);
					if(empCode == null || empCode.trim().length()==0 )
					{
						errString = itmDBAccessEJB.getErrorString("emp_no","VMNULLEMP",userId);
						break;
					}
					else 
					{
						sql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							count = rs.getInt("COUNT");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("Count: " + count);
						if (count == 0) 
						{
							errString = itmDBAccessEJB.getErrorString("emp_no","VTINVEMP",userId);
							break;
						}
					}
				}
			}
		}
		break;
		
		}
	}
	catch (Exception e) 
	{
		System.out.println("Exception in "+this.getClass().getSimpleName()+"  == >");
		e.printStackTrace();
		throw new ITMException(e);
	}
	finally 
	{
		try 
		{
			if (rs != null) 
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null) 
			{
				pstmt.close();
				pstmt = null;
			}
			if ((conn != null) && (!conn.isClosed()))
				conn.close();
		}
		catch (Exception e) 
		{
			System.out.println("Exception :"+this.getClass().getSimpleName()+":wfValData :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
	}
	return errString;
}
	
	
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str ;
		}

	}


}
	


