package ibase.webitm.ejb.phizzy;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;

import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TreeMap;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SuppressWarnings({ "rawtypes" })
public class VoucherPrintingScheduler implements Schedule  {
	
	E12GenericUtility genericUtility = new E12GenericUtility();
	SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yy");
	String logPath = CommonConstants.JBOSSHOME + File.separator + this.getClass().getSimpleName();
	
	@Override
	public String schedule(String scheduleParamXML) throws Exception {
		UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
		String fromDateStr="",toDateStr="",fromTranId="",toTranId="",userFrom="",userTo="",aprvFrom="",aprvTo="";
		String loginCode = checkNull(userInfo.getLoginCode());
		String lsiteCode = checkNull(userInfo.getSiteCode());
		String errString = "", printerName = "",siteCode="";
		//this.userInfoXml = scheduleParamXML;
		//userInfo = new UserInfoBean(this.userInfoXml);
		String transDB = userInfo.getTransDB();
		System.out.println("get TransDB connection in updateStatus : " + transDB);

		Connection conn=null;
		ConnDriver driver = new ConnDriver();
		//conn = driver.getConnectDB("DriverITM");
		if ((transDB != null) && (transDB.trim().length() > 0))
		{
			conn = driver.getConnectDB(transDB);
		}
		NodeList parentNodeList = null,childNodeList = null;
		Node parentNode = null,childNode = null;
		
		int childNodeListLength = 0;
		String childNodeName = null;
	    Document dom=genericUtility.parseString(scheduleParamXML);
		parentNodeList = dom.getElementsByTagName("ACTUALPARAMETERS");
		parentNode = parentNodeList.item(0);
		childNodeList = parentNode.getChildNodes();
		childNodeListLength = childNodeList.getLength();
		
		System.out.println("childNodeListLength>>> "+ childNodeListLength);
		
		for(int ctr = 0; ctr < childNodeListLength; ctr++)
		{
			childNode = childNodeList.item(ctr);
			childNodeName = childNode.getNodeName();
			
			
			
			
			
			if(childNodeName!=null && !"#text".equalsIgnoreCase(childNodeName))
			{


				if(ctr==0)
				{
					siteCode = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("siteCode>>>>>"+ siteCode);
					System.out.println("childNodeListLength>>> "+ childNodeListLength);
					
				}
				else if(ctr==1)
				{
					fromDateStr = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("fromDateStr>>>>>"+ fromDateStr);
									
				}
				else if(ctr==2)
				{
					toDateStr = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("toDateStr>>>>>"+ toDateStr);
					
				}
				else if(ctr==3)
				{
					fromTranId = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("fromTranId>>>>>"+ fromTranId);
					  		 
				}
				else if(ctr==4)
				{
					toTranId = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("fromTranId>>>>>"+ toTranId);
					  		 
				}
		
				else if(ctr==5)
				{
					userFrom = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("userFrom>>>>>"+ userFrom);
					
				}
				else if(ctr==6)
				{
					userTo = checkNull(childNode.getFirstChild().getNodeValue());
					System.out.println("userTo>>>>>"+ userTo);
					
				}
				else if(ctr==7)
				{
					aprvFrom = checkNull(childNode.getFirstChild().getNodeValue());
 					System.out.println("aprvFrom>>>>>"+ aprvFrom);
 					 
				}
				else if(ctr==8)
				{
					aprvTo = checkNull(childNode.getFirstChild().getNodeValue());
 					System.out.println("aprvTo>>>>>"+ aprvTo);
 					 
				}
			}
			System.out.println("ctrFinal>>>>"+ ctr);
		}
		
		/*
		 * FinCommon finUtil = new FinCommon(); String hol_tblno =
		 * finUtil.getFinparams("999999", "VOU_PRNT_HOL_TBLNO", conn);
		 * if("NULLFOUND".equalsIgnoreCase(hol_tblno)) { errString =
		 * "Please define 'HBL_TBLNO' value in finparm for period '999999' and var_name 'VOU_PRNT_HOL_TBLNO' for considering Holiday table to look for holiday list"
		 * ; writeLog(this.getClass().getSimpleName(), errString); return ""; }
		 * printerName = finUtil.getFinparams("999999", "VOU_PRNT_PRNTR_NAME", conn);
		 * if("NULLFOUND".equalsIgnoreCase(printerName)) { errString =
		 * "Please define value in finparm for period '999999' and var_name 'VOU_PRNT_PRNTR_NAME' for considering Printer for printing voucher"
		 * ; writeLog(this.getClass().getSimpleName(), errString); return ""; }
		 * 
		 * boolean isHoliday = getHolidayForToday(hol_tblno, conn); if(isHoliday) {
		 * errString = "Scheduler not running for date (dd-MMM-yy): " +
		 * sdf.format(Calendar.getInstance().getTime());
		 * writeLog(this.getClass().getSimpleName(), errString); return ""; } else
		 */ {
			
			SimpleDateFormat sdfReport = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			Calendar cal = Calendar.getInstance();
			cal.add(Calendar.DATE, -1);
			Date yesterday = new Date(cal.getTimeInMillis());
			String toDate = sdfReport.format(yesterday);
			
		//	String fromDate = sdfReport.format(getPreviousWorkingDate(yesterday, hol_tblno, conn));
			System.out.println("fromDate ::: " + fromDateStr + " ::: toDate ::: " + toDate);
//			fromDate = "01/01/13";
//			toDate = "01/05/13";
			System.out.println("fromDate ::: " + fromDateStr + " ::: toDate ::: " + toDateStr);
		//	String objName = "d_field_staff_exp_claim_vr";
			
//			String objName = "d_misc_voucher_summary_gst";
			String objName = "d_misc_voucher_summary";

			System.out.println("objName ::: " + objName);
			System.out.println("userName ::: " + loginCode);
//			printerName = "jbnbasehp4thflr";
//			printerName = checkNull(getPrinterName(conn));
			if(printerName.length() > 0) {
				//printVoucher(objName, loginCode, siteCode, fromDate, toDate, printerName, conn);
			//	printVoucher(objName, loginCode, siteCode, fromDateStr, toDateStr, printerName, conn);

			}
	printVoucher(objName, loginCode, siteCode, fromDateStr, toDateStr,fromTranId,toTranId,userFrom,userTo,aprvFrom,aprvTo, printerName, conn,userInfo);
			//String fromDateStr="",toDateStr="",fromTranId="",toTranId="",userFrom="",userTo="",aprvFrom="",aprvTo="";

		}
		return "";
	}

	private String checkNull(String value) {
		return value = value == null ? "" : value.trim(); 
	}



	private Date getPreviousWorkingDate(Date yesterday, String hol_tblno, Connection conn) {
		String sql = "";
		PreparedStatement ps = null;
		ResultSet rs = null;
		Date retValue = null;
		try {
			sql = "select fn_get_previous_working_date(?, ?) as previous from dual";
			ps = conn.prepareStatement(sql);
			ps.setString(1, hol_tblno);
			ps.setDate(2, yesterday);
			rs = ps.executeQuery();
			if(rs.next()) {
				retValue = rs.getDate("previous");
			}
		} catch (SQLException e) {
			retValue = yesterday;
		} finally {
			try {
				rs.close();
				rs = null;
				ps.close();
				ps = null;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return retValue;
	}

	private boolean getHolidayForToday(String hol_tblno, Connection conn) {
		String sql = "";
		PreparedStatement ps = null;
		ResultSet rs = null;
		Date today = null;
		boolean retValue = false;
		try {
			sql = "select hol_tblno from holiday where hol_tblno = ? and hol_date = ?";
			ps = conn.prepareStatement(sql);
			today = new Date(Calendar.getInstance().getTimeInMillis());
			ps.setString(1, hol_tblno);
			ps.setDate(2, today);
			rs = ps.executeQuery();
			if(rs.next()) {
				retValue = true;
			}
		} catch (SQLException e) {
			retValue = false;
		} finally {
			try {
				rs.close();
				rs = null;
				ps.close();
				ps = null;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return retValue;
	}

	private void writeLog(String fileName, String errString) {
		File logFilePath = new File(logPath);
		SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yy kk:mm:ss,SSS");
		System.out.println("logFilePath:::" + logFilePath);
		if(!logFilePath.exists()){
			logFilePath.mkdir();
		}
		
		File logFile = new File(logFilePath + File.separator + fileName + ".log");
		
		FileWriter localFileWriter = null;
		try {
			localFileWriter = new FileWriter(logFile, true);
			localFileWriter.write("[LOG at "+sdf.format(Calendar.getInstance().getTime()) + "]" + errString);
			localFileWriter.write("\n");
			localFileWriter.flush();
			localFileWriter.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}


	@SuppressWarnings("unchecked")
	public void printVoucher(String objName, String loginCode , String siteCode, String fromDate, String toDate,
			String fromTranId,String toTranId,String userFrom,String userTo,String aprvFrom,String aprvTo,
			String printerName, Connection conn, UserInfoBean userInfo) {
		try {
			SimpleDateFormat sdf1 = new SimpleDateFormat("dd-MMM-yy");
			String outputFilename = loginCode+"_"+sdf1.format(System.currentTimeMillis());
			TreeMap argMap = null;
			String argumentString ="<Arguments>" +
					"<Argument id=\"as_site\" name=\"as_site\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+ siteCode +"</value>" +
					"</Argument>" +
					
					"<Argument id=\"as_trandate_fr\" name=\"as_trandate_fr\">" +
					"<argType>java.util.Date</argType>" +
					"<value>"+ fromDate +"</value>" +
					"</Argument>" +
					"<Argument id=\"as_trandate_to\" name=\"as_trandate_to\">" +
					"<argType>java.util.Date</argType>" +
					"<value>"+ toDate +"</value>" +
					"</Argument>" +
					"<Argument id=\"frmtranid\" name=\"frmtranid\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+fromTranId+"</value>" +
					"</Argument>" +
					"<Argument id=\"tomtranid\" name=\"tomtranid\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+toTranId+"</value>" +
					"</Argument>" +
					"<Argument id=\"as_user_fr\" name=\"as_user_fr\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+userFrom+"</value>" +
					"</Argument>" +
					"<Argument id=\"as_user_to\" name=\"as_user_to\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+userTo+"</value>" +
				 	"</Argument>" +
					"<Argument id=\"as_emp_aprv_fr\" name=\"as_emp_aprv_fr\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+aprvFrom+"</value>" +	
					"</Argument>" +
					"<Argument id=\"as_emp_aprv_to\" name=\"as_emp_aprv_to\">" +
					"<argType>java.lang.String</argType>" +
					"<value>"+aprvTo+"</value>" +
					"</Argument>" +
					"<Argument id=\"report_save_type\" name=\"report_save_type\">" +
					"<argType>java.lang.String</argType>" +
					"<value>NATIVE</value>" +
					"</Argument>" +
					"<Argument id=\"data_source\" name=\"data_source\">" +
					"<argType>java.lang.String</argType>" +
					"<value>SQL</value>" +
					"</Argument>" +
				"</Arguments>";
			System.out.println("argumentString:::"+argumentString);
			XSDParser xsdParser = new XSDParser(objName);
			System.out.println(":::::::::::::xsd parsed:::::::::::::");
			JasperReportGenerator jasperReport = new JasperReportGenerator(userInfo);
			System.out.println("after generating report");
			
			argMap = jasperReport.createArgMap(argumentString);
			argMap.put("report_save_type", "PDF");
			System.out.println("argMap:::" + argMap + "\nxsdParser:::" + xsdParser + "\nuserName:::" + loginCode + "\noutputFilename:::" + outputFilename);
			System.out.println("@V@ Printer name :- ["+printerName+"]");
			System.out.println("@V@ objName name :- ["+objName+"]");
			System.out.println("@V@ argumentString name :- ["+argumentString+"]");
			System.out.println("@V@ loginCode name :- ["+loginCode+"]");
			jasperReport.createReport(objName, argMap, xsdParser, loginCode, outputFilename);
			
			
			
			//TODO Print Report
			System.out.println("Sending Report to Print:: @@@Tajuddin " + printerName);
			
			String reportOutputFileName = jasperReport.getOutputFileName();
			System.out.println("reportOutputFileName:::"+reportOutputFileName);
			reportOutputFileName = reportOutputFileName == null ? "" : reportOutputFileName.trim();
			
			if(reportOutputFileName.length() > 0){
				reportOutputFileName = ResourceConstants.REPORTDESTINATION + File.separator + loginCode + File.separator + outputFilename + ".pdf";
//				File f = new File(reportOutputFileName);	
//				String fs = f.getAbsolutePath();
//				int index = fs.indexOf(File.separator + "bin");
//				System.out.println("fs:::"+fs);
//				String  path = fs.substring(0, index);
//				
//				System.out.println("file path:::" + path);
//				System.out.println("Output file name" + reportOutputFileName);
				
				
				//TODO save report to Voucher Folder
				File orignalFile= new File(reportOutputFileName);
				File reportSavePath = new File(logPath +File.separator + "Voucher");
				if(!reportSavePath.exists()){
					reportSavePath.mkdir();
				}
				File detFile= new File(reportSavePath.getAbsolutePath()+File.separator+outputFilename+".pdf");
				orignalFile.renameTo(detFile);
				
//				argMap = null;
//				
//				argMap = jasperReport.createArgMap(argumentString);
//				argMap.put("report_save_type", "NATIVE");
				/*
				 * try { jasperReport.printReport(objName, argumentString, loginCode,
				 * printerName, 1, conn); } catch (Exception e) { String errString =
				 * "Printing voucher fail for loginCode["+loginCode+"] siteCode["+siteCode+"],"
				 * + "fromDate["+fromDate+"], toDate["
				 * +toDate+"], empCodeFrom [00], empCodeTo[ZZ]. Please use same retreival from Metis to check."
				 * ; writeLog(this.getClass().getSimpleName(), errString); }
				 */
			} else {
				String errString = "Printing voucher fail for loginCode["+loginCode+"] siteCode["+siteCode+"]," +
						"fromDate["+fromDate+"], toDate["+toDate+"], empCodeFrom [00], empCodeTo[ZZ]";
				writeLog(this.getClass().getSimpleName(), errString);
			}
		} catch(Exception e) {
			String errString = "Printing voucher fail for loginCode["+loginCode+"] siteCode["+siteCode+"]," +
					"fromDate["+fromDate+"], toDate["+toDate+"], empCodeFrom [00], empCodeTo[ZZ]. Please use same retreival from Metis to check.";
			writeLog(this.getClass().getSimpleName(), errString);
		}
		finally {
		System.out.println("In finally block of printVoucher");	
		}
	}

	@Override
	public String schedulePriority(String arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String schedule(HashMap arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
}
