package ibase.webitm.marketing.servlet;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.DocumentHandlerWrapperLocal;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import javax.ejb.Stateless;
import javax.naming.InitialContext;

@Stateless
public class UnallocatedMrketingDoc implements UnallocatedMrketingDocRemote, UnallocatedMrketingDocLocal {
	Map<String, ArrayList<String>> mapList = new HashMap();

	public Map<String, ArrayList<String>> addDocument() {
		String strGetObj = "select obj_name from unallocated_attach WHERE STATUS='N' AND upper(obj_name) = 'MARKETING_BILL' group by obj_name";
		String objName = "";
		Connection conn = null;
		PreparedStatement pstmtParamName=null;
		PreparedStatement pstmtParamName2=null;

		ResultSet rsCnt2=null;
		ResultSet rsCnt =null;
		try {
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			ArrayList docIds = new ArrayList();
			 pstmtParamName = conn.prepareStatement(
					"select obj_name from unallocated_attach WHERE STATUS='N' AND upper(obj_name) = 'MARKETING_BILL' group by obj_name");
			 rsCnt = pstmtParamName.executeQuery();

			String unallocDocIds;
			while (rsCnt.next()) {
				System.out.println("obj name = " + rsCnt.getString(1));
				objName = rsCnt.getString(1);
				unallocDocIds = "select doc_id from UNALLOCATED_ATTACH where STATUS='N' and OBJ_NAME =? order by Added_on , ref_id";
				 pstmtParamName2 = conn.prepareStatement(
						"select doc_id from UNALLOCATED_ATTACH where STATUS='N' and OBJ_NAME =? order by Added_on , ref_id");
				pstmtParamName2.setString(1, rsCnt.getString(1));
				 rsCnt2 = pstmtParamName2.executeQuery();

				while (rsCnt2.next()) {
					docIds.add(rsCnt2.getString(1));
				}

				this.mapList.put(objName, docIds);
			}

			pstmtParamName.close();
			pstmtParamName = null;
			rsCnt.close();
			rsCnt = null;
			//added by sangita 21-4-23
			pstmtParamName2.close();
			pstmtParamName2 = null;
			rsCnt2.close();
			rsCnt2 = null;
			//added by sangita 21-4-23

			if (docIds != null && !docIds.isEmpty()) {
				unallocDocIds = "";

				int updateCnt;
				for (updateCnt = 0; updateCnt < docIds.size(); ++updateCnt) {
					unallocDocIds = String.valueOf(unallocDocIds) + "'" + docIds.get(updateCnt) + "', ";
				}

				unallocDocIds = unallocDocIds.trim();
				if (unallocDocIds.trim().length() > 2) {
					unallocDocIds = unallocDocIds.substring(1, unallocDocIds.length() - 2);
				}

				System.out.println("unallocDocIds = " + unallocDocIds);
				updateCnt = this.updateUnallocAttachAddedToMap(objName, unallocDocIds);
				System.out.println(String.valueOf(updateCnt) + " rows of UNALLOCATED_ATTACH updated.");
			}

			System.out.println(
					"\n=========================================================In addDocument()=======================================================================\n");
			Iterator var29 = this.mapList.entrySet().iterator();

			while (var29.hasNext()) {
				Entry entry = (Entry) var29.next();
				String key = entry.getKey().toString();
				ArrayList values = (ArrayList) entry.getValue();
				System.out.println("ObjName = [" + key + "] Document Ids = [" + values + "]");
			}
		} catch (SQLException var24) {
			var24.printStackTrace();
		} catch (Exception var25) {
			var25.printStackTrace();
		} finally {
			try {
				
				
				
				
				if (conn != null) {
					
					if(rsCnt2 !=null)
						
					{
						rsCnt2.close();
						rsCnt2 = null;
					}
                  if(rsCnt !=null)
						
					{
						rsCnt.close();
						rsCnt = null;
					}
                  if(pstmtParamName !=null)
						
					{
                	  pstmtParamName.close();
                	  pstmtParamName = null;
					}
                  if(pstmtParamName2 !=null)
						
					{
              	  pstmtParamName2.close();
              	  pstmtParamName2 = null;
					}
					conn.close();
				}

				conn = null;
			} catch (Exception var22) {
				var22.printStackTrace();
			}

		}

		try {
			if (conn != null) {
				conn.close();
			}

			conn = null;
		} catch (Exception var23) {
			var23.printStackTrace();
		}

		return this.mapList;
	}

	public void getDocumentList(String objName) {
		if (this.mapList.containsKey(objName)) {
			System.out.println(
					"\n=========================================================In getDocumentList()=======================================================================\n");
			System.out.println("obj_name = " + objName);
			ArrayList arrayList = (ArrayList) this.mapList.get(objName);
			System.out.println("document Id List = " + arrayList);
		} else {
			System.out.println("Document you want to view not present in hashmap");
		}

	}

	public void isDocumentExist(String objName, String docId) {
		if (this.mapList.containsKey(objName)) {
			ArrayList arrayList = (ArrayList) this.mapList.get(objName);
			if (arrayList.contains(docId)) {
				System.out.println(" Document present in list ");
			} else {
				System.out.println(" Document is not present in list ");
			}
		} else {
			System.out.println(" Document is not present in list ");
		}

	}

	public void removeDocument(String objName, String docId) {
		ArrayList oldArrayList;
		if (this.mapList.containsKey(objName)) {
			oldArrayList = (ArrayList) this.mapList.get(objName);
			if (oldArrayList.contains(docId)) {
				((ArrayList) this.mapList.get(objName)).remove(docId);
				System.out.println(" Document remove from list");
			} else {
				System.out.println(" Document you want to remove not present in list");
			}
		} else {
			System.out.println(" Document you want to remove note present in list");
		}

		System.out.println(
				"\n================================= In removeDocument() ===================================\n");
		System.out.println("obj_name = " + objName);
		oldArrayList = (ArrayList) this.mapList.get(objName);
		System.out.println("After remove document Ids List = " + oldArrayList);
	}

	public Map<String, ArrayList<String>> appendDocument(String endTime, String inProcessDocIds) {
		String strGetObj = "select obj_name from unallocated_attach WHERE STATUS='N' AND upper(obj_name) = 'MARKETING_BILL' group by obj_name";
		String objName = "";
		Connection conn = null;
		HashMap newUnAllocDocMap = new HashMap();

		try {
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			PreparedStatement pstmtParamName = conn.prepareStatement(
					"select obj_name from unallocated_attach WHERE STATUS='N' AND upper(obj_name) = 'MARKETING_BILL' group by obj_name");
			ResultSet rsCnt = pstmtParamName.executeQuery();

			ArrayList docIds;
			while (rsCnt.next()) {
				System.out.println("obj name = [" + rsCnt.getString(1) + "]");
				objName = rsCnt.getString(1);
				String strGetDocId = "";
				if (endTime != null && endTime.trim().length() > 0) {
					if (inProcessDocIds != null && inProcessDocIds.trim().length() > 0) {
						strGetDocId = "select doc_id from UNALLOCATED_ATTACH where STATUS='N'  and OBJ_NAME = ? AND doc_id NOT IN(?) and to_char(added_on, 'dd/MM/yy HH24:MI:SS') >= ? order by Added_on ,ref_id";
					} else {
						strGetDocId = "select doc_id from UNALLOCATED_ATTACH where STATUS='N'  and OBJ_NAME = ? AND to_char(added_on, 'dd/MM/yy HH24:MI:SS') >= ? order by Added_on ,ref_id";
					}
				} else if (inProcessDocIds != null && inProcessDocIds.trim().length() > 0) {
					strGetDocId = "select doc_id from UNALLOCATED_ATTACH where STATUS='N' and OBJ_NAME = ? AND doc_id NOT IN(?) order by Added_on ,ref_id";
				} else {
					strGetDocId = "select doc_id from UNALLOCATED_ATTACH where STATUS='N' and OBJ_NAME = ? order by Added_on ,ref_id";
				}

				PreparedStatement pstmtParamName2 = conn.prepareStatement(strGetDocId);
				pstmtParamName2.setString(1, rsCnt.getString(1));
				if (endTime != null && endTime.trim().length() > 0) {
					if (inProcessDocIds != null && inProcessDocIds.trim().length() > 0) {
						pstmtParamName2.setString(2, inProcessDocIds);
						pstmtParamName2.setString(3, endTime);
					} else {
						pstmtParamName2.setString(2, endTime);
					}
				} else if (inProcessDocIds != null && inProcessDocIds.trim().length() > 0) {
					pstmtParamName2.setString(2, inProcessDocIds);
				}

				ResultSet rsCnt2 = pstmtParamName2.executeQuery();
				docIds = new ArrayList();

				while (rsCnt2.next()) {
					docIds.add(rsCnt2.getString(1));
				}

				this.mapList.put(objName, docIds);
				newUnAllocDocMap.put(objName, docIds);
			}

			System.out.println(
					"\n====================================== In appendDocument() ==========================================\n");
			Iterator var29 = this.mapList.entrySet().iterator();

			while (var29.hasNext()) {
				Entry entry = (Entry) var29.next();
				String key = entry.getKey().toString();
				docIds = (ArrayList) entry.getValue();
				System.out.println("ObjName = [" + key + "] Document Ids = [" + docIds + "]");
			}
		} catch (SQLException var26) {
			var26.printStackTrace();
		} catch (Exception var27) {
			var27.printStackTrace();
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}

				conn = null;
			} catch (Exception var24) {
				var24.printStackTrace();
			}

		}

		try {
			if (conn != null) {
				conn.close();
			}

			conn = null;
		} catch (Exception var25) {
			var25.printStackTrace();
		}

		return newUnAllocDocMap;
	}

	public String getDocumentTime() {
		Connection conn = null;
		String maxTime = "";

		try {
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			String sql = "SELECT to_char(MAX(added_on), 'dd/MM/yy HH24:MI:SS') FROM UNALLOCATED_ATTACH where STATUS='N'";
			PreparedStatement pstmtParamName = conn.prepareStatement(
					"SELECT to_char(MAX(added_on), 'dd/MM/yy HH24:MI:SS') FROM UNALLOCATED_ATTACH where STATUS='N'");

			for (ResultSet rsCnt = pstmtParamName.executeQuery(); rsCnt.next(); maxTime = rsCnt.getString(1)) {
				;
			}

			System.out.println("maxTime = [" + maxTime + "]");
		} catch (SQLException var19) {
			var19.printStackTrace();
		} catch (Exception var20) {
			var20.printStackTrace();
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}

				conn = null;
			} catch (Exception var17) {
				var17.printStackTrace();
			}

		}

		try {
			if (conn != null) {
				conn.close();
			}

			conn = null;
		} catch (Exception var18) {
			var18.printStackTrace();
		}

		return maxTime;
	}

	public String updateDocTransactionLink(String newObjName, String newRefId, String oldObjName, String docId,
			String LoginEmpCode, Connection conn) throws RemoteException, ITMException {
		ConnDriver connDriver = null;
		connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		String newRefSer = "";
		String oldRefSer = "";
		String oldRefId = "";
		String retVal = "success";
		boolean localConn = false;

		try {
			if (conn == null) {
				conn = connDriver.getConnectDB("DriverITM");
				localConn = true;
				conn.setAutoCommit(false);
			}

			newRefSer = this.getRefSer(conn, newObjName);
			oldRefSer = this.getRefSer(conn, oldObjName);
			oldRefId = this.getRefId(conn, oldRefSer, docId);
			String docTranLinkSql = "UPDATE DOC_TRANSACTION_LINK SET REF_SER = ? , REF_ID = ? WHERE REF_SER = ? AND REF_ID = ? AND DOC_ID = ?";
			pstmt = conn.prepareStatement(
					"UPDATE DOC_TRANSACTION_LINK SET REF_SER = ? , REF_ID = ? WHERE REF_SER = ? AND REF_ID = ? AND DOC_ID = ?");
			pstmt.setString(1, newRefSer);
			pstmt.setString(2, newRefId);
			pstmt.setString(3, oldRefSer);
			pstmt.setString(4, oldRefId);
			pstmt.setString(5, docId);
			int updateCount = pstmt.executeUpdate();
			System.out.println(String.valueOf(updateCount) + " rows of DOC_TRANSACTION_LINK updated.");
			pstmt.close();
			pstmt = null;
			String unalSql = "UPDATE UNALLOCATED_ATTACH SET MOVED_ON = sysdate , MOVED_BY = ?, STATUS = ?, OBJ_NAME__NEW = ?, REF_ID__NEW = ? WHERE REF_ID = ? AND DOC_ID = ?";
			pstmt = conn.prepareStatement(
					"UPDATE UNALLOCATED_ATTACH SET MOVED_ON = sysdate , MOVED_BY = ?, STATUS = ?, OBJ_NAME__NEW = ?, REF_ID__NEW = ? WHERE REF_ID = ? AND DOC_ID = ?");
			pstmt.setString(1, LoginEmpCode);
			pstmt.setString(2, "Y");
			pstmt.setString(3, newObjName);
			pstmt.setString(4, newRefId);
			pstmt.setString(5, oldRefId);
			pstmt.setString(6, docId);
			int update = pstmt.executeUpdate();
			System.out.println(String.valueOf(update) + " rows of UNALLOCATED_ATTACH updated.");
			pstmt.close();
			pstmt = null;
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			DocumentHandlerWrapperLocal docHandler = (DocumentHandlerWrapperLocal) ctx
					.lookup("ibase/DocumentHandlerWrapperEJB/local");
			docHandler.updateCountOfAttachments(newObjName, newRefId, newRefSer, conn, "");
			if (localConn) {
				conn.commit();
			}
		} catch (SQLException var31) {
			retVal = "error";
			var31.printStackTrace();
			throw new ITMException(var31);
		} catch (Exception var32) {
			retVal = "error";
			var32.printStackTrace();
			throw new ITMException(var32);
		} finally {
			try {
				if (localConn && conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException var29) {
				var29.printStackTrace();
			}

		}

		try {
			if (localConn && conn != null) {
				conn.close();
				conn = null;
			}
		} catch (SQLException var30) {
			var30.printStackTrace();
		}

		return retVal;
	}

	public String getRefSer(Connection conn, String objName) throws ITMException, RemoteException {
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		String refSer = "";

		try {
			objName = "w_" + objName;
			sql = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, objName);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				refSer = rs.getString("REF_SER") == null ? "" : rs.getString("REF_SER");
			}
		} catch (Exception var17) {
			System.out.println("[UnallocatedMrketingDoc] :: [getRefSer()] :: " + var17.getMessage());
			throw new ITMException(var17);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pStmt != null) {
					pStmt.close();
					pStmt = null;
				}
			} catch (SQLException var16) {
				System.out.println("[UnallocatedMrketingDoc] :: [getRefSer()] :finally: " + var16.getMessage());
				throw new ITMException(var16);
			}

		}

		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}

			if (pStmt != null) {
				pStmt.close();
				pStmt = null;
			}

			return refSer;
		} catch (SQLException var15) {
			System.out.println("[UnallocatedMrketingDoc] :: [getRefSer()] :finally: " + var15.getMessage());
			throw new ITMException(var15);
		}
	}

	public String getRefId(Connection conn, String refSer, String docId) throws ITMException, RemoteException {
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		String refId = "";

		try {
			sql = "SELECT REF_ID FROM UNALLOCATED_ATTACH WHERE REF_SER = ? AND DOC_ID = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, refSer);
			pStmt.setString(2, docId);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				refId = rs.getString("REF_ID") == null ? "" : rs.getString("REF_ID");
			}
		} catch (Exception var18) {
			System.out.println("[UnallocatedMrketingDoc] :: [getRefId()] :: " + var18.getMessage());
			throw new ITMException(var18);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pStmt != null) {
					pStmt.close();
					pStmt = null;
				}
			} catch (SQLException var17) {
				System.out.println("[UnallocatedMrketingDoc] :: [getRefId()] :finally: " + var17.getMessage());
				throw new ITMException(var17);
			}

		}

		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}

			if (pStmt != null) {
				pStmt.close();
				pStmt = null;
			}

			return refId;
		} catch (SQLException var16) {
			System.out.println("[UnallocatedMrketingDoc] :: [getRefId()] :finally: " + var16.getMessage());
			throw new ITMException(var16);
		}
	}

	public Map<String, ArrayList<String>> appendDocument() {
		System.out.println(
				"\n====================================== In appendDocument() ==========================================\n");
		String objName = "";
		Connection conn = null;
		HashMap newUnAllocDocMap = new HashMap();

		try {
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			String strGetObj = "select obj_name from unallocated_attach WHERE STATUS='N' AND upper(obj_name) = 'MARKETING_BILL' group by obj_name";
			ArrayList docIds = new ArrayList();
			PreparedStatement pstmtParamName = conn.prepareStatement(
					"select obj_name from unallocated_attach WHERE STATUS='N' AND upper(obj_name) = 'MARKETING_BILL' group by obj_name");
			ResultSet rsCnt = pstmtParamName.executeQuery();

			String unallocDocIds;
			while (rsCnt.next()) {
				objName = rsCnt.getString(1);
				System.out.println("objName = [" + objName + "]");
				unallocDocIds = "";
				unallocDocIds = "SELECT DOC_ID FROM UNALLOCATED_ATTACH WHERE STATUS='N' AND OBJ_NAME = ? AND ADDED_TO_MAP != 1 ORDER BY ADDED_ON, REF_ID";
				PreparedStatement pstmtParamName2 = conn.prepareStatement(unallocDocIds);
				pstmtParamName2.setString(1, objName);
				ResultSet rsCnt2 = pstmtParamName2.executeQuery();

				while (rsCnt2.next()) {
					docIds.add(rsCnt2.getString(1));
				}

				newUnAllocDocMap.put(objName, docIds);
			}

			pstmtParamName.close();
			pstmtParamName = null;
			rsCnt.close();
			rsCnt = null;
			if (docIds != null && !docIds.isEmpty()) {
				unallocDocIds = "";

				int updateCnt;
				for (updateCnt = 0; updateCnt < docIds.size(); ++updateCnt) {
					unallocDocIds = String.valueOf(unallocDocIds) + "'" + docIds.get(updateCnt) + "', ";
				}

				unallocDocIds = unallocDocIds.trim();
				if (unallocDocIds.length() > 2) {
					unallocDocIds = unallocDocIds.substring(1, unallocDocIds.length() - 2);
				}

				System.out.println("unallocDocIds = " + unallocDocIds);
				updateCnt = this.updateUnallocAttachAddedToMap(objName, unallocDocIds);
				System.out.println(String.valueOf(updateCnt) + " rows of UNALLOCATED_ATTACH updated.");
			}
		} catch (SQLException var24) {
			var24.printStackTrace();
		} catch (Exception var25) {
			var25.printStackTrace();
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}

				conn = null;
			} catch (Exception var22) {
				var22.printStackTrace();
			}

		}

		try {
			if (conn != null) {
				conn.close();
			}

			conn = null;
		} catch (Exception var23) {
			var23.printStackTrace();
		}

		return newUnAllocDocMap;
	}

	private int updateUnallocAttachAddedToMap(String objName, String unallocDocIds) {
		int updateCnt = 0;
		Connection conn = null;
		PreparedStatement pstmt = null;

		try {
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			if (unallocDocIds == null || unallocDocIds.trim().isEmpty()) {
				return updateCnt;
			}

			String updateUnallocIds = "UPDATE UNALLOCATED_ATTACH SET ADDED_TO_MAP = '1' WHERE DOC_ID IN ('"
					+ unallocDocIds + "') AND OBJ_NAME = ?";
			pstmt = conn.prepareStatement(updateUnallocIds);
			pstmt.setString(1, objName);
			updateCnt = pstmt.executeUpdate();
			System.out.println(String.valueOf(updateCnt) + " rows of UNALLOCATED_ATTACH updated.");
			pstmt.close();
			pstmt = null;
			if (updateCnt > 0) {
				conn.commit();
			}
		} catch (SQLException var23) {
			var23.printStackTrace();
		} catch (Exception var24) {
			var24.printStackTrace();

			try {
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException var22) {
				var24.printStackTrace();
			}
		} finally {
			try {
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException var20) {
				var20.printStackTrace();
			}

		}

		try {
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (SQLException var21) {
			var21.printStackTrace();
		}

		return updateCnt;
	}
}