package ibase.webitm.ejb.marketingsch;

import ibase.utility.BaseException;
import java.sql.Statement;
import java.io.StringWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import java.io.FileOutputStream;
import ibase.webitm.applAdmin.bean.DocumentPrint;
import java.io.ByteArrayInputStream;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.lowagie.text.pdf.PdfReader;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.sql.Timestamp;
import ibase.webitm.utility.TransIDGenerator;
import org.w3c.dom.Node;
import org.w3c.dom.Document;
import java.sql.ResultSet;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.FileInputStream;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import ibase.utility.UserInfoBean;
import java.sql.PreparedStatement;
import java.sql.Connection;
import java.io.ByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.sql.SQLException;
import java.io.FileFilter;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import java.io.File;
import java.util.ArrayList;
import ibase.utility.E12GenericUtility;
import javax.ejb.Stateless;

@Stateless
public class AttachmentHandlerEJB implements AttachmentHandlerEJBRemote, AttachmentHandlerEJBLocal {
	E12GenericUtility genericUtility;

	public AttachmentHandlerEJB() {
		this.genericUtility = new E12GenericUtility();
	}

	public String handleAttachment(String objName, final String tranIdFrom, final String tranIdTo,
			final String loginCode) throws RemoteException, ITMException {
		String attachmentDirPath = "";
		String toBeLoadedDirPath = "";
		String unAllocatedDirPath = "";
		String loadedDirPath = "";
		String toBeLoadedSubDirPath = "";
		ArrayList<File> directoryList = new ArrayList<File>();
		final BufferedInputStream bfr = null;
		final ByteArrayOutputStream bout = null;
		final StringBuffer retXMLStringBuff = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		final byte[] byteArray = {0};
		String retString = null;
		PreparedStatement unalPstmt = null;
		try {
			System.out.println("@ Amit Inside AttachmentHandler Ejb ");
			objName = objName.replace("w_", "");
			System.out.println("objName>>>> " + objName);
			UserInfoBean userInfoBean = this.createUserInfo(loginCode);
			conn = connDriver.getConnectDB(userInfoBean.getTransDB());
			conn.setAutoCommit(false);
			connDriver = null;
			final AppConnectParm appConnect = new AppConnectParm();
			final DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
			//attachmentDirPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "attachment";
			//System.out.println("attachmentDirPath>>> " + attachmentDirPath);
			//toBeLoadedDirPath = String.valueOf(attachmentDirPath) + File.separator + "to_be_loaded";
			//System.out.println("toBeLoadedDirPath>>> " + toBeLoadedDirPath);
			//loadedDirPath = String.valueOf(attachmentDirPath) + File.separator + "loaded";
			//System.out.println("loadedDirPath>>> " + loadedDirPath);
			//unAllocatedDirPath = String.valueOf(attachmentDirPath) + File.separator + "unAllocated";
			//System.out.println("unAllocatedDirPath>>> " + unAllocatedDirPath);
			FinCommon finCommon = new FinCommon();
			toBeLoadedDirPath = finCommon.getFinparams("999999", "MKT_TBLD_PTH", conn);
			attachmentDirPath = finCommon.getFinparams("999999", "MKT_ATCH_PTH", conn);
			unAllocatedDirPath = finCommon.getFinparams("999999", "MKT_UNAL_PTH", conn);
			loadedDirPath = finCommon.getFinparams("999999", "MKT_LOAD_PTH", conn);
			System.out.println("toBeLoadedDirPath>>>> " + toBeLoadedDirPath);
			System.out.println("attachmentDirPath>>>> " + attachmentDirPath);
			System.out.println("loadedDirPath>>>> " + loadedDirPath);
			System.out.println("unAllocatedDirPath>>>> " + unAllocatedDirPath);
			File path = new File(toBeLoadedDirPath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			path = new File(attachmentDirPath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			path = new File(unAllocatedDirPath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			path = new File(loadedDirPath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			if (objName != null && objName.trim().length() > 0) {
				toBeLoadedSubDirPath = String.valueOf(toBeLoadedDirPath) + File.separator + objName;
				System.out.println("toBeLoadedSubDirPath>> " + toBeLoadedSubDirPath);
				final File subDir = new File(toBeLoadedSubDirPath);
				System.out.println("subDir>>>> " + subDir);
				if (subDir.exists()) {
					System.out.println("inside the sub dir");
					directoryList.add(subDir);
				}
			} else {
				System.out.println("inside the else  sub dir");
				directoryList = this.getDirectoryNamesForAttachment(toBeLoadedDirPath);
			}
			final int directoryListLen = directoryList.size();
			System.out.println("directoryListLen = [" + directoryListLen + "] directoryList = " + directoryList);
			for (int i = 0; i < directoryListLen; ++i) {
				objName = directoryList.get(i).getName();
				toBeLoadedSubDirPath = String.valueOf(toBeLoadedDirPath) + File.separator + objName;
				System.out.println("toBeLoadedSubDirPath>>> " + toBeLoadedSubDirPath);
				final String refSer = this.getRefSer(conn, objName);
				final String loginSite = this.getLoginSite(loginCode, conn);
				final FileFilter fileFilter = new FileFilter() {
					@Override
					public boolean accept(final File file) {
						return !file.isDirectory();
					}
				};
				final File toBeLoadedSubDir = new File(toBeLoadedSubDirPath);
				System.out.println("File toBeLoadedSubDir>>>> " + toBeLoadedSubDir);
				File[] fileArray = new File[0];
				if (toBeLoadedSubDir.isDirectory()) {
					fileArray = toBeLoadedSubDir.listFiles(fileFilter);
					System.out.println("fileArray>>>>>> " + fileArray);
				}
				System.out.println("fileArray.length = [" + fileArray.length + "], objName = [" + objName + "]");
				for (int j = 0; j < fileArray.length; ++j) {
					final File fileToBeAttached = fileArray[j];
					final String fileName = fileToBeAttached.getName();
					String tranID = "";
					if (fileName.contains("_")) {
						tranID = fileName.substring(0, fileName.indexOf("_"));
					} else if (fileName.contains(".")) {
						tranID = fileName.substring(0, fileName.indexOf("."));
					}
					System.out.println("fileName = [" + fileName + "], tranID = [" + tranID + "]");
					final boolean isFileToBeAttach = this.getTransactionsBetweenRange(objName, tranIdFrom, tranIdTo,
							tranID, conn);
					System.out.println("isFileToBeAttach = [" + isFileToBeAttach + "]");
					retString = this.uploadAttachments(objName, refSer, tranID, loginCode, loginSite, fileToBeAttached,
							conn, docHandler, loadedDirPath, unAllocatedDirPath, toBeLoadedSubDirPath,
							isFileToBeAttach);
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			try {
				if (unalPstmt != null) {
					try {
						unalPstmt.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
					unalPstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
			return retString;
		} finally {
			try {
				if (unalPstmt != null) {
					try {
						unalPstmt.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
					unalPstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
		}
		try {
			if (unalPstmt != null) {
				try {
					unalPstmt.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
				unalPstmt = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (SQLException sqle) {
			sqle.printStackTrace();
		}
		return retString;
	}

	private String uploadAttachments(final String objName, final String refSer, String tranID, final String loginCode,
			final String loginSite, final File fileTobeAttached, Connection conn, final DocumentHandlerEJB docHandler,
			final String loadedDirPath, final String unAllocatedDirPath, final String toBeLoadedSubDirPath,
			final boolean isFileToBeAttach) throws Exception {
		String retString = null;
		byte[] byteArray = {0};
		ConnDriver connDriver = new ConnDriver();
		final StringBuffer retXMLStringBuff = new StringBuffer();
		PreparedStatement unalPstmt = null;
		boolean localConn = false;
		ResultSet rs = null;
		String MktRefSer = "";
		final StringBuffer uploadFileLog = new StringBuffer();
		String doc_id = "";
		Label_3514 : {
			try {
				System.out
						.println("Inside uploadAttachments - tranID = [" + tranID + "] - objName = [" + objName + "]");
				uploadFileLog
						.append("Inside uploadAttachments - tranID = [" + tranID + "] - objName = [" + objName + "]\n");
				if (conn == null) {
					final UserInfoBean userInfoBean = this.createUserInfo(loginCode);
					conn = connDriver.getConnectDB(userInfoBean.getTransDB());
					conn.setAutoCommit(false);
					localConn = true;
				}
				connDriver = null;
				final String fileName = fileTobeAttached.getName();
				final String filePath = fileTobeAttached.toString();
				System.out.println("fileName = [" + fileName + "] - filePath = [" + filePath + "]");
				uploadFileLog.append("fileName = [" + fileName + "] - filePath = [" + filePath + "]\n");
				final File file = new File(filePath);
				System.out.println("@ Amit file>>>>>>" + file);
				final String fileType = filePath.substring(filePath.lastIndexOf(".") + 1);
				System.out.println("@ Amit fileType>>>>>>" + fileType);
				if (!isFileToBeAttach) {
					if (fileName.contains(".")) {
						tranID = fileName.substring(0, fileName.lastIndexOf("."));
					}
					if (tranID.length() > 50) {
						tranID = tranID.substring(0, 49);
					}
				}
				uploadFileLog.append("isFileToBeAttach : [" + isFileToBeAttach + "]\n");
				uploadFileLog.append("tranID : [" + tranID + "]\n");
				final FileInputStream input = new FileInputStream(file);
				final BufferedInputStream bfr = new BufferedInputStream(input);
				final ByteArrayOutputStream bout = new ByteArrayOutputStream();
				int readCount = 0;
				while ((readCount = bfr.read()) != -1) {
					bout.write(readCount);
				}
				byteArray = bout.toByteArray();
				System.out.println("byteArray>>>>>" + byteArray);
				retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
				retXMLStringBuff.append("<DocumentRoot>");
				retXMLStringBuff.append("<description>Datawindow Root</description>");
				retXMLStringBuff.append("<group0>");
				retXMLStringBuff.append("<description>Group0 description</description>");
				retXMLStringBuff.append("<Header0>");
				retXMLStringBuff.append("<description>Header0 members</description>");
				retXMLStringBuff.append("<header>");
				retXMLStringBuff.append("<ref_id><![CDATA[" + tranID + "]]></ref_id>");
				retXMLStringBuff.append("<ref_ser><![CDATA[" + refSer + "]]></ref_ser>");
				retXMLStringBuff.append("<doc_name><![CDATA[" + fileName + "]]></doc_name>");
				retXMLStringBuff.append("<doc_type><![CDATA[" + fileType + "]]></doc_type>");
				retXMLStringBuff.append("<obj_name><![CDATA[" + objName + "]]></obj_name>");
				retXMLStringBuff.append("<created_by><![CDATA[" + loginCode + "]]></created_by>");
				retXMLStringBuff
						.append("<doc_pages><![CDATA[" + this.getPageCount(fileTobeAttached) + "]]></doc_pages>");
				retXMLStringBuff.append("</header>");
				retXMLStringBuff.append("</Header0>");
				retXMLStringBuff.append("</group0>");
				retXMLStringBuff.append("</DocumentRoot>");
				System.out.println("retXMLStringBuff = [" + retXMLStringBuff.toString() + "]");
				uploadFileLog.append("retXMLStringBuff = [" + retXMLStringBuff.toString() + "]\n");
				try {
					docHandler.ejbCreate();
					//UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
					UserInfoBean userInfo = this.createUserInfo(loginCode);
					retString = docHandler.addDocument(retXMLStringBuff.toString(), byteArray,(byte[]) null, userInfo);
					uploadFileLog.append("retString after upload : [" + retString + "]\n");
				} catch (Exception e1) {
					uploadFileLog.append("Exception while addDocument : [" + this.getStackTrace(e1) + "]\n");
					e1.printStackTrace();
					throw new ITMException(e1);
				}
				bfr.close();
				bout.close();
				System.out.println("retString = [" + retString + "]");
				if (isFileToBeAttach) {
					final File objNameFolder = new File(String.valueOf(loadedDirPath) + File.separator + objName);
					if (!objNameFolder.exists()) {
						final File ObjNameFold = new File(String.valueOf(loadedDirPath) + File.separator + objName);
						if (!ObjNameFold.mkdir()) {
							break Label_3514;
						}
						final boolean success = file.renameTo(new File(objNameFolder, file.getName()));
						if (!success) {
							System.out.print("this file [" + file.getName() + "] is not moved to the [" + objNameFolder
									+ "] Folder");
							uploadFileLog.append("File : [" + file.getName() + "] is not moved to the [" + objNameFolder
									+ "] folder.\n");
							break Label_3514;
						}
						uploadFileLog.append(
								"File : [" + file.getName() + "] is moved to the [" + objNameFolder + "] folder.\n");
					} else {
						final boolean success2 = file.renameTo(new File(objNameFolder, file.getName()));
						if (!success2) {
							System.out.print("file " + file.getName() + " is not moved");
							uploadFileLog.append("File : [" + file.getName() + "] is not moved to the [" + objNameFolder
									+ "] folder.\n");
							break Label_3514;
						}
						uploadFileLog.append(
								"File : [" + file.getName() + "] is moved to the [" + objNameFolder + "] folder.\n");
					}
				} else {
					final Document dom = this.genericUtility.parseString(retString);
					final Node node = dom.getElementsByTagName("ID").item(0);
					if (node == null || node.getAttributes() == null
							|| node.getAttributes().getNamedItem("Document_Id") == null) {
						break Label_3514;
					}
					doc_id = node.getAttributes().getNamedItem("Document_Id").getNodeValue();
					System.out.println("doc_id - [" + doc_id + "]");
					uploadFileLog.append("doc_id : [" + doc_id + "]\n");
					final String UDF_STR3 = "M-BILL";
					String sql = "SELECT UDF_STR3  FROM SSCBARCODE_TRAN WHERE UDF_STR3  = ? ";
					unalPstmt = conn.prepareStatement(sql);
					unalPstmt.setString(1, UDF_STR3);
					rs = unalPstmt.executeQuery();
					if (rs.next()) {
						MktRefSer = rs.getString("UDF_STR3");
					}
					if (unalPstmt != null) {
						unalPstmt.close();
						unalPstmt = null;
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					int updatecnt = 0;
					final String uniqueTranIdGenerator = this.generateTranId("W_UNALLOCATED", loginSite, loginCode,
							conn);
					sql = "INSERT INTO UNALLOCATED_ATTACH (TRAN_ID,REF_ID,REF_SER,DOC_ID,OBJ_NAME,STATUS,ADDED_BY,ADDED_TO_MAP,ADDED_ON)  VALUES ( ?,?,?,?,?,?,?,?,sysdate )";
					try {
						unalPstmt = conn.prepareStatement(sql);
						unalPstmt.setString(1, uniqueTranIdGenerator);
						unalPstmt.setString(2, tranID);
						unalPstmt.setString(3, MktRefSer);
						unalPstmt.setString(4, doc_id);
						unalPstmt.setString(5, objName);
						unalPstmt.setString(6, "N");
						unalPstmt.setString(7, loginCode);
						unalPstmt.setString(8, "0");
						updatecnt = unalPstmt.executeUpdate();
						uploadFileLog.append("uniqueTranIdGenerator - [" + uniqueTranIdGenerator + "]\n");
						uploadFileLog.append("documentId - [" + doc_id + "] : updatecnt - [" + updatecnt + "]\n");
					} catch (SQLException e2) {
						uploadFileLog.append("Exception while inserting into UNALLOCATED_ATTACH - ["
								+ this.getStackTrace(e2) + "]\n");
						e2.printStackTrace();
						throw new ITMException((Exception) e2);
					}
					boolean isError = false;
					try {
						if (updatecnt > 0) {
							final File unAllocatedFile = new File(
									String.valueOf(unAllocatedDirPath) + File.separator + objName);
							if (!unAllocatedFile.exists()) {
								final File ObjNameFold2 = new File(
										String.valueOf(unAllocatedDirPath) + File.separator + objName);
								if (ObjNameFold2.mkdir()) {
									final boolean success3 = file.renameTo(new File(unAllocatedFile, file.getName()));
									if (!success3) {
										System.out.print("this file [" + file.getName() + "] is not moved to the "
												+ ObjNameFold2 + " Folder");
										uploadFileLog.append("File : [" + file.getName() + "] is not moved to the ["
												+ unAllocatedFile + "] folder.\n");
									} else {
										uploadFileLog.append("File : [" + file.getName() + "] is moved to the ["
												+ unAllocatedFile + "] folder.\n");
									}
								}
							} else {
								final boolean success4 = file.renameTo(new File(unAllocatedFile, file.getName()));
								if (!success4) {
									System.out.print("file " + file.getName() + " is not moved");
									uploadFileLog.append("File : [" + file.getName() + "] is not moved to the ["
											+ unAllocatedFile + "] folder.\n");
								} else {
									uploadFileLog.append("File : [" + file.getName() + "] is moved to the ["
											+ unAllocatedFile + "] folder.\n");
								}
							}
						}
					} catch (Exception e3) {
						isError = true;
						uploadFileLog.append("Exception while moving file into Unallocated folder - ["
								+ this.getStackTrace(e3) + "]\n");
						e3.printStackTrace();
						throw new ITMException(e3);
					} finally {
						try {
							if (isError) {
								final int deleteCnt = this.deleteUnallocRec(uniqueTranIdGenerator, conn, loginCode);
								uploadFileLog.append(
										"[" + deleteCnt + "] record deleted from Unallocated_attach for tranId - ["
												+ uniqueTranIdGenerator + "] "
												+ " due to error while moving file to Unallocated Folder\n");
							}
						} catch (Exception e4) {
							e4.printStackTrace();
							throw new ITMException(e4);
						}
					}
					try {
						if (isError) {
							final int deleteCnt = this.deleteUnallocRec(uniqueTranIdGenerator, conn, loginCode);
							uploadFileLog.append("[" + deleteCnt
									+ "] record deleted from Unallocated_attach for tranId - [" + uniqueTranIdGenerator
									+ "] " + " due to error while moving file to Unallocated Folder\n");
						}
					} catch (Exception e4) {
						e4.printStackTrace();
						throw new ITMException(e4);
					}
				}
			} catch (FileNotFoundException e5) {
				retString = e5.getMessage();
				retString = this.getStackTrace(e5);
				e5.printStackTrace();
			} catch (RemoteException e6) {
				retString = e6.getMessage();
				retString = this.getStackTrace(e6);
				e6.printStackTrace();
			} catch (ITMException e7) {
				retString = e7.getMessage();
				retString = this.getStackTrace((Throwable) e7);
				e7.printStackTrace();
			} catch (IOException e8) {
				retString = e8.getMessage();
				retString = this.getStackTrace(e8);
				e8.printStackTrace();
			} finally {
				try {
					uploadFileLog.append("In Finally - [" + retString + "]\n");
					if (!this.isFileUploaded(doc_id, refSer, objName, conn, loginCode)) {
						final String fileName2 = String.valueOf(doc_id) + "_" + System.currentTimeMillis() + ".txt";
						this.createUploadFileLog(
								"------------------------ : In AttachmentHandlerEJB :------------------- \n"
										+ uploadFileLog.toString(),
								fileName2);
					}
					if (unalPstmt != null) {
						try {
							unalPstmt.close();
						} catch (SQLException e9) {
							e9.printStackTrace();
						}
						unalPstmt = null;
					}
					if (localConn && conn != null) {
						conn.close();
						conn = null;
					}
				} catch (SQLException sqle) {
					sqle.printStackTrace();
				}
			}
			try {
				uploadFileLog.append("In Finally - [" + retString + "]\n");
				if (!this.isFileUploaded(doc_id, refSer, objName, conn, loginCode)) {
					final String fileName2 = String.valueOf(doc_id) + "_" + System.currentTimeMillis() + ".txt";
					this.createUploadFileLog(
							"------------------------ : In AttachmentHandlerEJB :------------------- \n"
									+ uploadFileLog.toString(),
							fileName2);
				}
				if (unalPstmt != null) {
					try {
						unalPstmt.close();
					} catch (SQLException e9) {
						e9.printStackTrace();
					}
					unalPstmt = null;
				}
				if (localConn && conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
		}
		return retString;
	}

	private String getLoginSite(final String loginCode, final Connection conn) {
		PreparedStatement lstmt = null;
		ResultSet lrs = null;
		String loginSite = "";
		final String sql = "select emp_site from employee where emp_code = ?";
		try {
			lstmt = conn.prepareStatement(sql);
			lstmt.setString(1, loginCode);
			lrs = lstmt.executeQuery();
			if (lrs.next()) {
				loginSite = lrs.getString("emp_site");
			}
			lrs.close();
			lrs = null;
			lstmt.close();
			lstmt = null;
		} catch (SQLException e) {
			e.printStackTrace();
			return loginSite;
		} finally {
			if (lstmt != null) {
				try {
					lstmt.close();
				} catch (SQLException e2) {
					e2.printStackTrace();
				}
				lstmt = null;
			}
		}
		if (lstmt != null) {
			try {
				lstmt.close();
			} catch (SQLException e2) {
				e2.printStackTrace();
			}
			lstmt = null;
		}
		return loginSite;
	}

	private String generateTranId(final String winName, final String xsiteCode, final String userID,
			final Connection conn) throws Exception {
		PreparedStatement lstmt = null;
		ResultSet lrs = null;
		String tranId = null;
		try {
			String keyStringQuery = null;
			String tranDate = null;
			String tranSer = "";
			String keyString = "";
			String keyCol = "";
			keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = ?";
			System.out.println("keyStringQuery  :: " + keyStringQuery);
			lstmt = conn.prepareStatement(keyStringQuery);
			lstmt.setString(1, winName);
			lrs = lstmt.executeQuery();
			if (lrs.next()) {
				keyString = lrs.getString("KEY_STRING");
				keyCol = lrs.getString("TRAN_ID_COL");
				tranSer = lrs.getString("REF_SER");
			} else {
				if (lrs != null) {
					lrs.close();
				}
				lrs = null;
				if (lstmt != null) {
					lstmt.close();
				}
				final String sqlStr = "SELECT  KEY_STRING, TRAN_ID_COL, REF_SER  FROM  TRANSETUP WHERE  TRAN_WINDOW = 'GENERAL' ";
				System.out.println(" sqlStr : " + sqlStr);
				lstmt = conn.prepareStatement(sqlStr);
				lrs = lstmt.executeQuery();
				if (lrs.next()) {
					keyString = lrs.getString("KEY_STRING");
					keyCol = lrs.getString("TRAN_ID_COL");
					tranSer = lrs.getString("REF_SER");
				}
			}
			lrs.close();
			lrs = null;
			lstmt.close();
			lstmt = null;
			tranDate = this.getCurrdateAppFormat();
			final StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"")
					.append(CommonConstants.ENCODING).append("\"?><Root>");
			xmlValues.append("<Header></Header><Detail1><site_code>").append(xsiteCode).append("</site_code>");
			xmlValues.append("<tran_date>").append(tranDate).append("</tran_date></Detail1></Root>");
			final TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), userID, CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
		} catch (SQLException se) {
			se.printStackTrace();
			throw new ITMException((Exception) se);
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new ITMException(ex);
		} finally {
			if (lstmt != null) {
				lstmt.close();
				lstmt = null;
			}
		}
		if (lstmt != null) {
			lstmt.close();
			lstmt = null;
		}
		return tranId;
	}

	private String getCurrdateAppFormat() {
		String currAppdate = "";
		try {
			Timestamp currDate = new Timestamp(System.currentTimeMillis());
			final SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
			final Object date = sdf.parse(currDate.toString());
			currDate = Timestamp.valueOf(String.valueOf(sdf.format(date).toString()) + " 00:00:00.0");
			currAppdate = new SimpleDateFormat(this.genericUtility.getApplDateFormat()).format(currDate).toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return currAppdate;
	}

	public ArrayList<File> getDirectoryNamesForAttachment(final String toBeLoadedDirPath) {
		File[] directoryArray = new File[0];
		final ArrayList<File> directoryList = new ArrayList<File>();
		File toBeLoadedDir = null;
		try {
			final FileFilter directotyFilter = new FileFilter() {
				@Override
				public boolean accept(final File pathname) {
					return pathname.isDirectory();
				}
			};
			toBeLoadedDir = new File(toBeLoadedDirPath);
			if (toBeLoadedDir.isDirectory()) {
				directoryArray = toBeLoadedDir.listFiles(directotyFilter);
			}
			for (int i = 0; i < directoryArray.length; ++i) {
				directoryList.add(directoryArray[i]);
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return directoryList;
	}

	private HashMap<String, ArrayList<File>> getTransactionWiseFileMap(final String toBeLoadedDirPath,
			final String objName, final String tranIdFrom, final String tranIdTo, final Connection conn) {
		File[] fileArray = new File[0];
		final HashMap<String, ArrayList<File>> transactionWiseFileMap = new HashMap<String, ArrayList<File>>();
		File toBeLoadedSubDir = null;
		ArrayList<File> transactionWiseFileList = null;
		String fileName = "";
		final String toBeLoadedSubDirPath = String.valueOf(toBeLoadedDirPath) + File.separator + objName;
		try {
			final FileFilter fileFilter = new FileFilter() {
				@Override
				public boolean accept(final File file) {
					return !file.isDirectory();
				}
			};
			toBeLoadedSubDir = new File(toBeLoadedSubDirPath);
			if (toBeLoadedSubDir.isDirectory()) {
				fileArray = toBeLoadedSubDir.listFiles(fileFilter);
			}
			for (int i = 0; i < fileArray.length; ++i) {
				final File filesToBeAttached = fileArray[i];
				fileName = filesToBeAttached.getName();
				String tranID = "";
				if (fileName.contains(".")) {
					tranID = fileName.substring(0, fileName.lastIndexOf("."));
				}
				if (tranID.length() > 50) {
					tranID = tranID.substring(0, 49);
				}
				final boolean isFileToBeAttach = this.getTransactionsBetweenRange(objName, tranIdFrom, tranIdTo, tranID,
						conn);
				if (isFileToBeAttach) {
					if (transactionWiseFileMap.containsKey(tranID)) {
						transactionWiseFileList = transactionWiseFileMap.get(tranID);
						transactionWiseFileList.add(filesToBeAttached);
					} else {
						transactionWiseFileList = new ArrayList<File>();
						transactionWiseFileList.add(filesToBeAttached);
						transactionWiseFileMap.put(tranID, transactionWiseFileList);
					}
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return transactionWiseFileMap;
	}

	private boolean getTransactionsBetweenRange(String objName, final String tranIdFrom, final String tranIdTo,
			final String tranId, Connection conn) {
		final ArrayList<String> transactionList = new ArrayList<String>();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = null;
		String tableName = "";
		String columnName = "";
		boolean localConn = false;
		try {
			System.out.println("Inside getTransactionsBetweenRange( objName - [" + objName + "], tranIdFrom - ["
					+ tranIdFrom + "], tranIdTo - [" + tranIdTo + "], tranId - [" + tranId + "] )");
			connDriver = new ConnDriver();
			if (conn == null) {
				conn = connDriver.getConnectDB("Driver");
				conn.setAutoCommit(false);
				localConn = true;
			}
			connDriver = null;
			objName = (objName.contains("w_") ? objName : ("w_" + objName));
			sql = "SELECT TABLE_NAME,TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				tableName = ((rs.getString("TABLE_NAME") == null) ? "" : rs.getString("TABLE_NAME"));
				columnName = ((rs.getString("TRAN_ID_COL") == null) ? "" : rs.getString("TRAN_ID_COL"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (tableName != null && tableName.trim().length() > 0) {
				boolean isRangeSpecified = true;
				if ((tranIdFrom == null || tranIdFrom.trim().length() == 0)
						&& (tranIdTo == null || tranIdTo.trim().length() == 0)) {
					isRangeSpecified = false;
				}
				if (columnName.contains(":")) {
					System.out.println("columnName containing colonnnn : [ " + columnName + " ]");
					final String[] columns = columnName.split(":");
					final int columnsLength = columns.length;
					System.out.println("Length of column name = [ " + columnsLength + " ]");
					columnName = "";
					String tmpColumnName = "";
					for (int i = 0; i < columnsLength; ++i) {
						if (i == columnsLength - 1) {
							tmpColumnName = String.valueOf(tmpColumnName) + columns[i];
						} else {
							tmpColumnName = String.valueOf(tmpColumnName) + columns[i] + ",";
						}
					}
					columnName = tmpColumnName;
					System.out.println(
							"Column Name containing comma [" + columnName + " ] tmpColumnName = " + tmpColumnName);
					System.out.println("DBDateFormat : [" + this.genericUtility.getDBDateFormat() + "]");
					sql = "SELECT " + columnName + "  FROM " + tableName + " WHERE 1 = 2";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					final ResultSetMetaData md = rs.getMetaData();
					String columnNames = "";
					for (int j = 1; j <= md.getColumnCount(); ++j) {
						if (md.getColumnTypeName(j).toUpperCase().indexOf("DATE") != -1
								|| md.getColumnTypeName(j).toUpperCase().indexOf("TIMESTAMP") != -1) {
							columnNames = String.valueOf(columnNames) + "TO_CHAR(" + md.getColumnName(j) + ", '"
									+ this.genericUtility.getDBDateFormat() + "') AS " + md.getColumnName(j) + ", ";
						} else {
							columnNames = String.valueOf(columnNames) + md.getColumnName(j) + ", ";
						}
					}
					if (columnNames != null && columnNames.trim().length() > 1) {
						columnName = columnNames.substring(0, columnNames.trim().length() - 1);
					}
					System.out.println("columnNames = " + columnName);
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if (isRangeSpecified) {
						sql = "SELECT " + columnName + "  FROM " + tableName + "  WHERE " + columnName + " BETWEEN '"
								+ tranIdFrom + "' AND '" + tranIdTo + "' ";
					} else {
						sql = "SELECT " + columnName + "  FROM " + tableName;
					}
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					String tmp = "";
					String tmpExcludeAfterSpace = "";
					String st = "";
					while (rs.next()) {
						tmp = "";
						for (int k = 0; k < columnsLength; ++k) {
							tmpExcludeAfterSpace = "";
							st = "";
							tmpExcludeAfterSpace = rs.getString(columns[k]);
							if (tmpExcludeAfterSpace.contains("-") && tmpExcludeAfterSpace.contains(" ")) {
								final String[] tmpColumns = tmpExcludeAfterSpace.split(" ");
								st = tmpColumns[0];
							} else {
								st = tmpExcludeAfterSpace;
							}
							if (k == columnsLength - 1) {
								tmp = String.valueOf(tmp) + st;
							} else {
								tmp = String.valueOf(tmp) + st + "~";
							}
						}
						transactionList.add(tmp);
						if (tmp.equalsIgnoreCase(tranId)) {
							System.out.println(" Inside colon - tmp - " + tmp + " tranId - " + tranId);
							return true;
						}
					}
				} else {
					System.out.println("DBDateFormat : [" + this.genericUtility.getDBDateFormat() + "]");
					sql = "SELECT " + columnName + "  FROM " + tableName + " WHERE 1 = 2";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					final ResultSetMetaData md2 = rs.getMetaData();
					String columnNames2 = "";
					for (int l = 1; l <= md2.getColumnCount(); ++l) {
						if (md2.getColumnTypeName(l).toUpperCase().indexOf("DATE") != -1
								|| md2.getColumnTypeName(l).toUpperCase().indexOf("TIMESTAMP") != -1) {
							columnNames2 = String.valueOf(columnNames2) + "TO_CHAR(" + md2.getColumnName(l) + ", '"
									+ this.genericUtility.getDBDateFormat() + "') AS " + md2.getColumnName(l) + ", ";
						} else {
							columnNames2 = String.valueOf(columnNames2) + md2.getColumnName(l) + ", ";
						}
					}
					if (columnNames2 != null && columnNames2.trim().length() > 1) {
						columnName = columnNames2.substring(0, columnNames2.trim().length() - 1);
					}
					System.out.println("columnNames = " + columnName);
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if (isRangeSpecified) {
						sql = "SELECT " + columnName + "  FROM " + tableName + "  WHERE " + columnName + " BETWEEN '"
								+ tranIdFrom + "' AND '" + tranIdTo + "' " + " AND " + columnName + " = '" + tranId
								+ "' ";
					} else {
						sql = "SELECT " + columnName + "  FROM " + tableName + " WHERE " + columnName + " = '" + tranId
								+ "' ";
					}
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						final String value = rs.getString(columnName);
						transactionList.add(value);
						if (value.equalsIgnoreCase(tranId)) {
							System.out.println(" Inside colon - value - " + value + " tranId - " + tranId);
							return true;
						}
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (localConn && conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
			return false;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (localConn && conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
		}
		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (localConn && conn != null) {
				conn.close();
				conn = null;
			}
		} catch (SQLException sqle) {
			sqle.printStackTrace();
		}
		return false;
	}

	public boolean isRecordExist(String objName, final String refId, final String userCode) {
		final ArrayList<String> transactionList = new ArrayList<String>();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver = null;
		String tableName = "";
		String columnName = "";
		int cnt = 0;
		boolean status = false;
		try {
			connDriver = new ConnDriver();
			final UserInfoBean userInfoBean = this.createUserInfo(userCode);
			conn = connDriver.getConnectDB(userInfoBean.getTransDB());
			conn.setAutoCommit(false);
			connDriver = null;
			objName = (objName.contains("w_") ? objName : ("w_" + objName));
			sql = "SELECT TABLE_NAME,TRAN_ID_COL FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				tableName = ((rs.getString("TABLE_NAME") == null) ? "" : rs.getString("TABLE_NAME"));
				columnName = ((rs.getString("TRAN_ID_COL") == null) ? "" : rs.getString("TRAN_ID_COL"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (tableName != null && tableName.trim().length() > 0) {
				sql = "SELECT COUNT(*) FROM " + tableName + " WHERE " + columnName + " = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					cnt = rs.getInt(1);
				}
				if (cnt == 1) {
					status = true;
				} else if (cnt == 0) {
					status = false;
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
			return status;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException sqle) {
				sqle.printStackTrace();
			}
		}
		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (SQLException sqle) {
			sqle.printStackTrace();
		}
		return status;
	}

	public int getPageCount(final File fileTobeAttached) {
		final String filePath = fileTobeAttached.toString();
		final String fileName = fileTobeAttached.getName();
		final String fileType = fileName.substring(fileName.indexOf(".") + 1);
		int pageCount = 0;
		try {
			if ("pdf".equalsIgnoreCase(fileType)) {
				final PdfReader reader = new PdfReader(filePath);
				pageCount = reader.getNumberOfPages();
			} else if ("doc".equalsIgnoreCase(fileType)) {
				try {
					final POIFSFileSystem fis = new POIFSFileSystem(
							(InputStream) new FileInputStream(fileTobeAttached));
					final HWPFDocument wdDoc = new HWPFDocument(fis);
					pageCount = wdDoc.getSummaryInformation().getPageCount();
				} catch (Exception e) {
					System.out.println("In getPageCount Exception [" + e.getMessage() + "]");
					e.printStackTrace();
				}
			} else if ("docx".equalsIgnoreCase(fileType)) {
				byte[] inputBytePDF = null;
				try {
					final FileInputStream fin = new FileInputStream(fileTobeAttached);
					inputBytePDF = new byte[(int) fileTobeAttached.length()];
					fin.read(inputBytePDF);
					final ByteArrayInputStream docxInputStream = new ByteArrayInputStream(inputBytePDF);
					final com.aspose.words.Document wordDoc = new com.aspose.words.Document(
							(InputStream) docxInputStream);
					pageCount = wordDoc.getPageCount();
				} catch (Exception e2) {
					System.out.println("In docx type Exception [" + e2.getMessage() + "]");
					e2.printStackTrace();
				}
			}
		} catch (IOException e3) {
			System.out.println("In doc type Exception [" + e3.getMessage() + "]");
			e3.printStackTrace();
		}
		return pageCount;
	}

	public String getRefSer(String objName, final String LoginEmpCode) {
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		String refSer = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		try {
			connDriver = new ConnDriver();
			final UserInfoBean userInfo = this.createUserInfo(LoginEmpCode);
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			objName = (objName.contains("w_") ? objName : ("w_" + objName));
			sql = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, objName);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				System.out.println("Inside if ");
				refSer = ((rs.getString("REF_SER") == null) ? "" : rs.getString("REF_SER"));
			}
			System.out.println(" refSer : " + refSer);
		} catch (Exception ex) {
			System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :: " + ex.getMessage());
			ex.printStackTrace();
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pStmt != null) {
					pStmt.close();
					pStmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException ex2) {
				System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :finally: " + ex2.getMessage());
				ex2.printStackTrace();
			}
			return refSer;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pStmt != null) {
					pStmt.close();
					pStmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (SQLException ex2) {
				System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :finally: " + ex2.getMessage());
				ex2.printStackTrace();
			}
		}
		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pStmt != null) {
				pStmt.close();
				pStmt = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (SQLException ex2) {
			System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :finally: " + ex2.getMessage());
			ex2.printStackTrace();
		}
		return refSer;
	}

	public String getRefSer(final Connection conn, String objName) throws ITMException, RemoteException {
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql = "";
		String refSer = "";
		try {
			objName = (objName.contains("w_") ? objName : ("w_" + objName));
			sql = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, objName);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				refSer = ((rs.getString("REF_SER") == null) ? "" : rs.getString("REF_SER"));
			}
		} catch (Exception ex) {
			System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :: " + ex.getMessage());
			throw new ITMException(ex);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pStmt != null) {
					pStmt.close();
					pStmt = null;
				}
			} catch (SQLException ex2) {
				System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :finally: " + ex2.getMessage());
				throw new ITMException((Exception) ex2);
			}
		}
		try {
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pStmt != null) {
				pStmt.close();
				pStmt = null;
			}
		} catch (SQLException ex2) {
			System.out.println("[AttachmentHandlerEJB] :: [getRefSer ()] :finally: " + ex2.getMessage());
			throw new ITMException((Exception) ex2);
		}
		return refSer;
	}

	public String getAttachmentDetail(String objName, final String fromTranId, final String toTranId,
			final String userCode) {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		final StringBuffer xmlStringBuff = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root>\r\n");
		Connection conn = null;
		ConnDriver connDriver = null;
		String docName = "";
		String docType = "";
		String docPages = "";
		String docId = "";
		long countId = 0L;
		try {
			objName = (objName.contains("w_") ? objName : ("w_" + objName));
			connDriver = new ConnDriver();
			final UserInfoBean userInfoBean = this.createUserInfo(userCode);
			conn = connDriver.getConnectDB(userInfoBean.getTransDB());
			conn.setAutoCommit(false);
			connDriver = null;
			sql = " SELECT DT_LINK.REF_ID,DC.DOC_NAME,DC.DOC_TYPE,DC.DOC_PAGES,DC.DOC_ID FROM   DOC_CONTENTS DC , DOC_TRANSACTION_LINK DT_LINK WHERE DC.DOC_ID = DT_LINK.DOC_ID AND  DT_LINK.REF_ID BETWEEN ? AND ? AND TRIM (DT_LINK.REF_SER) in (SELECT TRIM (REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = ?)  ORDER BY REF_ID,DOC_ID,DOC_NAME";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, fromTranId);
			pstmt.setString(2, toTranId);
			pstmt.setString(3, objName);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				++countId;
				tranId = ((rs.getString("REF_ID") == null) ? "" : rs.getString("REF_ID"));
				docName = ((rs.getString("DOC_NAME") == null) ? "" : rs.getString("DOC_NAME"));
				docType = ((rs.getString("DOC_TYPE") == null) ? "" : rs.getString("DOC_TYPE"));
				docPages = ((rs.getString("DOC_PAGES") == null) ? "" : rs.getString("DOC_PAGES"));
				docId = ((rs.getString("DOC_ID") == null) ? "" : rs.getString("DOC_ID"));
				xmlStringBuff.append("<Detail>\r\n");
				xmlStringBuff.append("<count_id>").append("<![CDATA[").append(countId).append("]]>")
						.append("</count_id>\r\n ");
				xmlStringBuff.append("<tran_id>").append("<![CDATA[").append(tranId).append("]]>")
						.append("</tran_id>\r\n ");
				xmlStringBuff.append("<doc_id>").append("<![CDATA[").append(docId).append("]]>")
						.append("</doc_id>\r\n ");
				xmlStringBuff.append("<doc_name>").append("<![CDATA[").append(docName).append("]]>")
						.append("</doc_name>\r\n ");
				xmlStringBuff.append("<doc_type>").append("<![CDATA[").append(docType).append("]]>")
						.append("</doc_type>\r\n ");
				xmlStringBuff.append("<doc_pages>").append("<![CDATA[").append(docPages).append("]]>")
						.append("</doc_pages>\r\n ");
				xmlStringBuff.append("</Detail>\r\n");
			}
			xmlStringBuff.append("<Detail1>\r\n");
			xmlStringBuff.append("<max_id>").append("<![CDATA[").append(countId).append("]]>").append("</max_id>\r\n ");
			xmlStringBuff.append("</Detail1>\r\n");
			xmlStringBuff.append("</Root>\r\n");
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception ex2) {
				ex2.printStackTrace();
			}
			return xmlStringBuff.toString();
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception ex2) {
				ex2.printStackTrace();
			}
		}
		try {
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (Exception ex2) {
			ex2.printStackTrace();
		}
		return xmlStringBuff.toString();
	}

	public String getPrintLog(String objName, final String fromTranId, final String toTranId, final String printStatus,
			final String userCode) {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String docName = "";
		String docType = "";
		String docPages = "";
		String docId = "";
		String docPrintStatus = "";
		String docPrintDate = "";
		String docPrintBy = "";
		final StringBuffer xmlStringBuff = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root>\r\n");
		Connection conn = null;
		ConnDriver connDriver = null;
		long countId = 0L;
		try {
			objName = (objName.contains("w_") ? objName : ("w_" + objName));
			connDriver = new ConnDriver();
			final UserInfoBean userInfo = this.createUserInfo(userCode);
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			conn.setAutoCommit(false);
			connDriver = null;
			final SimpleDateFormat simpleDf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
			final SimpleDateFormat simpleDisp = new SimpleDateFormat("dd-MMM-yy");
			if ("A".equalsIgnoreCase(printStatus)) {
				sql = " SELECT TRAN_ID, DOC_NAME, DOC_TYPE, DOC_ID, PRINT_STATUS, CHG_DATE, CHG_USER  FROM PRINT_LOG WHERE TRAN_ID BETWEEN ? AND ? AND OBJ_NAME like '%"
						+ objName + "%' AND CHG_USER = ? " + " ORDER BY TRAN_ID,DOC_ID,DOC_NAME";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, fromTranId);
				pstmt.setString(2, toTranId);
				pstmt.setString(3, userCode);
			} else {
				sql = " SELECT TRAN_ID, DOC_NAME, DOC_TYPE, DOC_ID, PRINT_STATUS, CHG_DATE, CHG_USER  FROM PRINT_LOG WHERE TRAN_ID BETWEEN ? AND ? AND OBJ_NAME like '%"
						+ objName + "%' AND PRINT_STATUS = ? AND CHG_USER = ? " + " ORDER BY TRAN_ID,DOC_ID,DOC_NAME";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, fromTranId);
				pstmt.setString(2, toTranId);
				pstmt.setString(3, printStatus);
				pstmt.setString(4, userCode);
			}
			rs = pstmt.executeQuery();
			while (rs.next()) {
				++countId;
				tranId = ((rs.getString("TRAN_ID") == null) ? "" : rs.getString("TRAN_ID"));
				docName = ((rs.getString("DOC_NAME") == null) ? "" : rs.getString("DOC_NAME"));
				docType = ((rs.getString("DOC_TYPE") == null) ? "" : rs.getString("DOC_TYPE"));
				docId = ((rs.getString("DOC_ID") == null) ? "" : rs.getString("DOC_ID"));
				docPrintStatus = ((rs.getString("PRINT_STATUS") == null) ? "" : rs.getString("PRINT_STATUS"));
				docPrintDate = ((rs.getString("CHG_DATE") == null) ? "" : rs.getString("CHG_DATE"));
				docPrintBy = ((rs.getString("CHG_USER") == null) ? "" : rs.getString("CHG_USER"));
				docPages = String.valueOf(this.getNoOfPages(docId));
				docPrintDate = simpleDf.format(simpleDf.parse(docPrintDate));
				xmlStringBuff.append("<Detail>\r\n");
				xmlStringBuff.append("<count_id>").append("<![CDATA[").append(countId).append("]]>")
						.append("</count_id>\r\n ");
				xmlStringBuff.append("<tran_id>").append("<![CDATA[").append(tranId).append("]]>")
						.append("</tran_id>\r\n ");
				xmlStringBuff.append("<doc_id>").append("<![CDATA[").append(docId).append("]]>")
						.append("</doc_id>\r\n ");
				xmlStringBuff.append("<doc_name>").append("<![CDATA[").append(docName).append("]]>")
						.append("</doc_name>\r\n ");
				xmlStringBuff.append("<doc_type>").append("<![CDATA[").append(docType).append("]]>")
						.append("</doc_type>\r\n ");
				xmlStringBuff.append("<doc_pages>").append("<![CDATA[").append(docPages).append("]]>")
						.append("</doc_pages>\r\n ");
				xmlStringBuff.append("<print_status>").append("<![CDATA[").append(docPrintStatus).append("]]>")
						.append("</print_status>\r\n ");
				xmlStringBuff.append("<print_date>").append("<![CDATA[").append(docPrintDate).append("]]>")
						.append("</print_date>\r\n ");
				xmlStringBuff.append("<print_by>").append("<![CDATA[").append(docPrintBy).append("]]>")
						.append("</print_by>\r\n ");
				xmlStringBuff.append("</Detail>\r\n");
			}
			xmlStringBuff.append("<Detail1>\r\n");
			xmlStringBuff.append("<max_id>").append("<![CDATA[").append(countId).append("]]>").append("</max_id>\r\n ");
			xmlStringBuff.append("</Detail1>\r\n");
			xmlStringBuff.append("</Root>\r\n");
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception ex2) {
				ex2.printStackTrace();
			}
			return xmlStringBuff.toString();
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception ex2) {
				ex2.printStackTrace();
			}
		}
		try {
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (Exception ex2) {
			ex2.printStackTrace();
		}
		return xmlStringBuff.toString();
	}

	public String printAttachments(final String[] chkValues, final String printerName, String objName,
			final String userCode, final HashMap<String, String> noOfCopiesMap) {
		objName = (objName.contains("w_") ? objName : ("w_" + objName));
		final DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
		final DocumentPrint documentPrint = new DocumentPrint();
		byte[] byteArray = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String result = "";
		String docId = "";
		String docName = "";
		String docType = "";
		String tranId = "";
		int noOfCopies = 0;
		int rowsInserted = 0;
		Connection conn = null;
		ConnDriver connDriver = null;
		try {
			connDriver = new ConnDriver();
			final UserInfoBean userInfo = this.createUserInfo(userCode);
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			conn.setAutoCommit(false);
			connDriver = null;
			sql = " INSERT INTO PRINT_LOG (PRINTLOG_ID,OBJ_NAME,TRAN_ID,PRINT_DATE,PRINT_BY,DOC_NAME,DOC_TYPE,  PRINT_STATUS,CHG_DATE,CHG_USER,CHG_TERM,DOC_ID) VALUES (PRINTLOG_ID.nextval,?,?,sysdate,?,?,?,?,sysdate,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			for (int i = 0; i < chkValues.length; ++i) {
				byteArray = null;
				rowsInserted = 0;
				result = "";
				final UserInfoBean userInfoBean = this.createUserInfo(userCode);
				docId = chkValues[i];
				byteArray = docHandler.getDocument(docId,userInfoBean);
				docName = docHandler.getDocumentName(docId,userInfoBean.getTransDB());
				tranId = this.getTranId(docId, userInfoBean);
				docType = docHandler.getDocumentFile(docId,userInfoBean.getTransDB());
				noOfCopies = Integer.parseInt((noOfCopiesMap.get(docId) == null) ? "1" : noOfCopiesMap.get(docId));
				System.out.println("No Of Copies are [ " + noOfCopies + " ]");
				if (docType.contains(".")) {
					docType = docType.substring(docType.lastIndexOf(".") + 1, docType.length());
				}
				if (byteArray != null) {
					try {
						final String strDirectoy = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "Downloads";
						File outFile = new File(strDirectoy);
						if (!outFile.exists()) {
							outFile.mkdir();
						}
						outFile = new File(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "Downloads"
								+ File.separator + docName);
						final FileOutputStream fout = new FileOutputStream(outFile);
						IOUtils.write(byteArray, (OutputStream) fout);
						result = documentPrint.doPrint(outFile, docType, printerName, noOfCopies);
						fout.close();
						outFile.delete();
						if ("true".equalsIgnoreCase(result)) {
							pstmt.setString(1, objName);
							pstmt.setString(2, tranId);
							pstmt.setString(3, userCode);
							pstmt.setString(4, docName);
							pstmt.setString(5, docType);
							pstmt.setString(6, "Y");
							pstmt.setString(7, userCode);
							pstmt.setString(8, "");
							pstmt.setString(9, docId);
							System.out.println("Printing done successfully!!!");
						} else {
							pstmt.setString(1, objName);
							pstmt.setString(2, tranId);
							pstmt.setString(3, userCode);
							pstmt.setString(4, docName);
							pstmt.setString(5, docType);
							pstmt.setString(6, "N");
							pstmt.setString(7, userCode);
							pstmt.setString(8, "");
							pstmt.setString(9, docId);
							System.out.println("error occured in Printing!!!");
						}
						rowsInserted = pstmt.executeUpdate();
						System.out.println("rows Inserted [" + rowsInserted + "]");
						if (rowsInserted > 0) {
							conn.commit();
						} else {
							conn.rollback();
						}
					} catch (Exception e) {
						result = e.getMessage();
					}
				}
			}
			if ("true".equalsIgnoreCase(result)) {
				result = "Printing Done Successfully!!!";
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (Exception ex) {
			System.out.println("inside try==" + ex.getMessage());
			ex.printStackTrace();
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception ex2) {
				ex2.printStackTrace();
			}
			return result;
		} finally {
			try {
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception ex2) {
				ex2.printStackTrace();
			}
		}
		try {
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (Exception ex2) {
			ex2.printStackTrace();
		}
		return result;
	}

	public String getTranId(final String docId, final UserInfoBean userInfo) {
		String retTranId = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement mPstmt = null;
		ResultSet rs = null;
		try {
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			conn.setAutoCommit(false);
			connDriver = null;
			final String selQry = "SELECT REF_ID FROM DOC_TRANSACTION_LINK WHERE DOC_ID =?";
			mPstmt = conn.prepareStatement(selQry);
			mPstmt.setString(1, docId);
			rs = mPstmt.executeQuery();
			if (rs.next()) {
				retTranId = ((rs.getString(1) == null) ? "" : rs.getString(1));
			}
			conn.commit();
			if (mPstmt != null) {
				mPstmt.close();
				mPstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (Exception e) {
			System.out.println("Exception :AttachmentDetailEJB :getTranId :==>" + e);
			e.printStackTrace();
			try {
				if (mPstmt != null) {
					mPstmt.close();
					mPstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
			return retTranId;
		} finally {
			try {
				if (mPstmt != null) {
					mPstmt.close();
					mPstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
		try {
			if (mPstmt != null) {
				mPstmt.close();
				mPstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (Exception e2) {
			e2.printStackTrace();
		}
		return retTranId;
	}

	public int getNoOfPages(final String docId) {
		int retNoOfPages = 0;
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement mPstmt = null;
		ResultSet rs = null;
		try {
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			connDriver = null;
			final String selQry = "SELECT DOC_PAGES FROM DOC_CONTENTS WHERE DOC_ID =?";
			mPstmt = conn.prepareStatement(selQry);
			mPstmt.setString(1, docId);
			rs = mPstmt.executeQuery();
			if (rs.next()) {
				retNoOfPages = rs.getInt(1);
			}
			conn.commit();
			if (mPstmt != null) {
				mPstmt.close();
				mPstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
		} catch (Exception e) {
			System.out.println("Exception :AttachmentDetailEJB :getTranId :==>" + e);
			e.printStackTrace();
			try {
				if (mPstmt != null) {
					mPstmt.close();
					mPstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
			return retNoOfPages;
		} finally {
			try {
				if (mPstmt != null) {
					mPstmt.close();
					mPstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e2) {
				e2.printStackTrace();
			}
		}
		try {
			if (mPstmt != null) {
				mPstmt.close();
				mPstmt = null;
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (conn != null) {
				conn.close();
				conn = null;
			}
		} catch (Exception e2) {
			e2.printStackTrace();
		}
		return retNoOfPages;
	}

	private void createUploadFileLog(final String log, final String fileName) {
		try {
			final String logDir = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator
					+ "attachments" + File.separator + fileName;
			final File outFile = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log"
					+ File.separator + "attachments");
			if (!outFile.exists()) {
				outFile.mkdir();
			}
			final PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
			out.println(log);
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private String getStackTrace(final Throwable throwable) {
		final StringWriter sw = new StringWriter();
		final PrintWriter pw = new PrintWriter(sw, true);
		throwable.printStackTrace(pw);
		return sw.getBuffer().toString();
	}

	private boolean isFileUploaded(final String docId, final String refSer, final String objName, Connection conn,
			final String loginCode) {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection mConnection = conn;
		boolean isLocalConnection = false;
		boolean isFileUploaded = false;
		Label_0299 : {
			try {
				int resultCnt = 0;
				if (mConnection == null) {
					final UserInfoBean userInfoBean = this.createUserInfo(loginCode);
					ConnDriver mConnDriver = new ConnDriver();
					conn = mConnDriver.getConnectDB(userInfoBean.getTransDB());
					mConnDriver = null;
					isLocalConnection = true;
				}
				final String sql = "SELECT COUNT(*) FROM UNALLOCATED_ATTACH WHERE DOC_ID = ? AND REF_SER = ? AND OBJ_NAME = ?";
				pstmt = mConnection.prepareStatement(sql);
				pstmt.setString(1, docId);
				pstmt.setString(2, refSer);
				pstmt.setString(3, objName);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					resultCnt = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("resultCnt - [" + resultCnt + "]");
				if (resultCnt > 0) {
					isFileUploaded = true;
				}
			} catch (Exception e) {
				isFileUploaded = false;
				e.printStackTrace();
				try {
					if (isLocalConnection && mConnection != null) {
						mConnection.close();
						mConnection = null;
					}
				} catch (SQLException e2) {
					e2.printStackTrace();
				}
				break Label_0299;
			} finally {
				try {
					if (isLocalConnection && mConnection != null) {
						mConnection.close();
						mConnection = null;
					}
				} catch (SQLException e2) {
					e2.printStackTrace();
				}
			}
			try {
				if (isLocalConnection && mConnection != null) {
					mConnection.close();
					mConnection = null;
				}
			} catch (SQLException e2) {
				e2.printStackTrace();
			}
		}
		System.out.println("isFileUploaded : [" + isFileUploaded + "]");
		return isFileUploaded;
	}

	private int deleteUnallocRec(final String tranId, Connection conn, final String loginCode) {
		PreparedStatement pstmt = null;
		Connection mConnection = conn;
		boolean isLocalConnection = false;
		int deleteCnt = 0;
		Label_0202 : {
			try {
				if (mConnection == null) {
					final UserInfoBean userInfoBean = this.createUserInfo(loginCode);
					ConnDriver mConnDriver = new ConnDriver();
					conn = mConnDriver.getConnectDB(userInfoBean.getTransDB());
					mConnDriver = null;
					isLocalConnection = true;
				}
				final String sql = "DELETE FROM UNALLOCATED_ATTACH WHERE TRAN_ID = ?";
				pstmt = mConnection.prepareStatement(sql);
				pstmt.setString(1, tranId);
				deleteCnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			} catch (Exception e) {
				e.printStackTrace();
				try {
					if (isLocalConnection && mConnection != null) {
						mConnection.close();
						mConnection = null;
					}
				} catch (SQLException e2) {
					e2.printStackTrace();
				}
				break Label_0202;
			} finally {
				try {
					if (isLocalConnection && mConnection != null) {
						mConnection.close();
						mConnection = null;
					}
				} catch (SQLException e2) {
					e2.printStackTrace();
				}
			}
			try {
				if (isLocalConnection && mConnection != null) {
					mConnection.close();
					mConnection = null;
				}
			} catch (SQLException e2) {
				e2.printStackTrace();
			}
		}
		System.out.println("deleteCnt : [" + deleteCnt + "]");
		return deleteCnt;
	}

	public UserInfoBean createUserInfo(final String userId) throws BaseException, Exception {
		final UserInfoBean userInfoBean = new UserInfoBean();
		ConnDriver connDriver = null;
		Connection connection = null;
		Statement statement = null;
		ResultSet resultSet = null;
		try {
			userInfoBean.setLoginCode(userId);
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			statement = connection.createStatement();
			final String sql = "select EMP_CODE,ENTITY_CODE,PROFILE_ID,USER_TYPE,CHG_TERM,USER_THEME,USER_COUNTRY,USER_LANG,TRANS_DB,SITE_CODE__DEF from users where code='"
					+ userId + "'";
			resultSet = statement.executeQuery(sql);
			if (resultSet.next()) {
				userInfoBean.setEmpCode(E12GenericUtility.checkNull(resultSet.getString("EMP_CODE")));
				userInfoBean.setEntityCode(E12GenericUtility.checkNull(resultSet.getString("ENTITY_CODE")));
				userInfoBean.setProfileId(E12GenericUtility.checkNull(resultSet.getString("PROFILE_ID")));
				userInfoBean.setUserType(E12GenericUtility.checkNull(resultSet.getString("USER_TYPE")));
				userInfoBean.setRemoteHost(E12GenericUtility.checkNull(resultSet.getString("CHG_TERM")));
				userInfoBean.setUserTheme(E12GenericUtility.checkNull(resultSet.getString("USER_THEME")));
				userInfoBean.setUserCountry(E12GenericUtility.checkNull(resultSet.getString("USER_COUNTRY")));
				userInfoBean.setUserLanguage(E12GenericUtility.checkNull(resultSet.getString("USER_LANG")));
				userInfoBean.setTransDB(E12GenericUtility.checkNull(resultSet.getString("TRANS_DB")));
				userInfoBean.setSiteCode(E12GenericUtility.checkNull(resultSet.getString("SITE_CODE__DEF")));
				System.out.println("CommonDBAccessEjb createUserInfo()::::::" + userInfoBean.toString());
			}
		} catch (Exception e) {
			System.out.println("Exception in CommonDBAccessEJB createUserInfo()........." + e);
			return userInfoBean;
		} finally {
			if (resultSet != null) {
				resultSet.close();
			}
			if (statement != null) {
				statement.close();
			}
			if (connection != null) {
				connection.close();
			}
		}
		if (resultSet != null) {
			resultSet.close();
		}
		if (statement != null) {
			statement.close();
		}
		if (connection != null) {
			connection.close();
		}
		return userInfoBean;
	}


	
}