package ibase.webitm.ejb.marketingsch;

import com.itextpdf.text.pdf.PdfReader;
import ibase.planner.utility.ITMException;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.TransIDGenerator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarketingInsertSchOld extends ValidatorEJB implements Schedule {
	UserInfoBean userInfo = null;
	String xmlpath = "";
	String movePath = "";
	String attachmentPath = "";
	String logPath = "";
	String xmlName = "";
	String chgUser = "";
	String chgTerm = "";
	String loginSiteCode = "";
	String logFilePath = "";
	String winId = "";

	public String schedulePriority(String wrkflwPriority) throws Exception {
		return "";
	}

	public String schedule(HashMap map) throws Exception {
		return "";
	}

	public String schedule(String scheduleParamXML) throws ITMException, Exception {
		String flag = "PWC";
		String reultString = "";
		Connection conn = null;

		try {
			System.out.println("MarketingSchBean.java.schedule()");
			ConnDriver connDriver = new ConnDriver();
			this.userInfo = new UserInfoBean(scheduleParamXML);
			String transDB = this.userInfo.getTransDB();
			String loginEmpCode = this.userInfo.getEmpCode();
			System.out.println("get TransDB & login code connection in updateStatus : " + transDB + "::loginEmpCode::"
					+ loginEmpCode);
			if (transDB != null && transDB.trim().length() > 0) {
				conn = connDriver.getConnectDB(transDB);
			} else {
				conn = connDriver.getConnectDB("DriverITM");
			}

			conn.setAutoCommit(false);
			connDriver = null;
			reultString = this.schedule(scheduleParamXML, flag, conn);
			this.sendIntimation("ITM", this.logFilePath, loginEmpCode, conn);
		} catch (Exception var11) {
			var11.printStackTrace();
		} finally {
			if (conn != null) {
				conn.commit();
				conn.close();
				conn = null;
			}

		}

		return reultString;
	}

	private String schedule(String scheduleParamXML, String flag, Connection conn) throws ITMException, Exception {
		int ctr = 0;
		String companyCode = "";
		String companyName = "";
		double invAmt = 0.0D;
		String invDate = "";
		String invNo = "";
		String metisVendorCode = "";
		String orderRefNo = "";
		String orderRefNoDateTime = "";
		String remarks = "";
		String vcode = "";
		String vendorName = "";
		String winame = "";
		String acctCode = "";
		String cctrCode = "";
		String childNodeName = "";
		String orderRefNodesName = "";
		String errMsg = "";
		Document dom = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Node orderRefNodes = null;
		Node orderRefNodesChildNode = null;
		NodeList orderRefNodesList = null;
		NodeList orderRefNodesChildList = null;
		int childNodeListLength = 0;
		String xtraParams = "";
		File loadXmlfolder = null;
		File[] loadAllXml = null;
		File checkFile = null;
		FinCommon finCommon = null;
		MarketingSchBeanOld vendorSchBean = null;

		try {
			System.out.println("MarketingSchBean.java.schedule()2]");
			System.out.println("scheduleParamXML]" + scheduleParamXML);
			finCommon = new FinCommon();
			this.userInfo = new UserInfoBean(scheduleParamXML);
			xtraParams = "loginEmpCode=" + this.userInfo.getEmpCode() + "~~termId=" + this.userInfo.getRemoteHost()
					+ "~~loginSiteCode=" + this.userInfo.getSiteCode() + "~loginCode=" + this.userInfo.getLoginCode();
			System.out.println("xtraParams]" + xtraParams);
			String transDB = this.userInfo.getTransDB();
			String loginCode = this.userInfo.getLoginCode();
			System.out.println(
					"get TransDB & login code connection in updateStatus : " + transDB + "::loginCode::" + loginCode);
			this.xmlpath = finCommon.getFinparams("999999", "MKT_XML_PATH", conn);
			this.attachmentPath = finCommon.getFinparams("999999", "MKT_ATTACH_PATH", conn);
			this.movePath = finCommon.getFinparams("999999", "MKT_MOVE_PATH", conn);
			this.logPath = finCommon.getFinparams("999999", "MKT_LOG_PATH", conn);
			System.out.println("xmlpath>>>> " + this.xmlpath);
			System.out.println("attachmentPath>>>> " + this.attachmentPath);
			System.out.println("movePath>>>> " + this.movePath);
			System.out.println("logPath>>>> " + this.logPath);
			File path = new File(this.xmlpath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			path = new File(this.attachmentPath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			path = new File(this.movePath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			path = new File(this.logPath);
			if(!path.exists()) 
			{
				path.mkdirs();
			}
			loadXmlfolder = new File(this.xmlpath);
			loadAllXml = loadXmlfolder.listFiles();
			File[] var44 = loadAllXml;
			int var43 = loadAllXml.length;

			for (int var42 = 0; var42 < var43; ++var42) {
				File xmlfile = var44[var42];
				this.xmlName = xmlfile.getName();
				System.out.println("xmlName==>" + this.xmlName);
				DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
				DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
				dom = docBuilder.parse(xmlfile);
				parentNodeList = dom.getElementsByTagName("workitem");
				System.out.println("parentNodeList@]" + parentNodeList.getLength());

				for (int i = 0; i < parentNodeList.getLength(); ++i) {
					parentNode = parentNodeList.item(i);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeListLength " + childNodeListLength);

					for (ctr = 0; ctr < childNodeListLength; ++ctr) {
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equalsIgnoreCase("companyCode")) {
							if (childNode.getFirstChild() != null) {
								companyCode = childNode.getFirstChild().getNodeValue();
							} else {
								companyCode = "";
							}

							System.out.println("[companyCode@1]+" + companyCode);
						}

						if (childNodeName.equalsIgnoreCase("companyName")) {
							if (childNode.getFirstChild() != null) {
								companyName = childNode.getFirstChild().getNodeValue();
							} else {
								companyName = "";
							}

							System.out.println("[companyName@1]+" + companyName);
						}

						if (childNodeName.equalsIgnoreCase("invAmt")) {
							if (childNode.getFirstChild() != null) {
								invAmt = Double.parseDouble(childNode.getFirstChild().getNodeValue() == null
										? "0.0"
										: childNode.getFirstChild().getNodeValue());
							} else {
								invAmt = 0.0D;
							}

							System.out.println("[invAmt@1]+" + invAmt);
						}

						if (childNodeName.equalsIgnoreCase("invDate")) {
							if (childNode.getFirstChild() != null) {
								invDate = childNode.getFirstChild().getNodeValue();
							} else {
								invDate = "";
							}

							System.out.println("[invDate@1]+" + invDate);
						}

						if (childNodeName.equalsIgnoreCase("invNo")) {
							if (childNode.getFirstChild() != null) {
								invNo = childNode.getFirstChild().getNodeValue();
							} else {
								invNo = "";
							}

							System.out.println("[invNo@1]+" + invNo);
						}

						if (childNodeName.equalsIgnoreCase("metisVendorCode")) {
							if (childNode.getFirstChild() != null) {
								metisVendorCode = childNode.getFirstChild().getNodeValue();
							} else {
								metisVendorCode = "";
							}

							System.out.println("[metisVendorCode@1]+" + metisVendorCode);
						}

						if (childNodeName.equalsIgnoreCase("orderRefNoTbl")) {
							Element e = (Element) childNode;
							orderRefNodesList = e.getElementsByTagName("orderRefNoDetails");
							System.out.println(orderRefNodesList.getLength());

							for (int j = 0; j < orderRefNodesList.getLength(); ++j) {
								orderRefNodes = orderRefNodesList.item(j);
								orderRefNodesChildList = orderRefNodes.getChildNodes();
								System.out.println("lenth" + orderRefNodesChildList.getLength());

								for (int k = 0; k < orderRefNodesChildList.getLength(); ++k) {
									orderRefNodesChildNode = orderRefNodesChildList.item(k);
									orderRefNodesName = orderRefNodesChildNode.getNodeName();
									if (orderRefNodesName.equalsIgnoreCase("orderRefNo")) {
										if (orderRefNodesChildNode.getFirstChild() != null) {
											orderRefNo = orderRefNodesChildNode.getFirstChild().getNodeValue();
										} else {
											orderRefNo = "";
										}

										System.out.println("[orderRefNo@1]+" + orderRefNo);
									}

									if (orderRefNodesName.equalsIgnoreCase("orderRefNoDateTime")) {
										if (orderRefNodesChildNode.getFirstChild() != null) {
											orderRefNoDateTime = orderRefNodesChildNode.getFirstChild().getNodeValue();
										} else {
											orderRefNoDateTime = "";
										}

										System.out.println("[orderRefNoDateTime@1]+" + orderRefNoDateTime);
									}
								}
							}
						}

						if (childNodeName.equalsIgnoreCase("remarks")) {
							if (childNode.getFirstChild() != null) {
								remarks = childNode.getFirstChild().getNodeValue();
							} else {
								remarks = "";
							}

							System.out.println("[remarks@1]+" + remarks);
						}

						if (childNodeName.equalsIgnoreCase("vcode")) {
							if (childNode.getFirstChild() != null) {
								vcode = childNode.getFirstChild().getNodeValue();
							} else {
								vcode = "";
							}

							System.out.println("[vcode@1]+" + vcode);
						}

						if (childNodeName.equalsIgnoreCase("vendorName")) {
							if (childNode.getFirstChild() != null) {
								vendorName = childNode.getFirstChild().getNodeValue();
							} else {
								vendorName = "";
							}

							System.out.println("[vendorName@1]+" + vendorName);
						}

						if (childNodeName.equalsIgnoreCase("winame")) {
							if (childNode.getFirstChild() != null) {
								winame = childNode.getFirstChild().getNodeValue();
							} else {
								winame = "";
							}

							System.out.println("[winame@1]+" + winame);
						}

						if (childNodeName.equalsIgnoreCase("costCenterCode")) {
							if (childNode.getFirstChild() != null
									&& !childNode.getFirstChild().getNodeValue().equalsIgnoreCase("NA")) {
								cctrCode = childNode.getFirstChild().getNodeValue();
								cctrCode = cctrCode.trim().length() > 4
										? cctrCode.trim().substring(cctrCode.trim().length() - 4)
										: cctrCode.trim();
								System.out.println("INSIDE CCTR VJ" + cctrCode);
							} else {
								cctrCode = "";
							}

							System.out.println("[cctrCode@1]+" + cctrCode);
						}

						if (childNodeName.equalsIgnoreCase("glCode")) {
							if (childNode.getFirstChild() != null
									&& !childNode.getFirstChild().getNodeValue().equalsIgnoreCase("NA")) {
								acctCode = childNode.getFirstChild().getNodeValue();
								acctCode = acctCode.trim().length() > 4
										? acctCode.trim().substring(acctCode.trim().length() - 4)
										: acctCode.trim();
								System.out.println("INSIDE GLCODE VJ" + acctCode);
							} else {
								acctCode = "";
								System.out.println("[acctCode@1]+" + acctCode);
							}
						}

						this.winId = winame.length() >= 13 ? winame.substring(3, 13) : winame;
						vendorSchBean = new MarketingSchBeanOld(companyCode, companyName, invAmt, invDate, invNo,
								metisVendorCode, orderRefNo, orderRefNoDateTime, remarks, vcode, vendorName, winame,
								cctrCode, acctCode);
						System.out.println("winId>>>> " + this.winId);
						System.out.println("winame>>>> " + winame);
						if (winame != null && winame.trim().length() > 0) {
							checkFile = new File(this.attachmentPath);
							File[] files = checkFile.listFiles();
							boolean isFileExists = false;
							File[] var53 = files;
							int var52 = files.length;

							for (int var51 = 0; var51 < var52; ++var51) {
								File file = var53[var51];
								if (file.getName().toLowerCase().indexOf(winame.toLowerCase()) >= 0) {
									System.out.println("Parth==>" + file.getName());
									isFileExists = true;
									break;
								}
							}

							System.out.println("isFileExists>>>> " + isFileExists);
							if (isFileExists)
							{
								System.out.println("checkFile.exists()>>>> " + checkFile.exists());
								errMsg = this.supplierBillInsert(vendorSchBean, xtraParams, transDB, conn);
							} else
							{
								this.printLog("win_id==> checkFile.exists() " + this.winId,
										"attachment does not exixts", this.xmlName);
							}
						} else {
							this.printLog("win_id==>" + this.winId, "attachment does not exixts", this.xmlName);
						}
					}

					System.out.println("<===errMsg===>" + errMsg);
					Path temp = Files.move(Paths.get(xmlfile.getAbsolutePath()),
							Paths.get(this.movePath + "/" + xmlfile.getName()));
					if (temp != null) {
						this.printLog("xmlName==>" + this.xmlName, "   successfully to move", this.xmlName);
						System.out.println("vj xml moved>>>> " + temp);
					} else {
						this.printLog("xmlName==>" + this.xmlName, "failed to move", this.xmlName);
						System.out.println("vj xml moved failed>>>> " + temp);
					}
				}
			}
		} catch (Exception var54) {
			var54.printStackTrace();
			System.out.println("Exception@123]" + var54.getMessage());
			this.printLog("win_id==>" + this.winId, var54.getMessage(), this.xmlName);
		}

		return errMsg;
	}

	private String supplierBillInsert(MarketingSchBeanOld vendorSchBean, String xtraParams, String tranDb, Connection conn)
			throws ITMException {
		String errMsg = "";
		String sql = "";
		String trandId = "";
		String chgDate = "";
		String docId = "";
		int count = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = null;

		try {
			System.out.println("MarketingSchBean.java.supplierBillInsert()");
			genericUtility = new E12GenericUtility();
			this.chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			this.chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			chgDate = sdf.format(new Date());
			this.loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			trandId = this.generateTranID("marketing_bill", this.loginSiteCode, "", conn);
			System.out.println("MarketingSchBean.java.supplierBillInsert().tranId==>" + trandId);
			/*sql = "insert into supplier_bill (tran_id,bill_no,bill_amt,bill_date,supp_code,document_ref_no,remarks,sundry_code,ref_ser,chg_date ,chg_user,chg_term,tran_date,status,sundry_type,acct_code,cctr_code,new_gen_ref_no) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, trandId);
			pstmt.setString(2, vendorSchBean.getInvNo());
			pstmt.setDouble(3, vendorSchBean.getInvAmt());
			pstmt.setTimestamp(4, Timestamp.valueOf(vendorSchBean.getInvDate()));
			pstmt.setString(5, vendorSchBean.getMetisVendorCode());
			pstmt.setString(6, vendorSchBean.getOrderRefNo());
			pstmt.setString(7, vendorSchBean.getRemarks());
			pstmt.setString(8, vendorSchBean.getVcode());
			pstmt.setString(9, "M-BILL");
			pstmt.setTimestamp(10, Timestamp.valueOf(genericUtility.getValidDateString(chgDate,
					genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0"));
			pstmt.setString(11, this.chgUser);
			pstmt.setString(12, this.chgTerm);
			pstmt.setTimestamp(13, Timestamp.valueOf(genericUtility.getValidDateString(chgDate,
					genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0"));
			pstmt.setString(14, "O");
			pstmt.setString(15, "S");
			pstmt.setString(16, vendorSchBean.getAcctCode());
			pstmt.setString(17, vendorSchBean.getCctrCode());
			pstmt.setString(18, vendorSchBean.getWiname());
			System.out.println("inside supplier_bill  vijay");
			count  = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			if (count > 0) {*/
			System.out.println("tranId = "+trandId+"\nvendorSchBean.getWiname() = "+vendorSchBean.getWiname()
			+"\ntranDb = "+tranDb);
				errMsg = this.uploadAttachment(trandId, vendorSchBean.getWiname(), tranDb, conn);
				this.printLog("win_id==>" + this.winId, " trandId==>" + trandId + " transaction generate successfully",
						this.xmlName);
				System.out.println("MarketingSchBean.java.supplierBillInsert().errMsg]" + errMsg);
			//}

			return errMsg;
		} catch (Exception var15) {
			System.out.println("MarketingSchBean.java.supplierBillInsert().Exception" + var15);
			this.printLog("win_id==>" + this.winId, var15.getMessage(), this.xmlName);
			var15.printStackTrace();
			throw new ITMException(var15);
		}
	}

	private String uploadAttachment(String tranId, String fileName, String transDB, Connection conn)
			throws ITMException {
		String retString = "";
		PreparedStatement pstmt = null;
		StringBuffer retXMLStringBuff = null;
		StringBuffer uploadFileLog = null;
		String fileType = "";
		File filess = null;
		String attachment = "";
		byte[] byteArray = new byte[1];
		BufferedInputStream bfr = null;
		ByteArrayOutputStream bout = null;
		FileInputStream input = null;
		boolean var16 = false;

		try {
			E12GenericUtility genericUtility = new E12GenericUtility();
			DocumentHandlerWrapperEJB documentHandlerWrapperEJB = new DocumentHandlerWrapperEJB();
			attachment = this.attachmentPath;
			filess = new File(attachment);
			File[] files = filess.listFiles();
			File[] var23 = files;
			int var22 = files.length;
			int var21 = 0;

			while (true) {
				label207 : {
					if (var21 < var22) {
						File file = var23[var21];
						System.out.println("fileName12==>" + file.getName());
						System.out.println("fileName1234==>" + fileName);
						if (file.getName().toLowerCase().indexOf(fileName.toLowerCase()) < 0) {
							break label207;
						}

						input = new FileInputStream(file);
						bfr = new BufferedInputStream(input);
						bout = new ByteArrayOutputStream();

						int readCount;
						while ((readCount = bfr.read()) != -1) {
							bout.write(readCount);
						}

						byteArray = bout.toByteArray();
						fileType = FilenameUtils.getExtension(attachment);
						System.out.println("attachment>>>> " + attachment);
						System.out.println("fileType]" + fileType);
						retXMLStringBuff = new StringBuffer();
						retXMLStringBuff
								.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
						retXMLStringBuff.append("<DocumentRoot>");
						retXMLStringBuff.append("<description>Datawindow Root</description>");
						retXMLStringBuff.append("<group0>");
						retXMLStringBuff.append("<description>Group0 description</description>");
						retXMLStringBuff.append("<Header0>");
						retXMLStringBuff.append("<description>Header0 members</description>");
						retXMLStringBuff.append("<header>");
						retXMLStringBuff.append("<ref_id><![CDATA[" + tranId + "]]></ref_id>");
						retXMLStringBuff.append("<ref_ser><![CDATA[M-BILL]]></ref_ser>");
						retXMLStringBuff.append("<doc_name><![CDATA[" + file.getName() + "]]></doc_name>");
						retXMLStringBuff.append("<doc_type><![CDATA[" + fileType + "]]></doc_type>");
						retXMLStringBuff.append("<obj_name><![CDATA[marketing_bill]]></obj_name>");
						retXMLStringBuff.append("<created_by><![CDATA[" + this.chgUser + "]]></created_by>");
						retXMLStringBuff.append("</header>");
						retXMLStringBuff.append("</Header0>");
						retXMLStringBuff.append("</group0>");
						retXMLStringBuff.append("</DocumentRoot>");
						System.out.println("retXMLStringBuff = [" + retXMLStringBuff.toString() + "]");
						System.out.println(retXMLStringBuff.toString());

						try {
							System.out.println("retXMLStringBuff = "+retXMLStringBuff.toString()+"\nbyteArray = "+byteArray.toString()
							+"\nthis.userInfo = "+this.userInfo);
							retString = documentHandlerWrapperEJB.addDocument(retXMLStringBuff.toString(), byteArray,
									(byte[]) null, this.userInfo);
						} catch (Exception var47) {
							this.printLog("win_id==>" + this.winId, var47.getMessage(), this.xmlName);
							System.out.println(var47.getMessage());
							var47.printStackTrace();
							throw new ITMException(var47);
						}

						System.out.println("addDocument@adnan[" + retString + "]");
						Document dom = genericUtility.parseString(retString);
						Node node = dom.getElementsByTagName("ID").item(0);
						if (node == null || node.getAttributes() == null
								|| node.getAttributes().getNamedItem("Document_Id") == null) {
							break label207;
						}

						String docid = node.getAttributes().getNamedItem("Document_Id").getNodeValue();
						System.out.println("doc_id - [" + docid + "]");
						String uniqueTranIdGenerator = this.generateTranID("unallocated", this.loginSiteCode, "", conn);
						String sql = "INSERT INTO UNALLOCATED_ATTACH (TRAN_ID,REF_ID,REF_SER,DOC_ID,OBJ_NAME,STATUS,ADDED_BY,ADDED_TO_MAP,ADDED_ON)  VALUES ( ?,?,?,?,?,?,?,?,sysdate )";

						int updatecnt;
						try {
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, uniqueTranIdGenerator);
							pstmt.setString(2, tranId);
							pstmt.setString(3, "M-BILL");
							pstmt.setString(4, docid);
							pstmt.setString(5, "marketing_bill");
							pstmt.setString(6, "N");
							pstmt.setString(7, this.loginSiteCode);
							pstmt.setString(8, "0");
							updatecnt = pstmt.executeUpdate();
							System.out.println("inside unallocated  vijay");
							pstmt.close();
							pstmt = null;
						} catch (SQLException var46) {
							this.printLog("win_id==>" + this.winId, var46.getMessage(), this.xmlName);
							System.out.println("insiden exception==>[" + var46.getMessage() + "]");
							var46.printStackTrace();
							throw new ITMException(var46);
						}

						if (updatecnt != 0) {
							break label207;
						}

						conn.rollback();
					}

					System.out.println("attachment>>>> " + attachment);
					return retString;
				}

				++var21;
			}
		} catch (Exception var48) {
			this.printLog("win_id==>" + this.winId, var48.getMessage(), this.xmlName);
			var48.printStackTrace();
			System.out.println("MarketingSchBean.java.uploadAttachment()Exception" + var48.getMessage());
			throw new ITMException(var48);
		} finally {
			filess = null;
			byteArray = null;
			if (bfr != null) {
				try {
					bfr.close();
				} catch (IOException var45) {
					var45.printStackTrace();
					throw new ITMException(var45);
				}
			}

			if (bout != null) {
				try {
					bout.close();
				} catch (IOException var44) {
					var44.printStackTrace();
					throw new ITMException(var44);
				}
			}

			if (input != null) {
				try {
					input.close();
				} catch (IOException var43) {
					var43.printStackTrace();
					throw new ITMException(var43);
				}
			}

		}
	}

	private String generateTranID(String objName, String loginSiteCode, String itemSer, Connection conn)
			throws ITMException {
		String retString = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String keyString = "";
		String refSer = "";
		String sysDate = "";
		E12GenericUtility genericUtility = new E12GenericUtility();

		try {
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			sysDate = sdf.format(new Date());
			System.out.println(" objName =>" + objName);
			new HashMap();
			HashMap<String, String> transetupMap = this.getTransetup("w_" + objName, conn);
			keyString = (String) transetupMap.get("key_string");
			refSer = (String) transetupMap.get("ref_ser");
			String xmlValues = "";
			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<TRAN_ID></TRAN_ID>";
			xmlValues = xmlValues + "<TRAN_DATE>" + sysDate + "</TRAN_DATE>";
			xmlValues = xmlValues + "<SITE_CODE>" + loginSiteCode + "</SITE_CODE>";
			xmlValues = xmlValues + "<ITEM_SER>" + itemSer + "</ITEM_SER>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues :[" + xmlValues + "]");
			System.out.println("keyString>>>>" + keyString + ">>>refSer>>>" + refSer);
			TransIDGenerator tranIdGenerator = new TransIDGenerator(xmlValues, "SYSTEM", CommonConstants.DB_NAME);
			String tranIdGenerated = tranIdGenerator.generateTranSeqID(refSer, "tran_id", keyString, conn);
			System.out.println("tranIdGenerated => " + tranIdGenerated);
			retString = tranIdGenerated;
		} catch (Exception var23) {
			var23.printStackTrace();
			throw new ITMException(var23);
		} finally {
			try {
				if (rs != null) {
					((ResultSet) rs).close();
					rs = null;
				}

				if (pstmt != null) {
					((PreparedStatement) pstmt).close();
					pstmt = null;
				}
			} catch (Exception var24) {
				var24.printStackTrace();
				throw new ITMException(var24);
			}

		}

		return retString;
	}

	private HashMap<String, String> getTransetup(String winName, Connection conn) throws ITMException {
		String keyString = "";
		String refSer = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap transetupMap = null;

		try {
			sql = "SELECT KEY_STRING, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, winName);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				keyString = rs.getString("KEY_STRING");
				refSer = rs.getString("REF_SER");
			}

			if (rs != null) {
				rs.close();
				rs = null;
			}

			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}

			System.out.println("ITWizardBean :: getKeyString :: keyString =>" + keyString);
			System.out.println("ITWizardBean :: getKeyString :: refSer =>" + refSer);
			transetupMap = new HashMap();
			transetupMap.put("key_string", keyString);
			transetupMap.put("ref_ser", refSer);
		} catch (Exception var17) {
			this.printLog("win_id==>" + this.winId, var17.getMessage(), this.xmlName);
			var17.printStackTrace();
			throw new ITMException(var17);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception var16) {
				var16.printStackTrace();
				throw new ITMException(var16);
			}

		}

		return transetupMap;
	}

	private void printLog(String msg, String text, String fileName) throws ITMException {
		String logFile = "";
		String logDir = "";
		File logFileDir = null;
		FileWriter fileWriter = null;

		try {
			String logFileName = "";
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			logFileName = "marketing_bill_" + fileName + "_" + sdf.format(new Date());
			System.out.println("Inside the print log method");
			logDir = this.logPath + File.separator + "marketingScan";
			System.out.println("Log direction: " + logDir);
			logFileDir = new File(logDir);
			if (!logFileDir.exists()) {
				logFileDir.mkdirs();
			}

			logFile = logDir + File.separator + logFileName + ".log";
			System.out.println("FIle path::" + logFile);
			this.logFilePath = logFile;
			SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
			Date now = new Date();
			String strDate = sdfDate.format(now);
			fileWriter = new FileWriter(logFile, true);
			fileWriter.write("\r\n");
			fileWriter.write(strDate + " " + "[" + text + "] " + msg);
		} catch (Exception var20) {
			this.printLog("win_id==>" + this.winId, var20.getMessage(), this.xmlName);
			var20.printStackTrace();
			throw new ITMException(var20);
		} finally {
			try {
				if (fileWriter != null) {
					fileWriter.flush();
					fileWriter.close();
				}
			} catch (Exception var19) {
				var19.printStackTrace();
			}

		}

	}

	public int getPageCount(File fileTobeAttached) {
		String filePath = fileTobeAttached.toString();
		String fileName = fileTobeAttached.getName();
		String fileType = fileName.substring(fileName.indexOf(".") + 1);
		int pageCount = 0;

		try {
			if ("pdf".equalsIgnoreCase(fileType)) {
				PdfReader reader = new PdfReader(filePath);
				pageCount = reader.getNumberOfPages();
			} else if ("doc".equalsIgnoreCase(fileType)) {
				try {
					POIFSFileSystem fis = new POIFSFileSystem(new FileInputStream(fileTobeAttached));
					HWPFDocument wdDoc = new HWPFDocument(fis);
					pageCount = wdDoc.getSummaryInformation().getPageCount();
				} catch (Exception var10) {
					System.out.println("In getPageCount Exception [" + var10.getMessage() + "]");
					var10.printStackTrace();
				}
			} else if ("docx".equalsIgnoreCase(fileType)) {
				byte[] inputBytePDF = (byte[]) null;

				try {
					FileInputStream fin = new FileInputStream(fileTobeAttached);
					inputBytePDF = new byte[(int) fileTobeAttached.length()];
					fin.read(inputBytePDF);
					new ByteArrayInputStream(inputBytePDF);
				} catch (Exception var9) {
					System.out.println("In docx type Exception [" + var9.getMessage() + "]");
					var9.printStackTrace();
				}
			}
		} catch (IOException var11) {
			System.out.println("In doc type Exception [" + var11.getMessage() + "]");
			var11.printStackTrace();
		}

		return pageCount;
	}

	private void sendIntimation(String infoType, String logFileName, String loginEmpCode, Connection conn)
			throws ITMException {
		String formatCode = "VENDOR_ATT_LOG";
		System.out.println("in send mail activity");
		System.out.println("info type::" + infoType);
		System.out.println("logFileName::" + logFileName);
		System.out.println("loginCode::" + loginEmpCode);
		StringBuffer valueXmlString = null;
		valueXmlString = new StringBuffer("<?xml version='1.0' encoding='UTF-8'?><ROOT><TRANS_INFO>");
		valueXmlString.append("</TRANS_INFO>");
		valueXmlString.append("<MAIL>");
		valueXmlString.append("<EMAIL_TYPE>").append("<![CDATA[page]]>").append("</EMAIL_TYPE>");
		valueXmlString.append("<ENTITY_TYPE>").append("<![CDATA[E]]>").append("</ENTITY_TYPE>");
		valueXmlString.append("<ENTITY_CODE>").append("<![CDATA[" + loginEmpCode + "]]>").append("</ENTITY_CODE>");
		valueXmlString.append("<FORMAT_CODE>").append("<![CDATA[" + formatCode + "]]>").append("</FORMAT_CODE>");
		valueXmlString.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" + logFileName + "]]>")
				.append("</XML_DATA_FILE_PATH>");
		valueXmlString.append("</MAIL>");
		valueXmlString.append("</ROOT>");
		String mailXmlString = valueXmlString.toString();
		EMail em = new EMail();

		try {
			String mail_status = em.sendMail(mailXmlString, infoType, conn);
			System.out.println("mail_status==" + mail_status);
		} catch (Exception var10) {
			var10.printStackTrace();
		}

	}
}